/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.common.utils.ContractHttpUtil;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempxMapper;
import com.tydic.uoc.dao.UocOrgSubCodeMapper;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrgSubCodePO;
import com.tydic.uoc.zone.ability.api.PebVasAbilityService;
import com.tydic.uoc.zone.ability.bo.PebVasReqBO;
import com.tydic.uoc.zone.ability.bo.PebVasRspBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.PebVasAbilityService"})
public class PebVasAbilityServiceImpl
implements PebVasAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebVasAbilityServiceImpl.class);
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Value(value="${uoc.vas.url:http://172.16.3.98:8080/ords/erp/cuxinv/QyPoAslFlag}")
    private String url;
    @Autowired
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Autowired
    private UocOrdGoodsTempxMapper uocOrdGoodsTempxMapper;
    @Value(value="${uoc.vas.flag:false}")
    private boolean flag;
    @Autowired
    private UocOrgSubCodeMapper uocOrgSubCodeMapper;
    @Value(value="${erp.push.dt.userId:,22,22}")
    private String dtUserId;
    @Value(value="${erp.push.dt.org:1401}")
    private String dtOrg;
    @Value(value="${erp.push.dt.aforg:1397}")
    private String dtafOrg;
    @Value(value="${erp.push.dt.afc:J001}")
    private String dtafc;
    @Value(value="${erp.push.dt.afd:93735}")
    private String dtafd;
    @Value(value="${erp.push.dt.afcfjs:C003}")
    private String afcfjs;

    @PostMapping(value={"checkVas"})
    public PebVasRspBO checkVas(@RequestBody PebVasReqBO reqBO) {
        List list;
        PebVasRspBO rspBO = new PebVasRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (this.flag) {
            return rspBO;
        }
        JSONArray array = new JSONArray();
        UocOrdGoodsTempPO goodsTempPO = new UocOrdGoodsTempPO();
        if (reqBO.getTempOrderId() != null) {
            goodsTempPO.setOrderId(reqBO.getTempOrderId());
            list = this.uocOrdGoodsTempxMapper.selectByCondition(goodsTempPO);
        } else {
            goodsTempPO.setOrderId(reqBO.getOrderId());
            list = this.uocOrdGoodsTempMapper.selectByCondition(goodsTempPO);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (UocOrdGoodsTempPO skuInfo : list) {
            ids.add(Long.valueOf(skuInfo.getOrganizationId()));
        }
        UocOrgSubCodePO codePO = new UocOrgSubCodePO();
        codePO.setBfOrgIdList(ids);
        List subCodePOS = this.uocOrgSubCodeMapper.selectByCondition(codePO);
        for (Object skuInfo : list) {
            for (UocOrgSubCodePO subCodePO : subCodePOS) {
                if (!subCodePO.getBfOrgId().toString().equals(skuInfo.getOrganizationId())) continue;
                skuInfo.setOrganizationId(subCodePO.getAfsOrgId().toString());
            }
        }
        for (Object skuInfo : list) {
            if (!this.dtUserId.contains("," + skuInfo.getCreateOperId()) || !this.dtOrg.equals(skuInfo.getOrganizationId())) continue;
            skuInfo.setOrganizationId(this.dtafOrg);
        }
        int i = 1;
        for (UocOrdGoodsTempPO skuInfo : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("VENDOR_ID", (Object)reqBO.getSupplierErpNo());
            jsonObject.put("B2B_SITE_ID", (Object)reqBO.getB2bsiteId());
            jsonObject.put("PO_LINE_ID", (Object)i);
            jsonObject.put("ITEM_NO", (Object)(Objects.nonNull(skuInfo.getExt6()) ? skuInfo.getExt6() : skuInfo.getSkuMaterialId()));
            jsonObject.put("ORGANIZATION_ID", (Object)(StringUtils.isNotBlank((CharSequence)skuInfo.getExt12()) ? skuInfo.getExt12() : skuInfo.getOrganizationId()));
            ++i;
            array.add((Object)jsonObject);
        }
        JSONObject erp = new JSONObject();
        erp.put("PBATCH_ID", (Object)(this.idUtil.nextId() + ""));
        erp.put("DATA", (Object)array);
        HashMap<String, String> herder = new HashMap<String, String>();
        herder.put("P_INTERFACE_CODE", "ASLFLAG_CODE");
        herder.put("P_SOURCE_SYSTEM", "CUXPOPORTAL");
        log.info("\u4e0b\u5355\u67e5\u8be2\u5165\u53c2\uff1a" + erp.toJSONString());
        String str = ContractHttpUtil.doPost((String)this.url, (String)erp.toJSONString(), (String)JSONObject.toJSONString(herder));
        log.info("\u4e0b\u5355\u67e5\u8be2erp\u8fd4\u56de\uff1a" + str);
        if (StringUtils.isBlank((CharSequence)str)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2erp\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)str);
        if (!"S".equals(jsonObject.getString("ERP_STATUS"))) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(jsonObject.getString("ERP_MSG"));
            return rspBO;
        }
        JSONArray item = new JSONArray();
        try {
            item = jsonObject.getJSONArray("DATA");
        }
        catch (Exception e) {
            JSONObject object = jsonObject.getJSONObject("DATA");
            item.add((Object)object);
        }
        ArrayList<String> erpM = new ArrayList<String>();
        for (Object object : item) {
            JSONObject material = (JSONObject)object;
            if (!"Y".equals(material.getString("PO_ASL_FLAG"))) continue;
            erpM.add(material.getString("ITEM_NO"));
        }
        ArrayList<String> js = new ArrayList<String>();
        ArrayList<String> fJs = new ArrayList<String>();
        for (UocOrdGoodsTempPO skuInfo : list) {
            if (!erpM.contains(skuInfo.getSkuMaterialId())) {
                if (js.contains(skuInfo.getSkuMaterialId())) continue;
                js.add(skuInfo.getSkuMaterialId());
                continue;
            }
            if (fJs.contains(skuInfo.getSkuMaterialId())) continue;
            fJs.add(skuInfo.getSkuMaterialId());
        }
        rspBO.setJs(js);
        rspBO.setFJs(fJs);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

