/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.UocOrdGoodsHistoryMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempxMapper;
import com.tydic.uoc.dao.UocOrdZmInfoHistoryMapper;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.UocOrdGoodsHistoryPO;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrdZmInfoHistoryPO;
import com.tydic.uoc.zone.ability.api.UocQueryOrderChangeDetailListAbilityService;
import com.tydic.uoc.zone.ability.bo.UocOrderDetailsOrderItemInfoBO;
import com.tydic.uoc.zone.ability.bo.UocQueryOrderChangeDetailListServiceReqBO;
import com.tydic.uoc.zone.ability.bo.UocQueryOrderChangeDetailListServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.UocQueryOrderChangeDetailListAbilityService"})
public class UocQueryOrderChangeDetailListAbilityServiceImpl
implements UocQueryOrderChangeDetailListAbilityService {
    @Resource
    private OrdItemMapper ordItemMapper;
    @Resource
    private UocOrdGoodsHistoryMapper uocOrdGoodsHistoryMapper;
    @Resource
    private OrdGoodsMapper ordGoodsMapper;
    @Resource
    private UocOrdGoodsTempxMapper uocOrdGoodsTempxMapper;
    @Resource
    private UocOrdZmInfoHistoryMapper uocOrdZmInfoHistoryMapper;

    @PostMapping(value={"queryOrderChangeDetailList"})
    public UocQueryOrderChangeDetailListServiceRspBO queryOrderChangeDetailList(@RequestBody UocQueryOrderChangeDetailListServiceReqBO reqBO) {
        int version;
        UocQueryOrderChangeDetailListServiceRspBO rspBO = new UocQueryOrderChangeDetailListServiceRspBO();
        this.checkInput(reqBO);
        ArrayList beforeOrderDetail = new ArrayList();
        ArrayList changeOrderDetail = new ArrayList();
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(reqBO.getOrderId());
        List ordItemPOList = this.ordItemMapper.getList(ordItemPO);
        if (CollectionUtils.isEmpty((Collection)ordItemPOList)) {
            throw new UocProBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u660e\u7ec6\u4fe1\u606f");
        }
        if (Objects.isNull(reqBO.getTempId())) {
            version = 2;
        } else {
            UocOrdZmInfoHistoryPO uocOrdZmInfoHistoryPO = new UocOrdZmInfoHistoryPO();
            uocOrdZmInfoHistoryPO.setOrderId(reqBO.getOrderId());
            uocOrdZmInfoHistoryPO.setTempId(reqBO.getTempId());
            List historyPOList = this.uocOrdZmInfoHistoryMapper.queryList(uocOrdZmInfoHistoryPO);
            version = CollectionUtils.isEmpty((Collection)historyPOList) ? 2 : ((UocOrdZmInfoHistoryPO)historyPOList.get(0)).getVersion();
        }
        UocOrdGoodsHistoryPO uocOrdGoodsHistoryPO = new UocOrdGoodsHistoryPO();
        uocOrdGoodsHistoryPO.setOrderId(reqBO.getOrderId());
        uocOrdGoodsHistoryPO.setVersion(Integer.valueOf(version - 1));
        List goodsHistoryPOList = this.uocOrdGoodsHistoryMapper.queryList(uocOrdGoodsHistoryPO);
        if (CollectionUtils.isEmpty((Collection)goodsHistoryPOList)) {
            OrdGoodsPO ordGoodsPO = new OrdGoodsPO();
            ordGoodsPO.setOrderId(reqBO.getOrderId());
            List goodsPOList = this.ordGoodsMapper.getList(ordGoodsPO);
            if (CollectionUtils.isEmpty((Collection)goodsPOList)) {
                throw new UocProBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u7269\u8d44\u660e\u7ec6\u4fe1\u606f");
            }
            goodsPOList.forEach(e -> {
                UocOrdGoodsHistoryPO historyPO = new UocOrdGoodsHistoryPO();
                BeanUtils.copyProperties((Object)e, (Object)historyPO);
                goodsHistoryPOList.add(historyPO);
            });
        }
        Map goodsMap = goodsHistoryPOList.stream().collect(Collectors.toMap(UocOrdGoodsHistoryPO::getOrdItemId, Function.identity(), (k1, k2) -> k1));
        ordItemPOList.forEach(item -> {
            UocOrderDetailsOrderItemInfoBO itemInfoBO = new UocOrderDetailsOrderItemInfoBO();
            BeanUtils.copyProperties((Object)item, (Object)itemInfoBO);
            if (Objects.nonNull(goodsMap.get(item.getOrdItemId()))) {
                BeanUtils.copyProperties(goodsMap.get(item.getOrdItemId()), (Object)itemInfoBO);
            }
            itemInfoBO.setSalePriceMoney(MoneyUtil.l4B((Long)item.getSalePrice()));
            itemInfoBO.setTotalSaleMoney(MoneyUtil.l4B((Long)item.getTotalSaleFee()));
            itemInfoBO.setTempId(item.getTempId());
            try {
                itemInfoBO.setTotalPurchaseMoney(MoneyUtil.l4B((Long)item.getTotalPurchaseFee()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (StringUtils.isNumeric((CharSequence)itemInfoBO.getArrivalTime())) {
                itemInfoBO.setArrivalTime("\u81ea\u8ba2\u5355\u751f\u6548\u8d77" + itemInfoBO.getArrivalTime() + "\u65e5\u5185\u4ea4\u8d27");
            }
            beforeOrderDetail.add(itemInfoBO);
        });
        if (Objects.nonNull(reqBO.getTempId())) {
            UocOrdGoodsTempPO uocOrdGoodsTempPO = new UocOrdGoodsTempPO();
            uocOrdGoodsTempPO.setOrderId(reqBO.getTempId());
            List ordGoodsTempPOList = this.uocOrdGoodsTempxMapper.selectByCondition(uocOrdGoodsTempPO);
            if (CollectionUtils.isEmpty((Collection)ordGoodsTempPOList)) {
                throw new UocProBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u7269\u8d44\u660e\u7ec6\u4fe1\u606f");
            }
            ordGoodsTempPOList.forEach(item -> {
                UocOrderDetailsOrderItemInfoBO itemInfoBO = new UocOrderDetailsOrderItemInfoBO();
                BeanUtils.copyProperties((Object)item, (Object)itemInfoBO);
                itemInfoBO.setSalePriceMoney(item.getSalePrice());
                itemInfoBO.setTotalSaleMoney(item.getTotalSalePrice());
                if (StringUtils.isNumeric((CharSequence)itemInfoBO.getArrivalTime())) {
                    itemInfoBO.setArrivalTime("\u81ea\u8ba2\u5355\u751f\u6548\u8d77" + itemInfoBO.getArrivalTime() + "\u65e5\u5185\u4ea4\u8d27");
                }
                changeOrderDetail.add(itemInfoBO);
            });
        }
        rspBO.setBeforeOrderDetail(beforeOrderDetail);
        rspBO.setChangeOrderDetail(changeOrderDetail);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkInput(UocQueryOrderChangeDetailListServiceReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
    }
}

