/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.commodity.common.ability.api.UccThematerialsearchAbilityService;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccThematerialsearchAbilityRspBO;
import com.tydic.umc.general.ability.api.UmcOrderImportGetDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseAccountBO;
import com.tydic.umc.general.ability.bo.UmcOrderImportGetDetailReqBO;
import com.tydic.umc.general.ability.bo.UmcOrderImportGetDetailRspBO;
import com.tydic.umc.general.ability.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import com.tydic.umc.supplier.ability.api.UmcSupplierInfoQryListAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoQryListAbilityRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.utils.BatchImportUtils;
import com.tydic.uoc.dao.UocOrdImportFaileItemMapper;
import com.tydic.uoc.dao.UocOrdImportMapper;
import com.tydic.uoc.po.UocOrdImportFaileItemPO;
import com.tydic.uoc.po.UocOrdImportPO;
import com.tydic.uoc.zone.ability.api.UocOrdImportAbilityService;
import com.tydic.uoc.zone.ability.bo.UocOrdImportBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportDataBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportFaileItemExtReqBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportFaileItemExtRspBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportListPageQueryReqBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportListPageQueryRspBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportReqBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportRspBO;
import com.tydic.uoc.zone.busi.api.UocOrdImportBusiService;
import com.tydic.uoc.zone.busi.bo.UocOrdImportBusiReqBO;
import com.tydic.uoc.zone.busi.bo.UocOrdImportBusiRspBO;
import com.tydic.uoc.zone.comb.api.UocOrdImportdealCombService;
import com.tydic.uoc.zone.comb.bo.UocOrdImportdealCombReqBO;
import com.tydic.uoc.zone.comb.bo.UocOrdImportdealCombRspBO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.UocOrdImportAbilityService"})
public class UocOrdImportAbilityServiceImpl
implements UocOrdImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocOrdImportAbilityServiceImpl.class);
    @Autowired
    private UocOrdImportMapper uocOrdImportMapper;
    @Autowired
    private UocOrdImportFaileItemMapper uocOrdImportFaileItemMapper;
    @Autowired
    private UocOrdImportBusiService uocOrdImportBusiService;
    @Autowired
    private UmcOrderImportGetDetailAbilityService umcOrderImportGetDetailAbilityService;
    @Autowired
    private UocOrdImportdealCombService uocOrdImportdealCombService;
    @Autowired
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;
    @Autowired
    private UmcSupplierInfoQryListAbilityService umcSupplierInfoQryListAbilityService;
    @Autowired
    private UccThematerialsearchAbilityService uccThematerialsearchAbilityService;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "uoc";
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"getContractOrderImportList"})
    public UocOrdImportListPageQueryRspBO getContractOrderImportList(@RequestBody UocOrdImportListPageQueryReqBO reqBO) {
        this.validateUocOrdImportListPageQueryReqBO(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UocOrdImportPO uocOrdImportPO = new UocOrdImportPO();
        uocOrdImportPO.setOperUserId(reqBO.getUserId());
        uocOrdImportPO.setOrderBy(" oper_time desc ");
        List UocOrdImportPOS = this.uocOrdImportMapper.getListPage(uocOrdImportPO, page);
        ArrayList<UocOrdImportBO> rows = new ArrayList<UocOrdImportBO>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)UocOrdImportPOS)) {
            for (UocOrdImportPO ordImportPO : UocOrdImportPOS) {
                UocOrdImportBO uocOrdImportBO = new UocOrdImportBO();
                BeanUtils.copyProperties((Object)ordImportPO, (Object)uocOrdImportBO);
                rows.add(uocOrdImportBO);
            }
        }
        UocOrdImportListPageQueryRspBO rspBO = new UocOrdImportListPageQueryRspBO();
        rspBO.setRows(rows);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        return rspBO;
    }

    @PostMapping(value={"dealContractOrderImport"})
    public UocOrdImportRspBO dealContractOrderImport(@RequestBody UocOrdImportReqBO reqBO) {
        List importDataMap;
        UocOrdImportRspBO rspBO = new UocOrdImportRspBO();
        this.validateUocOrdImportReqBO(reqBO);
        List<String> title = PebExtConstant.YES.equals(reqBO.getIsHtInit()) ? this.getHtInitTitle() : this.getTitile();
        ArrayList data = new ArrayList();
        try {
            BatchImportUtils batchImportUtils = new BatchImportUtils(title, data, UocOrdImportDataBO.class);
            batchImportUtils.batchImport(reqBO.getFileUrl(), 1, 3, -1);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:{}", (Object)e.toString());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)importDataMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        List dataList = JSONArray.parseArray((String)JSON.toJSONString((Object)importDataMap), UocOrdImportDataBO.class);
        this.dealArrivalTime(dataList);
        this.checkOrderOnlyId(dataList);
        Map<Long, List<UocOrdImportDataBO>> dataMap = dataList.stream().collect(Collectors.groupingBy(UocOrdImportDataBO::getOrderOnlyId));
        int count = dataMap.keySet().size();
        UocOrdImportBusiReqBO busiReqBO = new UocOrdImportBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        busiReqBO.setExt1(count + "");
        busiReqBO.setExt1(reqBO.getIsHtInit() + "");
        UocOrdImportBusiRspBO busiRspBO = this.uocOrdImportBusiService.dealOrdImportInsert(busiReqBO);
        Long importId = busiRspBO.getImportId();
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u5bfc\u5165\u8bb0\u5f55\u5165\u5e93\u6570\u636e\u5e93\u5931\u8d25");
        }
        HashSet<Long> faileSet = new HashSet<Long>();
        HashSet<Long> succesSet = new HashSet<Long>();
        HashMap paramMap = new HashMap();
        for (Long key : dataMap.keySet()) {
            if (!this.CheckData(dataMap.get(key), reqBO.getIsHtInit()).booleanValue()) {
                faileSet.add(key);
                continue;
            }
            succesSet.add(key);
        }
        if (succesSet.size() == 0) {
            this.upateAllFaile(reqBO, dataMap, importId, faileSet, "\u672a\u901a\u8fc7\u975e\u7a7a\u6821\u9a8c");
        } else {
            List<UocOrdImportDataBO> successToSearchList = this.getDataList(dataMap, succesSet);
            Map<Long, List<UocOrdImportDataBO>> successToSearchMap = successToSearchList.stream().collect(Collectors.groupingBy(UocOrdImportDataBO::getOrderOnlyId));
            HashSet<String> acquirerIds = new HashSet<String>();
            HashSet<String> consigneeIds = new HashSet<String>();
            HashSet<String> supNos = new HashSet<String>();
            HashSet<String> organizationIds = new HashSet<String>();
            HashSet<String> buynerNos = new HashSet<String>();
            HashSet<String> skuMaterialIds = new HashSet<String>();
            for (UocOrdImportDataBO uocOrdImportDataBO : successToSearchList) {
                acquirerIds.add(uocOrdImportDataBO.getAcquirerId());
                consigneeIds.add(uocOrdImportDataBO.getConsigneeId());
                supNos.add(uocOrdImportDataBO.getSupNo());
                organizationIds.add(uocOrdImportDataBO.getOrganizationId());
                buynerNos.add(uocOrdImportDataBO.getBuynerNo());
                skuMaterialIds.add(uocOrdImportDataBO.getSkuMaterialId());
            }
            UmcOrderImportGetDetailRspBO umcOrderImportGetDetailRspBO = this.getUmcOrderImportGetDetailRspBO(acquirerIds, consigneeIds, supNos, organizationIds);
            Map supMap = umcOrderImportGetDetailRspBO.getSupMap();
            HashSet<Long> supId = new HashSet<Long>();
            for (String key : supMap.keySet()) {
                if (supMap.get(key) == null) continue;
                supId.add((Long)supMap.get(key));
            }
            UmcQryEnterpriseAccountDetailAbilityRspBO umcQryEnterpriseAccountDetailAbilityRspBO = this.getUmcQryEnterpriseAccountDetailAbilityRspBO(buynerNos);
            Map accountMap = umcQryEnterpriseAccountDetailAbilityRspBO.getAccountMap();
            Map<String, UmcSupplierInfoBO> suppilerMap = this.getStringUmcSupplierInfoBOMap(rspBO, supId);
            Map<String, UccEMdmMaterialBO> materialMap = this.getStringUccEMdmMaterialBOMap(skuMaterialIds);
            for (Long orderOnlyId : successToSearchMap.keySet()) {
                List<UocOrdImportDataBO> checkList = dataMap.get(orderOnlyId);
                if (PebExtConstant.YES.equals(reqBO.getIsHtInit()) || this.checkSearch(umcOrderImportGetDetailRspBO, checkList, accountMap, suppilerMap, materialMap).booleanValue()) continue;
                faileSet.add(orderOnlyId);
                succesSet.remove(orderOnlyId);
            }
            if (succesSet.size() == 0) {
                this.upateAllFaile(reqBO, dataMap, importId, faileSet, "\u5bfc\u5165\u7684\u7f16\u7801\u6709\u8bef");
            } else {
                UocOrdImportdealCombReqBO combReqBO = new UocOrdImportdealCombReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)((Object)combReqBO));
                combReqBO.setDataMap(dataMap);
                combReqBO.setAccountMap(accountMap);
                combReqBO.setSuppilerMap(suppilerMap);
                combReqBO.setImportId(importId);
                combReqBO.setMaterialMap(materialMap);
                combReqBO.setFaileSet(faileSet);
                combReqBO.setSuccesSet(succesSet);
                combReqBO.setUmcOrderImportGetDetailRspBO(umcOrderImportGetDetailRspBO);
                UocOrdImportdealCombRspBO combRspBO = this.uocOrdImportdealCombService.dealImport(combReqBO);
                rspBO.setRespCode(combRspBO.getRespCode());
                rspBO.setRespDesc(combRspBO.getRespDesc());
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6267\u884c\u5b8c\u6bd5");
        return rspBO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"dealFaileItemExt"})
    public UocOrdImportFaileItemExtRspBO dealFaileItemExt(@RequestBody UocOrdImportFaileItemExtReqBO reqBO) {
        String url = "";
        String fileName = "";
        UocOrdImportFaileItemExtRspBO rspBO = new UocOrdImportFaileItemExtRspBO();
        this.validateFaileExt(reqBO);
        UocOrdImportPO uocOrdImportPO = this.uocOrdImportMapper.getModelById(reqBO.getImportId());
        if (uocOrdImportPO == null || uocOrdImportPO.getImportResult() == null || uocOrdImportPO.getImportResult() != 1 && uocOrdImportPO.getImportResult() != 2) {
            throw new BusinessException("8888", "\u5bfc\u51fa\u8bb0\u5f55\u4e0d\u7b26\u5408\u5bfc\u51fa\u5931\u8d25\u6587\u4ef6\u6761\u4ef6");
        }
        UocOrdImportFaileItemPO queryPO = new UocOrdImportFaileItemPO();
        queryPO.setImportId(reqBO.getImportId());
        List pos = this.uocOrdImportFaileItemMapper.getList(queryPO);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)pos)) {
            int initRowSize = 3 + pos.size();
            int initColSize = 39;
            fileName = uocOrdImportPO.getFileName();
            String sheetName = "shee1";
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFCellStyle dataStyleRight = this.getDataStyle(workbook, true, "right");
            XSSFCellStyle dataStyleLeft = this.getDataStyle(workbook, true, "left");
            XSSFSheet sheet = workbook.createSheet(sheetName);
            sheet.setDefaultColumnWidth(17);
            sheet.setDisplayGridlines(true);
            for (int rowIndex = 0; rowIndex <= initRowSize - 1; ++rowIndex) {
                XSSFRow titleRow = sheet.createRow(rowIndex);
                titleRow.setHeightInPoints(18.0f);
                for (int columnIndex = 0; columnIndex <= initColSize - 1; ++columnIndex) {
                    titleRow.createCell(columnIndex);
                }
            }
            this.merge(sheet, 0, 0, 0, 38);
            XSSFRow firstRow = sheet.getRow(0);
            XSSFCell firstCell = firstRow.getCell(0);
            firstCell.setCellValue("\u76f8\u540c\u8ba2\u5355\u552f\u4e00\u6027\u6807\u8bc6\u7684\u660e\u7ec6\u5c5e\u4e8e\u4e00\u4e2a\u8ba2\u5355\uff0c\u6570\u5b57\u683c\u5f0f,\u7b2c\u4e09\u884c\u4e3a\u793a\u4f8b\u884c,\u8bf7\u52ff\u6539\u52a8");
            firstCell.setCellStyle((CellStyle)dataStyleLeft);
            List<String> titlelist = PebExtConstant.YES.toString().equals(uocOrdImportPO.getExt3()) ? this.getHtInitTitle() : this.getTitile();
            titlelist.add("\u5931\u8d25\u539f\u56e0");
            XSSFRow secondRow = sheet.getRow(1);
            for (int i = 0; i < titlelist.size(); ++i) {
                secondRow.getCell(i).setCellValue(titlelist.get(i));
                secondRow.getCell(i).setCellStyle((CellStyle)dataStyleLeft);
            }
            XSSFRow thirdRow = sheet.getRow(2);
            thirdRow.setRowStyle((CellStyle)dataStyleLeft);
            thirdRow.getCell(0).setCellValue("\u6570\u5b57\u683c\u5f0f");
            thirdRow.getCell(1).setCellValue("\u7ed9\u53c2\u8003\u8868\uff0c\u540d\u79f0-\u7f16\u7801");
            thirdRow.getCell(2).setCellValue("\u7ed9\u53c2\u8003\u8868\uff0c\u540d\u79f0-\u7f16\u7801");
            thirdRow.getCell(3).setCellValue("\u7ed9\u53c2\u8003\u8868\uff0c\u540d\u79f0-\u7f16\u7801");
            thirdRow.getCell(4).setCellValue("\u7ed9\u53c2\u8003\u8868\uff0c\u540d\u79f0-\u7f16\u7801");
            int rowIndex = 3;
            for (UocOrdImportFaileItemPO po : pos) {
                XSSFRow contentRow = sheet.getRow(rowIndex);
                contentRow.setRowStyle((CellStyle)dataStyleRight);
                contentRow.getCell(0).setCellValue(this.dealNull(po.getOrderOnlyId()));
                contentRow.getCell(1).setCellValue(this.dealNull(po.getBuynerNo()));
                contentRow.getCell(2).setCellValue(this.dealNull(po.getAcquirerId()));
                contentRow.getCell(3).setCellValue(this.dealNull(po.getConsigneeId()));
                contentRow.getCell(4).setCellValue(this.dealNull(po.getSupNo()));
                contentRow.getCell(5).setCellValue(this.dealNull(po.getMaterialCategory()));
                contentRow.getCell(6).setCellValue(this.dealNull(po.getOrigin()));
                contentRow.getCell(7).setCellValue(this.dealNull(po.getIsPushErp()));
                contentRow.getCell(8).setCellValue(this.dealNull(po.getOrderName()));
                contentRow.getCell(9).setCellValue(this.dealNull(po.getContactName()));
                contentRow.getCell(10).setCellValue(this.dealNull(po.getContactCompany()));
                contentRow.getCell(11).setCellValue(this.dealNull(po.getContactProvinceName()));
                contentRow.getCell(12).setCellValue(this.dealNull(po.getContactCityName()));
                contentRow.getCell(13).setCellValue(this.dealNull(po.getContactCountyName()));
                contentRow.getCell(14).setCellValue(this.dealNull(po.getContactTown()));
                contentRow.getCell(15).setCellValue(this.dealNull(po.getContactAddress()));
                contentRow.getCell(16).setCellValue(this.dealNull(po.getContactEmail()));
                contentRow.getCell(17).setCellValue(this.dealNull(po.getContactMobile()));
                contentRow.getCell(18).setCellValue(this.dealNull(po.getVendorSiteId()));
                contentRow.getCell(19).setCellValue(this.dealNull(po.getAddrJc()));
                contentRow.getCell(20).setCellValue(this.dealNull(po.getSkuMaterialId()));
                contentRow.getCell(21).setCellValue(this.dealNull(po.getUnitName()));
                contentRow.getCell(22).setCellValue(this.dealNull(po.getPurchaseCount()));
                contentRow.getCell(23).setCellValue(this.dealNull(po.getSalePrice()));
                contentRow.getCell(24).setCellValue(this.dealNull(po.getTax()));
                contentRow.getCell(25).setCellValue(this.dealNull(po.getOrganizationId()));
                contentRow.getCell(26).setCellValue(this.dealNull(po.getArrivalTime()));
                contentRow.getCell(27).setCellValue(this.dealNull(po.getBjType()));
                contentRow.getCell(28).setCellValue(this.dealNull(po.getDbPrice()));
                contentRow.getCell(29).setCellValue(this.dealNull(po.getSpec()));
                contentRow.getCell(30).setCellValue(this.dealNull(po.getModel()));
                contentRow.getCell(31).setCellValue(this.dealNull(po.getMaterialBj()));
                contentRow.getCell(32).setCellValue(this.dealNull(po.getZljsyq()));
                contentRow.getCell(33).setCellValue(this.dealNull(po.getJtyt()));
                contentRow.getCell(34).setCellValue(this.dealNull(po.getZxbz()));
                contentRow.getCell(35).setCellValue(this.dealNull(po.getPpcd()));
                contentRow.getCell(36).setCellValue(this.dealNull(po.getDccj()));
                contentRow.getCell(37).setCellValue(this.dealNull(po.getSkuMaterialRemark()));
                contentRow.getCell(38).setCellValue(this.dealNull(po.getFailReason()));
                if (PebExtConstant.YES.toString().equals(uocOrdImportPO.getExt3())) {
                    contentRow.getCell(39).setCellValue(this.dealNull(po.getExt1()));
                }
                ++rowIndex;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                workbook.write((OutputStream)byteArrayOutputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            if (FILE_TYPE_OSS.equals(this.fileType)) {
                url = this.ossFileUrl + path;
            } else if (FILE_TYPE_FASTDFS.equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                url = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u65f6\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
        }
        rspBO.setFileName(fileName);
        rspBO.setFileUrl(url);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    String dealNull(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        return o.toString();
    }

    private void merge(XSSFSheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        CellRangeAddress cra = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
        sheet.addMergedRegion(cra);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cra, (Sheet)sheet);
    }

    private XSSFCellStyle getDataStyle(XSSFWorkbook workbook, boolean wrapText, String flag) {
        XSSFCellStyle dataSetStyle = workbook.createCellStyle();
        dataSetStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        dataSetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        dataSetStyle.setWrapText(wrapText);
        dataSetStyle.setBorderBottom(BorderStyle.THIN);
        dataSetStyle.setBorderLeft(BorderStyle.THIN);
        dataSetStyle.setBorderRight(BorderStyle.THIN);
        dataSetStyle.setBorderTop(BorderStyle.THIN);
        if ("right".equals(flag)) {
            dataSetStyle.setAlignment(HorizontalAlignment.RIGHT);
        } else {
            dataSetStyle.setAlignment(HorizontalAlignment.LEFT);
        }
        dataSetStyle.setVerticalAlignment(VerticalAlignment.TOP);
        XSSFFont dataSetFont = workbook.createFont();
        dataSetFont.setFontHeightInPoints((short)12);
        dataSetFont.setColor(HSSFColor.HSSFColorPredefined.BLACK.getIndex());
        dataSetFont.setFontName("\u5b8b\u4f53");
        dataSetStyle.setFont((Font)dataSetFont);
        return dataSetStyle;
    }

    private void validateFaileExt(UocOrdImportFaileItemExtReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u67e5\u8be2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getImportId() == null) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u67e5\u8be2[importId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void dealArrivalTime(List<UocOrdImportDataBO> dataList) {
        for (UocOrdImportDataBO uocOrdImportDataBO : dataList) {
            if (!StringUtils.isNotBlank((CharSequence)uocOrdImportDataBO.getArrivalTime())) continue;
            if (uocOrdImportDataBO.getArrivalTime().endsWith(".0")) {
                uocOrdImportDataBO.setArrivalTime(uocOrdImportDataBO.getArrivalTime().substring(0, uocOrdImportDataBO.getArrivalTime().length() - 2));
            }
            if (!StringUtils.isNumeric((CharSequence)uocOrdImportDataBO.getArrivalTime())) continue;
            LocalDate arrivalDate = LocalDate.now().minusDays(Integer.parseInt(uocOrdImportDataBO.getArrivalTime()));
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String formattedArrivalTime = formatter.format(arrivalDate);
            uocOrdImportDataBO.setArrivalTime(formattedArrivalTime);
        }
    }

    private void upateAllFaile(UocOrdImportReqBO reqBO, Map<Long, List<UocOrdImportDataBO>> dataMap, Long importId, Set<Long> faileSet, String faileReason) {
        UocOrdImportBusiReqBO updateReq = new UocOrdImportBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)updateReq));
        updateReq.setImportId(importId);
        updateReq.setFaileList(this.getDataList(dataMap, faileSet));
        updateReq.setImportResult(2);
        updateReq.setFaileReason(faileReason);
        UocOrdImportBusiRspBO busiRspBO = this.uocOrdImportBusiService.dealOrdImportUpdate(updateReq);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u9519\u8bef\u4e0b\u5355\u660e\u7ec6\u6570\u636e\u5165\u5e93\u5931\u8d25");
        }
    }

    private Map<String, UccEMdmMaterialBO> getStringUccEMdmMaterialBOMap(Set<String> skuMaterialIds) {
        Map<String, UccEMdmMaterialBO> materialMap = new HashMap<String, UccEMdmMaterialBO>();
        UccThematerialsearchAbilityReqBO uccThematerialsearchAbilityReqBO = new UccThematerialsearchAbilityReqBO();
        uccThematerialsearchAbilityReqBO.setMaterialCodes(new ArrayList<String>(skuMaterialIds));
        uccThematerialsearchAbilityReqBO.setPageNo(1);
        uccThematerialsearchAbilityReqBO.setPageSize(99999);
        log.debug("\u67e5\u8be2\u7269\u6599\u7f16\u7801:" + JSON.toJSONString((Object)uccThematerialsearchAbilityReqBO));
        UccThematerialsearchAbilityRspBO uccThematerialsearchAbilityRspBO = this.uccThematerialsearchAbilityService.dealUccThematerialsearch(uccThematerialsearchAbilityReqBO);
        if (!"0000".equals(uccThematerialsearchAbilityRspBO.getRespCode())) {
            throw new UocProBusinessException("8888", "\u8c03\u7528\u5546\u54c1\u63a5\u53e3\u62a5\u9519");
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)uccThematerialsearchAbilityRspBO.getRows())) {
            List eMdmMaterialBOS = JSONArray.parseArray((String)JSON.toJSONString((Object)uccThematerialsearchAbilityRspBO.getRows()), UccEMdmMaterialBO.class);
            materialMap = eMdmMaterialBOS.stream().collect(Collectors.toMap(e -> e.getMaterialCode(), e -> e, (k, v) -> k));
        }
        return materialMap;
    }

    private UmcOrderImportGetDetailRspBO getUmcOrderImportGetDetailRspBO(Set<String> acquirerIds, Set<String> consigneeIds, Set<String> supNos, Set<String> organizationIds) {
        UmcOrderImportGetDetailReqBO umcOrderImportGetDetailReqBO = new UmcOrderImportGetDetailReqBO();
        umcOrderImportGetDetailReqBO.setAcquirerIds(new ArrayList<String>(acquirerIds));
        umcOrderImportGetDetailReqBO.setConsigneeIds(new ArrayList<String>(consigneeIds));
        umcOrderImportGetDetailReqBO.setSupNos(new ArrayList<String>(supNos));
        umcOrderImportGetDetailReqBO.setOrganizationIds(new ArrayList<String>(organizationIds));
        UmcOrderImportGetDetailRspBO umcOrderImportGetDetailRspBO = this.umcOrderImportGetDetailAbilityService.getDetail(umcOrderImportGetDetailReqBO);
        if (!"0000".equals(umcOrderImportGetDetailRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u8c03\u7528\u4f1a\u5458\u63a5\u53e3\u67e5\u8be2\u76f8\u5173\u4fe1\u606f\u5931\u8d25!!!!");
        }
        return umcOrderImportGetDetailRspBO;
    }

    private Map<String, UmcSupplierInfoBO> getStringUmcSupplierInfoBOMap(UocOrdImportRspBO rspBO, Set<Long> supId) {
        Map<String, UmcSupplierInfoBO> suppilerMap = new HashMap<String, UmcSupplierInfoBO>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(supId)) {
            UmcSupplierInfoQryListAbilityReqBO umcSupplierInfoQryListAbilityReqBO = new UmcSupplierInfoQryListAbilityReqBO();
            umcSupplierInfoQryListAbilityReqBO.setSupplierIds(new ArrayList<Long>(supId));
            UmcSupplierInfoQryListAbilityRspBO umcSupplierInfoQryListAbilityRspBO = this.umcSupplierInfoQryListAbilityService.supplierInfoQryListByIds(umcSupplierInfoQryListAbilityReqBO);
            if (!"0000".equals(umcSupplierInfoQryListAbilityRspBO.getRespCode())) {
                throw new UocProBusinessException("103028", "\u67e5\u8be2\u4f9b\u5e94\u5546\u5931\u8d25" + rspBO.getRespDesc());
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)umcSupplierInfoQryListAbilityRspBO.getRows())) {
                suppilerMap = umcSupplierInfoQryListAbilityRspBO.getRows().stream().collect(Collectors.toMap(e -> e.getSupplierCode(), e -> e, (k, v) -> k));
            }
        }
        return suppilerMap;
    }

    private UmcQryEnterpriseAccountDetailAbilityRspBO getUmcQryEnterpriseAccountDetailAbilityRspBO(Set<String> buynerNos) {
        UmcQryEnterpriseAccountDetailAbilityReqBO umcQryEnterpriseAccountDetailAbilityReqBO = new UmcQryEnterpriseAccountDetailAbilityReqBO();
        umcQryEnterpriseAccountDetailAbilityReqBO.setOrgCodes(new ArrayList<String>(buynerNos));
        UmcQryEnterpriseAccountDetailAbilityRspBO umcQryEnterpriseAccountDetailAbilityRspBO = this.umcQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountBuyCodeList(umcQryEnterpriseAccountDetailAbilityReqBO);
        if (!"0000".equals(umcQryEnterpriseAccountDetailAbilityRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u4f1a\u5458\u63a5\u53e3\u67e5\u8be2\u8d26\u5957\u5931\u8d25!!!!");
        }
        return umcQryEnterpriseAccountDetailAbilityRspBO;
    }

    private Boolean checkSearch(UmcOrderImportGetDetailRspBO umcOrderImportGetDetailRspBO, List<UocOrdImportDataBO> checkList, Map<String, UmcEnterpriseAccountBO> accountMap, Map<String, UmcSupplierInfoBO> suppilerMap, Map<String, UccEMdmMaterialBO> materialMap) {
        ArrayList<Boolean> resultList = new ArrayList<Boolean>();
        for (UocOrdImportDataBO uocOrdImportDataBO : checkList) {
            if (StringUtil.isBlank((String)((String)umcOrderImportGetDetailRspBO.getAcquirerNameMap().get(uocOrdImportDataBO.getAcquirerId())))) {
                uocOrdImportDataBO.setFailReason("\u6536\u5355\u65b9\u7f16\u7801\u6709\u8bef");
                resultList.add(false);
                continue;
            }
            if (StringUtil.isBlank((String)((String)umcOrderImportGetDetailRspBO.getConsigneeNameNameMap().get(uocOrdImportDataBO.getConsigneeId())))) {
                uocOrdImportDataBO.setFailReason("\u6536\u8d27\u65b9\u7f16\u7801\u6709\u8bef");
                resultList.add(false);
                continue;
            }
            if (suppilerMap.get(uocOrdImportDataBO.getSupNo()) == null) {
                uocOrdImportDataBO.setFailReason("\u4f9b\u5e94\u5546\u7f16\u7801\u6709\u8bef");
                resultList.add(false);
                continue;
            }
            if (StringUtil.isBlank((String)((String)umcOrderImportGetDetailRspBO.getOrganizationNameMap().get(uocOrdImportDataBO.getOrganizationId())))) {
                uocOrdImportDataBO.setFailReason("\u7533\u62a5\u5355\u4f4d\u7f16\u7801\u7f16\u7801\u6709\u8bef");
                resultList.add(false);
                continue;
            }
            if (accountMap.get(uocOrdImportDataBO.getBuynerNo()) == null) {
                uocOrdImportDataBO.setFailReason("\u4e70\u53d7\u4eba\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u6709\u8bef");
                resultList.add(false);
                continue;
            }
            if (materialMap.get(uocOrdImportDataBO.getSkuMaterialId()) == null) {
                uocOrdImportDataBO.setFailReason("\u7269\u8d44\u7f16\u7801\u6709\u8bef");
                resultList.add(false);
                continue;
            }
            resultList.add(true);
        }
        for (Boolean flag : resultList) {
            if (flag.booleanValue()) continue;
            return false;
        }
        return true;
    }

    List<UocOrdImportDataBO> getDataList(Map<Long, List<UocOrdImportDataBO>> dataMap, Set<Long> DataSet) {
        ArrayList<UocOrdImportDataBO> returnList = new ArrayList<UocOrdImportDataBO>();
        for (Long key : DataSet) {
            returnList.addAll((Collection<UocOrdImportDataBO>)dataMap.get(key));
        }
        return returnList;
    }

    private void checkOrderOnlyId(List<UocOrdImportDataBO> dataList) {
        for (UocOrdImportDataBO bo : dataList) {
            if (bo.getOrderOnlyId() != null) continue;
            throw new BusinessException("8888", "\u5b58\u5728\u8ba2\u5355\u552f\u4e00\u6027\u6807\u8bc6\u4e3a\u7a7a\u7684\u660e\u7ec6,\u65e0\u6cd5\u8bc6\u522b,\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
        }
    }

    private Boolean CheckData(List<UocOrdImportDataBO> dataList, Integer isHtInit) {
        ArrayList<Boolean> resultList = new ArrayList<Boolean>();
        if (PebExtConstant.YES.equals(isHtInit)) {
            for (UocOrdImportDataBO bo : dataList) {
                if (StringUtils.isBlank((CharSequence)bo.getBuynerNo())) {
                    bo.setFailReason("\u4e70\u53d7\u4eba\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getAcquirerId())) {
                    bo.setFailReason("\u6536\u5355\u65b9\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getConsigneeId())) {
                    bo.setFailReason("\u6536\u8d27\u65b9\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getSupNo())) {
                    bo.setFailReason("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getMaterialCategory())) {
                    bo.setFailReason("\u7269\u8d44\u7c7b\u522b\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getOrigin()) || "\u8fdb\u53e3".equals(bo.getOrigin()) && "\u56fd\u4ea7".equals(bo.getOrigin())) {
                    bo.setFailReason("\u8fdb\u53e3/\u56fd\u4ea7\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getIsPushErp()) || "\u4e0d\u63a8\u9001".equals(bo.getIsPushErp()) && "\u63a8\u9001".equals(bo.getIsPushErp())) {
                    bo.setFailReason("\u8ba2\u5355\u63a8\u9001ERP\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactAddress())) {
                    bo.setFailReason("\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getAddrJc())) {
                    bo.setFailReason("\u5730\u5740\u7b80\u79f0\u540d\u79f0\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getVendorSiteId())) {
                    bo.setFailReason("\u5730\u5740\u7b80\u79f0ID\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getSkuMaterialId())) {
                    bo.setFailReason("\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getUnitName())) {
                    bo.setFailReason("\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (bo.getPurchaseCount() == null || bo.getPurchaseCount().equals(BigDecimal.ZERO)) {
                    bo.setFailReason("\u6570\u91cf\u4e3a\u7a7a\u6216\u8005\u4e3a0");
                    resultList.add(false);
                    continue;
                }
                if (bo.getSalePrice() == null) {
                    bo.setFailReason("\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (bo.getTax() == null) {
                    bo.setFailReason("\u7a0e\u7387\uff08%\uff09\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getOrganizationId())) {
                    bo.setFailReason("\u7533\u62a5\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getArrivalTime())) {
                    bo.setFailReason("\u4ea4\u8d27\u65e5\u671f\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getSpec())) {
                    bo.setFailReason("\u89c4\u683c\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getModel())) {
                    bo.setFailReason("\u578b\u53f7\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContractNo())) {
                    bo.setFailReason("\u5408\u540c\u7f16\u53f7\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                resultList.add(true);
            }
        } else {
            for (UocOrdImportDataBO bo : dataList) {
                if (StringUtils.isBlank((CharSequence)bo.getBuynerNo())) {
                    bo.setFailReason("\u4e70\u53d7\u4eba\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getAcquirerId())) {
                    bo.setFailReason("\u6536\u5355\u65b9\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getConsigneeId())) {
                    bo.setFailReason("\u6536\u8d27\u65b9\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getSupNo())) {
                    bo.setFailReason("\u4f9b\u5e94\u5546\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getMaterialCategory())) {
                    bo.setFailReason("\u7269\u8d44\u7c7b\u522b\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getOrigin()) || "\u8fdb\u53e3".equals(bo.getOrigin()) && "\u56fd\u4ea7".equals(bo.getOrigin())) {
                    bo.setFailReason("\u8fdb\u53e3/\u56fd\u4ea7\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getIsPushErp()) || "\u4e0d\u63a8\u9001".equals(bo.getIsPushErp()) && "\u63a8\u9001".equals(bo.getIsPushErp())) {
                    bo.setFailReason("\u8ba2\u5355\u63a8\u9001ERP\u4e3a\u7a7a\u6216\u8005\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactName())) {
                    bo.setFailReason("\u6536\u8d27\u4eba\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactCompany())) {
                    bo.setFailReason("\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactProvinceName())) {
                    bo.setFailReason("\u7701\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactCityName())) {
                    bo.setFailReason("\u5e02\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactCountyName())) {
                    bo.setFailReason("\u533a/\u53bf\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactAddress())) {
                    bo.setFailReason("\u8be6\u7ec6\u5730\u5740\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getContactMobile())) {
                    bo.setFailReason("\u624b\u673a\u53f7\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getAddrJc())) {
                    bo.setFailReason("\u5730\u5740\u7b80\u79f0\u540d\u79f0\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getVendorSiteId())) {
                    bo.setFailReason("\u5730\u5740\u7b80\u79f0ID\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getSkuMaterialId())) {
                    bo.setFailReason("\u7269\u8d44\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getUnitName())) {
                    bo.setFailReason("\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (bo.getPurchaseCount() == null || bo.getPurchaseCount().equals(BigDecimal.ZERO)) {
                    bo.setFailReason("\u6570\u91cf\u4e3a\u7a7a\u6216\u8005\u4e3a0");
                    resultList.add(false);
                    continue;
                }
                if (bo.getSalePrice() == null) {
                    bo.setFailReason("\u542b\u7a0e\u5355\u4ef7\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (bo.getTax() == null) {
                    bo.setFailReason("\u7a0e\u7387\uff08%\uff09\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getOrganizationId())) {
                    bo.setFailReason("\u7533\u62a5\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getArrivalTime())) {
                    bo.setFailReason("\u4ea4\u8d27\u65e5\u671f\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getSpec())) {
                    bo.setFailReason("\u89c4\u683c\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)bo.getModel())) {
                    bo.setFailReason("\u578b\u53f7\u4e3a\u7a7a");
                    resultList.add(false);
                    continue;
                }
                resultList.add(true);
            }
        }
        for (Boolean flag : resultList) {
            if (flag.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private List<String> getTitile() {
        ArrayList<String> title = new ArrayList<String>();
        List<String> arrayList = Arrays.asList("*\u8ba2\u5355\u552f\u4e00\u6027\u6807\u8bc6", "*\u4e70\u53d7\u4eba\u7f16\u7801", "*\u6536\u5355\u65b9\u7f16\u7801", "*\u6536\u8d27\u65b9\u7f16\u7801", "*\u4f9b\u5e94\u5546\u7f16\u7801", "*\u7269\u8d44\u7c7b\u522b", "*\u8fdb\u53e3/\u56fd\u4ea7", "*\u8ba2\u5355\u63a8\u9001ERP", "\u8ba2\u5355\u540d\u79f0", "*\u6536\u8d27\u4eba", "*\u516c\u53f8\u540d\u79f0", "*\u7701", "*\u5e02", "*\u533a/\u53bf", "\u4e61\u9547/\u8857\u9053", "*\u8be6\u7ec6\u5730\u5740", "\u90ae\u7bb1", "*\u624b\u673a\u53f7\u7801", "*\u5730\u5740\u7b80\u79f0ID", "*\u5730\u5740\u7b80\u79f0\u540d\u79f0", "*\u7269\u8d44\u7f16\u7801", "*\u8ba1\u91cf\u5355\u4f4d", "*\u6570\u91cf", "*\u542b\u7a0e\u5355\u4ef7", "*\u7a0e\u7387\uff08%\uff09", "*\u7533\u62a5\u5355\u4f4d\u7f16\u7801", "*\u4ea4\u8d27\u65e5\u671f", "\u6bd4\u4ef7\u7c7b\u522b", "\u5bf9\u6bd4\u5355\u4ef7", "*\u89c4\u683c", "*\u578b\u53f7", "\u90e8\u4ef6\u53f7", "\u8d28\u91cf\u6280\u672f\u8981\u6c42", "\u5177\u4f53\u7528\u9014", "\u6267\u884c\u6807\u51c6", "\u4ea7\u5730\u54c1\u724c", "\u5230/\u51fa\u5382\u4ef7", "\u5907\u6ce8");
        title.addAll(arrayList);
        return title;
    }

    private List<String> getHtInitTitle() {
        ArrayList<String> title = new ArrayList<String>();
        List<String> arrayList = Arrays.asList("*\u8ba2\u5355\u552f\u4e00\u6027\u6807\u8bc6", "*\u4e70\u53d7\u4eba\u7f16\u7801", "*\u6536\u5355\u65b9\u7f16\u7801", "*\u6536\u8d27\u65b9\u7f16\u7801", "*\u4f9b\u5e94\u5546\u7f16\u7801", "*\u7269\u8d44\u7c7b\u522b", "*\u8fdb\u53e3/\u56fd\u4ea7", "*\u8ba2\u5355\u63a8\u9001ERP", "\u8ba2\u5355\u540d\u79f0", "*\u6536\u8d27\u4eba", "*\u516c\u53f8\u540d\u79f0", "*\u7701", "*\u5e02", "*\u533a/\u53bf", "\u4e61\u9547/\u8857\u9053", "*\u8be6\u7ec6\u5730\u5740", "\u90ae\u7bb1", "*\u624b\u673a\u53f7\u7801", "*\u5730\u5740\u7b80\u79f0ID", "*\u5730\u5740\u7b80\u79f0\u540d\u79f0", "*\u7269\u8d44\u7f16\u7801", "*\u8ba1\u91cf\u5355\u4f4d", "*\u6570\u91cf", "*\u542b\u7a0e\u5355\u4ef7", "*\u7a0e\u7387\uff08%\uff09", "*\u7533\u62a5\u5355\u4f4d\u7f16\u7801", "*\u4ea4\u8d27\u65e5\u671f", "\u6bd4\u4ef7\u7c7b\u522b", "\u5bf9\u6bd4\u5355\u4ef7", "*\u89c4\u683c", "*\u578b\u53f7", "\u90e8\u4ef6\u53f7", "\u8d28\u91cf\u6280\u672f\u8981\u6c42", "\u5177\u4f53\u7528\u9014", "\u6267\u884c\u6807\u51c6", "\u4ea7\u5730\u54c1\u724c", "\u5230/\u51fa\u5382\u4ef7", "\u5907\u6ce8", "*\u5408\u540c\u7f16\u7801");
        title.addAll(arrayList);
        return title;
    }

    private void validateUocOrdImportReqBO(UocOrdImportReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u67e5\u8be2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFileName())) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u67e5\u8be2[fileName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getFileUrl())) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u67e5\u8be2[fileUrl]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocOrdImportListPageQueryReqBO(UocOrdImportListPageQueryReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u67e5\u8be2[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getUserId() == null) {
            throw new BusinessException("8888", "\u5408\u540c\u8ba2\u5355\u67e5\u8be2[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

