/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.enums.PebCommonStatus;
import com.tydic.uoc.base.enums.PebOrderTypeStatus;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.common.ability.bo.OrdPayConfRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdAccessoryRspBO;
import com.tydic.uoc.common.atom.api.SelectDicValByPcodeAndCode;
import com.tydic.uoc.common.atom.bo.SelectSingleDictReqBO;
import com.tydic.uoc.common.atom.bo.SelectSingleDictRspBO;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdAccessoryHistoryMapper;
import com.tydic.uoc.dao.UocOrdAccessoryTempMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempxMapper;
import com.tydic.uoc.dao.UocOrdLogisticsRelaHistoryMapper;
import com.tydic.uoc.dao.UocOrdLogisticsRelaTempMapper;
import com.tydic.uoc.dao.UocOrdZmInfoHistoryMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrdZmInfoTempMapper;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdAccessoryHistoryPO;
import com.tydic.uoc.po.UocOrdAccessoryTempPO;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrdLogisticsRelaHistoryPO;
import com.tydic.uoc.po.UocOrdLogisticsRelaTempPO;
import com.tydic.uoc.po.UocOrdZmInfoHistoryPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrdZmInfoTempPO;
import com.tydic.uoc.zone.ability.api.UocOrderChangeDetailAbilityService;
import com.tydic.uoc.zone.ability.bo.UocOrderDetailBO;
import com.tydic.uoc.zone.ability.bo.UocQueryOrderChangeDetailServiceReqBO;
import com.tydic.uoc.zone.ability.bo.UocQueryOrderChangeDetailServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.UocOrderChangeDetailAbilityService"})
public class UocOrderChangeDetailAbilityServiceImpl
implements UocOrderChangeDetailAbilityService {
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private OrdStakeholderMapper ordStakeholderMapper;
    @Resource
    private OrdAgreementMapper ordAgreementMapper;
    @Resource
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Resource
    private UocOrdZmInfoHistoryMapper uocOrdZmHistoryInfoMapper;
    @Resource
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Resource
    private UocOrdLogisticsRelaHistoryMapper ordLogisticsRelaHistoryMapper;
    @Resource
    private UocOrdZmInfoTempMapper uocOrdZmInfoTempMapper;
    @Resource
    private UocOrdLogisticsRelaTempMapper uocOrdLogisticsRelaTempMapper;
    @Resource
    private OrdPayConfMapper ordPayConfMapper;
    @Resource
    private UocOrdGoodsTempxMapper uocOrdGoodsTempxMapper;
    @Resource
    private UocOrdAccessoryTempMapper uocOrdAccessoryTempMapper;
    @Resource
    private UocOrdAccessoryHistoryMapper uocOrdAccessoryHistoryMapper;
    @Autowired
    private SelectDicValByPcodeAndCode selectDicValByPcodeAndCode;

    @PostMapping(value={"queryOrderChangeDetail"})
    public UocQueryOrderChangeDetailServiceRspBO queryOrderChangeDetail(@RequestBody UocQueryOrderChangeDetailServiceReqBO reqBO) {
        this.checkInput(reqBO);
        UocOrderDetailBO beforeOrderDetailBO = this.handleBeforeInfo(reqBO);
        UocOrderDetailBO changeOrderDetailBO = new UocOrderDetailBO();
        UocQueryOrderChangeDetailServiceRspBO rspBO = new UocQueryOrderChangeDetailServiceRspBO();
        if (Objects.nonNull(reqBO.getTempId())) {
            UocOrdZmInfoTempPO ordZmInfoTempPO;
            BeanUtils.copyProperties((Object)beforeOrderDetailBO, (Object)changeOrderDetailBO);
            if (null != changeOrderDetailBO.getIsPushErp()) {
                changeOrderDetailBO.setIsPushErpStr(1 == changeOrderDetailBO.getIsPushErp() ? "\u63a8\u9001" : "\u4e0d\u63a8\u9001");
            }
            if (Objects.nonNull(ordZmInfoTempPO = this.uocOrdZmInfoTempMapper.queryById(reqBO.getTempId()))) {
                BeanUtils.copyProperties((Object)ordZmInfoTempPO, (Object)changeOrderDetailBO);
                changeOrderDetailBO.setOriginStr("1".equals(ordZmInfoTempPO.getOrigin()) ? "\u56fd\u4ea7" : "\u8fdb\u53e3");
            }
            UocOrdGoodsTempPO po = new UocOrdGoodsTempPO();
            po.setOrderId(reqBO.getTempId());
            List uocOrdGoodsTempPOS = this.uocOrdGoodsTempxMapper.selectByCondition(po);
            BigDecimal totalSalePrice = uocOrdGoodsTempPOS.stream().map(UocOrdGoodsTempPO::getTotalSalePrice).reduce(BigDecimal.ZERO, BigDecimal::add);
            changeOrderDetailBO.setTotalSaleMoney(totalSalePrice.stripTrailingZeros());
            UocOrdLogisticsRelaTempPO uocOrdLogisticsRelaTempPO = this.uocOrdLogisticsRelaTempMapper.queryById(reqBO.getTempId());
            if (Objects.nonNull(uocOrdLogisticsRelaTempPO)) {
                BeanUtils.copyProperties((Object)uocOrdLogisticsRelaTempPO, (Object)changeOrderDetailBO);
            }
            UocOrdAccessoryTempPO uocOrdAccessoryTempPO = new UocOrdAccessoryTempPO();
            uocOrdAccessoryTempPO.setOrderId(reqBO.getOrderId());
            uocOrdAccessoryTempPO.setTempId(reqBO.getTempId());
            List ordAccessoryTempPOList = this.uocOrdAccessoryTempMapper.queryList(uocOrdAccessoryTempPO);
            if (CollectionUtils.isNotEmpty((Collection)ordAccessoryTempPOList)) {
                ArrayList orderAccessoryInfo = new ArrayList();
                ordAccessoryTempPOList.forEach(e -> {
                    UocOrdAccessoryRspBO uocOrdAccessoryRspBO = (UocOrdAccessoryRspBO)JSON.parseObject((String)JSON.toJSONString((Object)e), UocOrdAccessoryRspBO.class);
                    orderAccessoryInfo.add(uocOrdAccessoryRspBO);
                });
                changeOrderDetailBO.setOrderAccessoryInfo(orderAccessoryInfo);
            }
            changeOrderDetailBO.setCreateTime(beforeOrderDetailBO.getCreateTime());
            changeOrderDetailBO.setPurPay(beforeOrderDetailBO.getPurPay());
        }
        rspBO.setBeforeOrderDetail(beforeOrderDetailBO);
        rspBO.setChangeOrderDetail(changeOrderDetailBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkInput(UocQueryOrderChangeDetailServiceReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
    }

    private UocOrderDetailBO handleBeforeInfo(UocQueryOrderChangeDetailServiceReqBO reqBO) {
        Long saleFee;
        UocOrdZmInfoHistoryPO uocOrdZmInfoHistoryPO;
        int version;
        UocOrderDetailBO beforeOrderDetailBO = new UocOrderDetailBO();
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (Objects.isNull(orderPO)) {
            throw new UocProBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4e3b\u5355\u4fe1\u606f");
        }
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelById(reqBO.getSaleVoucherId().longValue());
        if (Objects.isNull(ordSalePO)) {
            throw new UocProBusinessException("101018", "\u672a\u67e5\u8be2\u5230\u9500\u552e\u4e3b\u5355\u4fe1\u606f");
        }
        OrdStakeholderPO ordStakeholderPO = new OrdStakeholderPO();
        ordStakeholderPO.setOrderId(reqBO.getOrderId());
        ordStakeholderPO = this.ordStakeholderMapper.getModelBy(ordStakeholderPO);
        OrdAgreementPO ordAgreementPO = new OrdAgreementPO();
        ordAgreementPO.setOrderId(reqBO.getOrderId());
        List ordAgreementPOList = this.ordAgreementMapper.selectByCondition(ordAgreementPO);
        if (Objects.isNull(reqBO.getTempId())) {
            version = 2;
        } else {
            uocOrdZmInfoHistoryPO = new UocOrdZmInfoHistoryPO();
            uocOrdZmInfoHistoryPO.setOrderId(reqBO.getOrderId());
            uocOrdZmInfoHistoryPO.setTempId(reqBO.getTempId());
            uocOrdZmInfoHistoryPO.setSaleStateNot(UocConstant.SALE_ORDER_STATUS.AUDIT_REFUSE);
            List historyPOList = this.uocOrdZmHistoryInfoMapper.queryList(uocOrdZmInfoHistoryPO);
            int n = version = CollectionUtils.isEmpty((Collection)historyPOList) ? 2 : ((UocOrdZmInfoHistoryPO)historyPOList.get(0)).getVersion();
            if (CollectionUtils.isEmpty((Collection)historyPOList)) {
                uocOrdZmInfoHistoryPO.setTempId(null);
                uocOrdZmInfoHistoryPO.setOrderBy("version DESC");
                historyPOList = this.uocOrdZmHistoryInfoMapper.queryList(uocOrdZmInfoHistoryPO);
                version = ((UocOrdZmInfoHistoryPO)historyPOList.get(0)).getVersion() + 1;
            }
        }
        uocOrdZmInfoHistoryPO = new UocOrdZmInfoHistoryPO();
        uocOrdZmInfoHistoryPO.setOrderId(reqBO.getOrderId());
        uocOrdZmInfoHistoryPO.setVersion(Integer.valueOf(version - 1));
        List ordZmInfoHistoryPOList = this.uocOrdZmHistoryInfoMapper.queryList(uocOrdZmInfoHistoryPO);
        if (CollectionUtils.isEmpty((Collection)ordZmInfoHistoryPOList)) {
            UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
            uocOrdZmInfoPO.setOrderId(reqBO.getOrderId());
            uocOrdZmInfoPO = this.uocOrdZmInfoMapper.selectOne(uocOrdZmInfoPO);
            BeanUtils.copyProperties((Object)uocOrdZmInfoPO, (Object)uocOrdZmInfoHistoryPO);
            uocOrdZmInfoHistoryPO.setTaxRate(uocOrdZmInfoPO.getTaxrate());
        } else {
            uocOrdZmInfoHistoryPO = (UocOrdZmInfoHistoryPO)ordZmInfoHistoryPOList.get(0);
        }
        UocOrdLogisticsRelaHistoryPO ordLogisticsRelaHistoryPO = new UocOrdLogisticsRelaHistoryPO();
        ordLogisticsRelaHistoryPO.setOrderId(reqBO.getOrderId());
        ordLogisticsRelaHistoryPO.setVersion(Integer.valueOf(version - 1));
        List ordLogisticsRelaHistoryPOList = this.ordLogisticsRelaHistoryMapper.queryList(ordLogisticsRelaHistoryPO);
        if (CollectionUtils.isEmpty((Collection)ordLogisticsRelaHistoryPOList)) {
            OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
            ordLogisticsRelaPO.setOrderId(reqBO.getOrderId());
            ordLogisticsRelaPO = this.ordLogisticsRelaMapper.getModelBy(ordLogisticsRelaPO);
            BeanUtils.copyProperties((Object)ordLogisticsRelaPO, (Object)ordLogisticsRelaHistoryPO);
        } else {
            ordLogisticsRelaHistoryPO = (UocOrdLogisticsRelaHistoryPO)ordLogisticsRelaHistoryPOList.get(0);
        }
        UocOrdAccessoryHistoryPO uocOrdAccessoryHistoryPO = new UocOrdAccessoryHistoryPO();
        uocOrdAccessoryHistoryPO.setOrderId(reqBO.getOrderId());
        uocOrdAccessoryHistoryPO.setVersion(Integer.valueOf(version - 1));
        List ordAccessoryHistoryPOList = this.uocOrdAccessoryHistoryMapper.queryList(uocOrdAccessoryHistoryPO);
        if (!StringUtils.isEmpty((Object)orderPO.getOrderType())) {
            beforeOrderDetailBO.setIsNcStr(PebOrderTypeStatus.PRODUCTION.getCode().equals(orderPO.getOrderType()) ? PebCommonStatus.YES.getName() : PebCommonStatus.NOT.getName());
        }
        beforeOrderDetailBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        beforeOrderDetailBO.setSaleVoucherNo(ordSalePO.getSaleVoucherNo());
        beforeOrderDetailBO.setSaleState(ordSalePO.getSaleState());
        SelectSingleDictReqBO dictReqBO = new SelectSingleDictReqBO();
        dictReqBO.setCode(ordSalePO.getSaleState() + "");
        dictReqBO.setPcode("SALE_ORDER_STATUS");
        SelectSingleDictRspBO dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            beforeOrderDetailBO.setSaleStateStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        if (CollectionUtils.isNotEmpty((Collection)ordAgreementPOList)) {
            beforeOrderDetailBO.setPlaAgreementCode(((OrdAgreementPO)ordAgreementPOList.get(0)).getPlaAgreementCode());
            beforeOrderDetailBO.setEntAgreementCode(((OrdAgreementPO)ordAgreementPOList.get(0)).getEntAgreementCode());
            beforeOrderDetailBO.setAgreementName(((OrdAgreementPO)ordAgreementPOList.get(0)).getAgreementName());
        }
        if (Objects.nonNull(ordStakeholderPO)) {
            BeanUtils.copyProperties((Object)ordStakeholderPO, (Object)beforeOrderDetailBO);
            if (Objects.isNull(beforeOrderDetailBO.getSupAccountName())) {
                beforeOrderDetailBO.setSupAccountName(ordStakeholderPO.getSupName());
            }
        }
        if (Objects.nonNull(uocOrdZmInfoHistoryPO)) {
            BeanUtils.copyProperties((Object)uocOrdZmInfoHistoryPO, (Object)beforeOrderDetailBO);
            dictReqBO.setCode(uocOrdZmInfoHistoryPO.getPurType());
            dictReqBO.setPcode("PEB_PROCUREMENT_TYPE");
            dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
            if ("0000".equals(dictRspBO.getRespCode())) {
                beforeOrderDetailBO.setPurTypeStr(dictRspBO.getDicDictionarys().getDescrip());
            }
            beforeOrderDetailBO.setAddrJc(uocOrdZmInfoHistoryPO.getAddrJc());
            beforeOrderDetailBO.setVendorSiteId(uocOrdZmInfoHistoryPO.getVendorSiteId());
            beforeOrderDetailBO.setVendorSiteName(uocOrdZmInfoHistoryPO.getVendorSiteName());
            beforeOrderDetailBO.setBuynerNo(uocOrdZmInfoHistoryPO.getBuynerNo());
            beforeOrderDetailBO.setBuynerErpNo(uocOrdZmInfoHistoryPO.getBuynerErpNo());
            beforeOrderDetailBO.setAcquirerId(uocOrdZmInfoHistoryPO.getAcquirerId());
            beforeOrderDetailBO.setConsigneeId(uocOrdZmInfoHistoryPO.getConsigneeId());
            beforeOrderDetailBO.setOriginStr("1".equals(uocOrdZmInfoHistoryPO.getOrigin()) ? "\u56fd\u4ea7" : "\u8fdb\u53e3");
            beforeOrderDetailBO.setPurCompanyName(uocOrdZmInfoHistoryPO.getPurCompanyName());
        }
        if (Objects.nonNull(ordLogisticsRelaHistoryPO)) {
            BeanUtils.copyProperties((Object)ordLogisticsRelaHistoryPO, (Object)beforeOrderDetailBO);
        }
        if (CollectionUtils.isNotEmpty((Collection)ordAccessoryHistoryPOList)) {
            ArrayList orderAccessoryInfo = new ArrayList();
            ordAccessoryHistoryPOList.forEach(e -> {
                UocOrdAccessoryRspBO uocOrdAccessoryRspBO = (UocOrdAccessoryRspBO)JSON.parseObject((String)JSON.toJSONString((Object)e), UocOrdAccessoryRspBO.class);
                orderAccessoryInfo.add(uocOrdAccessoryRspBO);
            });
            beforeOrderDetailBO.setOrderAccessoryInfo(orderAccessoryInfo);
        }
        dictReqBO.setCode(orderPO.getPayType() + "");
        dictReqBO.setPcode("PAY_TYPE");
        dictRspBO = this.selectDicValByPcodeAndCode.selectDicValByPcodeAndCode(dictReqBO);
        if ("0000".equals(dictRspBO.getRespCode())) {
            beforeOrderDetailBO.setPayTypeStr(dictRspBO.getDicDictionarys().getDescrip());
        }
        if (Objects.isNull(beforeOrderDetailBO.getOrderName())) {
            beforeOrderDetailBO.setOrderName(orderPO.getOrderName());
        }
        if (Objects.nonNull(orderPO.getExt4())) {
            beforeOrderDetailBO.setIsTax(Integer.valueOf(orderPO.getExt4()));
        }
        if ((saleFee = ordSalePO.getSaleFee()) != null) {
            beforeOrderDetailBO.setTotalSaleMoney(MoneyUtil.l4B((Long)saleFee));
        }
        beforeOrderDetailBO.setOrderId(orderPO.getOrderId());
        beforeOrderDetailBO.setCreateTime(orderPO.getCreateTime());
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        payConfPO.setOrderId(reqBO.getOrderId());
        payConfPO.setUserType(Integer.valueOf(1));
        List payConfPOList = this.ordPayConfMapper.selectByCondition(payConfPO);
        if (!CollectionUtils.isEmpty((Collection)payConfPOList)) {
            OrdPayConfRspBO ordPayConfRspBO = new OrdPayConfRspBO();
            BeanUtils.copyProperties(payConfPOList.get(0), (Object)ordPayConfRspBO);
            beforeOrderDetailBO.setPurPay(ordPayConfRspBO);
        }
        return beforeOrderDetailBO;
    }
}

