/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.agreement.ability.api.AgrQryAgreementByPageAbilityService;
import com.tydic.agreement.ability.api.AgrQryAgreementSkuByPageAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrAgreementSkuBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementByPageAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSkuByPageAbilityRspBO;
import com.tydic.uoc.base.enums.PpcPlanStatus;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.po.PlanDiversionInfo;
import com.tydic.uoc.zone.ability.api.UocPlanSubmitOrderCheckService;
import com.tydic.uoc.zone.ability.bo.UocPlanSubmitOrderCheckReq;
import com.tydic.uoc.zone.ability.bo.UocPlanSubmitOrderCheckRsp;
import com.tydic.uoc.zone.ability.bo.UocPlanSubmitOrderProtocolItem;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.UocPlanSubmitOrderCheckService"})
public class UocPlanSubmitOrderCheckServiceImpl
implements UocPlanSubmitOrderCheckService {
    private static final Logger log = LoggerFactory.getLogger(UocPlanSubmitOrderCheckServiceImpl.class);
    @Autowired
    private AgrQryAgreementByPageAbilityService agrQryAgreementByPageAbilityService;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;
    @Autowired
    private AgrQryAgreementSkuByPageAbilityService agrQryAgreementSkuByPageAbilityService;

    @PostMapping(value={"checkSubmit"})
    public UocPlanSubmitOrderCheckRsp checkSubmit(@RequestBody UocPlanSubmitOrderCheckReq uocPlanSubmitOrderCheckReq) {
        log.debug("UocPlanSubmitOrderCheckService checkSubmit param:{}", (Object)JSON.toJSONString((Object)uocPlanSubmitOrderCheckReq));
        UocPlanSubmitOrderCheckRsp uocPlanSubmitOrderCheckRsp = new UocPlanSubmitOrderCheckRsp();
        TreeSet<String> protocolFialList = new TreeSet<String>();
        uocPlanSubmitOrderCheckRsp.setRespCode("8888");
        try {
            if (Objects.isNull(uocPlanSubmitOrderCheckReq) || CollectionUtils.isEmpty((Collection)uocPlanSubmitOrderCheckReq.getUocPlanSubmitOrderProtocolItems())) {
                uocPlanSubmitOrderCheckRsp.setRespDesc("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                return uocPlanSubmitOrderCheckRsp;
            }
            List agrIds = uocPlanSubmitOrderCheckReq.getUocPlanSubmitOrderProtocolItems().stream().map(UocPlanSubmitOrderProtocolItem::getAgreementId).collect(Collectors.toList());
            AgrQryAgreementByPageAbilityReqBO agrQryAgreementByPageAbilityReqBO = new AgrQryAgreementByPageAbilityReqBO();
            agrQryAgreementByPageAbilityReqBO.setAgreementIds(agrIds);
            agrQryAgreementByPageAbilityReqBO.setPageQueryFlag(Boolean.valueOf(false));
            AgrQryAgreementByPageAbilityRspBO agrQryAgreementByPageAbilityRspBO = this.agrQryAgreementByPageAbilityService.qryAgreementInfoByPage(agrQryAgreementByPageAbilityReqBO);
            log.info("UocPlanSubmitOrderCheckService checkSubmit agrQryAgreementByPageAbilityRspBO:{}", (Object)JSON.toJSONString((Object)agrQryAgreementByPageAbilityRspBO));
            List<AgrAgreementBO> rows = agrQryAgreementByPageAbilityRspBO.getRows();
            if (CollectionUtils.isEmpty((Collection)rows)) {
                uocPlanSubmitOrderCheckRsp.setRespDesc("\u672a\u67e5\u8be2\u5230\u534f\u8bae\u4fe1\u606f");
                return uocPlanSubmitOrderCheckRsp;
            }
            if (CollectionUtils.isEmpty(rows = rows.stream().filter($ -> Objects.nonNull($.getOrderMethod()) && $.getOrderMethod() == 2).collect(Collectors.toList()))) {
                uocPlanSubmitOrderCheckRsp.setRespCode("0000");
                uocPlanSubmitOrderCheckRsp.setRespDesc("\u6210\u529f");
                return uocPlanSubmitOrderCheckRsp;
            }
            Map<Long, List<AgrAgreementBO>> agrMap = rows.stream().collect(Collectors.groupingBy(AgrAgreementBO::getAgreementId));
            Map<Long, List<UocPlanSubmitOrderProtocolItem>> protocolMap = uocPlanSubmitOrderCheckReq.getUocPlanSubmitOrderProtocolItems().stream().collect(Collectors.groupingBy(UocPlanSubmitOrderProtocolItem::getAgreementId));
            switch (uocPlanSubmitOrderCheckReq.getSubmitType()) {
                case "0": {
                    this.cartOrder(rows, uocPlanSubmitOrderCheckReq, protocolFialList, agrMap, protocolMap);
                    break;
                }
                case "1": {
                    this.planOrder(rows, uocPlanSubmitOrderCheckReq, protocolFialList, agrMap, protocolMap);
                    break;
                }
                case "2": {
                    this.protocolOrder(rows, uocPlanSubmitOrderCheckReq, protocolFialList, agrMap, protocolMap);
                }
            }
        }
        catch (Exception e) {
            log.error("UocPlanSubmitOrderCheckService checkSubmit error:{}", (Throwable)e);
            uocPlanSubmitOrderCheckRsp.setRespCode("8888");
            uocPlanSubmitOrderCheckRsp.setRespDesc("\u5931\u8d25");
            return uocPlanSubmitOrderCheckRsp;
        }
        uocPlanSubmitOrderCheckRsp.setProtocolFialList(protocolFialList);
        uocPlanSubmitOrderCheckRsp.setRespCode("0000");
        uocPlanSubmitOrderCheckRsp.setRespDesc("\u6210\u529f");
        return uocPlanSubmitOrderCheckRsp;
    }

    private void protocolOrder(List<AgrAgreementBO> agrAgreementBOS, UocPlanSubmitOrderCheckReq uocPlanSubmitOrderCheckReq, Set<String> protocolFialList, Map<Long, List<AgrAgreementBO>> agrMap, Map<Long, List<UocPlanSubmitOrderProtocolItem>> protocolMap) throws Exception {
        this.checkOrder(uocPlanSubmitOrderCheckReq, protocolFialList, agrAgreementBOS, protocolMap, agrMap);
    }

    private void checkOrder(UocPlanSubmitOrderCheckReq uocPlanSubmitOrderCheckReq, Set<String> protocolFialList, List<AgrAgreementBO> agrAgreementBOS, Map<Long, List<UocPlanSubmitOrderProtocolItem>> protocolMap, Map<Long, List<AgrAgreementBO>> agrMap) throws Exception {
        log.info("UocPlanSubmitOrderCheckService checkOrder protocolMap:{},agrMap:{},agrAgreementBOS:{}", new Object[]{JSON.toJSONString(protocolMap), JSON.toJSONString(agrMap), JSON.toJSONString(agrAgreementBOS)});
        List uocPlanSubmitOrderProtocolItems = uocPlanSubmitOrderCheckReq.getUocPlanSubmitOrderProtocolItems();
        Map<Long, List<UocPlanSubmitOrderProtocolItem>> collect1 = uocPlanSubmitOrderProtocolItems.stream().collect(Collectors.groupingBy(UocPlanSubmitOrderProtocolItem::getAgreementSkuId));
        Map<Long, List<AgrAgreementBO>> collect2 = agrAgreementBOS.stream().collect(Collectors.groupingBy(AgrAgreementBO::getAgreementId));
        List agrIds = uocPlanSubmitOrderProtocolItems.stream().map(UocPlanSubmitOrderProtocolItem::getAgreementId).collect(Collectors.toList());
        AgrQryAgreementSkuByPageAbilityReqBO abilityReqBO = new AgrQryAgreementSkuByPageAbilityReqBO();
        abilityReqBO.setAgreementIds(agrIds);
        AgrQryAgreementSkuByPageAbilityRspBO agrQryAgreementSkuByPageAbilityRspBO = this.agrQryAgreementSkuByPageAbilityService.qryAgreementSkuByPage(abilityReqBO);
        List rows = agrQryAgreementSkuByPageAbilityRspBO.getRows();
        log.info("UocPlanSubmitOrderCheckService checkOrder agrQryAgreementSkuByPageAbilityRspBO:{}", (Object)JSON.toJSONString((Object)rows));
        List collect = rows.stream().filter($ -> "2".equals($.getSaleStatus())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            for (int i = 0; i < collect.size(); ++i) {
                UocPlanSubmitOrderProtocolItem uocPlanSubmitOrderProtocolItem;
                AgrAgreementSkuBO agrAgreementSkuBO = (AgrAgreementSkuBO)collect.get(i);
                List<AgrAgreementBO> agrAgreementBOS1 = collect2.get(agrAgreementSkuBO.getAgreementId());
                List<UocPlanSubmitOrderProtocolItem> uocPlanSubmitOrderProtocolItems1 = collect1.get(agrAgreementSkuBO.getAgreementSkuId());
                if (CollectionUtils.isEmpty(uocPlanSubmitOrderProtocolItems1) || (uocPlanSubmitOrderProtocolItem = uocPlanSubmitOrderProtocolItems1.get(0)).getQuantity().compareTo(agrAgreementSkuBO.getCurrentStockNumber()) <= 0) continue;
                protocolFialList.add(agrAgreementBOS1.get(0).getPlaAgreementCode());
            }
        }
        for (Long key : protocolMap.keySet()) {
            List<UocPlanSubmitOrderProtocolItem> uocPlanSubmitOrderProtocolItems1 = protocolMap.get(key);
            List<AgrAgreementBO> agrAgreementBOS1 = agrMap.get(key);
            if (CollectionUtils.isEmpty(agrAgreementBOS1) || Objects.isNull(agrAgreementBOS1.get(0).getOrderQuota())) continue;
            AgrAgreementBO agrAgreementBO = agrAgreementBOS1.get(0);
            BigDecimal reduce = uocPlanSubmitOrderProtocolItems1.stream().map($ -> $.getSalePrice().multiply($.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reduce.compareTo(agrAgreementBO.getOrderQuota()) <= 0) continue;
            protocolFialList.add(agrAgreementBO.getPlaAgreementCode());
        }
    }

    private void cartOrder(List<AgrAgreementBO> agrAgreementBOS, UocPlanSubmitOrderCheckReq uocPlanSubmitOrderCheckReq, Set<String> protocolFialList, Map<Long, List<AgrAgreementBO>> agrMap, Map<Long, List<UocPlanSubmitOrderProtocolItem>> protocolMap) throws Exception {
        this.checkOrder(uocPlanSubmitOrderCheckReq, protocolFialList, agrAgreementBOS, protocolMap, agrMap);
    }

    private void planOrder(List<AgrAgreementBO> agrAgreementBOS, UocPlanSubmitOrderCheckReq uocPlanSubmitOrderCheckReq, Set<String> protocolFialList, Map<Long, List<AgrAgreementBO>> agrMap, Map<Long, List<UocPlanSubmitOrderProtocolItem>> protocolMap) {
        if (CollectionUtils.isEmpty(agrAgreementBOS)) {
            return;
        }
        List planIds = uocPlanSubmitOrderCheckReq.getUocPlanSubmitOrderProtocolItems().stream().map(UocPlanSubmitOrderProtocolItem::getPlanId).collect(Collectors.toList());
        List listByPlanIds = this.planDiversionMapper.getListByPlanIds(planIds);
        listByPlanIds.forEach(e -> {
            if (PpcPlanStatus.TERMINATE.getCode().equals(e.getPlanStatus())) {
                log.error("\u91c7\u8d2d\u8ba1\u5212\u7f16\u53f7[" + e.getScheduleNo() + "]\u72b6\u6001\u4e3a\u5df2\u7ec8\u6b62" + JSON.toJSONString((Object)e));
                throw new ZTBusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u53f7[" + e.getScheduleNo() + "]\u72b6\u6001\u4e3a\u5df2\u7ec8\u6b62");
            }
        });
        Map<Long, List<PlanDiversionInfo>> planMap = listByPlanIds.stream().collect(Collectors.groupingBy(PlanDiversionInfo::getPlanId));
        for (Long key : protocolMap.keySet()) {
            List<UocPlanSubmitOrderProtocolItem> uocPlanSubmitOrderProtocolItems = protocolMap.get(key);
            List<AgrAgreementBO> agrAgreementBOS1 = agrMap.get(key);
            AgrAgreementBO agrAgreementBO = agrAgreementBOS1.get(0);
            BigDecimal reduce = uocPlanSubmitOrderProtocolItems.stream().map($ -> $.getSalePrice().multiply($.getQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (reduce.compareTo(agrAgreementBO.getOrderQuota()) > 0) {
                protocolFialList.add(agrAgreementBO.getPlaAgreementCode());
            }
            for (int i = 0; i < uocPlanSubmitOrderProtocolItems.size(); ++i) {
                UocPlanSubmitOrderProtocolItem uocPlanSubmitOrderProtocolItem = uocPlanSubmitOrderProtocolItems.get(i);
                PlanDiversionInfo planDiversionInfo = planMap.get(uocPlanSubmitOrderProtocolItem.getPlanId()).get(0);
                if (uocPlanSubmitOrderProtocolItem.getQuantity().compareTo(uocPlanSubmitOrderProtocolItem.getRemainQty().add(planDiversionInfo.getSscSchemeQty())) <= 0) continue;
                protocolFialList.add(agrAgreementBO.getPlaAgreementCode());
            }
        }
    }
}

