/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.authority.busi.bo.StationWebBO;
import com.tydic.contract.ability.ContractOrderedAmountSynAbilityService;
import com.tydic.contract.ability.ContractPlanOrderAbilityService;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityReqBO;
import com.tydic.contract.ability.bo.ContractOrderedAmountSynAbilityRspBO;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityReqBo;
import com.tydic.contract.ability.bo.ContractPlanOrderAbilityRspBo;
import com.tydic.dyc.ssc.service.scheme.SchemeAmountService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeAmountRspBO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.CommUtils;
import com.tydic.uoc.base.utils.DateUtil;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.base.utils.OrderGenerateIdUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfZmPushOrderChangeAbilityService;
import com.tydic.uoc.busibase.busi.bo.HeaderChangeDateBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfZmPushOrderChangeReqBO;
import com.tydic.uoc.busibase.busi.bo.PebIntfZmPushOrderChangeRspBO;
import com.tydic.uoc.busibase.busi.bo.PolDateBO;
import com.tydic.uoc.common.ability.bo.OrdItemRspBO;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.enums.ApproveTypeEnum;
import com.tydic.uoc.common.atom.api.UocFillMaterialCodeAtomService;
import com.tydic.uoc.common.atom.api.plan.InterFaceContractUpdateOrderItemAtomService;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomReqBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemAtomRspBO;
import com.tydic.uoc.common.atom.bo.plan.InterFaceContractUpdateOrderItemBO;
import com.tydic.uoc.common.busi.api.PebExtFieldInBusiService;
import com.tydic.uoc.common.busi.api.UocTodoDealMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.OrdInterLogBO;
import com.tydic.uoc.common.busi.bo.PebExtFieldInReqBO;
import com.tydic.uoc.common.busi.bo.PebTodoPushWaitBusiReqBO;
import com.tydic.uoc.common.busi.bo.UocTodoDealMsgLogBusiReqBO;
import com.tydic.uoc.common.comb.api.UocTodoCombService;
import com.tydic.uoc.common.utils.ElUtils;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdGoodsMapper;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayItemMapper;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdPurchaseItemMapper;
import com.tydic.uoc.dao.OrdPurchaseMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.dao.UocOrdAccessoryHistoryMapper;
import com.tydic.uoc.dao.UocOrdAccessoryTempMapper;
import com.tydic.uoc.dao.UocOrdGoodsHistoryMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.dao.UocOrdGoodsTempxMapper;
import com.tydic.uoc.dao.UocOrdLogisticsRelaHistoryMapper;
import com.tydic.uoc.dao.UocOrdLogisticsRelaTempMapper;
import com.tydic.uoc.dao.UocOrdZmInfoHistoryMapper;
import com.tydic.uoc.dao.UocOrdZmInfoMapper;
import com.tydic.uoc.dao.UocOrdZmInfoTempMapper;
import com.tydic.uoc.dao.UocOrdZmItemMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdGoodsPO;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayItemPO;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdPurchaseItemPO;
import com.tydic.uoc.po.OrdPurchasePO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import com.tydic.uoc.po.UocOrdAccessoryHistoryPO;
import com.tydic.uoc.po.UocOrdAccessoryTempPO;
import com.tydic.uoc.po.UocOrdGoodsHistoryPO;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrdLogisticsRelaHistoryPO;
import com.tydic.uoc.po.UocOrdLogisticsRelaTempPO;
import com.tydic.uoc.po.UocOrdZmInfoHistoryPO;
import com.tydic.uoc.po.UocOrdZmInfoPO;
import com.tydic.uoc.po.UocOrdZmInfoTempPO;
import com.tydic.uoc.po.UocOrdZmItemPO;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalReqBO;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalRspBO;
import com.tydic.uoc.zone.busi.api.PebChangeOrderApprovalBusiService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebChangeOrderApprovalBusiServiceImpl
implements PebChangeOrderApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebChangeOrderApprovalBusiServiceImpl.class);
    @Resource
    private OrdSaleMapper ordSaleMapper;
    @Resource
    private UocOrdZmInfoMapper uocOrdZmInfoMapper;
    @Resource
    private UocOrdZmItemMapper uocOrdZmItemMapper;
    @Resource
    private UocOrdZmInfoTempMapper uocOrdZmInfoTempMapper;
    @Resource
    private UocOrdZmInfoHistoryMapper uocOrdZmInfoHistoryMapper;
    @Resource
    private OrdGoodsMapper ordGoodsMapper;
    @Resource
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Resource
    private UocOrdGoodsTempxMapper uocOrdGoodsTempxMapper;
    @Resource
    private UocOrdGoodsHistoryMapper uocOrdGoodsHistoryMapper;
    @Resource
    private UocOrdLogisticsRelaTempMapper uocOrdLogisticsRelaTempMapper;
    @Resource
    private UocOrdLogisticsRelaHistoryMapper uocOrdLogisticsRelaHistoryMapper;
    @Resource
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Resource
    private OrdItemMapper ordItemMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private PebIntfZmPushOrderChangeAbilityService pebIntfZmPushOrderChangeAbilityService;
    @Autowired
    private PebExtFieldInBusiService pebExtFieldInBusiService;
    @Resource
    private OrdExtMapMapper ordExtMapMapper;
    @Resource
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private ContractOrderedAmountSynAbilityService contractOrderedAmountSynAbilityService;
    @Autowired
    private OrderGenerateIdUtil idUtil;
    @Resource
    private OrdPurchaseItemMapper ordPurchaseItemMapper;
    @Resource
    private OrdPurchaseMapper ordPurchaseMapper;
    @Autowired
    private ContractPlanOrderAbilityService contractPlanOrderAbilityService;
    @Autowired
    private InterFaceContractUpdateOrderItemAtomService interFaceContractUpdateOrderItemAtomService;
    @Resource
    private OrdPayMapper ordPayMapper;
    @Resource
    private OrdPayItemMapper ordPayItemMapper;
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private OrdAccessoryMapper ordAccessoryMapper;
    @Resource
    private UocOrdAccessoryTempMapper uocOrdAccessoryTempMapper;
    @Resource
    private UocOrdAccessoryHistoryMapper uocOrdAccessoryHistoryMapper;
    @Value(value="${zone.ship.maxTime:15}")
    private Integer maxShipTime;
    @Autowired
    private SchemeAmountService schemeAmountService;
    @Value(value="${UOC_SYNC_TODO_TOPIC:UOC_SYNC_TODO_TOPIC}")
    private String todoTopic;
    @Value(value="${UOC_SYNC_TODO_TAG:*}")
    private String todoTag;
    @Resource(name="uocPushTodoProvider")
    private ProxyMessageProducer uocPushTodoProvider;
    @Autowired
    private UocTodoCombService uocTodoCombService;
    @Autowired
    private UocFillMaterialCodeAtomService uocFillMaterialCodeAtomService;
    @Autowired
    private UocTodoDealMsgLogBusiService uocTodoDealMsgLogBusiService;

    @Override
    public PebOrderChangeApprovalRspBO dealPebOrderApproval(PebOrderChangeApprovalReqBO reqBO) {
        PebOrderChangeApprovalRspBO rspBO = new PebOrderChangeApprovalRspBO();
        if (!StringUtils.isBlank((CharSequence)reqBO.getName())) {
            reqBO.setUsername(reqBO.getName());
        }
        ArrayList<Long> taskList = new ArrayList<Long>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)reqBO.getUmcStationsListWebExt())) {
            List umcStationsListWebExt = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getUmcStationsListWebExt()), StationWebBO.class);
            for (StationWebBO webBO : umcStationsListWebExt) {
                taskList.add(webBO.getStationId());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(taskList)) {
            throw new UocProBusinessException("102044", "\u5f53\u524d\u7528\u6237\u5c1a\u672a\u914d\u7f6e\u89d2\u8272\uff01");
        }
        for (PebDealOrderBO orderBO : reqBO.getOrderApprovalList()) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setTaskList(taskList);
            salePO.setOrderId(orderBO.getOrderId());
            int count = this.ordSaleMapper.getAuditCount(salePO);
            if (count == 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u60a8\u6ca1\u6709\u8be5\u8ba2\u5355\u7684\u5ba1\u6279\u6743\u9650");
                return rspBO;
            }
            OrderPO orderPO = this.orderMapper.getModelById(orderBO.getOrderId().longValue());
            OrdSalePO ordSalePO = new OrdSalePO();
            ordSalePO.setOrderId(orderBO.getOrderId());
            ordSalePO = this.ordSaleMapper.getModelBy(ordSalePO);
            orderBO.setOrderSource(ordSalePO.getOrderSource());
            orderBO.setSaleFee(ordSalePO.getSaleFee());
            orderBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
            if (Objects.nonNull(orderPO)) {
                orderBO.setExt4(orderPO.getExt4());
            }
            if (StringUtils.isBlank((CharSequence)orderBO.getStepId())) {
                orderBO.setStepId(ordSalePO.getTbOrderId());
            }
            if (!UocConstant.ORDER_SOURCE.REPLENISHMENT.equals(Integer.valueOf(orderBO.getOrderSource()))) continue;
            rspBO.setPushWms(Boolean.valueOf(true));
        }
        this.audit(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5408\u540c\u8ba2\u5355\u53d8\u66f4\u5ba1\u6279\u6210\u529f");
        return rspBO;
    }

    private void audit(PebOrderChangeApprovalReqBO reqBO) {
        reqBO.getOrderApprovalList().forEach(e -> {
            String stationId = null;
            try {
                stationId = this.uocTodoCombService.getNextStationId(e.getChangeOrderId(), UocConstant.OBJ_TYPE.CHANGE);
            }
            catch (Exception ex) {
                log.error("\u67e5\u8be2\u5f53\u524d\u5ba1\u6279\u4eba\u5c97\u4f4d\u5931\u8d25\uff1a" + ex.getMessage());
            }
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(e.getStepId());
            uacNoTaskAuditOrderAuditReqBO.setAuditResult(reqBO.getAuditResult());
            uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
            uacNoTaskAuditOrderAuditReqBO.setOrgName(reqBO.getOrgName());
            uacNoTaskAuditOrderAuditReqBO.setUsername(reqBO.getUsername());
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApprovalRemark());
            uacNoTaskAuditOrderAuditReqBO.setOperDept(reqBO.getOperDept());
            if (UocConstant.ORDER_SOURCE.CONTRACT.equals(Integer.valueOf(e.getOrderSource()))) {
                uacNoTaskAuditOrderAuditReqBO.setObjType(UocConstant.OBJ_TYPE.CHANGE);
            } else {
                uacNoTaskAuditOrderAuditReqBO.setObjType(UocConstant.OBJ_TYPE.BH);
            }
            ArrayList<Long> objIds = new ArrayList<Long>();
            objIds.add(e.getChangeOrderId());
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIds);
            HashMap<String, Object> ows = new HashMap<String, Object>();
            UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
            zmInfoPO.setOrderId(e.getOrderId());
            zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
            if (Objects.isNull(zmInfoPO)) {
                throw new UocProBusinessException("102044", "\u672a\u67e5\u8be2\u5230\u4e0b\u5355\u660e\u7ec6\u4fe1\u606f\uff01");
            }
            ows.put("jhwzlb", ElUtils.getMaterialCategory((String)zmInfoPO.getMaterialCategory()));
            try {
                ows.put("ysje", MoneyUtils.Long2BigDecimal((Long)e.getSaleFee()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.uocFillMaterialCodeAtomService.fillOrderMaterialCode(ows, e.getOrderId());
            uacNoTaskAuditOrderAuditReqBO.setVariables(ows);
            OrdItemPO ordItemPO = new OrdItemPO();
            ordItemPO.setOrderId(e.getOrderId());
            List ordItemPOList = this.ordItemMapper.getItemAndSkuPic(ordItemPO);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ordItemPOList)) {
                throw new UocProBusinessException("102044", "\u672a\u67e5\u8be2\u5230\u4e0b\u5355\u660e\u7ec6\u4fe1\u606f\uff01");
            }
            UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
            if (!uacNoTaskAuditOrderAuditRspBO.getRespCode().equals("0000")) {
                throw new UocProBusinessException("102044", "\u5ba1\u6279\u5931\u8d25" + uacNoTaskAuditOrderAuditRspBO.getRespCode());
            }
            Integer pushErpFlag = this.dealSuccess((PebDealOrderBO)e, uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish(), uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getStepId(), reqBO, stationId);
            if (uacNoTaskAuditOrderAuditRspBO.getNoneInstanceBO().getFinish().booleanValue() && PebExtConstant.YES.equals(pushErpFlag)) {
                this.pushErp(zmInfoPO, ordItemPOList, e.getExt4());
            }
        });
    }

    private void pushErp(UocOrdZmInfoPO beforeZmInfoPO, List<OrdItemRspBO> beforeOrdItemPOList, String beforeExt4) {
        OrderPO orderPO = this.orderMapper.getModelById(beforeZmInfoPO.getOrderId().longValue());
        OrdSalePO ordSalePOReq = new OrdSalePO();
        ordSalePOReq.setOrderId(beforeZmInfoPO.getOrderId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(ordSalePOReq);
        UocOrdZmInfoPO zmInfoPO = new UocOrdZmInfoPO();
        zmInfoPO.setOrderId(beforeZmInfoPO.getOrderId());
        zmInfoPO = this.uocOrdZmInfoMapper.selectOne(zmInfoPO);
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(ordSalePO.getOrderId());
        List ordItemPOList = this.ordItemMapper.getItemAndSkuPic(ordItemPO);
        if (Objects.isNull(zmInfoPO) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ordItemPOList)) {
            throw new UocProBusinessException("102044", "\u672a\u67e5\u8be2\u5230\u4e0b\u5355\u4fe1\u606f\uff01");
        }
        if (Objects.nonNull(beforeZmInfoPO.getAgentId()) && !beforeZmInfoPO.getAgentId().equals(zmInfoPO.getAgentId()) || Objects.nonNull(beforeZmInfoPO.getTaxrate()) && !beforeZmInfoPO.getTaxrate().equals(zmInfoPO.getTaxrate()) || Objects.nonNull(orderPO) && StringUtils.isNotBlank((CharSequence)beforeExt4) && !beforeExt4.equals(orderPO.getExt4())) {
            this.push(ordSalePO, zmInfoPO, ordItemPOList, orderPO);
        } else {
            Map beforeItemMap = beforeOrdItemPOList.stream().collect(Collectors.toMap(OrdItemRspBO::getOrdItemId, Function.identity(), (k1, k2) -> k1));
            boolean flag = false;
            for (OrdItemRspBO item : ordItemPOList) {
                if (CollectionUtils.isEmpty(beforeItemMap) || Objects.isNull(beforeItemMap.get(item.getOrdItemId()))) {
                    flag = true;
                    break;
                }
                OrdItemRspBO beforeItem = (OrdItemRspBO)beforeItemMap.get(item.getOrdItemId());
                if (!(Objects.nonNull(item.getPurchaseCount()) && !item.getPurchaseCount().equals(beforeItem.getPurchaseCount()) || Objects.nonNull(item.getSalePrice()) && !item.getSalePrice().equals(beforeItem.getSalePrice()) || Objects.nonNull(item.getTax()) && !item.getTax().equals(beforeItem.getTax()) || StringUtils.isNotBlank((CharSequence)item.getDccj()) && !item.getDccj().equals(beforeItem.getDccj())) && (!StringUtils.isNotBlank((CharSequence)item.getArrivalTime()) || item.getArrivalTime().equals(beforeItem.getArrivalTime()))) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.push(ordSalePO, zmInfoPO, ordItemPOList, orderPO);
            } else {
                UocOrdZmInfoPO update = new UocOrdZmInfoPO();
                update.setOrderId(ordSalePO.getOrderId());
                update.setErpStatusChange(Integer.valueOf(3));
                update.setChangePushDesc("\u5f53\u524d\u5408\u540c\u8ba2\u5355\u53d8\u66f4\u672a\u6d89\u53caERP\u5b57\u6bb5\u53d8\u66f4\uff0c\u65e0\u9700\u63a8\u9001erp");
                this.uocOrdZmInfoMapper.update(update);
            }
        }
    }

    private void push(OrdSalePO ordSalePO, UocOrdZmInfoPO zmInfoPO, List<OrdItemRspBO> ordItemPOList, OrderPO orderPO) {
        PebIntfZmPushOrderChangeReqBO pushReqBO = new PebIntfZmPushOrderChangeReqBO();
        pushReqBO.setPBATCH_ID(String.valueOf(ordSalePO.getOrderId()));
        ArrayList<HeaderChangeDateBO> changeDateBOList = new ArrayList<HeaderChangeDateBO>();
        HeaderChangeDateBO changeDateBO = new HeaderChangeDateBO();
        changeDateBO.setHEADER_UUID(ordSalePO.getOrderId().toString());
        changeDateBO.setATTRIBUTE_CATEGORY("\u6613\u8d2d-\u5408\u540c\u8ba2\u5355");
        changeDateBO.setAGENT_ID(zmInfoPO.getAgentId().toString());
        changeDateBO.setORG_ID(zmInfoPO.getBuynerErpNo());
        changeDateBO.setDOC_NUM(ordSalePO.getSaleVoucherNo());
        changeDateBO.setDOC_TYPE("STANDARD");
        changeDateBO.setATTRIBUTE1(String.valueOf(zmInfoPO.getTaxrate()));
        ArrayList polDateBOList = new ArrayList();
        ordItemPOList.forEach(item -> {
            PolDateBO polDateBO = new PolDateBO();
            polDateBO.setLINE_ATTRIBUTE4(String.valueOf(item.getOrdItemId()));
            if (PebExtConstant.YES.toString().equals(orderPO.getExt4())) {
                polDateBO.setLINE_ATTRIBUTE7("Y");
                try {
                    polDateBO.setUNIT_PRICE(Objects.isNull(item.getSalePrice()) ? BigDecimal.ZERO.toPlainString() : MoneyUtils.Long2BigDecimal((Long)item.getSalePrice()).toPlainString());
                }
                catch (Exception e) {
                    log.error("\u8ba2\u5355\u53d8\u66f4\u63a8\u9001ERP\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
            } else {
                polDateBO.setLINE_ATTRIBUTE7("N");
                try {
                    BigDecimal price = new BigDecimal(item.getTax()).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                    BigDecimal taxA = price.add(BigDecimal.ONE);
                    BigDecimal djs = Objects.isNull(item.getSaleDecimalPrice()) ? BigDecimal.ZERO : item.getSaleDecimalPrice();
                    BigDecimal bud = djs.multiply(price).divide(taxA, 8, RoundingMode.HALF_UP);
                    polDateBO.setUNIT_PRICE(djs.subtract(bud).toPlainString());
                }
                catch (Exception ignored) {
                    log.error("\u8ba2\u5355\u53d8\u66f4\u63a8\u9001ERP\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
                }
            }
            polDateBO.setQUANTITY(String.valueOf(item.getPurchaseCount()));
            polDateBO.setLINE_ATTRIBUTE5(String.valueOf(item.getTax()));
            if (StringUtils.isNumeric((CharSequence)item.getDccj())) {
                polDateBO.setUN_NUMBER_ID(item.getDccj());
            } else {
                polDateBO.setUN_NUMBER_ID("\u5230\u5382\u4ef7".equals(item.getDccj()) ? "1" : "2");
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)item.getArrivalTime()) && item.getArrivalTime().contains("/")) {
                    item.setArrivalTime(item.getArrivalTime().replace("/", "-"));
                }
                polDateBO.setNEED_BY_DATE(DateUtils.dateToStr((Date)DateUtils.strToDate((String)item.getArrivalTime())));
            }
            catch (Exception ex) {
                polDateBO.setNEED_BY_DATE(item.getArrivalTime());
            }
            polDateBOList.add(polDateBO);
        });
        changeDateBO.setPOL_DATA(polDateBOList);
        changeDateBOList.add(changeDateBO);
        pushReqBO.setPOH_DATA(changeDateBOList);
        PebIntfZmPushOrderChangeRspBO rspBO = this.pebIntfZmPushOrderChangeAbilityService.pushOrderChange(pushReqBO);
        this.saveLog(ordSalePO.getOrderId(), rspBO.getReturnString(), JSON.toJSONString((Object)pushReqBO), "pushErpChange", rspBO.getRespCode(), rspBO.getRespDesc());
        UocOrdZmInfoPO update = new UocOrdZmInfoPO();
        update.setOrderId(ordSalePO.getOrderId());
        if ("0000".equals(rspBO.getRespCode())) {
            update.setErpStatusChange(Integer.valueOf(1));
        } else {
            update.setErpStatusChange(Integer.valueOf(2));
        }
        this.uocOrdZmInfoMapper.update(update);
    }

    private void saveLog(Long orderId, String out, String in, String interCode, String code, String detail) {
        OrdInterLogBO logBO = new OrdInterLogBO();
        logBO.setFlowFlag(Integer.valueOf(1));
        logBO.setInContent(in);
        logBO.setInterCode(interCode);
        logBO.setInterSn("1");
        logBO.setCallCount(Integer.valueOf(1));
        logBO.setCallState("1");
        logBO.setCreateLoginId("1");
        logBO.setCallTime(new Date());
        logBO.setErrCode(code);
        logBO.setOutContent(out);
        logBO.setRetTime(new Date());
        logBO.setObjType(UocConstant.OBJ_TYPE.CHANGE);
        logBO.setOrderId(orderId);
        logBO.setObjId(orderId);
        logBO.setErrDetail(detail);
        PebExtFieldInReqBO reqBO = new PebExtFieldInReqBO();
        reqBO.setLog(logBO);
        try {
            this.pebExtFieldInBusiService.dealSaveLog(reqBO);
        }
        catch (Exception ignored) {
            log.error("\u5408\u540c\u8ba2\u5355\u53d8\u66f4\u63a8\u9001ERP\u4fdd\u5b58\u65e5\u5fd7\u65f6\u5f02\u5e38\uff01" + ignored);
        }
    }

    private Integer dealSuccess(PebDealOrderBO orderBO, boolean finish, String stepId, PebOrderChangeApprovalReqBO reqBO, String stationId) {
        OrdSalePO ordSalePOReq = new OrdSalePO();
        ordSalePOReq.setOrderId(orderBO.getOrderId());
        OrdSalePO ordSalePO = this.ordSaleMapper.getModelBy(ordSalePOReq);
        orderBO.setSaleVoucherId(ordSalePO.getSaleVoucherId());
        Integer pushErpFlag = 0;
        if (finish) {
            Integer changeSaleState = UocConstant.ACTION_RESULT.PASS.equals(reqBO.getAuditResult()) ? UocConstant.SALE_ORDER_STATUS.APPROVE_CHANGE : UocConstant.SALE_ORDER_STATUS.AUDIT_REFUSE;
            UocOrdZmInfoTempPO ordZmInfoTempPO = this.uocOrdZmInfoTempMapper.queryById(ordSalePO.getChangeOrderId());
            UocOrdGoodsTempPO ordGoodsTempPO = new UocOrdGoodsTempPO();
            ordGoodsTempPO.setOrderId(ordSalePO.getChangeOrderId());
            List goodsTempPOList = this.uocOrdGoodsTempxMapper.selectByCondition(ordGoodsTempPO);
            UocOrdLogisticsRelaTempPO ordLogisticsRelaTempPO = this.uocOrdLogisticsRelaTempMapper.queryById(ordSalePO.getChangeOrderId());
            UocOrdAccessoryTempPO ordAccessoryTempPO = new UocOrdAccessoryTempPO();
            ordAccessoryTempPO.setTempId(ordSalePO.getChangeOrderId());
            ordAccessoryTempPO.setOrderId(ordSalePO.getOrderId());
            List uocOrdAccessoryTempPOList = this.uocOrdAccessoryTempMapper.queryList(ordAccessoryTempPO);
            if (Objects.isNull(ordZmInfoTempPO) || org.apache.commons.collections.CollectionUtils.isEmpty((Collection)goodsTempPOList) || Objects.isNull(ordLogisticsRelaTempPO)) {
                throw new UocProBusinessException("102044", "\u5ba1\u6279\u5931\u8d25, \u672a\u67e5\u8be2\u5230\u53d8\u66f4\u6570\u636e");
            }
            pushErpFlag = ordZmInfoTempPO.getIsPushErp();
            ordZmInfoTempPO.setSaleState(changeSaleState);
            ordZmInfoTempPO.setAuditTime(new Date());
            this.uocOrdZmInfoTempMapper.update(ordZmInfoTempPO);
            int version = this.uocOrdZmInfoHistoryMapper.queryMaxVersion(ordZmInfoTempPO.getOrderId());
            UocOrdZmInfoHistoryPO uocOrdZmInfoHistoryPO = new UocOrdZmInfoHistoryPO();
            uocOrdZmInfoHistoryPO.setHistoryId(Long.valueOf(Sequence.getInstance().nextId()));
            BeanUtils.copyProperties((Object)ordZmInfoTempPO, (Object)uocOrdZmInfoHistoryPO);
            uocOrdZmInfoHistoryPO.setVersion(Integer.valueOf(version + 1));
            uocOrdZmInfoHistoryPO.setSaleState(changeSaleState);
            uocOrdZmInfoHistoryPO.setAuditTime(new Date());
            this.uocOrdZmInfoHistoryMapper.insert(uocOrdZmInfoHistoryPO);
            ArrayList uocOrdGoodsHistoryPOList = new ArrayList();
            goodsTempPOList.forEach(e -> {
                UocOrdGoodsHistoryPO uocOrdGoodsHistoryPO = new UocOrdGoodsHistoryPO();
                BeanUtils.copyProperties((Object)e, (Object)uocOrdGoodsHistoryPO);
                uocOrdGoodsHistoryPO.setHistoryId(Long.valueOf(Sequence.getInstance().nextId()));
                uocOrdGoodsHistoryPO.setTempId(ordSalePO.getChangeOrderId());
                uocOrdGoodsHistoryPO.setOrderId(ordSalePO.getOrderId());
                uocOrdGoodsHistoryPO.setVersion(Integer.valueOf(version + 1));
                try {
                    if (StringUtils.isNotBlank((CharSequence)e.getArrivalTime()) && e.getArrivalTime().contains("/")) {
                        e.setArrivalTime(e.getArrivalTime().replace("/", "-"));
                    }
                    uocOrdGoodsHistoryPO.setArrivalTime(DateUtils.dateToStr((Date)DateUtils.strToDate((String)e.getArrivalTime())));
                }
                catch (Exception ex) {
                    uocOrdGoodsHistoryPO.setArrivalTime(e.getArrivalTime());
                }
                uocOrdGoodsHistoryPOList.add(uocOrdGoodsHistoryPO);
            });
            this.uocOrdGoodsHistoryMapper.insertBatch(uocOrdGoodsHistoryPOList);
            UocOrdLogisticsRelaHistoryPO ordLogisticsRelaHistoryPO = new UocOrdLogisticsRelaHistoryPO();
            BeanUtils.copyProperties((Object)ordLogisticsRelaTempPO, (Object)ordLogisticsRelaHistoryPO);
            ordLogisticsRelaHistoryPO.setHistoryId(Long.valueOf(Sequence.getInstance().nextId()));
            ordLogisticsRelaHistoryPO.setVersion(Integer.valueOf(version + 1));
            this.uocOrdLogisticsRelaHistoryMapper.insert(ordLogisticsRelaHistoryPO);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uocOrdAccessoryTempPOList)) {
                ArrayList uocOrdAccessoryHistoryPOList = new ArrayList();
                uocOrdAccessoryTempPOList.forEach(e -> {
                    UocOrdAccessoryHistoryPO uocOrdAccessoryHistoryPO = new UocOrdAccessoryHistoryPO();
                    BeanUtils.copyProperties((Object)e, (Object)uocOrdAccessoryHistoryPO);
                    uocOrdAccessoryHistoryPO.setHistoryId(Long.valueOf(Sequence.getInstance().nextId()));
                    uocOrdAccessoryHistoryPO.setVersion(Integer.valueOf(version + 1));
                    uocOrdAccessoryHistoryPOList.add(uocOrdAccessoryHistoryPO);
                });
                this.uocOrdAccessoryHistoryMapper.insertBatch(uocOrdAccessoryHistoryPOList);
            }
            if (UocConstant.ACTION_RESULT.PASS.equals(reqBO.getAuditResult())) {
                UocOrdZmInfoPO uocOrdZmInfoPO = new UocOrdZmInfoPO();
                BeanUtils.copyProperties((Object)ordZmInfoTempPO, (Object)uocOrdZmInfoPO);
                uocOrdZmInfoPO.setTaxrate(ordZmInfoTempPO.getTaxRate());
                uocOrdZmInfoPO.setPurType(null);
                this.uocOrdZmInfoMapper.update(uocOrdZmInfoPO);
                OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
                BeanUtils.copyProperties((Object)ordLogisticsRelaTempPO, (Object)ordLogisticsRelaPO);
                this.ordLogisticsRelaMapper.updateByOrderId(ordLogisticsRelaPO);
                OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
                ordAccessoryPO.setOrderId(ordSalePO.getOrderId());
                this.ordAccessoryMapper.deleteBy(ordAccessoryPO);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)uocOrdAccessoryTempPOList)) {
                    ArrayList ordAccessoryPOList = new ArrayList();
                    uocOrdAccessoryTempPOList.forEach(e -> {
                        OrdAccessoryPO saveOrdAccessoryPO = new OrdAccessoryPO();
                        BeanUtils.copyProperties((Object)e, (Object)saveOrdAccessoryPO);
                        ordAccessoryPOList.add(saveOrdAccessoryPO);
                    });
                    this.ordAccessoryMapper.insertBatch(ordAccessoryPOList);
                }
                this.updateExt("purUserNo", "\u91c7\u8d2d\u5458\u7f16\u7801", ordZmInfoTempPO.getPurUserNo(), orderBO.getOrderId());
                this.updateExt("purUserName", "\u91c7\u8d2d\u5458\u540d\u79f0", ordZmInfoTempPO.getPurUserName(), orderBO.getOrderId());
                this.updateOrder(orderBO, ordSalePO, reqBO, ordZmInfoTempPO.getOrderName());
            } else {
                ordSalePO.setChangeSaleState(changeSaleState);
                this.ordSaleMapper.updateById(ordSalePO);
            }
        } else {
            UocOrdZmInfoTempPO ordZmInfoTempPO = this.uocOrdZmInfoTempMapper.queryById(ordSalePO.getChangeOrderId());
            ordZmInfoTempPO.setAuditTime(new Date());
            this.uocOrdZmInfoTempMapper.update(ordZmInfoTempPO);
            ordSalePO.setTbOrderId(stepId);
            this.ordSaleMapper.updateById(ordSalePO);
        }
        this.pushTodoWait(orderBO, reqBO, finish, stationId);
        return pushErpFlag;
    }

    private void updateOrder(PebDealOrderBO pebDealOrderBO, OrdSalePO last, PebOrderChangeApprovalReqBO reqBO, String orderName) {
        OrdItemPO qry;
        Long saleFee = 0L;
        OrdExtMapPO createType = new OrdExtMapPO();
        createType.setOrderId(pebDealOrderBO.getOrderId());
        createType.setFieldCode("createType");
        createType = this.ordExtMapMapper.getModelBy(createType);
        boolean pushFz = false;
        boolean pushHt = true;
        if (createType != null) {
            if ("4".equals(createType.getFieldValue()) || "3".equals(createType.getFieldValue())) {
                pushFz = true;
                pushHt = false;
            }
            if ("2".equals(createType.getFieldValue())) {
                pushHt = false;
            }
        }
        ArrayList<Integer> saleStateList = new ArrayList<Integer>();
        saleStateList.add(1107);
        ArrayList<InterFaceContractUpdateOrderItemBO> operOrderItem = new ArrayList<InterFaceContractUpdateOrderItemBO>();
        ArrayList<ContractPlanOrderAbilityBo> planOrderReqBo = new ArrayList<ContractPlanOrderAbilityBo>();
        UocOrdGoodsTempPO tempPO = new UocOrdGoodsTempPO();
        tempPO.setOrderId(pebDealOrderBO.getOrderId());
        List list = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        List xlist = new ArrayList();
        if (pebDealOrderBO.getChangeOrderId() != null) {
            tempPO.setOrderId(pebDealOrderBO.getChangeOrderId());
            xlist = this.uocOrdGoodsTempxMapper.selectByCondition(tempPO);
        }
        OrdItemPO ordItemPO = new OrdItemPO();
        ordItemPO.setOrderId(pebDealOrderBO.getOrderId());
        List itemPOS = this.ordItemMapper.getList(ordItemPO);
        Map<Long, OrdItemPO> map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getTempId, i -> i));
        Map<Long, UocOrdGoodsTempPO> oldM = list.stream().collect(Collectors.toMap(UocOrdGoodsTempPO::getTempId, i -> i));
        boolean isYg = false;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(xlist)) {
            ArrayList<Long> uIds = new ArrayList<Long>();
            for (UocOrdGoodsTempPO po : xlist) {
                UocOrdGoodsTempPO update = oldM.get(po.getTempId());
                po.setOrderId(pebDealOrderBO.getOrderId());
                if (update != null) {
                    BeanUtils.copyProperties((Object)po, (Object)update);
                    this.uocOrdGoodsTempMapper.update(update);
                } else {
                    this.uocOrdGoodsTempMapper.insert(po);
                }
                uIds.add(po.getTempId());
            }
            ArrayList<Long> itemIds = new ArrayList<Long>();
            ArrayList<Long> delTemp = new ArrayList<Long>();
            for (UocOrdGoodsTempPO old : list) {
                if ("10".equals(old.getOutObjType())) {
                    isYg = true;
                }
                if (uIds.contains(old.getTempId())) continue;
                itemIds.add(map.get(old.getTempId()).getOrdItemId());
                delTemp.add(old.getTempId());
                if (saleStateList.contains(last.getSaleState())) continue;
                if (pushFz) {
                    InterFaceContractUpdateOrderItemBO updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                    updateOrderItemBO.setGoodTypeId(old.getOutObjItemId());
                    updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                    updateOrderItemBO.setOperateType(Integer.valueOf(0));
                    updateOrderItemBO.setOrderNum(old.getPurchaseCount());
                    operOrderItem.add(updateOrderItemBO);
                }
                if (!pushHt) continue;
                ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                abilityBo.setItemId(old.getHtItemId());
                abilityBo.setNum(old.getPurchaseCount().negate());
                planOrderReqBo.add(abilityBo);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemIds)) {
                OrdItemPO del = new OrdItemPO();
                del.setItemIds(itemIds);
                this.ordItemMapper.deleteByIds(del);
                UocOrdGoodsTempPO goodsTempPO = new UocOrdGoodsTempPO();
                goodsTempPO.setTempIds(delTemp);
                this.uocOrdGoodsTempMapper.deleteByIds(goodsTempPO);
                this.ordItemMapper.deletePurItemByIds(del);
                this.ordItemMapper.deletePayItemByIds(del);
                this.ordItemMapper.deleteZmItemByIds(del);
                ordItemPO = new OrdItemPO();
                ordItemPO.setOrderId(pebDealOrderBO.getOrderId());
                itemPOS = this.ordItemMapper.getList(ordItemPO);
                map = itemPOS.stream().collect(Collectors.toMap(OrdItemPO::getTempId, i -> i));
            }
            tempPO = new UocOrdGoodsTempPO();
            tempPO.setOrderId(pebDealOrderBO.getOrderId());
            list = this.uocOrdGoodsTempMapper.selectByCondition(tempPO);
        }
        OrdPurchasePO purchasePO = new OrdPurchasePO();
        purchasePO.setOrderId(pebDealOrderBO.getOrderId());
        purchasePO = this.ordPurchaseMapper.getModelBy(purchasePO);
        OrdPayPO payPO = new OrdPayPO();
        payPO.setOrderId(pebDealOrderBO.getOrderId());
        payPO = this.ordPayMapper.getModelBy(payPO);
        ArrayList<UocOrdZmItemPO> zmItemInsert = new ArrayList<UocOrdZmItemPO>();
        ArrayList<OrdPayItemPO> payItemPOS = new ArrayList<OrdPayItemPO>();
        for (UocOrdGoodsTempPO goodsTempPO : list) {
            InterFaceContractUpdateOrderItemBO updateOrderItemBO;
            if ("10".equals(goodsTempPO.getOutObjType())) {
                isYg = true;
            }
            BigDecimal purChaseCountAll = goodsTempPO.getPurchaseCount();
            OrdPayItemPO payItemPO = new OrdPayItemPO();
            OrdItemPO itemPO = new OrdItemPO();
            qry = map.get(goodsTempPO.getTempId());
            if (qry == null) {
                Long id = this.insertItem(goodsTempPO, payItemPOS, pebDealOrderBO.getSaleVoucherId(), purchasePO, payPO.getPayVoucherId());
                UocOrdZmItemPO zmItemPO = new UocOrdZmItemPO();
                BeanUtils.copyProperties((Object)goodsTempPO, (Object)zmItemPO);
                zmItemPO.setOrdItemId(id);
                zmItemInsert.add(zmItemPO);
                try {
                    saleFee = saleFee + MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!saleStateList.contains(last.getSaleState())) {
                    if (pushFz) {
                        InterFaceContractUpdateOrderItemBO updateOrderItemBO2 = new InterFaceContractUpdateOrderItemBO();
                        updateOrderItemBO2.setGoodTypeId(goodsTempPO.getOutObjItemId());
                        updateOrderItemBO2.setType(Integer.valueOf(createType.getFieldValue()));
                        updateOrderItemBO2.setOperateType(Integer.valueOf(1));
                        updateOrderItemBO2.setOrderNum(goodsTempPO.getPurchaseCount());
                        operOrderItem.add(updateOrderItemBO2);
                    }
                    if (pushHt) {
                        ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                        abilityBo.setItemId(goodsTempPO.getHtItemId());
                        abilityBo.setNum(goodsTempPO.getPurchaseCount());
                        planOrderReqBo.add(abilityBo);
                    }
                }
            } else {
                if (!saleStateList.contains(last.getSaleState())) {
                    if (pushFz) {
                        updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                        updateOrderItemBO.setGoodTypeId(goodsTempPO.getOutObjItemId());
                        updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                        BigDecimal count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                        if (count.compareTo(BigDecimal.ZERO) > 0) {
                            updateOrderItemBO.setOperateType(Integer.valueOf(0));
                            updateOrderItemBO.setOrderNum(count);
                            operOrderItem.add(updateOrderItemBO);
                        } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                            updateOrderItemBO.setOperateType(Integer.valueOf(1));
                            updateOrderItemBO.setOrderNum(count.negate());
                            operOrderItem.add(updateOrderItemBO);
                        }
                    }
                    if (pushHt) {
                        BigDecimal count = qry.getPurchaseCount().subtract(goodsTempPO.getPurchaseCount());
                        ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
                        abilityBo.setItemId(goodsTempPO.getHtItemId());
                        abilityBo.setNum(count.negate());
                        if (count.compareTo(BigDecimal.ZERO) > 0) {
                            planOrderReqBo.add(abilityBo);
                        } else if (count.compareTo(BigDecimal.ZERO) < 0) {
                            planOrderReqBo.add(abilityBo);
                        }
                    }
                }
                itemPO.setOrdItemId(qry.getOrdItemId());
                itemPO.setOrderId(pebDealOrderBO.getOrderId());
                itemPO.setTempId(goodsTempPO.getTempId());
                itemPO.setTempId(goodsTempPO.getTempId());
                itemPO.setPurchaseCount(goodsTempPO.getPurchaseCount());
                itemPO.setTaxId(goodsTempPO.getTaxCode());
                itemPO.setTax(goodsTempPO.getTax());
                try {
                    itemPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getSalePrice()));
                    itemPO.setPurchaseDecimalPrice(goodsTempPO.getSalePrice());
                    itemPO.setSaleDecimalPrice(goodsTempPO.getSalePrice());
                    itemPO.setTotalSaleDecimalPrice(goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                    itemPO.setTotalPurchaseDecimalPrice(goodsTempPO.getSalePrice().multiply(goodsTempPO.getPurchaseCount()).setScale(2, 4));
                    saleFee = saleFee + MoneyUtils.BigDecimal2Long((BigDecimal)itemPO.getTotalSaleDecimalPrice());
                    itemPO.setPurchasePrice(itemPO.getSalePrice());
                    itemPO.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTotalSalePrice()));
                    itemPO.setTotalPurchaseFee(itemPO.getTotalSaleFee());
                    itemPO.setNakedPrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getNakePrice()));
                    itemPO.setTaxPrice(MoneyUtils.BigDecimal2Long((BigDecimal)goodsTempPO.getTaxPrice().setScale(4, 4)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                itemPO.setOrganizationId(goodsTempPO.getOrganizationId());
                itemPO.setOrganizationName(goodsTempPO.getOrganizationName());
                itemPO.setOrganizationCode(goodsTempPO.getOrganizationCode());
                itemPO.setArrivalTime(goodsTempPO.getArrivalTime());
                if (StringUtils.isNotBlank((CharSequence)goodsTempPO.getArrivalTime()) && StringUtils.isNumeric((CharSequence)goodsTempPO.getArrivalTime())) {
                    itemPO.setArrivalTime(DateUtil.dateToStr((Date)DateUtil.getDate((Date)new Date(), (Integer)Integer.valueOf(goodsTempPO.getArrivalTime()))));
                } else {
                    itemPO.setArrivalTime(goodsTempPO.getArrivalTime());
                }
                this.ordItemMapper.updateById(itemPO);
                payItemPO.setPayCount(itemPO.getPurchaseCount());
                payItemPO.setPayFee(itemPO.getSalePrice());
                payItemPO.setTotalFee(itemPO.getTotalSaleFee());
                payItemPO.setOrderId(itemPO.getOrderId());
                payItemPO.setOrdItemId(itemPO.getOrdItemId());
                this.ordPayItemMapper.updateById(payItemPO);
                UocOrdZmItemPO zmItemPO = new UocOrdZmItemPO();
                BeanUtils.copyProperties((Object)goodsTempPO, (Object)zmItemPO);
                zmItemPO.setOrdItemId(itemPO.getOrdItemId());
                this.uocOrdZmItemMapper.update(zmItemPO);
                OrdGoodsPO goodsPO = new OrdGoodsPO();
                goodsPO.setSkuMaterialRemark(goodsTempPO.getSkuMaterialRemark());
                goodsPO.setOrdItemId(itemPO.getOrdItemId());
                this.ordGoodsMapper.updateByItem(goodsPO);
                goodsTempPO.setPurchaseCount(itemPO.getPurchaseCount().subtract(qry.getPurchaseCount()));
            }
            if (!saleStateList.contains(last.getSaleState())) continue;
            if (pushFz) {
                updateOrderItemBO = new InterFaceContractUpdateOrderItemBO();
                updateOrderItemBO.setGoodTypeId(goodsTempPO.getOutObjItemId());
                updateOrderItemBO.setType(Integer.valueOf(createType.getFieldValue()));
                updateOrderItemBO.setOperateType(Integer.valueOf(1));
                updateOrderItemBO.setOrderNum(purChaseCountAll);
                operOrderItem.add(updateOrderItemBO);
            }
            if (!pushHt) continue;
            ContractPlanOrderAbilityBo abilityBo = new ContractPlanOrderAbilityBo();
            abilityBo.setItemId(goodsTempPO.getHtItemId());
            abilityBo.setNum(purChaseCountAll);
            planOrderReqBo.add(abilityBo);
        }
        OrdSalePO salePO = new OrdSalePO();
        salePO.setSaleVoucherId(last.getSaleVoucherId());
        salePO.setOrderId(last.getOrderId());
        salePO.setSaleFee(saleFee);
        salePO.setPurchaseFee(saleFee);
        salePO.setChangeSaleState(UocConstant.ACTION_RESULT.PASS.equals(reqBO.getAuditResult()) ? UocConstant.SALE_ORDER_STATUS.APPROVE_CHANGE : UocConstant.SALE_ORDER_STATUS.AUDIT_REFUSE);
        salePO.setExt3(UocConstant.ACTION_RESULT.PASS.equals(reqBO.getAuditResult()) ? "\u5408\u540c\u8ba2\u5355\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7" : "\u5408\u540c\u8ba2\u5355\u53d8\u66f4\u5ba1\u6279\u9a73\u56de");
        this.ordSaleMapper.updateById(salePO);
        OrderPO orderPO = new OrderPO();
        orderPO.setOrderId(pebDealOrderBO.getOrderId());
        orderPO.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        orderPO.setTotalSaleFee(saleFee);
        orderPO.setTotalPurchaseFee(saleFee);
        orderPO.setOrderName(orderName);
        this.orderMapper.updateById(orderPO);
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(salePO.getOrderId());
        ordPayPO.setPayFee(saleFee);
        this.ordPayMapper.updateById(ordPayPO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(zmItemInsert)) {
            this.uocOrdZmItemMapper.insertBatch(zmItemInsert);
            this.ordPayItemMapper.insertBatch(payItemPOS);
        }
        BigDecimal fee = MoneyUtil.l4B((Long)(saleFee - last.getSaleFee()));
        if (pushHt) {
            OrdExtMapPO extMapPO = new OrdExtMapPO();
            extMapPO.setOrderId(pebDealOrderBO.getOrderId());
            extMapPO.setObjId(pebDealOrderBO.getOrderId());
            extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
            extMapPO.setFieldCode("contractFee");
            qry = this.ordExtMapMapper.getModelBy(extMapPO);
            OrdAgreementPO agreementPO = new OrdAgreementPO();
            agreementPO.setOrderId(pebDealOrderBO.getOrderId());
            agreementPO = (OrdAgreementPO)this.ordAgreementMapper.selectByCondition(agreementPO).get(0);
            ContractOrderedAmountSynAbilityReqBO abilityReqBO = new ContractOrderedAmountSynAbilityReqBO();
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(Long.valueOf(agreementPO.getAgreementId()));
            abilityReqBO.setContractIds(ids);
            boolean flag = true;
            if (qry != null && PebExtConstant.YES.toString().equals(qry.getFieldValue())) {
                abilityReqBO.setOrderAmount(fee);
                if (fee.compareTo(BigDecimal.ZERO) > 0) {
                    abilityReqBO.setOperType("0");
                } else {
                    abilityReqBO.setOperType("1");
                }
                if (fee.compareTo(BigDecimal.ZERO) == 0) {
                    flag = false;
                }
            } else {
                BigDecimal pushFee = BigDecimal.ZERO;
                if (PebExtConstant.YES.equals(agreementPO.getAssignStatus())) {
                    pushFee = MoneyUtil.l4B((Long)saleFee);
                } else {
                    OrdItemPO ordItemPo = new OrdItemPO();
                    ordItemPo.setOrderId(pebDealOrderBO.getOrderId());
                    List ordItemList = this.ordItemMapper.getList(ordItemPo);
                    for (OrdItemPO itemPO : ordItemList) {
                        try {
                            BigDecimal price = itemPO.getTax() == null ? new BigDecimal(0) : new BigDecimal((float)itemPO.getTax().longValue() / 100.0f + "");
                            BigDecimal djs = MoneyUtil.l4B((Long)itemPO.getTotalSaleFee());
                            BigDecimal taxA = price.add(BigDecimal.ONE);
                            pushFee = pushFee.add(djs.subtract(djs.multiply(price).divide(taxA, 2, 4)));
                        }
                        catch (Exception exception) {}
                    }
                }
                abilityReqBO.setOrderAmount(pushFee);
                abilityReqBO.setOperType("0");
            }
            if (flag) {
                ContractOrderedAmountSynAbilityRspBO rspBO = this.contractOrderedAmountSynAbilityService.orderedAmountSyn(abilityReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
                }
                extMapPO.setFieldName("\u4fee\u6539\u5408\u540c\u9650\u989d");
                if (qry != null) {
                    extMapPO.setId(qry.getId());
                    extMapPO.setFieldValue(PebExtConstant.YES.toString());
                    this.ordExtMapMapper.updateById(extMapPO);
                } else {
                    extMapPO.setFieldValue(PebExtConstant.YES.toString());
                    extMapPO.setId(Long.valueOf(this.idUtil.nextId()));
                    this.ordExtMapMapper.insert(extMapPO);
                }
            }
        }
        if (operOrderItem.size() > 0) {
            if (isYg) {
                SscSchemeAmountReqBO amountReqBO = new SscSchemeAmountReqBO();
                amountReqBO.setTypeAmount(Integer.valueOf(1));
                ArrayList<SscSchemeAmountBO> ygList = new ArrayList<SscSchemeAmountBO>();
                for (InterFaceContractUpdateOrderItemBO skuInfo : operOrderItem) {
                    SscSchemeAmountBO bo = new SscSchemeAmountBO();
                    bo.setGoodTypeId(skuInfo.getGoodTypeId());
                    bo.setType(skuInfo.getType());
                    bo.setOperateType(skuInfo.getOperateType());
                    bo.setOrderNum(skuInfo.getOrderNum());
                    ygList.add(bo);
                }
                amountReqBO.setOrderItem(ygList);
                SscSchemeAmountRspBO rspBO = this.schemeAmountService.updateSchemeOrderAmount(amountReqBO);
                if (!"0000".equals(rspBO.getRespCode())) {
                    throw new UocProBusinessException(rspBO.getRespCode(), "\u4fee\u6539\u65b9\u6848\u660e\u7ec6\u62a5\u9519\uff1a" + rspBO.getRespDesc());
                }
            } else {
                InterFaceContractUpdateOrderItemAtomReqBO interFaceContractUpdateOrderItemAtomReqBO = new InterFaceContractUpdateOrderItemAtomReqBO();
                interFaceContractUpdateOrderItemAtomReqBO.setToken(reqBO.getToken());
                interFaceContractUpdateOrderItemAtomReqBO.setOrderItem(operOrderItem);
                InterFaceContractUpdateOrderItemAtomRspBO interFaceContractUpdateOrderItemAtomRspBO = this.interFaceContractUpdateOrderItemAtomService.updateSchemeOrderItemStatus(interFaceContractUpdateOrderItemAtomReqBO);
                if (!"0000".equals(interFaceContractUpdateOrderItemAtomRspBO.getRespCode())) {
                    throw new UocProBusinessException(interFaceContractUpdateOrderItemAtomRspBO.getRespCode(), "\u4fee\u6539\u65b9\u6848\u660e\u7ec6\u62a5\u9519\uff1a" + interFaceContractUpdateOrderItemAtomRspBO.getRespDesc());
                }
            }
        }
        if (planOrderReqBo.size() > 0) {
            ContractPlanOrderAbilityReqBo reqBo = new ContractPlanOrderAbilityReqBo();
            reqBo.setPlanOrderReqBo(planOrderReqBo);
            ContractPlanOrderAbilityRspBo abilityRspBo = this.contractPlanOrderAbilityService.dealContractOrder(reqBo);
            if (!"0000".equals(abilityRspBo.getRespCode())) {
                throw new UocProBusinessException(abilityRspBo.getRespCode(), "\u5408\u540c\u660e\u7ec6\u4fee\u6539\u5931\u8d25\uff1a" + abilityRspBo.getRespDesc());
            }
        }
    }

    private Long insertItem(UocOrdGoodsTempPO tempPO, List<OrdPayItemPO> list, Long saleId, OrdPurchasePO purchaseP, Long payId) {
        OrdItemPO itemPO = new OrdItemPO();
        OrdGoodsPO goodsPO = new OrdGoodsPO();
        itemPO.setOrdItemId(Long.valueOf(this.idUtil.nextId()));
        goodsPO.setOrdItemId(itemPO.getOrdItemId());
        goodsPO.setGoodsItemId(Long.valueOf(this.idUtil.nextId()));
        itemPO.setTempId(tempPO.getTempId());
        itemPO.setPurchaseVoucherId(purchaseP.getPurchaseVoucherId());
        goodsPO.setSkuCode(tempPO.getSkuCode());
        goodsPO.setSkuMaterialId(tempPO.getSkuMaterialId());
        goodsPO.setCreateTime(new Date());
        itemPO.setItemType(Integer.valueOf(2));
        if (StringUtils.isBlank((CharSequence)tempPO.getSkuId())) {
            itemPO.setSkuId(tempPO.getSkuMaterialId().trim());
            itemPO.setSkuName(tempPO.getSkuMaterialName());
            goodsPO.setSkuName(tempPO.getSkuMaterialName());
            goodsPO.setSkuId(tempPO.getSkuMaterialId().trim());
            goodsPO.setSpuId(tempPO.getSkuMaterialId());
        } else {
            itemPO.setSkuId(tempPO.getSkuId());
            itemPO.setSkuName(tempPO.getSkuName());
            goodsPO.setSkuId(tempPO.getSkuId());
            goodsPO.setSkuName(tempPO.getSkuName());
            goodsPO.setSpuId(StringUtils.isNotBlank((CharSequence)tempPO.getExt5()) ? tempPO.getExt5() : tempPO.getSkuMaterialId());
        }
        itemPO.setOrderId(purchaseP.getOrderId());
        goodsPO.setOrderId(purchaseP.getOrderId());
        itemPO.setSaleVoucherId(saleId);
        goodsPO.setSkuMaterialName(tempPO.getExt8());
        itemPO.setExtField2(tempPO.getSkuMaterialName());
        goodsPO.setSkuMaterialTypeId(tempPO.getExt1());
        goodsPO.setSkuMaterialTypeName(tempPO.getExt2());
        itemPO.setPurchaseCount(tempPO.getPurchaseCount());
        goodsPO.setExt4(tempPO.getExt6());
        goodsPO.setExt6(tempPO.getExt7());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getHtId())) {
            itemPO.setExtField1(tempPO.getHtId());
        }
        try {
            itemPO.setTotalSaleFee(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice().multiply(tempPO.getPurchaseCount())));
            itemPO.setTotalPurchaseFee(itemPO.getTotalSaleFee());
            itemPO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            itemPO.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuMarketPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSkuMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getSalePrice()));
            itemPO.setArriveCount(BigDecimal.ZERO);
            itemPO.setSendCount(BigDecimal.ZERO);
            itemPO.setRefuseCount(BigDecimal.ZERO);
            itemPO.setReturnCount(BigDecimal.ZERO);
            itemPO.setAcceptanceCount(BigDecimal.ZERO);
            itemPO.setInspChangeCount(BigDecimal.ZERO);
            itemPO.setAfterServingCount(BigDecimal.ZERO);
            itemPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            itemPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            itemPO.setTotalSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            itemPO.setTotalPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            goodsPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
            goodsPO.setTotalSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            goodsPO.setTotalPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
            itemPO.setTaxPrice(MoneyUtils.BigDecimal2Long((BigDecimal)tempPO.getTaxPrice().setScale(4, RoundingMode.HALF_UP)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank((CharSequence)tempPO.getPlanId())) {
            itemPO.setPlanId(Long.valueOf(tempPO.getPlanId()));
        }
        goodsPO.setSkuMaterialRemark(tempPO.getSkuMaterialRemark());
        itemPO.setOrganizationId(tempPO.getOrganizationId());
        itemPO.setOrganizationName(tempPO.getOrganizationName());
        itemPO.setOrganizationCode(tempPO.getOrganizationCode());
        itemPO.setExtField3(tempPO.getMaterialUnitName());
        itemPO.setTaxId(tempPO.getTaxCode());
        itemPO.setTax(tempPO.getTax());
        itemPO.setUnitName(tempPO.getUnitName());
        goodsPO.setModel(tempPO.getModel());
        goodsPO.setSpec(tempPO.getSpec());
        if (StringUtils.isBlank((CharSequence)tempPO.getArrivalTime())) {
            itemPO.setArrivalTime(DateUtil.dateToStr((Date)DateUtil.getDate((Date)new Date(), (Integer)this.maxShipTime)));
        }
        if (StringUtils.isNotBlank((CharSequence)tempPO.getArrivalTime()) && StringUtils.isNumeric((CharSequence)tempPO.getArrivalTime())) {
            itemPO.setArrivalTime(DateUtil.dateToStr((Date)DateUtil.getDate((Date)new Date(), (Integer)Integer.valueOf(tempPO.getArrivalTime()))));
        } else {
            itemPO.setArrivalTime(tempPO.getArrivalTime());
        }
        itemPO.setSettleUnit(tempPO.getExt1());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getExt2())) {
            itemPO.setSalesUnitRate(new BigDecimal(tempPO.getExt2()));
        }
        itemPO.setSupNo(String.valueOf(tempPO.getSupplierShopId()));
        itemPO.setSupplierShopId(tempPO.getSupplierShopId());
        goodsPO.setSupplierShopId(tempPO.getSupplierShopId());
        goodsPO.setSupplierShopName(tempPO.getSkuSupplierName());
        goodsPO.setSkuCurrencyType("CNY");
        goodsPO.setSkuBrandName(tempPO.getPpcd());
        if (StringUtils.isNotBlank((CharSequence)tempPO.getExt3())) {
            goodsPO.setSkuCommodityTypeId(Long.valueOf(tempPO.getExt3()));
        }
        goodsPO.setSkuMaterialTypeId(tempPO.getCateCode());
        goodsPO.setSkuMaterialTypeName(tempPO.getCateName());
        goodsPO.setMaterialBj(tempPO.getMaterialBj());
        goodsPO.setExt1(tempPO.getZljsyq());
        itemPO.setInspectionExcessPercent(Integer.valueOf(0));
        OrdPurchaseItemPO purchaseItemPO = new OrdPurchaseItemPO();
        BeanUtils.copyProperties((Object)itemPO, (Object)purchaseItemPO);
        purchaseItemPO.setPurchaseItemId(Long.valueOf(this.idUtil.nextId()));
        purchaseItemPO.setOrderItemId(itemPO.getOrdItemId());
        this.ordItemMapper.insert(itemPO);
        this.ordGoodsMapper.insert(goodsPO);
        this.ordPurchaseItemMapper.insert(purchaseItemPO);
        OrdPayItemPO uocOrderPayItemBO = new OrdPayItemPO();
        uocOrderPayItemBO.setOrdItemId(itemPO.getOrdItemId());
        uocOrderPayItemBO.setPayObjId(itemPO.getOrdItemId());
        uocOrderPayItemBO.setPayObjType(PecConstant.PAY_OBJ_TYPE_SALE_ORDER_ITEM);
        uocOrderPayItemBO.setPurchaseCount(itemPO.getPurchaseCount());
        uocOrderPayItemBO.setUnitName(itemPO.getUnitName());
        uocOrderPayItemBO.setSalePrice(itemPO.getSalePrice());
        uocOrderPayItemBO.setPurchasePrice(itemPO.getPurchasePrice());
        uocOrderPayItemBO.setCurrencyType(itemPO.getCurrencyType());
        uocOrderPayItemBO.setPayCount(itemPO.getPurchaseCount());
        uocOrderPayItemBO.setTotalFee(itemPO.getTotalSaleFee());
        uocOrderPayItemBO.setPayFee(itemPO.getTotalSaleFee());
        uocOrderPayItemBO.setOrderId(purchaseP.getOrderId());
        uocOrderPayItemBO.setPayItemId(Long.valueOf(this.idUtil.nextId()));
        uocOrderPayItemBO.setReduceFee(Long.valueOf(0L));
        uocOrderPayItemBO.setPayVoucherId(payId);
        uocOrderPayItemBO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
        uocOrderPayItemBO.setSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()));
        uocOrderPayItemBO.setTotalSaleDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
        uocOrderPayItemBO.setTotalPurchaseDecimalPrice(MoneyUtil.b2B((BigDecimal)tempPO.getSalePrice()).multiply(tempPO.getPurchaseCount()).setScale(2, 4));
        list.add(uocOrderPayItemBO);
        return itemPO.getOrdItemId();
    }

    private void updateExt(String key, String name, String val, Long orderId) {
        if (StringUtils.isBlank((CharSequence)val)) {
            val = " ";
        }
        OrdExtMapPO extMapPO = new OrdExtMapPO();
        extMapPO.setFieldValue(val);
        extMapPO.setFieldCode(key);
        extMapPO.setFieldName(name);
        extMapPO.setObjType(UocConstant.OBJ_TYPE.ORDER);
        extMapPO.setObjId(orderId);
        extMapPO.setOrderId(orderId);
        this.ordExtMapMapper.updateById(extMapPO);
    }

    private void pushTodoWait(PebDealOrderBO orderBO, PebOrderChangeApprovalReqBO reqBO, Boolean finsh, String stationId) {
        CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(5000L);
                PebTodoPushWaitBusiReqBO uocTodoBO = new PebTodoPushWaitBusiReqBO();
                uocTodoBO.setOrderId(orderBO.getOrderId());
                uocTodoBO.setSaleVoucherId(orderBO.getSaleVoucherId());
                uocTodoBO.setChangeOrderId(orderBO.getChangeOrderId());
                uocTodoBO.setApproveType(ApproveTypeEnum.APPROVE.getCode());
                uocTodoBO.setOperatorId(reqBO.getUserId() + "");
                uocTodoBO.setOperatorNo(reqBO.getUsername());
                uocTodoBO.setOperatorName(reqBO.getName());
                uocTodoBO.setOrgId(reqBO.getOrgId());
                uocTodoBO.setFinishTime(new Date());
                uocTodoBO.setFinishYn(finsh);
                uocTodoBO.setAuditRemark(reqBO.getApprovalRemark());
                uocTodoBO.setAuditStatus(Boolean.valueOf("0".equals(reqBO.getAuditResult().toString())));
                uocTodoBO.setStationId(stationId);
                uocTodoBO.setTodoMqLogId(Long.valueOf(Sequence.getInstance().nextId()));
                log.info("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uocTodoBO));
                ProxySendResult send = this.uocPushTodoProvider.send(new ProxyMessage(this.todoTopic, this.todoTag, JSON.toJSONString((Object)uocTodoBO)));
                UocTodoDealMsgLogBusiReqBO busiReqBO = new UocTodoDealMsgLogBusiReqBO();
                busiReqBO.setOrderId(uocTodoBO.getOrderId());
                busiReqBO.setMqBody(JSON.toJSONString((Object)uocTodoBO));
                busiReqBO.setTodoMqLogId(uocTodoBO.getTodoMqLogId());
                if ("SEND_OK".equals(send.getStatus())) {
                    busiReqBO.setExcuteStatus(Integer.valueOf(3));
                } else {
                    busiReqBO.setExcuteStatus(Integer.valueOf(4));
                    busiReqBO.setExt1("\u53d1\u9001\u6d88\u606f\u5931\u8d25");
                }
                this.uocTodoDealMsgLogBusiService.dealMsgLog(busiReqBO);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u8ba2\u5355\u5f85\u529e\u5931\u8d25\uff1a" + CommUtils.dealStackTrace((Exception)e));
            }
        });
    }
}

