/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractHtQryListAbilityService;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtContractMarkerPushOrderAbilityService;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderReqBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomReqBO;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushPurchaseContractService;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.zone.ability.api.PebChangeOrderApprovalAbilityService;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalReqBO;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalRspBO;
import com.tydic.uoc.zone.busi.api.PebChangeOrderApprovalBusiService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.PebChangeOrderApprovalAbilityService"})
public class PebChangeOrderApprovalAbilityServiceImpl
implements PebChangeOrderApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebChangeOrderApprovalAbilityServiceImpl.class);
    @Autowired
    private PebChangeOrderApprovalBusiService pebChangeOrderApprovalBusiService;
    @Autowired
    private ContractHtQryListAbilityService contractHtQryListAbilityService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebExtOrdIdxSyncAbilityService pebExtOrdIdxSyncAbilityService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UccGateWayApplicationPushPurchaseContractService uccGateWayApplicationPushPurchaseContractService;
    @Autowired
    private PebExtContractMarkerPushOrderAbilityService markerPushOrderAbilityService;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TOPIC:DEAL_PUSH_WMS_ORDER_TOPIC}")
    private String pushWmsOrderTopic;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TAG:DEAL_PUSH_WMS_ORDER_TAG}")
    private String pushWmsOrderTag;
    @Resource(name="dealPushWmsOrderProvider")
    private ProxyMessageProducer dealPushWmsOrderProvider;

    @PostMapping(value={"dealPebOrderApproval"})
    public PebOrderChangeApprovalRspBO dealPebOrderApproval(@RequestBody PebOrderChangeApprovalReqBO reqBO) {
        this.checkInput(reqBO);
        PebOrderChangeApprovalRspBO rspBO = this.pebChangeOrderApprovalBusiService.dealPebOrderApproval(reqBO);
        this.sendMq(reqBO, rspBO.getPushWms());
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderApprovalList())) {
            List<Long> list = reqBO.getOrderApprovalList().stream().map(PebDealOrderBO::getOrderId).collect(Collectors.toList());
            this.pushInfo(list);
        }
        return rspBO;
    }

    private void pushInfo(List<Long> list) {
        try {
            if (!CollectionUtils.isEmpty(list)) {
                PebSyncHtPurchaseContractAtomReqBO contractAtomReqBO = new PebSyncHtPurchaseContractAtomReqBO();
                contractAtomReqBO.setOrderIds(list);
                this.uccGateWayApplicationPushPurchaseContractService.syncHtPurchase(contractAtomReqBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5931\u8d25", (Object)e.getMessage());
        }
    }

    private void sendMq(PebOrderChangeApprovalReqBO reqBO, Boolean pushWms) {
        reqBO.getOrderApprovalList().forEach(order -> {
            UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            uocPebOrdIdxSyncReqBO.setObjId(order.getSaleVoucherId());
            uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            uocPebOrdIdxSyncReqBO.setOrderId(order.getOrderId());
            this.pebExtOrdIdxSyncAbilityService.dealOrdIdxSync(uocPebOrdIdxSyncReqBO);
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setShipVoucherId(order.getOrderId());
            List shipPOList = this.ordShipMapper.getList(shipPO);
            shipPOList.forEach(e -> {
                UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                idxSyncReqBO.setObjId(e.getShipVoucherId());
                idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                idxSyncReqBO.setOrderId(e.getOrderId());
                this.pebExtOrdIdxSyncAbilityService.dealOrdIdxSync(idxSyncReqBO);
            });
            if (pushWms.booleanValue()) {
                PebExtPushWmsOrderReqBO wmsOrderReqBO = new PebExtPushWmsOrderReqBO();
                wmsOrderReqBO.setOrderId(order.getOrderId());
                wmsOrderReqBO.setIsChange(Boolean.valueOf(true));
                this.dealPushWmsOrderProvider.send(new ProxyMessage(this.pushWmsOrderTopic, this.pushWmsOrderTag, JSONObject.toJSONString((Object)wmsOrderReqBO)));
            }
        });
    }

    private void checkInput(PebOrderChangeApprovalReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAuditResult())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getOrderApprovalList())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5ba1\u6279\u8ba2\u5355\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getOrderApprovalList().forEach(e -> {
            if (Objects.isNull(e.getOrderId())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(e.getChangeOrderId())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

