/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.contract.ability.ContractHtQryListAbilityService;
import com.tydic.uoc.base.constants.UocApproveEntrustConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.PebExtContractMarkerPushOrderAbilityService;
import com.tydic.uoc.common.ability.api.PebExtOrdIdxSyncAbilityService;
import com.tydic.uoc.common.ability.bo.PebDealOrderBO;
import com.tydic.uoc.common.ability.bo.PebExtPushWmsOrderReqBO;
import com.tydic.uoc.common.ability.bo.UocApproveEntrustNotificationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocNoTaskAuditOrderAuditNoticeBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.atom.api.UocConvertNoticeUrlAtomService;
import com.tydic.uoc.common.atom.bo.PebSyncHtPurchaseContractAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocConvertNoticeUrlAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocConvertNoticeUrlAtomRspBO;
import com.tydic.uoc.common.busi.api.plan.UccGateWayApplicationPushPurchaseContractService;
import com.tydic.uoc.common.comb.api.UocSendApproveNoticeCombService;
import com.tydic.uoc.common.comb.bo.UocSendApproveNoticeCombReqBO;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.zone.ability.api.PebChangeOrderApprovalAbilityService;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalReqBO;
import com.tydic.uoc.zone.ability.bo.PebOrderChangeApprovalRspBO;
import com.tydic.uoc.zone.busi.api.PebChangeOrderApprovalBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.PebChangeOrderApprovalAbilityService"})
public class PebChangeOrderApprovalAbilityServiceImpl
implements PebChangeOrderApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(PebChangeOrderApprovalAbilityServiceImpl.class);
    @Autowired
    private PebChangeOrderApprovalBusiService pebChangeOrderApprovalBusiService;
    @Autowired
    private ContractHtQryListAbilityService contractHtQryListAbilityService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private PebExtOrdIdxSyncAbilityService pebExtOrdIdxSyncAbilityService;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Autowired
    private UccGateWayApplicationPushPurchaseContractService uccGateWayApplicationPushPurchaseContractService;
    @Autowired
    private PebExtContractMarkerPushOrderAbilityService markerPushOrderAbilityService;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TOPIC:DEAL_PUSH_WMS_ORDER_TOPIC}")
    private String pushWmsOrderTopic;
    @Value(value="${DEAL_PUSH_WMS_ORDER_TAG:DEAL_PUSH_WMS_ORDER_TAG}")
    private String pushWmsOrderTag;
    @Resource(name="dealPushWmsOrderProvider")
    private ProxyMessageProducer dealPushWmsOrderProvider;
    @Resource(name="mqUocApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqUocApproveEntrustNotificationProvider;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC:UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String uocApproveEntrustNotificationTopic;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String uocApproveEntrustNotificationTag;
    @Resource
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocConvertNoticeUrlAtomService uocConvertNoticeUrlAtomService;
    @Autowired
    private UocSendApproveNoticeCombService uocSendApproveNoticeCombService;

    @PostMapping(value={"dealPebOrderApproval"})
    public PebOrderChangeApprovalRspBO dealPebOrderApproval(@RequestBody PebOrderChangeApprovalReqBO reqBO) {
        this.checkInput(reqBO);
        PebOrderChangeApprovalRspBO rspBO = this.pebChangeOrderApprovalBusiService.dealPebOrderApproval(reqBO);
        this.sendMq(reqBO, rspBO.getPushWms());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getOrderApprovalList())) {
            List<Long> list = reqBO.getOrderApprovalList().stream().map(PebDealOrderBO::getOrderId).collect(Collectors.toList());
            this.pushInfo(list);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
            UocApproveEntrustNotificationAbilityReqBO approveWaitNotificationReqBO = new UocApproveEntrustNotificationAbilityReqBO();
            try {
                approveWaitNotificationReqBO.setAuditNoticeList(rspBO.getAuditNoticeList());
                approveWaitNotificationReqBO.setApproveEntrustType(UocApproveEntrustConstant.ApproveEntrustType.ChangeOrder);
                approveWaitNotificationReqBO.setApproveEntrustNoticeType(UocApproveEntrustConstant.ApproveEntrustNoticeType.ChangeOrder);
                log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                this.mqUocApproveEntrustNotificationProvider.send(new ProxyMessage(this.uocApproveEntrustNotificationTopic, this.uocApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
            }
            catch (Exception e) {
                log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getNoticeUserInfo()) && !StringUtils.isEmpty((Object)reqBO.getObjCode())) {
            this.sendApproveNotice(reqBO, rspBO.getAuditNoticeList());
        }
        return rspBO;
    }

    private void pushInfo(List<Long> list) {
        try {
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
                PebSyncHtPurchaseContractAtomReqBO contractAtomReqBO = new PebSyncHtPurchaseContractAtomReqBO();
                contractAtomReqBO.setOrderIds(list);
                this.uccGateWayApplicationPushPurchaseContractService.syncHtPurchase(contractAtomReqBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001\u5408\u540c\u7cfb\u7edf\u5931\u8d25", (Object)e.getMessage());
        }
    }

    private void sendMq(PebOrderChangeApprovalReqBO reqBO, Boolean pushWms) {
        reqBO.getOrderApprovalList().forEach(order -> {
            UocPebOrdIdxSyncReqBO uocPebOrdIdxSyncReqBO = new UocPebOrdIdxSyncReqBO();
            uocPebOrdIdxSyncReqBO.setObjId(order.getSaleVoucherId());
            uocPebOrdIdxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            uocPebOrdIdxSyncReqBO.setOrderId(order.getOrderId());
            this.pebExtOrdIdxSyncAbilityService.dealOrdIdxSync(uocPebOrdIdxSyncReqBO);
            OrdShipPO shipPO = new OrdShipPO();
            shipPO.setShipVoucherId(order.getOrderId());
            List shipPOList = this.ordShipMapper.getList(shipPO);
            shipPOList.forEach(e -> {
                UocPebOrdIdxSyncReqBO idxSyncReqBO = new UocPebOrdIdxSyncReqBO();
                idxSyncReqBO.setObjId(e.getShipVoucherId());
                idxSyncReqBO.setObjType(UocConstant.OBJ_TYPE.SHIP);
                idxSyncReqBO.setOrderId(e.getOrderId());
                this.pebExtOrdIdxSyncAbilityService.dealOrdIdxSync(idxSyncReqBO);
            });
            if (pushWms.booleanValue()) {
                PebExtPushWmsOrderReqBO wmsOrderReqBO = new PebExtPushWmsOrderReqBO();
                wmsOrderReqBO.setOrderId(order.getOrderId());
                wmsOrderReqBO.setIsChange(Boolean.valueOf(true));
                this.dealPushWmsOrderProvider.send(new ProxyMessage(this.pushWmsOrderTopic, this.pushWmsOrderTag, JSONObject.toJSONString((Object)wmsOrderReqBO)));
            }
        });
    }

    private void checkInput(PebOrderChangeApprovalReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAuditResult())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getOrderApprovalList())) {
            throw new UocProBusinessException("100001", "\u5165\u53c2\u5ba1\u6279\u8ba2\u5355\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.getOrderApprovalList().forEach(e -> {
            if (Objects.isNull(e.getOrderId())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (Objects.isNull(e.getChangeOrderId())) {
                throw new UocProBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }

    private void sendApproveNotice(PebOrderChangeApprovalReqBO reqBO, List<UocNoTaskAuditOrderAuditNoticeBO> auditNoticeList) {
        if (!(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqBO.getNoticeUserInfo()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqBO.getObjCode()) || org.apache.commons.collections.CollectionUtils.isEmpty(auditNoticeList) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)auditNoticeList.get(0).getTaskId()))) {
            try {
                UocSendApproveNoticeCombReqBO combReqBO = new UocSendApproveNoticeCombReqBO();
                OrdSalePO ordSalePO = new OrdSalePO();
                ordSalePO.setOrderId(((PebDealOrderBO)reqBO.getOrderApprovalList().get(0)).getOrderId());
                OrdSalePO qry = this.ordSaleMapper.getModelBy(ordSalePO);
                String typeStr = "";
                String objCode = reqBO.getObjCode();
                if (qry == null) {
                    throw new ZTBusinessException("\u8ba2\u5355\u4e0d\u5b58\u5728");
                }
                UocConvertNoticeUrlAtomReqBO atomReqBO = new UocConvertNoticeUrlAtomReqBO();
                ArrayList<Long> objIds = new ArrayList<Long>();
                objIds.add(((PebDealOrderBO)reqBO.getOrderApprovalList().get(0)).getChangeOrderId());
                atomReqBO.setObjIds(objIds);
                atomReqBO.setObjType(UocApproveEntrustConstant.ApproveEntrustType.ChangeOrder);
                Map objIdMap = new HashMap();
                UocConvertNoticeUrlAtomRspBO atomRspBO = this.uocConvertNoticeUrlAtomService.convertNoticeUrl(atomReqBO);
                if (!CollectionUtils.isEmpty((Map)atomRspBO.getObjIdMap())) {
                    objIdMap = atomRspBO.getObjIdMap();
                }
                objCode = qry.getSaleVoucherNo();
                String titelEndStr = "";
                String textEndStr = "";
                if (reqBO.getAuditResult() != null && reqBO.getAuditResult() == 0) {
                    titelEndStr = "\u5ba1\u6279\u901a\u8fc7";
                    textEndStr = "\u5df2\u901a\u8fc7\u5ba1\u6279";
                } else {
                    titelEndStr = "\u5ba1\u6279\u9a73\u56de";
                    textEndStr = "\u88ab\u5ba1\u6279\u9a73\u56de";
                }
                typeStr = UocConstant.ORDER_SOURCE.REPLENISHMENT.toString().equals(qry.getOrderSource()) ? "\u5bc4\u552e\u8865\u8d27\u5355\u53d8\u66f4" : (UocConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.toString().equals(qry.getOrderSource()) ? "\u8d85\u5e02\u8ba2\u5355\u53d8\u66f4" : (UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(qry.getOrderSource()) && UocCoreConstant.TradeMode.TRADE_MODEL.equals(qry.getModelSettle()) ? "\u534f\u8bae\u8ba2\u5355\u53d8\u66f4" : ((UocConstant.ORDER_SOURCE.SINGLE_PRODUCT.toString().equals(qry.getOrderSource()) || UocConstant.ORDER_SOURCE.PROTOCOL_GENERATION.toString().equals(qry.getOrderSource())) && UocCoreConstant.TradeMode.MATCHMAKING_MODE.equals(qry.getModelSettle()) ? "\u96c6\u91c7\u5206\u7b7e\u8ba2\u5355\u53d8\u66f4" : (UocConstant.ORDER_SOURCE.CONTRACT.toString().equals(qry.getOrderSource()) ? "\u5408\u540c\u8ba2\u5355\u53d8\u66f4" : "\u8ba2\u5355"))));
                String titel = objCode + "_" + typeStr + "_\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4" + titelEndStr;
                String text = "\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u8ba2\u5355" + objCode + "\u5f53\u524d\u8282\u70b9" + textEndStr;
                String noticeUrl = null;
                if (objIdMap.containsKey(objIds.get(0))) {
                    noticeUrl = (String)objIdMap.get(objIds.get(0));
                }
                String noticeText = "";
                noticeText = !StringUtils.isEmpty(noticeUrl) ? "<a href=\"" + noticeUrl + "\">" + text + "</a>" : text;
                combReqBO.setText(noticeText);
                combReqBO.setTitel(titel);
                combReqBO.setUserId(reqBO.getUserId());
                combReqBO.setName(reqBO.getName());
                combReqBO.setUsername(reqBO.getUsername());
                combReqBO.setTaskId(auditNoticeList.get(0).getTaskId());
                combReqBO.setNoticeUserInfo(reqBO.getNoticeUserInfo());
                this.uocSendApproveNoticeCombService.sendApproveNotice(combReqBO);
            }
            catch (Exception e) {
                log.error("\u5ba1\u6279\u6284\u9001\u7ad9\u5185\u4fe1\u53d1\u9001\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

