/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.uoc.base.constants.UocApproveEntrustConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.enums.PebErpStatus;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.api.UocBusinessPendingTodoAbilityService;
import com.tydic.uoc.common.ability.bo.TodoBusinessWaitDoneAddReqBo;
import com.tydic.uoc.common.ability.bo.UocApproveEntrustNotificationAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomReqBO;
import com.tydic.uoc.common.ability.bo.UocBusinessPendingTodoAbilityAtomRspBO;
import com.tydic.uoc.common.comb.bo.UocOrdIdxSyncReqBO;
import com.tydic.uoc.dao.OrdShipMapper;
import com.tydic.uoc.po.OrdShipPO;
import com.tydic.uoc.zone.ability.api.UocContractOrderUpdateAbilityService;
import com.tydic.uoc.zone.ability.bo.UocContractOrderUpdateServiceReqBO;
import com.tydic.uoc.zone.ability.bo.UocContractOrderUpdateServiceRspBO;
import com.tydic.uoc.zone.busi.api.UocContractOrderUpdateBusiService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.zone.ability.api.UocContractOrderUpdateAbilityService"})
public class UocContractOrderUpdateAbilityServiceImpl
implements UocContractOrderUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UocContractOrderUpdateAbilityServiceImpl.class);
    @Autowired
    private UocContractOrderUpdateBusiService uocContractOrderUpdateBusiService;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private OrdShipMapper ordShipMapper;
    @Resource(name="mqUocApproveEntrustNotificationProvider")
    private ProxyMessageProducer mqUocApproveEntrustNotificationProvider;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC:UOC_APPROVE_ENTRUST_NOTIFICATION_TOPIC}")
    private String uocApproveEntrustNotificationTopic;
    @Value(value="${UOC_APPROVE_ENTRUST_NOTIFICATION_TAG:*}")
    private String uocApproveEntrustNotificationTag;
    @Autowired
    private UocBusinessPendingTodoAbilityService uocBusinessPendingTodoAbilityService;

    @PostMapping(value={"updateContractOrder"})
    public UocContractOrderUpdateServiceRspBO updateContractOrder(@RequestBody UocContractOrderUpdateServiceReqBO reqBO) {
        this.checkInput(reqBO);
        UocContractOrderUpdateServiceRspBO rspBO = this.uocContractOrderUpdateBusiService.updateContractOrder(reqBO);
        this.sendMq(reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getAuditNoticeList())) {
            UocApproveEntrustNotificationAbilityReqBO approveWaitNotificationReqBO = new UocApproveEntrustNotificationAbilityReqBO();
            try {
                approveWaitNotificationReqBO.setAuditNoticeList(rspBO.getAuditNoticeList());
                approveWaitNotificationReqBO.setApproveEntrustType(UocApproveEntrustConstant.ApproveEntrustType.ChangeOrder);
                approveWaitNotificationReqBO.setApproveEntrustNoticeType(UocApproveEntrustConstant.ApproveEntrustNoticeType.ChangeOrder);
                log.info("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)approveWaitNotificationReqBO));
                this.mqUocApproveEntrustNotificationProvider.send(new ProxyMessage(this.uocApproveEntrustNotificationTopic, this.uocApproveEntrustNotificationTag, JSON.toJSONString((Object)approveWaitNotificationReqBO)));
            }
            catch (Exception e) {
                log.error("\u5ba1\u6279\u59d4\u6258\u5355\u4ea7\u751f\u7684\u6d88\u606f\u5931\u8d25\uff1a" + e.getMessage() + "\u62a5\u6587json{}->" + JSONObject.toJSONString((Object)approveWaitNotificationReqBO));
            }
        }
        this.addBacklog(reqBO);
        return rspBO;
    }

    private void addBacklog(UocContractOrderUpdateServiceReqBO reqBO) {
        UocBusinessPendingTodoAbilityAtomReqBO todoBusinessWaitDoneAddReqBo = new UocBusinessPendingTodoAbilityAtomReqBO();
        TodoBusinessWaitDoneAddReqBo todoBusinessWaitDoneAddBo = new TodoBusinessWaitDoneAddReqBo();
        todoBusinessWaitDoneAddBo.setBusiCode("3065");
        todoBusinessWaitDoneAddBo.setCenterCode("order");
        todoBusinessWaitDoneAddBo.setSystemCode("1");
        todoBusinessWaitDoneAddBo.setSubmitTime(new Date());
        todoBusinessWaitDoneAddBo.setObjId(String.valueOf(reqBO.getOrderId()));
        todoBusinessWaitDoneAddBo.setHandleOrgNo(String.valueOf(reqBO.getUserId()));
        todoBusinessWaitDoneAddBo.setHandleUserName(reqBO.getName());
        todoBusinessWaitDoneAddBo.setHandleOrgName(reqBO.getName());
        todoBusinessWaitDoneAddBo.setHandleUserNo(String.valueOf(reqBO.getUserId()));
        todoBusinessWaitDoneAddBo.setSubmitUserNo(String.valueOf(reqBO.getUserId()));
        todoBusinessWaitDoneAddBo.setSubmitUserName(reqBO.getName());
        todoBusinessWaitDoneAddReqBo.setTodoBusinessWaitDoneAddReqBo(todoBusinessWaitDoneAddBo);
        log.error("\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5fc5\u8981\u53c2\u6570\u7ec4\u88c5{}", (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
        try {
            UocBusinessPendingTodoAbilityAtomRspBO uocBusinessPendingTodoAbilityAtomRspBO = this.uocBusinessPendingTodoAbilityService.businessPendingTodoParameterConcatenationAdd(todoBusinessWaitDoneAddReqBo);
            if (!"0000".equals(uocBusinessPendingTodoAbilityAtomRspBO.getRespCode())) {
                log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
            }
        }
        catch (Exception e) {
            log.error("{}\u4e1a\u52a1\u5f85\u529e\u63a8\u9001--------\u6dfb\u52a0\u5931\u8d25{}", (Object)todoBusinessWaitDoneAddBo.getBusiCode(), (Object)JSON.toJSONString((Object)todoBusinessWaitDoneAddReqBo));
        }
    }

    private void sendMq(UocContractOrderUpdateServiceReqBO reqBO) {
        UocOrdIdxSyncReqBO uocOrdIdxSyncReqBO = new UocOrdIdxSyncReqBO();
        uocOrdIdxSyncReqBO.setOrderId(reqBO.getOrderId());
        uocOrdIdxSyncReqBO.setObjId(reqBO.getSaleVoucherId());
        uocOrdIdxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
        this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)uocOrdIdxSyncReqBO)));
        OrdShipPO shipPO = new OrdShipPO();
        shipPO.setShipVoucherId(reqBO.getOrderId());
        List shipPOList = this.ordShipMapper.getList(shipPO);
        shipPOList.forEach(e -> {
            UocOrdIdxSyncReqBO idxSyncReqBO = new UocOrdIdxSyncReqBO();
            idxSyncReqBO.setObjId(e.getShipVoucherId());
            idxSyncReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SHIP);
            idxSyncReqBO.setOrderId(e.getOrderId());
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSONObject.toJSONString((Object)idxSyncReqBO)));
        });
    }

    private void checkInput(UocContractOrderUpdateServiceReqBO reqBO) {
        if (Objects.isNull(reqBO)) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getSubmitFlag())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u63d0\u4ea4\u6807\u8bc6\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getTempId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u53d8\u66f4\u8ba2\u5355id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getOrderId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getSaleVoucherId())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u9500\u552e\u5355id\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getSaleState())) {
            throw new UocProBusinessException("107777", "\u5165\u53c2\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        if (UocConstant.SALE_ORDER_STATUS.CREATE.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.PENDING_APPROVAL.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ORDER_FAILED.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ZONE_PRE_ORDER.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ADMIN_COMFRIM.equals(reqBO.getSaleState()) || UocConstant.SALE_ORDER_STATUS.REJECT_PENDING.equals(reqBO.getSaleState())) {
            throw new UocProBusinessException("107777", "\u5f53\u524d\u72b6\u6001\u7684\u8ba2\u5355\u4e0d\u652f\u6301\u8fdb\u884c\u53d8\u66f4");
        }
        if (PebErpStatus.YES.getCode().equals(reqBO.getIsPushErp()) && (Objects.isNull(reqBO.getAcquirer()) || Objects.isNull(reqBO.getAcquirerId()) || Objects.isNull(reqBO.getConsignee()) || Objects.isNull(reqBO.getConsigneeId()))) {
            throw new UocProBusinessException("107777", "\u63a8\u9001ERP\u65f6\uff0c\u6536\u5355\u65b9\u548c\u6536\u8d27\u65b9\u4fe1\u606f\u4e0d\u53ef\u4e3a\u7a7a");
        }
    }
}

