/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.busi.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.PlanDiversionMapper;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.zone.atom.api.PebBHOrderPushPlanAtomService;
import com.tydic.uoc.zone.atom.bo.PebBHOrderPushPlanAtomBO;
import com.tydic.uoc.zone.atom.bo.PebBHOrderPushPlanAtomReqBO;
import com.tydic.uoc.zone.busi.api.PebBHOrderPushPlanBusiService;
import com.tydic.uoc.zone.busi.bo.PebBHOrderPushPlanBusiReqBO;
import com.tydic.uoc.zone.busi.bo.PebBHOrderPushPlanBusiRspBO;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PebBHOrderPushPlanBusiServiceImpl
implements PebBHOrderPushPlanBusiService {
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private PebBHOrderPushPlanAtomService pebBHOrderPushPlanAtomService;
    @Autowired
    private PlanDiversionMapper planDiversionMapper;

    @Override
    public PebBHOrderPushPlanBusiRspBO dealBHOrderPushPlan(PebBHOrderPushPlanBusiReqBO reqBO) {
        PebBHOrderPushPlanAtomBO atomBO;
        PebBHOrderPushPlanAtomReqBO atomReqBO;
        List lineIds;
        PebBHOrderPushPlanBusiRspBO rspBO = new PebBHOrderPushPlanBusiRspBO();
        if (reqBO.getOrderId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        OrdSalePO qry = new OrdSalePO();
        qry.setOrderId(reqBO.getOrderId());
        qry = this.ordSaleMapper.getModelBy(qry);
        if (qry == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8ba2\u5355\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (qry != null && UocConstant.ORDER_SOURCE.REPLENISHMENT.toString().equals(qry.getOrderSource())) {
            lineIds = this.planDiversionMapper.qryLineIdByOrderId(reqBO.getOrderId());
            if (CollectionUtils.isEmpty((Collection)lineIds)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u8ba1\u5212\u660e\u7ec6\u4e3a\u7a7a\uff0c\u4e0d\u63a8\u9001");
                return rspBO;
            }
            atomReqBO = new PebBHOrderPushPlanAtomReqBO();
            atomBO = new PebBHOrderPushPlanAtomBO();
            atomBO.setOrder(qry.getSaleVoucherNo());
            atomBO.setOptType(1);
            if (UocConstant.SALE_ORDER_STATUS.CANCEL.equals(qry.getSaleState()) || UocConstant.SALE_ORDER_STATUS.ORDER_DELETE.equals(qry.getSaleState())) {
                atomBO.setOptType(0);
            }
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8ba2\u5355\u4e0d\u662f\u8865\u8d27\u5355\uff0c\u4e0d\u63a8\u9001");
            return rspBO;
        }
        String lineIdsStr = String.join((CharSequence)",", lineIds.stream().map(String::valueOf).collect(Collectors.toList()));
        atomBO.setLineIds(lineIdsStr);
        atomReqBO.setAtomBO(atomBO);
        atomReqBO.setOrderId(reqBO.getOrderId());
        this.pebBHOrderPushPlanAtomService.dealBHOrderPushPlan(atomReqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

