/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.zone.comb.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.UccEMdmMaterialBO;
import com.tydic.contract.ability.ContractDetailQueryAbilityService;
import com.tydic.contract.ability.ContractItemCanBuyListQryAbilityService;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractDetailQueryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryAbilityReqBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryAbilityRspBO;
import com.tydic.contract.ability.bo.ContractItemCanBuyListQryRspBO;
import com.tydic.umc.supplier.ability.bo.UmcSupplierInfoBO;
import com.tydic.uoc.base.bo.UocOrdGoodsTempBO;
import com.tydic.uoc.base.constants.PebExtConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.MoneyUtil;
import com.tydic.uoc.busibase.busi.api.PebIntfEnterpriseOrgDetailAbilityService;
import com.tydic.uoc.busibase.busi.api.PebIntfQryOrgEffAccountAbilityService;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailReqBO;
import com.tydic.uoc.busibase.busi.bo.EnterpriseOrgDetailRspBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountReqBO;
import com.tydic.uoc.busibase.busi.bo.QryOrgEffAccountRspBO;
import com.tydic.uoc.common.ability.bo.AgreementSettlementBO;
import com.tydic.uoc.common.ability.bo.EnterpriseAccountBO;
import com.tydic.uoc.common.ability.bo.GoodsInfoIdBO;
import com.tydic.uoc.common.ability.bo.GoodsListDelReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAddressInfoIntfceReqBO;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSkuInfo;
import com.tydic.uoc.common.ability.bo.PebExtAgreementSubmitOrderSaleItemRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreActiveReqBO;
import com.tydic.uoc.common.ability.bo.UocOrdAgreementBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdIdxSyncReqBO;
import com.tydic.uoc.common.busi.api.EsMsgLogBusiService;
import com.tydic.uoc.common.busi.bo.EsMsgLogReqBO;
import com.tydic.uoc.common.busi.bo.EsMsgLogRspBO;
import com.tydic.uoc.dao.UocOrdGoodsTempMapper;
import com.tydic.uoc.dao.UocOrdImportMapper;
import com.tydic.uoc.dao.UocOrdInitImportRelationMapper;
import com.tydic.uoc.po.UocOrdGoodsTempPO;
import com.tydic.uoc.po.UocOrdImportPO;
import com.tydic.uoc.po.UocOrdInitImportRelationPO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderReqBO;
import com.tydic.uoc.zone.ability.bo.PebExtAgreementCreateOrderRspBO;
import com.tydic.uoc.zone.ability.bo.UocOrdImportDataBO;
import com.tydic.uoc.zone.busi.api.PebExtAgreementCreateOrderBusiService;
import com.tydic.uoc.zone.busi.api.UocOrdImportBusiService;
import com.tydic.uoc.zone.busi.bo.UocOrdImportBusiReqBO;
import com.tydic.uoc.zone.busi.bo.UocOrdImportBusiRspBO;
import com.tydic.uoc.zone.comb.api.UocOrdImportdealCombService;
import com.tydic.uoc.zone.comb.bo.UocOrdImportdealCombReqBO;
import com.tydic.uoc.zone.comb.bo.UocOrdImportdealCombRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UocOrdImportdealCombServiceImpl
implements UocOrdImportdealCombService {
    private static final Logger log = LoggerFactory.getLogger(UocOrdImportdealCombServiceImpl.class);
    @Autowired
    private UocOrdImportBusiService uocOrdImportBusiService;
    @Autowired
    private PebExtAgreementCreateOrderBusiService pebExtAgreementCreateOrderBusiService;
    @Autowired
    private UocOrdGoodsTempMapper uocOrdGoodsTempMapper;
    @Autowired
    private UocOrdImportMapper uocOrdImportMapper;
    @Autowired
    private UocOrdInitImportRelationMapper uocOrdInitImportRelationMapper;
    @Autowired
    private PebIntfEnterpriseOrgDetailAbilityService pebIntfEnterpriseOrgDetailAbilityService;
    @Value(value="${zone.ship.maxTime:15}")
    private String maxShipTime;
    @Resource(name="uocZoneCreateOrderMsgProvider")
    private ProxyMessageProducer uocCreateOrderMsgProvider;
    @Value(value="${UOC_ZONE_ORDER_CREATE_TOPIC}")
    private String topic;
    @Value(value="${UOC_ZONE_ORDER_CREATE_TAG}")
    private String tag;
    @Value(value="${UOC_PEB_ORDER_SYNC_TOPIC}")
    private String orderSyncTopic;
    @Value(value="${UOC_PEB_ORDER_SYNC_TAG}")
    private String orderSyncTag;
    @Resource(name="uocPebSyncOrderListMqServiceProvider")
    private ProxyMessageProducer uocPebSyncOrderListMqServiceProvider;
    @Autowired
    private EsMsgLogBusiService esMsgLogBusiService;
    @Autowired
    private PebIntfQryOrgEffAccountAbilityService pebIntfQryOrgEffAccountAbilityService;
    @Autowired
    private ContractDetailQueryAbilityService contractDetailQueryAbilityService;
    @Autowired
    private ContractItemCanBuyListQryAbilityService contractItemCanBuyListQryAbilityService;

    @Override
    public UocOrdImportdealCombRspBO dealImport(UocOrdImportdealCombReqBO reqBO) {
        UocOrdImportBusiReqBO updateReq;
        this.validate(reqBO);
        Map<Long, List<UocOrdImportDataBO>> allDataMap = reqBO.getDataMap();
        List<UocOrdImportDataBO> canDoOrderList = this.getDataList(allDataMap, reqBO.getSuccesSet());
        Map<Long, List<UocOrdImportDataBO>> dataMap = canDoOrderList.stream().collect(Collectors.groupingBy(UocOrdImportDataBO::getOrderOnlyId));
        Set<Long> faileSet = reqBO.getFaileSet();
        Set<Long> succesSet = reqBO.getSuccesSet();
        HashMap<Long, String> faileMap = new HashMap<Long, String>();
        for (Long key : dataMap.keySet()) {
            Long orderId = Sequence.getInstance().nextId();
            List<UocOrdImportDataBO> dataList = dataMap.get(key);
            List<UocOrdGoodsTempBO> insertBatch = this.converGoodsTempBO(dataList, orderId, reqBO);
            UocOrdImportBusiRspBO UocOrdImportBusiRspBO2 = this.batchInsertGoodsTemp(insertBatch);
            if (!"0000".equals(UocOrdImportBusiRspBO2.getRespCode())) {
                throw new BusinessException("8888", "\u6279\u91cf\u63d2\u5165temp\u8868\u5931\u8d25");
            }
            PebExtAgreementCreateOrderReqBO busiReqBO = new PebExtAgreementCreateOrderReqBO();
            busiReqBO = this.converCreateOrderParam(dataList, orderId, reqBO);
            log.info(JSON.toJSONString((Object)busiReqBO));
            log.info(JSON.toJSONString((Object)busiReqBO));
            if (PebExtConstant.YES.equals(reqBO.getIsHtInit())) {
                busiReqBO.setIsReplenishment(PebExtConstant.YES);
                busiReqBO.setIsHtInit(reqBO.getIsHtInit());
            }
            busiReqBO.setCreateName(reqBO.getUsername());
            busiReqBO.setUsername(reqBO.getName());
            PebExtAgreementCreateOrderRspBO orderRspBO = this.pebExtAgreementCreateOrderBusiService.dealPebExtAgreementCreateOrder(busiReqBO);
            PebExtAgreementSubmitOrderSaleItemRspBO itemRspBO = new PebExtAgreementSubmitOrderSaleItemRspBO();
            if (!"0000".equals(orderRspBO.getRespCode())) {
                itemRspBO.setGoodSupplierName(orderRspBO.getGoodSupplierName());
                itemRspBO.setGoodsSupplierId(orderRspBO.getGoodsSupplierId());
                itemRspBO.setSuccess(Boolean.valueOf(false));
                itemRspBO.setFailMsg(orderRspBO.getRespDesc());
                faileSet.add(key);
                succesSet.remove(key);
                faileMap.put(key, orderRspBO.getRespDesc());
                continue;
            }
            BeanUtils.copyProperties((Object)orderRspBO, (Object)itemRspBO);
            itemRspBO.setIsPreOrder(Integer.valueOf(0));
            itemRspBO.setUserId(busiReqBO.getUserId());
            itemRspBO.setErp(busiReqBO.getErp());
            itemRspBO.setOrgId(busiReqBO.getOrgId());
            itemRspBO.setWarantty(busiReqBO.getAgreementBO().getWarantty());
            itemRspBO.setToken(busiReqBO.getToken());
            itemRspBO.setOrderId(orderRspBO.getOrderId());
            itemRspBO.setSaleOrderId(orderRspBO.getSaleOrderId());
            itemRspBO.setTotalfee(busiReqBO.getTotalAmount().divide(new BigDecimal(10000)));
            itemRspBO.setFee(itemRspBO.getTotalfee());
            itemRspBO.setSaleOrderItemList(busiReqBO.getSaleOrderItemList());
            itemRspBO.setCreateName(busiReqBO.getCreateName());
            itemRspBO.setEcpPurType(busiReqBO.getEcpPurType());
            itemRspBO.setIsOrgTax(busiReqBO.getAgreementBO().getAssignStatus());
            itemRspBO.setCompanyId(busiReqBO.getCompanyId());
            itemRspBO.setAgrId(((PebExtAgreementSkuInfo)busiReqBO.getSaleOrderItemList().get(0)).getAgrId());
            itemRspBO.setMemId(busiReqBO.getMemId());
            itemRspBO.setMemUserType(busiReqBO.getMemUserType());
            itemRspBO.setIsPersonal(busiReqBO.getIsPersonal());
            itemRspBO.setContractType(busiReqBO.getAgreementBO().getContractType());
            itemRspBO.setSubmit(busiReqBO.getSubmit());
            itemRspBO.setCreateType(busiReqBO.getCreateType());
            itemRspBO.setIsPlan(busiReqBO.getIsPlan());
            if (CollectionUtils.isNotEmpty((Collection)busiReqBO.getActiveBOList())) {
                itemRspBO.setActiveId(((UocCoreActiveReqBO)busiReqBO.getActiveBOList().get(0)).getActiveId());
                itemRspBO.setFl(Boolean.valueOf(true));
            } else {
                itemRspBO.setFl(Boolean.valueOf(false));
            }
            GoodsListDelReqBO goodsListDelReqBO = new GoodsListDelReqBO();
            ArrayList<GoodsInfoIdBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdBO>();
            goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
            goodsListDelReqBO.setMemberId(String.valueOf(busiReqBO.getUserId()));
            for (PebExtAgreementSkuInfo skuInfo : busiReqBO.getSaleOrderItemList()) {
                GoodsInfoIdBO goodsInfoIdBO = new GoodsInfoIdBO();
                goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
                goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
            }
            itemRspBO.setGoodsListDelReqBO(goodsListDelReqBO);
            itemRspBO.setBuynerNo(busiReqBO.getBuynerNo());
            this.uocCreateOrderMsgProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)itemRspBO)));
            UocPebOrdIdxSyncReqBO combReqBO = new UocPebOrdIdxSyncReqBO();
            combReqBO.setOrderId(itemRspBO.getOrderId());
            combReqBO.setObjId(Long.valueOf(itemRspBO.getSaleOrderId()));
            combReqBO.setObjType(UocCoreConstant.OBJ_TYPE.SALE);
            combReqBO.setIsStatistics(Boolean.valueOf(false));
            try {
                EsMsgLogReqBO logReqBO = new EsMsgLogReqBO();
                logReqBO.setObjId(combReqBO.getObjId());
                logReqBO.setObjType(combReqBO.getObjType());
                logReqBO.setOrderId(combReqBO.getOrderId());
                EsMsgLogRspBO es = this.esMsgLogBusiService.dealSave(logReqBO);
                combReqBO.setEsLogId(es.getId());
                if (PebExtConstant.YES.equals(reqBO.getIsHtInit())) {
                    UocOrdInitImportRelationPO relationPO = new UocOrdInitImportRelationPO();
                    relationPO.setRelationId(Long.valueOf(Sequence.getInstance().nextId()));
                    relationPO.setOrderId(orderRspBO.getOrderId());
                    relationPO.setSourceOrderId(key);
                    relationPO.setCreateTime(new Date());
                    if (reqBO.getImportId() != null) {
                        relationPO.setExt1(reqBO.getImportId() + "");
                    }
                    relationPO.setExt2(reqBO.getUsername());
                    this.uocOrdInitImportRelationMapper.insert(relationPO);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.uocPebSyncOrderListMqServiceProvider.send(new ProxyMessage(this.orderSyncTopic, this.orderSyncTag, JSON.toJSONString((Object)combReqBO)));
        }
        UocOrdImportPO uocOrdImportPO = this.uocOrdImportMapper.getModelById(reqBO.getImportId());
        if (!CollectionUtils.isEmpty(faileSet)) {
            updateReq = new UocOrdImportBusiReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)updateReq));
            List<UocOrdImportDataBO> faileBOS = this.getDataList(allDataMap, faileSet);
            for (UocOrdImportDataBO faileBO : faileBOS) {
                if (!StringUtils.isBlank((CharSequence)faileBO.getFailReason())) continue;
                faileBO.setFailReason((String)faileMap.get(faileMap.get(faileBO.getOrderOnlyId())));
            }
            updateReq.setFaileList(faileBOS);
            updateReq.setImportId(reqBO.getImportId());
            if (faileSet.size() < allDataMap.keySet().size()) {
                updateReq.setImportResult(1);
                updateReq.setFaileReason("\u90e8\u5206\u4e0b\u5355\u5931\u8d25");
            } else {
                updateReq.setImportResult(2);
                updateReq.setFaileReason("\u4e0b\u5355\u5931\u8d25");
            }
            UocOrdImportBusiRspBO busiRspBO = this.uocOrdImportBusiService.dealOrdImportUpdate(updateReq);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u9519\u8bef\u4e0b\u5355\u660e\u7ec6\u6570\u636e\u5165\u5e93\u5931\u8d25");
            }
        } else {
            updateReq = new UocOrdImportBusiReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)updateReq));
            updateReq.setImportId(reqBO.getImportId());
            updateReq.setImportResult(3);
            UocOrdImportBusiRspBO busiRspBO = this.uocOrdImportBusiService.dealOrdImportUpdate(updateReq);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new BusinessException("8888", "\u9519\u8bef\u4e0b\u5355\u660e\u7ec6\u6570\u636e\u5165\u5e93\u5931\u8d25");
            }
        }
        UocOrdImportdealCombRspBO rspBO = new UocOrdImportdealCombRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5bfc\u5165\u6210\u529f");
        return rspBO;
    }

    List<UocOrdImportDataBO> getDataList(Map<Long, List<UocOrdImportDataBO>> dataMap, Set<Long> dataSet) {
        ArrayList<UocOrdImportDataBO> returnList = new ArrayList<UocOrdImportDataBO>();
        for (Long key : dataSet) {
            returnList.addAll((Collection<UocOrdImportDataBO>)dataMap.get(key));
        }
        return returnList;
    }

    private PebExtAgreementCreateOrderReqBO converCreateOrderParam(List<UocOrdImportDataBO> dataList, Long orderId, UocOrdImportdealCombReqBO combReqBO) {
        PebExtAgreementCreateOrderReqBO busiReqBO = new PebExtAgreementCreateOrderReqBO();
        UocOrdImportDataBO source = dataList.get(0);
        String contractNo = dataList.get(0).getContractNo();
        String contractName = null;
        Integer contractType = null;
        Long contractId = null;
        if (StringUtils.isNotBlank((CharSequence)contractNo)) {
            ContractDetailQueryAbilityReqBO abilityReqBO = new ContractDetailQueryAbilityReqBO();
            abilityReqBO.setContractCode(contractNo);
            ContractDetailQueryAbilityRspBO contractedDetailQuery = this.contractDetailQueryAbilityService.contractDetailQuery(abilityReqBO);
            if (contractedDetailQuery.getContractId() == null) {
                throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5408\u540c\u5931\u8d25");
            }
            contractId = contractedDetailQuery.getContractId();
            contractName = contractedDetailQuery.getContractName();
            contractType = contractedDetailQuery.getContractType();
        }
        BeanUtils.copyProperties((Object)((Object)combReqBO), (Object)busiReqBO);
        busiReqBO.setAcquirerId(source.getAcquirerId());
        busiReqBO.setAcquirer((String)combReqBO.getUmcOrderImportGetDetailRspBO().getAcquirerNameMap().get(busiReqBO.getAcquirerId()));
        busiReqBO.setAddrJc(source.getAddrJc());
        if (!StringUtils.isEmpty((CharSequence)dataList.get(0).getVendorSiteId())) {
            try {
                busiReqBO.setVendorSiteId(Long.valueOf(source.getVendorSiteId()));
            }
            catch (Exception e) {
                throw new UocProBusinessException("8888", "\u5730\u5740\u7b80\u79f0ID\u8f6c\u5316\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5730\u5740\u7b80\u79f0ID\u662f\u5426\u6b63\u786e");
            }
        }
        busiReqBO.setVendorSiteName(source.getAddrJc());
        PebExtAddressInfoIntfceReqBO addressInfo = this.converAddress(source);
        busiReqBO.setAddressInfo(addressInfo);
        busiReqBO.setAdjustType("\u4ee5\uff08\u542b\u7a0e\uff09\u5355\u4ef7\u4e3a\u57fa\u51c6\u8c03\u6574");
        UmcSupplierInfoBO UmcSupplierInfoBO2 = combReqBO.getSuppilerMap().get(source.getSupNo());
        busiReqBO.setExtField5(UmcSupplierInfoBO2.getSupplierCode());
        this.coverAccount(combReqBO, busiReqBO, source);
        busiReqBO.setConsignee((String)combReqBO.getUmcOrderImportGetDetailRspBO().getConsigneeNameNameMap().get(source.getConsigneeId()));
        busiReqBO.setConsigneeId(source.getConsigneeId());
        busiReqBO.setCreateType("2");
        busiReqBO.setCreateName(combReqBO.getUsername());
        busiReqBO.setErp(Boolean.valueOf(false));
        busiReqBO.setIsHt(Integer.valueOf(1));
        busiReqBO.setIsPushErp(Integer.valueOf(Integer.parseInt(this.translate(source.getIsPushErp()))));
        busiReqBO.setMaterialCategory(source.getMaterialCategory());
        busiReqBO.setMergeOrderId(combReqBO.getImportId());
        busiReqBO.setOrderId(orderId);
        busiReqBO.setOrderName(source.getOrderName());
        busiReqBO.setOrderSource("1");
        busiReqBO.setOrigin(this.translate(source.getOrigin()));
        busiReqBO.setPayType(Integer.valueOf(10));
        busiReqBO.setSettlementType("10");
        busiReqBO.setProcKey("cnnc_el_sale_order_master_order_status");
        busiReqBO.setSubmit("0");
        busiReqBO.setPurUserName(combReqBO.getName());
        busiReqBO.setPurUserNo(combReqBO.getUsername());
        busiReqBO.setSaleOrderClassify(Integer.valueOf(1));
        busiReqBO.setTatleTransportationFee(BigDecimal.ZERO);
        busiReqBO.setTaxrate(Integer.valueOf(0));
        List<UocOrdGoodsTempPO> uocOrdGoodsTempPOS = this.getUocOrdGoodsTempPOS(orderId);
        this.tempItem(busiReqBO, uocOrdGoodsTempPOS, contractNo, contractId, UmcSupplierInfoBO2);
        UocOrdAgreementBO uocOrdAgreementBO = this.getUocOrdAgreementBO(orderId, busiReqBO, UmcSupplierInfoBO2);
        uocOrdAgreementBO.setContactId(contractId + "");
        uocOrdAgreementBO.setContactName(contractNo);
        uocOrdAgreementBO.setContactNo(contractName);
        uocOrdAgreementBO.setContractType(contractType);
        if (contractId != null) {
            uocOrdAgreementBO.setPlaAgreementCode(contractNo);
            uocOrdAgreementBO.setEntAgreementCode(contractNo);
            uocOrdAgreementBO.setAgreementName(contractName);
            uocOrdAgreementBO.setAgreementId(contractId + "");
        }
        busiReqBO.setAgreementBO(uocOrdAgreementBO);
        busiReqBO.setSupRelaMobile(busiReqBO.getAgreementBO().getVendorPhone());
        busiReqBO.setSupRelaName(busiReqBO.getAgreementBO().getVendorContact());
        busiReqBO.setComment(source.getOrderDesc());
        busiReqBO.setSupId(UmcSupplierInfoBO2.getSupplierId());
        return busiReqBO;
    }

    private List<UocOrdGoodsTempPO> getUocOrdGoodsTempPOS(Long orderId) {
        UocOrdGoodsTempPO record = new UocOrdGoodsTempPO();
        record.setOrderId(orderId);
        return this.uocOrdGoodsTempMapper.selectByCondition(record);
    }

    private void tempItem(PebExtAgreementCreateOrderReqBO reqBO, List<UocOrdGoodsTempPO> list, String contractNo, Long contractId, UmcSupplierInfoBO UmcSupplierInfoBO2) {
        ArrayList<PebExtAgreementSkuInfo> saleOrderItemList = new ArrayList<PebExtAgreementSkuInfo>();
        reqBO.setSaleOrderItemList(saleOrderItemList);
        BigDecimal fee = BigDecimal.ZERO;
        Map<Object, Object> map = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)contractNo)) {
            ContractItemCanBuyListQryAbilityReqBO itemReqBO = new ContractItemCanBuyListQryAbilityReqBO();
            ArrayList<String> materialCodes = new ArrayList<String>();
            for (UocOrdGoodsTempPO skuInfo : list) {
                materialCodes.add(skuInfo.getSkuMaterialId());
            }
            itemReqBO.setMaterialCodes(materialCodes);
            itemReqBO.setContractId(contractId);
            itemReqBO.setPageSize(Integer.valueOf(999999));
            itemReqBO.setPageNo(Integer.valueOf(1));
            ContractItemCanBuyListQryAbilityRspBO abilityRspBO = this.contractItemCanBuyListQryAbilityService.queryItemCanBuyListByMaterialCodes(itemReqBO);
            if (CollectionUtils.isEmpty((Collection)abilityRspBO.getRows())) {
                throw new UocProBusinessException("8888", "\u672a\u67e5\u8be2\u5230\u5408\u540c\u660e\u7ec6");
            }
            map = abilityRspBO.getRows().stream().collect(Collectors.toMap(ContractItemCanBuyListQryRspBO::getMaterialCode, Function.identity(), (existing, replacement) -> existing));
        }
        for (UocOrdGoodsTempPO tempPO : list) {
            PebExtAgreementSkuInfo agreementSkuInfo = new PebExtAgreementSkuInfo();
            if (StringUtils.isNotBlank((CharSequence)contractNo)) {
                ContractItemCanBuyListQryRspBO rspBO = (ContractItemCanBuyListQryRspBO)map.get(tempPO.getSkuMaterialId());
                agreementSkuInfo.setContractId(contractId);
                agreementSkuInfo.setAgrItemId(rspBO.getItemId());
                if (StringUtils.isNotBlank((CharSequence)rspBO.getPlanId())) {
                    agreementSkuInfo.setPlanId(Long.valueOf(rspBO.getPlanId()));
                }
            } else {
                agreementSkuInfo.setAgrItemId(tempPO.getHtItemId());
            }
            BeanUtils.copyProperties((Object)tempPO, (Object)agreementSkuInfo);
            agreementSkuInfo.setTempId(tempPO.getTempId());
            agreementSkuInfo.setSkuItemCode(tempPO.getSkuCode());
            agreementSkuInfo.setSkuMaterialId(tempPO.getSkuMaterialId());
            agreementSkuInfo.setItemType(Integer.valueOf(2));
            agreementSkuInfo.setSkuMaterialName(tempPO.getSkuMaterialName());
            agreementSkuInfo.setSkuMaterialTypeId(tempPO.getExt1());
            agreementSkuInfo.setSkuMaterialTypeName(tempPO.getExt2());
            agreementSkuInfo.setPurchaseCount(tempPO.getPurchaseCount());
            agreementSkuInfo.setPlanItemCode(tempPO.getExt6());
            agreementSkuInfo.setPlanItemName(tempPO.getExt7());
            if (StringUtils.isNotBlank((CharSequence)tempPO.getHtId())) {
                agreementSkuInfo.setAgrId(Long.valueOf(tempPO.getHtId()));
            } else {
                agreementSkuInfo.setAgrId(reqBO.getOrderId());
            }
            agreementSkuInfo.setTotalPrice(tempPO.getTotalSalePrice());
            agreementSkuInfo.setGoodsSupplierId(String.valueOf(tempPO.getSkuSupplierId()));
            if (StringUtils.isNotBlank((CharSequence)tempPO.getPlanId())) {
                agreementSkuInfo.setPlanId(Long.valueOf(tempPO.getPlanId()));
            }
            agreementSkuInfo.setSkuMaterialRemark(tempPO.getSkuMaterialRemark());
            agreementSkuInfo.setMaterialRemark(tempPO.getSkuMaterialRemark());
            agreementSkuInfo.setSupplier(tempPO.getSupplier());
            agreementSkuInfo.setAddrJc(reqBO.getAddrJc());
            if (StringUtils.isNotBlank((CharSequence)tempPO.getSkuId())) {
                agreementSkuInfo.setItemType(Integer.valueOf(1));
            } else {
                agreementSkuInfo.setItemType(Integer.valueOf(2));
            }
            agreementSkuInfo.setOrganizationId(tempPO.getOrganizationId());
            agreementSkuInfo.setOrganizationName(tempPO.getOrganizationName());
            agreementSkuInfo.setOrganizationCode(tempPO.getOrganizationCode());
            agreementSkuInfo.setVendorSiteId(reqBO.getVendorSiteId());
            agreementSkuInfo.setVendorSiteName(reqBO.getVendorSiteName());
            agreementSkuInfo.setB2bsiteId(reqBO.getB2bsiteId());
            agreementSkuInfo.setAddrJc(reqBO.getAddrJc());
            agreementSkuInfo.setSkuMaterialLongDesc(tempPO.getSkuMaterialName());
            agreementSkuInfo.setSkuMaterialUnit(tempPO.getMaterialUnitName());
            agreementSkuInfo.setSkuSalePrice(tempPO.getSalePrice().multiply(new BigDecimal("10000")));
            agreementSkuInfo.setSkuAgreementPrice(tempPO.getSalePrice().multiply(new BigDecimal("10000")));
            agreementSkuInfo.setTaxCode(tempPO.getTaxCode());
            agreementSkuInfo.setTax(tempPO.getTax());
            agreementSkuInfo.setMeasureName(tempPO.getUnitName());
            agreementSkuInfo.setSupplierTel(UmcSupplierInfoBO2.getPhoneNumber());
            agreementSkuInfo.setSupplierMan(UmcSupplierInfoBO2.getConsignerName());
            agreementSkuInfo.setSupplierErpNo(UmcSupplierInfoBO2.getErpOrgCode());
            agreementSkuInfo.setSupplierNo(UmcSupplierInfoBO2.getSupplierCode());
            agreementSkuInfo.setModel(tempPO.getModel());
            agreementSkuInfo.setSpec(tempPO.getSpec());
            if (tempPO.getArrivalTime() != null) {
                agreementSkuInfo.setArrivalTime(String.valueOf(tempPO.getArrivalTime()));
            } else {
                agreementSkuInfo.setArrivalTime(this.maxShipTime);
            }
            agreementSkuInfo.setSettlementUnit(tempPO.getExt1());
            if (StringUtils.isNotBlank((CharSequence)tempPO.getExt2())) {
                agreementSkuInfo.setSalesUnitRate(new BigDecimal(tempPO.getExt2()));
            }
            agreementSkuInfo.setAddCoefficient(new BigDecimal("0"));
            agreementSkuInfo.setSkuSupplierId(tempPO.getSkuSupplierId());
            agreementSkuInfo.setSkuSupplierName(tempPO.getSkuSupplierName());
            agreementSkuInfo.setSkuCurrencyType("CNY");
            agreementSkuInfo.setSkuBrandName(tempPO.getPpcd());
            if (StringUtils.isNotBlank((CharSequence)tempPO.getExt3())) {
                agreementSkuInfo.setSkuCommodityTypeId(Long.valueOf(tempPO.getExt3()));
            }
            agreementSkuInfo.setSkuMaterialLongDesc(tempPO.getSkuMaterialName());
            agreementSkuInfo.setSkuMaterialTypeId(tempPO.getCateCode());
            agreementSkuInfo.setSkuMaterialTypeName(tempPO.getCateName());
            agreementSkuInfo.setPartNo(tempPO.getMaterialBj());
            agreementSkuInfo.setTechnicalParam(tempPO.getZljsyq());
            agreementSkuInfo.setInspectionExcessPercent(Integer.valueOf(0));
            agreementSkuInfo.setSupplierShopId(tempPO.getSupplierShopId());
            agreementSkuInfo.setSupplierName(tempPO.getSkuSupplierName());
            if (StringUtils.isBlank((CharSequence)tempPO.getSkuId())) {
                agreementSkuInfo.setSkuId(tempPO.getSkuMaterialId().trim());
                agreementSkuInfo.setSkuName(tempPO.getSkuMaterialName());
                agreementSkuInfo.setSpuId(Long.valueOf(1L));
            } else {
                agreementSkuInfo.setSkuId(tempPO.getSkuId());
                agreementSkuInfo.setSkuName(tempPO.getSkuName());
            }
            BigDecimal itemFee = agreementSkuInfo.getPurchaseCount().multiply(agreementSkuInfo.getSkuSalePrice());
            agreementSkuInfo.setTotalPrice(itemFee);
            saleOrderItemList.add(agreementSkuInfo);
            fee = fee.add(MoneyUtil.l4B((Long)itemFee.longValue()));
        }
        reqBO.setTotalAmount(fee);
    }

    String translate(String desc) {
        if (desc.equals("\u56fd\u4ea7")) {
            return "1";
        }
        if (desc.equals("\u8fdb\u53e3")) {
            return "2";
        }
        if (desc.equals("\u63a8\u9001")) {
            return "1";
        }
        if (desc.equals("\u4e0d\u63a8\u9001")) {
            return "0";
        }
        return "";
    }

    private void coverAccount(UocOrdImportdealCombReqBO combReqBO, PebExtAgreementCreateOrderReqBO busiReqBO, UocOrdImportDataBO source) {
        EnterpriseAccountBO umcEnterpriseAccountBO = (EnterpriseAccountBO)JSON.parseObject((String)JSON.toJSONString((Object)combReqBO.getAccountMap().get(source.getBuynerNo())), EnterpriseAccountBO.class);
        busiReqBO.setBuynerErpNo(umcEnterpriseAccountBO.getBuynerErpNo());
        busiReqBO.setBuynerNo(umcEnterpriseAccountBO.getMBuynerNo());
        busiReqBO.setBuynerName(umcEnterpriseAccountBO.getBuynerName());
        busiReqBO.setPurchaserAccountOrgId(umcEnterpriseAccountBO.getOrgId());
        busiReqBO.setProfessionalOrganizationId(umcEnterpriseAccountBO.getDeliveryCenterId());
        busiReqBO.setProPhone(umcEnterpriseAccountBO.getTelephone());
        busiReqBO.setPurchaserAccount(umcEnterpriseAccountBO.getAccountId());
        busiReqBO.setPurchaserAccountName(umcEnterpriseAccountBO.getAccountName());
        EnterpriseOrgDetailReqBO detailReqBO = new EnterpriseOrgDetailReqBO();
        detailReqBO.setOrgIdWeb(umcEnterpriseAccountBO.getDeliveryCenterId());
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(detailReqBO);
        if (!"0000".equals(detailRspBO.getRespCode())) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u5931\u8d25" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() == null) {
            throw new UocProBusinessException("103028", "\u67e5\u8be2\u8fd0\u8425\u5355\u4f4d\u4e3a\u7a7a");
        }
        busiReqBO.setProPath(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgTreePath());
        busiReqBO.setProCode(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgCode());
        busiReqBO.setProOrgName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getOrgName());
        busiReqBO.setProRealName(detailRspBO.getUmcEnterpriseOrgAbilityBO().getLinkMan());
        busiReqBO.setOperationArea(umcEnterpriseAccountBO.getOperationArea());
        busiReqBO.setOperationAreaStr(umcEnterpriseAccountBO.getOperationAreaStr());
        busiReqBO.setSettlePlatform(umcEnterpriseAccountBO.getSettlePlatform());
        busiReqBO.setSettlePlatformStr(umcEnterpriseAccountBO.getSettlePlatformStr());
        busiReqBO.setShareReleaseDate(umcEnterpriseAccountBO.getShareReleaseDate());
        EnterpriseAccountBO enterpriseAccountBO = this.qryOrgEffAccount(umcEnterpriseAccountBO);
        if (enterpriseAccountBO != null) {
            busiReqBO.setProAccount(enterpriseAccountBO.getAccountId());
        }
        busiReqBO.setEnterpriseAccountBO(umcEnterpriseAccountBO);
        String isTax = StringUtils.isBlank((CharSequence)umcEnterpriseAccountBO.getIsTax()) ? "0" : umcEnterpriseAccountBO.getIsTax();
        busiReqBO.setIsTax(Integer.valueOf(Integer.parseInt(isTax)));
    }

    private UocOrdAgreementBO getUocOrdAgreementBO(Long orderId, PebExtAgreementCreateOrderReqBO busiReqBO, UmcSupplierInfoBO umcSupplierInfoBO) {
        UocOrdAgreementBO uocOrdAgreementBO = new UocOrdAgreementBO();
        uocOrdAgreementBO.setAdjustPrice(Integer.valueOf(0));
        uocOrdAgreementBO.setAgreementId(String.valueOf(orderId));
        uocOrdAgreementBO.setAgreementMode("2");
        uocOrdAgreementBO.setAgreementName(null);
        uocOrdAgreementBO.setAgreementStatus(Byte.valueOf((byte)4));
        uocOrdAgreementBO.setAssignStatus(Integer.valueOf(1));
        uocOrdAgreementBO.setCreateTime(new Date());
        uocOrdAgreementBO.setEntAgreementCode(null);
        uocOrdAgreementBO.setIsDispatch(Integer.valueOf(1));
        uocOrdAgreementBO.setAgreementSrc(Byte.valueOf((byte)2));
        uocOrdAgreementBO.setEntAgreementCode(null);
        uocOrdAgreementBO.setTradeMode(Integer.valueOf(2));
        ArrayList<AgreementSettlementBO> settlementBOS = new ArrayList<AgreementSettlementBO>();
        AgreementSettlementBO pur = new AgreementSettlementBO();
        pur.setAgreementId(orderId);
        pur.setSettlementObject("1");
        pur.setSettlementType("10");
        settlementBOS.add(pur);
        uocOrdAgreementBO.setPaymentMethod(settlementBOS);
        uocOrdAgreementBO.setProducerId(busiReqBO.getUserId());
        uocOrdAgreementBO.setProducerName(busiReqBO.getName());
        uocOrdAgreementBO.setServiceRate(Double.valueOf(0.0));
        uocOrdAgreementBO.setSupplierId(umcSupplierInfoBO.getSupplierId());
        uocOrdAgreementBO.setSupplierName(umcSupplierInfoBO.getSupplierName());
        uocOrdAgreementBO.setVendorDepartmentId(uocOrdAgreementBO.getSupplierId());
        uocOrdAgreementBO.setVendorDepartmentName(uocOrdAgreementBO.getSupplierName());
        EnterpriseOrgDetailReqBO queryReqBO = new EnterpriseOrgDetailReqBO();
        queryReqBO.setOrgIdWeb(uocOrdAgreementBO.getVendorDepartmentId());
        EnterpriseOrgDetailRspBO detailRspBO = this.pebIntfEnterpriseOrgDetailAbilityService.queryEnterpriseOrgByDetail(queryReqBO);
        if (!detailRspBO.getRespCode().equals("0000")) {
            throw new UocProBusinessException("102105", "\u67e5\u8be2\u4f9b\u5e94\u5546\u673a\u6784\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + detailRspBO.getRespDesc());
        }
        if (detailRspBO.getUmcEnterpriseOrgAbilityBO() != null) {
            uocOrdAgreementBO.setVendorContactWay(detailRspBO.getUmcEnterpriseOrgAbilityBO().getPhone());
            uocOrdAgreementBO.setVendorContactPerson(detailRspBO.getUmcEnterpriseOrgAbilityBO().getLinkMan());
            uocOrdAgreementBO.setVendorContactAddress(detailRspBO.getUmcEnterpriseOrgAbilityBO().getAddress());
        }
        uocOrdAgreementBO.setVendorDepartmentId(uocOrdAgreementBO.getSupplierId());
        uocOrdAgreementBO.setVendorDepartmentName(uocOrdAgreementBO.getSupplierName());
        uocOrdAgreementBO.setVendorId(uocOrdAgreementBO.getSupplierId());
        uocOrdAgreementBO.setVendorName(uocOrdAgreementBO.getSupplierName());
        uocOrdAgreementBO.setVendorPhone(uocOrdAgreementBO.getVendorContactWay());
        uocOrdAgreementBO.setAgreementMode("1");
        ArrayList<PebExtAgreementSkuInfo> list = new ArrayList<PebExtAgreementSkuInfo>();
        for (PebExtAgreementSkuInfo agreementSkuInfo : busiReqBO.getSaleOrderItemList()) {
            agreementSkuInfo.setAgreementMode(uocOrdAgreementBO.getAgreementMode());
            agreementSkuInfo.setAgreementBO(uocOrdAgreementBO);
            agreementSkuInfo.setPayType(busiReqBO.getPayType());
            agreementSkuInfo.setAgreementMode(uocOrdAgreementBO.getAgreementMode());
            list.add(agreementSkuInfo);
        }
        busiReqBO.setSaleOrderItemList(list);
        return uocOrdAgreementBO;
    }

    private PebExtAddressInfoIntfceReqBO converAddress(UocOrdImportDataBO source) {
        PebExtAddressInfoIntfceReqBO addressInfo = new PebExtAddressInfoIntfceReqBO();
        addressInfo.setReceiverAddress(source.getContactAddress());
        addressInfo.setReceiverCityId("1");
        addressInfo.setReceiverCityName(source.getContactCityName());
        addressInfo.setReceiverCompany(source.getContactCompany());
        addressInfo.setReceiverCountyId("1");
        addressInfo.setReceiverCountyName(source.getContactCountyName());
        addressInfo.setReceiverEmail(source.getContactEmail());
        addressInfo.setReceiverMobileNumber(source.getContactMobile());
        addressInfo.setReceiverName(source.getContactName());
        addressInfo.setReceiverProvinceId("1");
        addressInfo.setReceiverProvinceName(source.getContactProvinceName());
        addressInfo.setReceiverTownId("1");
        addressInfo.setReceiverTown(source.getContactTown());
        return addressInfo;
    }

    private UocOrdImportBusiRspBO batchInsertGoodsTemp(List<UocOrdGoodsTempBO> insertBatch) {
        UocOrdImportBusiReqBO busiReqBO = new UocOrdImportBusiReqBO();
        busiReqBO.setUocOrdGoodsTempBOS(insertBatch);
        return this.uocOrdImportBusiService.dealOrdImportInsertGoodsTemp(busiReqBO);
    }

    private List<UocOrdGoodsTempBO> converGoodsTempBO(List<UocOrdImportDataBO> dataList, Long orderId, UocOrdImportdealCombReqBO reqBO) {
        ArrayList<UocOrdGoodsTempBO> UocOrdGoodsTempBOS = new ArrayList<UocOrdGoodsTempBO>();
        for (UocOrdImportDataBO source : dataList) {
            UocOrdGoodsTempBO bo = new UocOrdGoodsTempBO();
            bo.setTempId(Long.valueOf(Sequence.getInstance().nextId()));
            bo.setOrderId(orderId);
            UmcSupplierInfoBO umcSupplierInfoBO = reqBO.getSuppilerMap().get(source.getSupNo());
            bo.setSkuSupplierId(umcSupplierInfoBO.getSupplierId());
            bo.setSupplierShopId(umcSupplierInfoBO.getSupplierId());
            bo.setSkuSupplierName(umcSupplierInfoBO.getSupplierName());
            bo.setSupplier(umcSupplierInfoBO.getSupplierId().toString());
            UccEMdmMaterialBO uccEMdmMaterialBO = reqBO.getMaterialMap().get(source.getSkuMaterialId());
            bo.setSkuMaterialId(source.getSkuMaterialId());
            if (StringUtils.isNotBlank((CharSequence)uccEMdmMaterialBO.getLongDesc())) {
                bo.setSkuMaterialName(uccEMdmMaterialBO.getLongDesc());
            } else {
                bo.setSkuMaterialName(uccEMdmMaterialBO.getMaterialName());
            }
            bo.setCateCode(uccEMdmMaterialBO.getCatalogCode());
            bo.setCateName(uccEMdmMaterialBO.getCatalogName());
            bo.setExt8(uccEMdmMaterialBO.getMaterialName());
            bo.setUnitName(source.getUnitName());
            bo.setSpec(source.getSpec());
            bo.setModel(source.getModel());
            bo.setMaterialId(source.getSkuMaterialId());
            bo.setMaterialBj(source.getMaterialBj());
            bo.setZljsyq(source.getZljsyq());
            bo.setJtyt(source.getJtyt());
            bo.setZxbz(source.getZxbz());
            bo.setPpcd(source.getPpcd());
            bo.setDccj(source.getDccj());
            if (source.getPlanId() != null) {
                bo.setPlanId(source.getPlanId() + "");
            }
            bo.setSkuMaterialRemark(source.getSkuMaterialRemark());
            bo.setPurchaseCount(source.getPurchaseCount());
            bo.setSalePrice(source.getSalePrice());
            BigDecimal tax = new BigDecimal(source.getTax() + "").divide(new BigDecimal("100"), 2);
            BigDecimal nk = source.getSalePrice().divide(BigDecimal.ONE.add(tax), 4, 4);
            BigDecimal tn = nk.multiply(source.getPurchaseCount());
            BigDecimal ts = source.getSalePrice().multiply(source.getPurchaseCount());
            bo.setNakePrice(nk);
            bo.setTaxPrice(ts.subtract(tn));
            bo.setTotalSalePrice(ts);
            bo.setTotalNakePrice(tn);
            bo.setTax(source.getTax());
            Map organizationMap = reqBO.getUmcOrderImportGetDetailRspBO().getOrganizationNameMap();
            bo.setOrganizationId(source.getOrganizationId());
            bo.setOrganizationName((String)organizationMap.get(source.getOrganizationId()));
            bo.setOrganizationCode(source.getOrganizationCode());
            bo.setBjType(source.getBjType());
            bo.setArrivalTime(source.getArrivalTime());
            bo.setDbPrice(source.getDbPrice());
            bo.setCreateTime(new Date());
            bo.setCreateOperId(reqBO.getUserId().toString());
            bo.setUpdateTime(new Date());
            bo.setUpdateOperId(reqBO.getUserId().toString());
            UocOrdGoodsTempBOS.add(bo);
        }
        return UocOrdGoodsTempBOS;
    }

    private void validate(UocOrdImportdealCombReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8888", "\u5bfc\u5165\u4e0b\u5355\u670d\u52a1\u8c03\u7528[reqBO]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getSuccesSet())) {
            throw new BusinessException("8888", "\u5bfc\u5165\u4e0b\u5355\u670d\u52a1\u8c03\u7528[UocOrdImportDataBOs]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private EnterpriseAccountBO qryOrgEffAccount(EnterpriseAccountBO enterpriseAccountBO) {
        QryOrgEffAccountReqBO qryOrgEffAccountReqBO = new QryOrgEffAccountReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(enterpriseAccountBO.getDeliveryCenterId());
        log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)qryOrgEffAccountReqBO));
        QryOrgEffAccountRspBO rspBO = this.pebIntfQryOrgEffAccountAbilityService.qryOrgEffAccount(qryOrgEffAccountReqBO);
        log.debug("\u67e5\u8be2\u5e73\u53f0\u5546\u4fe1\u606f\u8c03\u7528" + JSON.toJSONString((Object)rspBO));
        if (CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            return null;
        }
        return (EnterpriseAccountBO)rspBO.getRows().get(0);
    }
}

