/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.intfce.sku.impl;

import com.cgd.commodity.busi.bo.CatalogInfo;
import com.cgd.commodity.busi.bo.catalog.BusiQryCommodityCatalogRspBO;
import com.cgd.commodity.busi.bo.catalog.QryOthLevelCommodityCatalogRspBO;
import com.cgd.commodity.dao.CommodityGuideCatalogMapper;
import com.ohaotian.commodity.common.exception.ResourceException;
import com.ohaotian.plugin.base.bo.RspPageBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.busi.sku.bo.HotSearchCommodityReqBO;
import com.xls.commodity.busi.sku.bo.HotSearchTypeReqBO;
import com.xls.commodity.dao.HotSearchCommodityDAO;
import com.xls.commodity.dao.HotSearchTypeDAO;
import com.xls.commodity.dao.po.HotSearchCommodityPO;
import com.xls.commodity.dao.po.HotSearchTypePO;
import com.xls.commodity.intfce.sku.HotSearchService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class HotSearchServiceImpl
implements HotSearchService {
    private static final Logger logger = LoggerFactory.getLogger(HotSearchServiceImpl.class);
    @Autowired
    HotSearchTypeDAO hotSearchTypeDAO;
    @Autowired
    HotSearchCommodityDAO hotSearchCommodityDAO;
    @Autowired
    private CommodityGuideCatalogMapper commodityGuideCatalogMapper;

    public BaseRspBO addHotSearchType(HotSearchTypeReqBO reqBO) {
        logger.info("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getCommodityTypeId() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5546\u54c1\u7c7b\u578bId\u4e3a\u7a7a");
            return result;
        }
        if (reqBO.getHotValue() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchTypePO po = this.typeReqBoToPO(reqBO);
            this.hotSearchTypeDAO.insertSelective(po);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u65b0\u589e\u70ed\u641c\u5206\u7c7b\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    private HotSearchTypePO typeReqBoToPO(HotSearchTypeReqBO bo) {
        HotSearchTypePO po = new HotSearchTypePO();
        po.setCommodityTypeId(bo.getCommodityTypeId());
        po.setHotSearchTypeId(bo.getHotSearchTypeId());
        po.setHotValue(bo.getHotValue());
        return po;
    }

    private HotSearchCommodityPO commodityReqBoToPO(HotSearchCommodityReqBO bo) {
        HotSearchCommodityPO po = new HotSearchCommodityPO();
        po.setCommodityId(bo.getCommodityId());
        po.setCommodityTypeId(bo.getCommodityTypeId());
        po.setHotSearchCommodityId(bo.getHotSearchCommodityId());
        po.setHotValue(bo.getHotValue());
        po.setSkuId(bo.getSkuId());
        return po;
    }

    public BaseRspBO addHotSearchCommodity(HotSearchCommodityReqBO reqBO) {
        logger.info("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getCommodityId() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5546\u54c1Id\u4e3a\u7a7a");
            return result;
        }
        if (reqBO.getSkuId() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5355\u54c1Id\u4e3a\u7a7a");
            return result;
        }
        if (reqBO.getCommodityTypeId() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u5546\u54c1\u5206\u7c7bId\u4e3a\u7a7a");
            return result;
        }
        if (reqBO.getHotValue() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchCommodityPO po = this.commodityReqBoToPO(reqBO);
            this.hotSearchCommodityDAO.insertSelective(po);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u65b0\u589e\u70ed\u641c\u5546\u54c1\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    public BaseRspBO editHotSearchCommodity(HotSearchCommodityReqBO reqBO) {
        logger.info("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getHotSearchCommodityId() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u641c\u5546\u54c1Id\u4e3a\u7a7a");
            return result;
        }
        if (reqBO.getHotValue() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchCommodityPO po = this.commodityReqBoToPO(reqBO);
            this.hotSearchCommodityDAO.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u7f16\u8f91\u70ed\u641c\u5546\u54c1\u70ed\u5ea6\u503c\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    public BaseRspBO editHotSearchType(HotSearchTypeReqBO reqBO) {
        logger.info("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u5165\u53c2\uff1a" + reqBO.toString());
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getHotSearchTypeId() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u641c\u5206\u7c7bId\u4e3a\u7a7a");
            return result;
        }
        if (reqBO.getHotValue() == null) {
            result.setRespCode("7777");
            result.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\u70ed\u5ea6\u503c\u4e3a\u7a7a");
            return result;
        }
        try {
            HotSearchTypePO po = this.typeReqBoToPO(reqBO);
            this.hotSearchTypeDAO.updateByPrimaryKeySelective(po);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u51fa\u9519\uff1a", (Throwable)e);
            throw new ResourceException("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u51fa\u9519", e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        logger.info("\u7f16\u8f91\u70ed\u641c\u5206\u7c7b\u70ed\u5ea6\u503c\u51fa\u53c2\uff1a" + result.toString());
        return result;
    }

    public RspPageBO<QryOthLevelCommodityCatalogRspBO> queryHotSearchType() {
        logger.error("\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u5f00\u59cb");
        RspPageBO rsp = new RspPageBO();
        try {
            RspPageBO value = new RspPageBO();
            HotSearchTypePO poReq = new HotSearchTypePO();
            poReq.setOrderByStr("hot_value desc");
            List<HotSearchTypePO> poList = this.hotSearchTypeDAO.selectByRecord(poReq);
            ArrayList<Long> typeIdList = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty(poList)) {
                for (HotSearchTypePO hotSearchTypePO : poList) {
                    typeIdList.add(hotSearchTypePO.getCommodityTypeId());
                }
            }
            List catalogInfos = this.commodityGuideCatalogMapper.selectByCatalogIdList(typeIdList);
            logger.info("\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u6570\u636e\u5e93\u8fd4\u56de\uff1a{}", (Object)catalogInfos);
            ArrayList<BusiQryCommodityCatalogRspBO> commodityCatalogRspBOS = new ArrayList<BusiQryCommodityCatalogRspBO>();
            for (CatalogInfo catalogInfo : catalogInfos) {
                BusiQryCommodityCatalogRspBO busiQryCommodityCatalogRspBO = new BusiQryCommodityCatalogRspBO();
                BeanUtils.copyProperties((Object)catalogInfo, (Object)busiQryCommodityCatalogRspBO);
                commodityCatalogRspBOS.add(busiQryCommodityCatalogRspBO);
            }
            ArrayList<QryOthLevelCommodityCatalogRspBO> qryOthLevelCommodityCatalogRspBOS = new ArrayList<QryOthLevelCommodityCatalogRspBO>();
            QryOthLevelCommodityCatalogRspBO qryOthLevelCommodityCatalogRspBO = new QryOthLevelCommodityCatalogRspBO();
            qryOthLevelCommodityCatalogRspBO.setRows(commodityCatalogRspBOS);
            qryOthLevelCommodityCatalogRspBOS.add(qryOthLevelCommodityCatalogRspBO);
            value.setRows(qryOthLevelCommodityCatalogRspBOS);
            logger.info("\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)value);
            rsp = value;
        }
        catch (Exception e) {
            logger.error(" \u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u51fa\u9519" + e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u70ed\u641c\u5206\u7c7b\u7c7b\u76ee\u4fe1\u606f\u51fa\u9519");
        }
        return rsp;
    }
}

