/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.intfce.sku.impl;

import com.ohaotian.base.common.exception.BusinessException;
import com.ohaotian.commodity.busi.sku.bo.QuerySkuDetailReqBO;
import com.ohaotian.plugin.db.Page;
import com.tydic.umc.ability.UmcMemDetailQueryAbilityService;
import com.tydic.umc.ability.bo.UmcMemDetailInfoAbilityBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemDetailQueryAbilityRspBO;
import com.xls.commodity.dao.CommodityAppraisesDAO;
import com.xls.commodity.dao.po.CommodityAppraisesPO;
import com.xls.commodity.intfce.sku.QryAppraisesService;
import com.xls.commodity.intfce.sku.bo.ChildEvaluationBO;
import com.xls.commodity.intfce.sku.bo.EvaluationBO;
import com.xls.commodity.intfce.sku.bo.MemDetailInfoBO;
import com.xls.commodity.intfce.sku.bo.QryAppraisesReqBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import com.xls.commodity.intfce.sku.impl.CreateAppraisesServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QryAppraisesServiceImpl
implements QryAppraisesService {
    private static final Logger logger = LoggerFactory.getLogger(CreateAppraisesServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private CommodityAppraisesDAO commodityAppraisesDAO;
    @Autowired
    private UmcMemDetailQueryAbilityService umcMemDetailQueryAbilityService;

    public RspPageBO<EvaluationBO> qryAppraises(QryAppraisesReqBO qryAppraisesReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)qryAppraisesReqBO.toString());
        }
        RspPageBO result = new RspPageBO();
        try {
            if (qryAppraisesReqBO.getCommodityId() == null && qryAppraisesReqBO.getSkuId() == null) {
                result.setRespCode("8888");
                result.setRespDesc("\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
                logger.error("commodityId\u548cskuId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            } else if (qryAppraisesReqBO.getSupplierShopId() == null) {
                result.setRespCode("8888");
                result.setRespDesc("\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
                logger.error("QryAppraisesService\u5fc5\u586b\u5165\u53c2\u4e3a\u7a7a");
            } else {
                Page page = new Page();
                page.setLimit(qryAppraisesReqBO.getLimit());
                page.setOffset(qryAppraisesReqBO.getOffset());
                CommodityAppraisesPO commodityAppraisesPO = new CommodityAppraisesPO();
                commodityAppraisesPO.setSupplierShopId(qryAppraisesReqBO.getSupplierShopId());
                if (qryAppraisesReqBO.getCommodityId() != null) {
                    commodityAppraisesPO.setCommodityId(qryAppraisesReqBO.getCommodityId());
                } else {
                    commodityAppraisesPO.setSkuId(qryAppraisesReqBO.getSkuId());
                }
                List<CommodityAppraisesPO> parentAppraises = this.commodityAppraisesDAO.selectParentAppraises(commodityAppraisesPO, (Page<CommodityAppraisesPO>)page);
                ArrayList<EvaluationBO> evaluationBOs = new ArrayList<EvaluationBO>();
                for (CommodityAppraisesPO commodityAppraisesPOParent : parentAppraises) {
                    EvaluationBO evaluationBO = new EvaluationBO();
                    List<CommodityAppraisesPO> ChildAppraises = this.commodityAppraisesDAO.selectChildAppraises(commodityAppraisesPOParent.getAppraiseId());
                    ArrayList<ChildEvaluationBO> childEvaluationBOs = new ArrayList<ChildEvaluationBO>();
                    for (CommodityAppraisesPO commodityAppraisesPOChild : ChildAppraises) {
                        ChildEvaluationBO childEvaluationBO = new ChildEvaluationBO();
                        childEvaluationBO.setChildTimeAppraise(commodityAppraisesPOChild.getTimeAppraise());
                        childEvaluationBO.setChildContentScore(commodityAppraisesPOChild.getContentScore());
                        String childImageScores = commodityAppraisesPOChild.getImageScore();
                        if (StringUtils.isNotEmpty((CharSequence)childImageScores)) {
                            childEvaluationBO.setChildImageScores(this.stringtoList(childImageScores));
                        }
                        childEvaluationBOs.add(childEvaluationBO);
                    }
                    evaluationBO.setAppraiseId(commodityAppraisesPOParent.getAppraiseId());
                    evaluationBO.setCommodityId(commodityAppraisesPOParent.getCommodityId());
                    evaluationBO.setSkuId(commodityAppraisesPOParent.getSkuId());
                    UmcMemDetailQueryAbilityReqBO umcMemDetailQueryAbilityReqBO = new UmcMemDetailQueryAbilityReqBO();
                    umcMemDetailQueryAbilityReqBO.setMemId(commodityAppraisesPOParent.getMemId());
                    UmcMemDetailQueryAbilityRspBO umcMemDetailQueryAbilityRspBO = this.umcMemDetailQueryAbilityService.memDetailQuery(umcMemDetailQueryAbilityReqBO);
                    UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityBO = umcMemDetailQueryAbilityRspBO.getUmcMemDetailInfoAbilityRspBO();
                    MemDetailInfoBO memDetailInfoBO = this.UmcMemDetailInfoAbilityBOtomemDetailInfoBO(umcMemDetailInfoAbilityBO);
                    evaluationBO.setMemDetailInfoBO(memDetailInfoBO);
                    evaluationBO.setCommodityScore(commodityAppraisesPOParent.getCommodityScore());
                    evaluationBO.setTimeAppraise(commodityAppraisesPOParent.getTimeAppraise());
                    evaluationBO.setContentScore(commodityAppraisesPOParent.getContentScore());
                    String imageScores = commodityAppraisesPOParent.getImageScore();
                    if (StringUtils.isNotEmpty((CharSequence)imageScores)) {
                        evaluationBO.setImageScores(this.stringtoList(imageScores));
                    }
                    evaluationBO.setReplyContent(commodityAppraisesPOParent.getReplyContent());
                    evaluationBO.setReplyTime(commodityAppraisesPOParent.getReplyTime());
                    evaluationBO.setChildEvaluations(childEvaluationBOs);
                    evaluationBOs.add(evaluationBO);
                }
                result.setRespCode("0000");
                result.setRespDesc("\u6210\u529f");
                QuerySkuDetailReqBO querySkuDetailReqBO = new QuerySkuDetailReqBO();
                querySkuDetailReqBO.setSkuId(qryAppraisesReqBO.getSkuId());
                querySkuDetailReqBO.setSupplierId(qryAppraisesReqBO.getSupplierShopId());
                result.setRows(evaluationBOs);
                result.setTotal(page.getTotalPages());
                result.setRecordsTotal(page.getTotalCount());
            }
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u9519\u8bef" + e);
            result.setRespCode("8888");
            result.setRespDesc("\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5546\u54c1\u8bc4\u4ef7\u67e5\u8be2\u670d\u52a1\u9519\u8bef");
        }
        return result;
    }

    public List<String> stringtoList(String strs) {
        String[] arrStrs = strs.split(";");
        ArrayList<String> listStrings = new ArrayList<String>();
        String[] stringArray = arrStrs;
        int n = arrStrs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            listStrings.add(str);
            ++n2;
        }
        return listStrings;
    }

    public MemDetailInfoBO UmcMemDetailInfoAbilityBOtomemDetailInfoBO(UmcMemDetailInfoAbilityBO umcMemDetailInfoAbilityBO) {
        MemDetailInfoBO memDetailInfoBO = new MemDetailInfoBO();
        memDetailInfoBO.setHeadUrl(umcMemDetailInfoAbilityBO.getHeadUrl());
        memDetailInfoBO.setIsPlus(umcMemDetailInfoAbilityBO.getIsPlus());
        memDetailInfoBO.setMemId(umcMemDetailInfoAbilityBO.getMemId());
        memDetailInfoBO.setMemLevel(umcMemDetailInfoAbilityBO.getMemLevel());
        memDetailInfoBO.setMemName1(umcMemDetailInfoAbilityBO.getMemName1());
        memDetailInfoBO.setMemName2(umcMemDetailInfoAbilityBO.getMemName2());
        memDetailInfoBO.setMemNickName(umcMemDetailInfoAbilityBO.getMemNickName());
        memDetailInfoBO.setMemType(umcMemDetailInfoAbilityBO.getMemType());
        memDetailInfoBO.setRegAccount(umcMemDetailInfoAbilityBO.getRegAccount());
        memDetailInfoBO.setSex(umcMemDetailInfoAbilityBO.getSex());
        memDetailInfoBO.setState(umcMemDetailInfoAbilityBO.getState());
        return memDetailInfoBO;
    }
}

