/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.syncInfo.impl;

import com.cgd.commodity.dao.SkuPriceMapper;
import com.cgd.commodity.po.SkuPrice;
import com.ohaotian.plugin.base.bo.RspBusiBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.syncInfo.UpdateSkuPriceService;
import com.xls.commodity.syncInfo.bo.JgInfoReqBO;
import com.xls.commodity.syncInfo.bo.UpdateSkuPriceReqBO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="updateSkuPriceService")
public class UpdateSkuPriceServiceImpl
implements UpdateSkuPriceService {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSkuPriceServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public RspBusiBaseBO updateSkuPrice(UpdateSkuPriceReqBO updateSkuPriceReqBO) {
        RspBusiBaseBO rspBO = new RspBusiBaseBO();
        logger.error("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65start");
        List objList = updateSkuPriceReqBO.getJgInfo();
        for (JgInfoReqBO jg : objList) {
            logger.error("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5217\u8868\u5165\u53c2\uff1a{}", (Object)jg.toString());
            String mdID = jg.getMdID();
            String zjm = jg.getZjm();
            String scmID = jg.getScmID();
            String jgl = jg.getJgl();
            String vipPrice = jg.getVipPrice();
            try {
                Sku sku = new Sku();
                Long supplierId = null;
                String materialId = null;
                String extSkuId = null;
                if (StringUtils.isNotEmpty((String)mdID)) {
                    sku.setSupplierId(Long.valueOf(mdID));
                    supplierId = Long.valueOf(mdID);
                }
                if (StringUtils.isNotEmpty((String)zjm)) {
                    sku.setExtSkuId(zjm);
                    extSkuId = zjm;
                }
                if (StringUtils.isNotEmpty((String)scmID)) {
                    sku.setMaterialId(scmID);
                    materialId = scmID;
                }
                logger.error("\u5165\u53c2\u5355\u54c1\u4fe1\u606f: {}", (Object)sku.toString());
                Sku skuPO = this.xlsSkuMapper.selectBySupplierIdAndOther(supplierId, materialId, extSkuId);
                logger.error("\u5355\u54c1\u4fe1\u606f: {}", (Object)skuPO.toString());
                if (skuPO == null || skuPO.getSkuId() == null || !StringUtils.isNotEmpty((String)jgl)) continue;
                SkuPrice skuPrice = new SkuPrice();
                skuPrice.setSkuId(skuPO.getSkuId());
                skuPrice.setSupplierId(skuPO.getSupplierId());
                skuPrice.setUpdateTime(new Date());
                if (StringUtils.isNotEmpty((String)vipPrice) && vipPrice != "0") {
                    BigDecimal memberPrice = new BigDecimal(vipPrice);
                    skuPrice.setMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)memberPrice));
                }
                BigDecimal price = new BigDecimal(jgl);
                skuPrice.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)price));
                this.skuPriceMapper.updateBySkuIdKey(skuPrice);
            }
            catch (Exception e) {
                logger.error("****\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25\u3002" + e.getMessage());
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u5931\u8d25");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65b0\u96f6\u552e\u5546\u54c1\u4ef7\u683c\u540c\u6b65\u5931\u8d25");
            }
        }
        logger.info("*********\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65end");
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u540c\u6b65\u6210\u529f");
        return rspBO;
    }

    public void setXlsSkuMapper(XlsSkuMapper xlsSkuMapper) {
        this.xlsSkuMapper = xlsSkuMapper;
    }
}

