/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.xls.commodity.atom.sku.DMaterialDefineManageService;
import com.xls.commodity.busi.sku.bo.DMaterialDefineBO;
import com.xls.commodity.dao.MaterialDefineDAO;
import com.xls.commodity.dao.po.MaterialDefinePO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DMaterialDefineManageServiceImpl
implements DMaterialDefineManageService {
    @Autowired
    private MaterialDefineDAO materialDefineDAO;
    private static final Logger logger = LoggerFactory.getLogger(DMaterialDefineManageServiceImpl.class);

    public BaseRspBO insertMaterialDefineRecords(List<DMaterialDefineBO> dMaterialDefineBOS) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (CollectionUtils.isEmpty(dMaterialDefineBOS)) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u539f\u5b50\u670d\u52a1\u63d2\u5165\u6570\u7ec4\u4e3a\u7a7a");
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc("\u6210\u529f");
            return baseRspBO;
        }
        ArrayList<MaterialDefinePO> materialPOS = new ArrayList<MaterialDefinePO>();
        Date now = new Date();
        for (DMaterialDefineBO dmaterialBO : dMaterialDefineBOS) {
            MaterialDefinePO materialPO = new MaterialDefinePO();
            BeanUtils.copyProperties((Object)dmaterialBO, (Object)materialPO);
            materialPO.setUpdateTime(now);
            materialPO.setCreateTime(now);
            if (!StringUtils.isNotBlank((CharSequence)materialPO.getDataName())) continue;
            materialPOS.add(materialPO);
        }
        try {
            this.materialDefineDAO.insertMaterialDefineBatch(materialPOS);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3--\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u63d2\u5165\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public RspInfoListBO<DMaterialDefineBO> selectMaterialDefineByBatch(DMaterialDefineBO reqBo) {
        RspInfoListBO baseRspBO = new RspInfoListBO();
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        ArrayList<DMaterialDefineBO> rows = new ArrayList<DMaterialDefineBO>();
        MaterialDefinePO po = new MaterialDefinePO();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        try {
            List<MaterialDefinePO> poList = this.materialDefineDAO.selectByBatch(po);
            if (CollectionUtils.isEmpty(poList)) {
                logger.info("\u5546\u54c1\u4e2d\u5fc3-\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u539f\u5b50\u67e5\u8be2\u670d\u52a1\u7ed3\u679c\u96c6\u4e3a\u7a7a");
                return baseRspBO;
            }
            for (MaterialDefinePO po1 : poList) {
                DMaterialDefineBO bo = new DMaterialDefineBO();
                BeanUtils.copyProperties((Object)po1, (Object)bo);
                rows.add(bo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3--\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRows(rows);
        return baseRspBO;
    }

    public BaseRspBO deleteMaterialDefineByDataType(DMaterialDefineBO reqBo) {
        BaseRspBO baseRspBO = new BaseRspBO();
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        if (StringUtils.isBlank((CharSequence)reqBo.getDataType())) {
            return baseRspBO;
        }
        try {
            int n = this.materialDefineDAO.deleteByDataType(reqBo.getDataType());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3--\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u5220\u9664\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        return baseRspBO;
    }
}

