/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.DPriceSheetManageService;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.bo.DPriceSheetBO;
import com.xls.commodity.busi.sku.bo.QueryDPriceSheetReqBO;
import com.xls.commodity.dao.PriceSheetDAO;
import com.xls.commodity.dao.po.PriceSheetPO;
import com.xls.commodity.dao.po.PriceSheetReqPO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DPriceSheetManageServiceImpl
implements DPriceSheetManageService {
    @Autowired
    private PriceSheetDAO priceSheetDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    private static final Logger logger = LoggerFactory.getLogger(DPriceSheetManageServiceImpl.class);

    public RspPageBO<DPriceSheetBO> selectPriceSheetPOBySelective(QueryDPriceSheetReqBO reqBO) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO));
        RspPageBO rspInfoListBO = new RspPageBO();
        rspInfoListBO.setRespCode("0000");
        rspInfoListBO.setRespDesc("\u6210\u529f");
        ArrayList<DPriceSheetBO> rows = new ArrayList<DPriceSheetBO>();
        PriceSheetReqPO po = new PriceSheetReqPO();
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSheetLevel())) {
            reqBO.setNotSheetLevel(null);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getNotSheetLevel())) {
            reqBO.setSheetLevel(null);
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setOrgRange(reqBO.getOrgName());
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        try {
            List<PriceSheetPO> priceSheetPOS = this.priceSheetDAO.selectBySelective(po, (Page<PriceSheetPO>)page);
            if (CollectionUtils.isNotEmpty(priceSheetPOS)) {
                Map<String, String> levelMap = this.sysParamsAtomService.selectByParentCode("SHEET_LEVEL_STR");
                Map<String, String> statusMap = this.sysParamsAtomService.selectByParentCode("PRICE_CHECK_STATUS");
                for (PriceSheetPO po1 : priceSheetPOS) {
                    DPriceSheetBO bo = new DPriceSheetBO();
                    BeanUtils.copyProperties((Object)po1, (Object)bo);
                    if (statusMap.containsKey(bo.getCheckStatus())) {
                        bo.setCheckStatusStr(statusMap.get(bo.getCheckStatus()));
                    }
                    if (levelMap.containsKey(bo.getSheetLevel())) {
                        bo.setSheetLevelStr(levelMap.get(bo.getSheetLevel()));
                    }
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        rspInfoListBO.setTotal(page.getTotalPages());
        rspInfoListBO.setRecordsTotal(page.getTotalCount());
        rspInfoListBO.setRows(rows);
        return rspInfoListBO;
    }
}

