/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.fastjson.JSONObject;
import com.xls.commodity.atom.sku.DPriceSheetOrgManageService;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.bo.PriceSheetOrgBO;
import com.xls.commodity.busi.sku.bo.PriceSheetOrgResBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.PriceSheetOrgDAO;
import com.xls.commodity.dao.po.PriceSheetOrgPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DPriceSheetOrgManageServiceImpl
implements DPriceSheetOrgManageService {
    @Autowired
    private PriceSheetOrgDAO priceSheetOrgDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    private static final Logger logger = LoggerFactory.getLogger(DPriceSheetOrgManageServiceImpl.class);

    public RspInfoListBO<PriceSheetOrgBO> selectSheetOrgBySheetId(Long sheetId) {
        RspInfoListBO baseRspBO = new RspInfoListBO();
        if (sheetId == null) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return baseRspBO;
        }
        ArrayList<PriceSheetOrgBO> rows = new ArrayList<PriceSheetOrgBO>();
        try {
            List<PriceSheetOrgPO> itemPOList = this.priceSheetOrgDAO.selectBySheetId(sheetId);
            if (CollectionUtils.isNotEmpty(itemPOList)) {
                for (PriceSheetOrgPO po : itemPOList) {
                    PriceSheetOrgBO bo = new PriceSheetOrgBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRows(rows);
        return baseRspBO;
    }

    public BaseRspBO deleteSheetOrgBySheetId(Long sheetId) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (sheetId == null) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u5220\u9664\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return baseRspBO;
        }
        try {
            this.priceSheetOrgDAO.deleteBySheetId(sheetId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u5220\u9664\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO insertSheetOrgBatch(List<PriceSheetOrgBO> reqList) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (CollectionUtils.isEmpty(reqList)) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u65b0\u589e\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return baseRspBO;
        }
        ArrayList<PriceSheetOrgPO> list = new ArrayList<PriceSheetOrgPO>();
        for (PriceSheetOrgBO bo : reqList) {
            PriceSheetOrgPO po = new PriceSheetOrgPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCreateTime(new Date());
            list.add(po);
        }
        try {
            this.priceSheetOrgDAO.insertList(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public PriceSheetOrgResBO select(PriceSheetOrgBO reqBO) {
        PriceSheetOrgResBO result = new PriceSheetOrgResBO();
        logger.debug("\u62a5\u4ef7\u9002\u7528\u516c\u53f8\u6279\u91cf\u67e5\u8be2\uff1a" + JSONObject.toJSONString((Object)reqBO));
        PriceSheetOrgPO record = new PriceSheetOrgPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        ArrayList<PriceSheetOrgBO> rows = new ArrayList<PriceSheetOrgBO>();
        Map<String, Map<String, String>> escaMap = this.getEscape();
        try {
            List<PriceSheetOrgPO> poList = this.priceSheetOrgDAO.selectByMany(record);
            if (!CollectionUtils.isEmpty(poList)) {
                PriceSheetOrgBO bo = null;
                for (PriceSheetOrgPO po : poList) {
                    bo = new PriceSheetOrgBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setOrgLevelStr(escaMap.get("ORG_LEVEL_STR").get(po.getOrgLevel()));
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u62a5\u4ef7\u9002\u7528\u516c\u53f8\u6279\u91cf\u67e5\u8be2\u51fa\u9519" + e.getMessage());
        }
        result.setRows(rows);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }
}

