/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.xls.commodity.atom.sku.SkuFodderManageService;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.dao.SkuFodderDAO;
import com.xls.commodity.dao.po.SkuFodderPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.SkuFodderBO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkuFodderManageServiceImpl
implements SkuFodderManageService {
    @Autowired
    private SkuFodderDAO skuFodderDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    private static final Logger logger = LoggerFactory.getLogger(SkuFodderManageServiceImpl.class);

    public List<SkuFodderBO> selectSkuFodderByCommodityId(Long commodityId) {
        ArrayList<SkuFodderBO> skuFodderBOs = new ArrayList<SkuFodderBO>();
        List<SkuFodderPO> skuFodderPOs = null;
        try {
            skuFodderPOs = this.skuFodderDAO.selectByCommodityId(commodityId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u7d20\u6750\u5217\u8868\u51fa\u9519" + e.getMessage());
        }
        Map<String, String> mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_STATUS");
        if (CollectionUtils.isNotEmpty(skuFodderPOs)) {
            for (SkuFodderPO skuFodderPO : skuFodderPOs) {
                SkuFodderBO skuFodderBO = new SkuFodderBO();
                BeanUtils.copyProperties((Object)skuFodderPO, (Object)skuFodderBO);
                skuFodderBO.setFodderStatusName(mapSysCommodityStatus.get(skuFodderBO.getFodderStatus().toString()));
                skuFodderBOs.add(skuFodderBO);
            }
        }
        return skuFodderBOs;
    }

    public BaseRspBO insertSkuFodder(SkuFodderBO skuFodderBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        SkuFodderPO skuFodderPO = new SkuFodderPO();
        BeanUtils.copyProperties((Object)skuFodderBO, (Object)skuFodderPO);
        try {
            this.skuFodderDAO.insertSelective(skuFodderPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u5165\u5e93\u7d20\u6750\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO updateSkuFodder(SkuFodderBO skuFodderBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        SkuFodderPO skuFodderPO = new SkuFodderPO();
        BeanUtils.copyProperties((Object)skuFodderBO, (Object)skuFodderPO);
        try {
            this.skuFodderDAO.updateByPrimaryKeySelective(skuFodderPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u4fee\u6539\u7d20\u6750\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO deleteSkuFodder(Long fodderId) {
        BaseRspBO baseRspBO = new BaseRspBO();
        try {
            this.skuFodderDAO.deleteByPrimaryKey(fodderId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u5220\u9664\u7d20\u6750\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

