/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.SysParamsDAO;
import com.xls.commodity.dao.po.SysParamsPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysParamsAtomServiceImpl
implements SysParamsAtomService {
    private static final Logger log = LoggerFactory.getLogger(SysParamsAtomServiceImpl.class);
    @Autowired
    private SysParamsDAO sysParamsDAO;

    @Override
    public Map<String, String> selectByParentCode(String parentCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<SysParamsPO> list = null;
        try {
            list = this.sysParamsDAO.selectByParentCode(parentCode);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u51fa\u9519" + e);
            return map;
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (SysParamsPO po : list) {
                map.put(po.getCode(), po.getCodeTitle());
            }
        }
        return map;
    }

    @Override
    public List<SysParamTransBusiBO> selectAll() {
        ArrayList<SysParamTransBusiBO> result = new ArrayList<SysParamTransBusiBO>();
        List<SysParamsPO> list = null;
        try {
            list = this.sysParamsDAO.selectAll();
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u7801\u8868\u51fa\u9519" + e.getMessage());
        }
        if (null != list && list.size() > 0) {
            for (SysParamsPO sysParamsPO : list) {
                result.add(this.toSysParamTransBusiBO(sysParamsPO));
            }
        }
        return result;
    }

    private SysParamTransBusiBO toSysParamTransBusiBO(SysParamsPO po) {
        SysParamTransBusiBO bo = new SysParamTransBusiBO();
        bo.setParentCode(po.getParentCode());
        bo.setCode(po.getCode());
        bo.setCodeTitle(po.getCodeTitle());
        return bo;
    }
}

