/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.cgd.commodity.constant.Constant;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.busi.sku.constant.SkuConstant;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XlsSkuManageServiceImpl
implements XlsSkuManageService {
    private static final Logger logger = LoggerFactory.getLogger(XlsSkuManageServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private SkuSpecMapper skuSpecMapper;

    public BaseRspBO batchUpdate(List<SkuBO> skuBOS) {
        logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skuBOS.size());
        BaseRspBO baseRspBO = new BaseRspBO();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Sku> skus = new ArrayList<Sku>();
        ArrayList<SpecBO> specBOList = new ArrayList<SpecBO>();
        if (CollectionUtils.isNotEmpty(skuBOS)) {
            for (SkuBO skuBO : skuBOS) {
                skuIds.add(skuBO.getSkuId());
                Sku sku = new Sku();
                BeanUtils.copyProperties((Object)skuBO, (Object)sku);
                sku.setCountyCode(skuBO.getCountyCode());
                sku.setUpdateTime(new Date());
                skus.add(sku);
                SpecBO pp = new SpecBO();
                long skuIdpp = Sequence.getInstance().nextId();
                pp.setSkuSpecId(Long.valueOf(skuIdpp));
                pp.setSkuId(skuBO.getSkuId());
                pp.setSupplierId(skuBO.getSupplierId());
                pp.setCommodityPropGrpId(SkuConstant.SKU_SPEC_PP);
                pp.setPropName("\u54c1\u724c");
                pp.setPropShowName("\u54c1\u724c");
                pp.setPropValue(skuBO.getBrand());
                pp.setCreateTime(new Date());
                pp.setIsDelete(Constant.IS_DELETE);
                SpecBO xh = new SpecBO();
                long skuIdxh = Sequence.getInstance().nextId();
                xh.setSkuSpecId(Long.valueOf(skuIdxh));
                xh.setSkuId(skuBO.getSkuId());
                xh.setSupplierId(skuBO.getSupplierId());
                xh.setCommodityPropGrpId(SkuConstant.SKU_SPEC_XH);
                xh.setPropName("\u578b\u53f7");
                xh.setPropShowName("\u578b\u53f7");
                xh.setPropValue(skuBO.getModel());
                xh.setCreateTime(new Date());
                xh.setIsDelete(Constant.IS_DELETE);
                SpecBO ys = new SpecBO();
                long skuIdys = Sequence.getInstance().nextId();
                ys.setSkuSpecId(Long.valueOf(skuIdys));
                ys.setSkuId(skuBO.getSkuId());
                ys.setSupplierId(skuBO.getSupplierId());
                ys.setCommodityPropGrpId(SkuConstant.SKU_SPEC_YS);
                ys.setPropName("\u989c\u8272");
                ys.setPropShowName("\u989c\u8272");
                ys.setPropValue(skuBO.getColor());
                ys.setCreateTime(new Date());
                ys.setIsDelete(Constant.IS_DELETE);
                SpecBO nc = new SpecBO();
                long skuIdnc = Sequence.getInstance().nextId();
                nc.setSkuSpecId(Long.valueOf(skuIdnc));
                nc.setSkuId(skuBO.getSkuId());
                nc.setSupplierId(skuBO.getSupplierId());
                nc.setCommodityPropGrpId(SkuConstant.SKU_SPEC_NC);
                nc.setPropName("\u5185\u5b58");
                nc.setPropShowName("\u5185\u5b58");
                nc.setPropValue(skuBO.getRam());
                nc.setCreateTime(new Date());
                nc.setIsDelete(Constant.IS_DELETE);
                specBOList.add(pp);
                specBOList.add(xh);
                specBOList.add(ys);
                specBOList.add(nc);
            }
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            try {
                logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skus.size());
                this.xlsSkuMapper.batchUpdateBySkuId(skus);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            try {
                this.skuSpecMapper.delBySkuIdListAll(skuIds);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u5220\u9664\u5355\u54c1\u89c4\u683c\u5f02\u5e38", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(specBOList)) {
            try {
                this.initSkuSpecAtomService.initSkuSpec(specBOList);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u521b\u5efa\u5355\u54c1\u89c4\u683c\u5f02\u5e38", (Throwable)e);
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO batchNewUpdate(List<SkuBO> skuBOS) {
        logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skuBOS.size());
        BaseRspBO baseRspBO = new BaseRspBO();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Sku> skus = new ArrayList<Sku>();
        ArrayList<SpecBO> specBOList = new ArrayList<SpecBO>();
        if (CollectionUtils.isNotEmpty(skuBOS)) {
            for (SkuBO skuBO : skuBOS) {
                skuIds.add(skuBO.getSkuId());
                Sku sku = new Sku();
                BeanUtils.copyProperties((Object)skuBO, (Object)sku);
                sku.setCountyCode(skuBO.getCountyCode());
                sku.setUpdateTime(new Date());
                skus.add(sku);
                SpecBO pp = new SpecBO();
                long skuIdpp = Sequence.getInstance().nextId();
                pp.setSkuSpecId(Long.valueOf(skuIdpp));
                pp.setSkuId(skuBO.getSkuId());
                pp.setSupplierId(skuBO.getSupplierId());
                pp.setCommodityPropGrpId(SkuConstant.SKU_SPEC_PP);
                pp.setPropName("\u54c1\u724c");
                pp.setPropShowName("\u54c1\u724c");
                pp.setPropValue(skuBO.getBrand());
                pp.setCreateTime(new Date());
                pp.setIsDelete(Constant.IS_DELETE);
                SpecBO xh = new SpecBO();
                long skuIdxh = Sequence.getInstance().nextId();
                xh.setSkuSpecId(Long.valueOf(skuIdxh));
                xh.setSkuId(skuBO.getSkuId());
                xh.setSupplierId(skuBO.getSupplierId());
                xh.setCommodityPropGrpId(SkuConstant.SKU_SPEC_XH);
                xh.setPropName("\u578b\u53f7");
                xh.setPropShowName("\u578b\u53f7");
                xh.setPropValue(skuBO.getModel());
                xh.setCreateTime(new Date());
                xh.setIsDelete(Constant.IS_DELETE);
                SpecBO ys = new SpecBO();
                long skuIdys = Sequence.getInstance().nextId();
                ys.setSkuSpecId(Long.valueOf(skuIdys));
                ys.setSkuId(skuBO.getSkuId());
                ys.setSupplierId(skuBO.getSupplierId());
                ys.setCommodityPropGrpId(SkuConstant.SKU_SPEC_YS);
                ys.setPropName("\u989c\u8272");
                ys.setPropShowName("\u989c\u8272");
                ys.setPropValue(skuBO.getColor());
                ys.setCreateTime(new Date());
                ys.setIsDelete(Constant.IS_DELETE);
                SpecBO nc = new SpecBO();
                long skuIdnc = Sequence.getInstance().nextId();
                nc.setSkuSpecId(Long.valueOf(skuIdnc));
                nc.setSkuId(skuBO.getSkuId());
                nc.setSupplierId(skuBO.getSupplierId());
                nc.setCommodityPropGrpId(SkuConstant.SKU_SPEC_NC);
                nc.setPropName("\u5185\u5b58");
                nc.setPropShowName("\u5185\u5b58");
                nc.setPropValue(skuBO.getRam());
                nc.setCreateTime(new Date());
                nc.setIsDelete(Constant.IS_DELETE);
                specBOList.add(pp);
                specBOList.add(xh);
                specBOList.add(ys);
                specBOList.add(nc);
            }
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            try {
                logger.debug("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u5165\u53c2" + skus.size());
                this.xlsSkuMapper.batchUpdateByProvinceCodeMaterialId(skus);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u4fee\u6539\u5546\u54c1\u5f02\u5e38", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            try {
                this.skuSpecMapper.delBySkuIdListAll(skuIds);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u5220\u9664\u5355\u54c1\u89c4\u683c\u5f02\u5e38", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(specBOList)) {
            try {
                this.initSkuSpecAtomService.initSkuSpec(specBOList);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u6279\u91cf\u521b\u5efa\u5355\u54c1\u89c4\u683c\u5f02\u5e38", (Throwable)e);
            }
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

