/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.po.Brand;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.xls.commodity.atom.sku.DMaterialManageService;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.busi.sku.AddGoodsByProvCodeService;
import com.xls.commodity.busi.sku.AddProvGoodsListService;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.BrandManageService;
import com.xls.commodity.busi.sku.bo.AddProvGoodsListReqBO;
import com.xls.commodity.busi.sku.bo.BatchCreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.BrandBO;
import com.xls.commodity.busi.sku.bo.CreateBrandReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.DPriceSheetBO;
import com.xls.commodity.busi.sku.bo.DmaterialBO;
import com.xls.commodity.busi.sku.bo.ProvAndCityCodeBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsBO;
import com.xls.commodity.busi.sku.bo.SupplierBO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.ProvGoodsAndSupplierPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.dao.po.ProvGoodsSupRelationPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.DPriceSheetService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.ProvinceMaterialBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import com.xls.commodity.util.TkHttpRequestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AddGoodsByProvCodeServiceImpl
implements AddGoodsByProvCodeService {
    private static final Logger logger = LoggerFactory.getLogger(AddGoodsByProvCodeServiceImpl.class);
    @Autowired
    private AddProvGoodsListService addProvGoodsListService;
    @Autowired
    private DMaterialManageService dMaterialManageService;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Value(value="${getProvience}")
    private String url;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private BrandManageService brandManageService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private DPriceSheetService dPriceSheetService;

    public BaseRspBO provCommodityCreation(AddProvGoodsListReqBO reqBO) {
        ProvGoodsBO backBO;
        BaseRspBO result = new BaseRspBO();
        HashMap<String, ProvGoodsBO> materialAndProvId = new HashMap<String, ProvGoodsBO>();
        logger.debug("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u7684\u6279\u91cf\u521b\u5efa\uff1a" + reqBO.getReqBO().size());
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqBO())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        for (ProvGoodsBO provGoodsBO : reqBO.getReqBO()) {
            Pattern pattern = Pattern.compile("[0-9]{1,}");
            Matcher matcher = pattern.matcher(provGoodsBO.getMaterialId());
            boolean b = matcher.matches();
            String substring = provGoodsBO.getMaterialId().substring(0, 2);
            if (b) {
                if (18 == provGoodsBO.getMaterialId().length() && "00".equals(substring)) continue;
                logger.debug("\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d");
                result.setRespDesc("\u7eaf\u6570\u5b57\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db318\u4f4d\u6216\u4e0d\u662f\u4ee500\u5f00\u5934" + provGoodsBO.getMaterialId());
                result.setRespCode("8888");
                return result;
            }
            if (16 == provGoodsBO.getMaterialId().length()) continue;
            logger.debug("\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d");
            result.setRespDesc("\u5e26\u82f1\u6587\u7684\u7269\u6599\u7f16\u7801\u957f\u5ea6\u4e0d\u8db316\u4f4d" + provGoodsBO.getMaterialId());
            result.setRespCode("8888");
            return result;
        }
        String back = this.check(reqBO);
        if (!StringUtils.isBlank((String)back)) {
            logger.debug("\u5165\u53c2\u4e0d\u5408\u6cd5\uff1a" + back);
            result.setRespCode("8888");
            result.setRespDesc(back);
            return result;
        }
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO goodsPo = null;
        HashMap<Long, ProvGoodsBO> supMap = new HashMap<Long, ProvGoodsBO>();
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            goodsPo = new ProvGoodsPO();
            if (bo.getProvGoodsId() == null) {
                bo.setProvGoodsId(Long.valueOf(Sequence.getInstance().nextId()));
            }
            if (!StringUtils.isBlank((String)bo.getMaterialId()) && "1".equals(reqBO.getAddType())) {
                ProvGoodsAndSupplierPO query = new ProvGoodsAndSupplierPO();
                query.setMaterialId(bo.getMaterialId());
                List<ProvGoodsAndSupplierPO> list = this.provGoodsDAO.selectByProvGroup(query);
                bo.setCgType(CollectionUtils.isEmpty(list) ? bo.getCgType() : list.get(0).getCgType());
            }
            bo.setReservedField3("601".equals(bo.getCgType()) ? "0" : "1");
            bo.setReservedField1("0");
            bo.setMaterialId(StringUtils.isBlank((String)bo.getMaterialId()) ? null : bo.getMaterialId().trim());
            goodsPo.setMaterialId(bo.getMaterialId());
            goodsPo.setProvinceCode(bo.getProvinceCode());
            record.add(goodsPo);
            if (supMap.containsKey(bo.getProvGoodsId())) continue;
            supMap.put(bo.getProvGoodsId(), bo);
        }
        List<Object> provGoods = new ArrayList();
        try {
            logger.debug("\u67e5\u5bfb\u540c\u6b65\u5546\u54c1\u662f\u5426\u5b58\u5728");
            provGoods = this.provGoodsDAO.selectByList(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        HashMap<String, ProvGoodsPO> provMap = new HashMap<String, ProvGoodsPO>();
        for (ProvGoodsPO provGoodsPO : provGoods) {
            if (provMap.containsKey(provGoodsPO.getProvinceCode() + provGoodsPO.getMaterialId())) continue;
            provMap.put(provGoodsPO.getProvinceCode() + provGoodsPO.getMaterialId(), provGoodsPO);
        }
        ArrayList<ProvGoodsBO> provInsert = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> arrayList = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> newTrailUpdate = new ArrayList<ProvGoodsBO>();
        ProvGoodsBO tempBO = null;
        if (CollectionUtils.isEmpty(provMap)) {
            for (ProvGoodsBO bo : reqBO.getReqBO()) {
                backBO = new ProvGoodsBO();
                backBO.setProvGoodsId(bo.getProvGoodsId());
                backBO.setGoodsSource(bo.getGoodsSource());
                materialAndProvId.put(bo.getMaterialId(), backBO);
                tempBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo, (Object)tempBO);
                tempBO.setCreateTime(new Date());
                tempBO.setIsValid("1");
                tempBO.setHasPrice("0");
                tempBO.setCreateUsername(bo.getCreateUser());
                tempBO.setGoodsName(bo.getGoodsLongName());
                tempBO.setCreateUser(bo.getCreateUser());
                tempBO.setUpdateUser(null);
                provInsert.add(tempBO);
            }
        } else {
            for (ProvGoodsBO bo : reqBO.getReqBO()) {
                if (provMap.get(bo.getProvinceCode() + bo.getMaterialId()) != null && ((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getGoodsSource().equals("01")) {
                    backBO = new ProvGoodsBO();
                    backBO.setProvGoodsId(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getProvGoodsId());
                    backBO.setGoodsSource(StringUtils.isBlank((String)bo.getGoodsSource()) ? "01" : bo.getGoodsSource());
                    backBO.setBrandName(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getBrandName());
                    backBO.setColorName(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getColorName());
                    backBO.setGoodsType(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getGoodsType());
                    backBO.setBrandId(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getBrandId());
                    materialAndProvId.put(bo.getMaterialId(), backBO);
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)bo, (Object)tempBO);
                    tempBO.setMaterialId(bo.getMaterialId());
                    tempBO.setGoodsSource("01");
                    tempBO.setProvGoodsId(null);
                    tempBO.setUpdateTime(new Date());
                    tempBO.setUpdateUser(StringUtils.isBlank((String)bo.getCreateUser()) ? bo.getUpdateUser() : bo.getCreateUser());
                    tempBO.setCreateUser(null);
                    tempBO.setCgType(null);
                    arrayList.add(tempBO);
                } else if (provMap.get(bo.getProvinceCode() + bo.getMaterialId()) != null && ((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getGoodsSource().equals("00")) {
                    backBO = new ProvGoodsBO();
                    backBO.setProvGoodsId(((ProvGoodsPO)provMap.get(bo.getProvinceCode() + bo.getMaterialId())).getProvGoodsId());
                    backBO.setGoodsSource(StringUtils.isBlank((String)bo.getGoodsSource()) ? "00" : bo.getGoodsSource());
                    materialAndProvId.put(bo.getMaterialId(), backBO);
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)bo, (Object)tempBO);
                    tempBO.setUpdateTime(new Date());
                    tempBO.setGoodsName(bo.getGoodsLongName());
                    tempBO.setUpdateUser(StringUtils.isBlank((String)bo.getCreateUser()) ? bo.getUpdateUser() : bo.getCreateUser());
                    tempBO.setProvGoodsId(null);
                    tempBO.setCgType(null);
                    tempBO.setCreateUser(null);
                    newTrailUpdate.add(tempBO);
                }
                if (provMap.get(bo.getProvinceCode() + bo.getMaterialId()) != null) continue;
                backBO = new ProvGoodsBO();
                backBO.setProvGoodsId(bo.getProvGoodsId());
                backBO.setGoodsSource(bo.getGoodsSource());
                materialAndProvId.put(bo.getMaterialId(), backBO);
                tempBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo, (Object)tempBO);
                tempBO.setCreateTime(new Date());
                tempBO.setHasPrice("0");
                tempBO.setIsValid("1");
                tempBO.setGoodsName(bo.getGoodsLongName());
                tempBO.setUpdateUser(null);
                tempBO.setCreateUsername(bo.getCreateUser());
                tempBO.setCreateUser(bo.getCreateUser());
                provInsert.add(tempBO);
            }
        }
        try {
            AddProvGoodsListReqBO bo;
            if (!CollectionUtils.isEmpty(provInsert)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(provInsert);
                this.addProvGoodsListService.addProvGood(bo);
                provInsert = null;
            }
            if (!(CollectionUtils.isEmpty(provInsert) && CollectionUtils.isEmpty(newTrailUpdate) && CollectionUtils.isEmpty(arrayList))) {
                this.materialAdd(reqBO);
            }
            if (!CollectionUtils.isEmpty(arrayList)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(arrayList);
                this.addProvGoodsListService.updataProvGoods(bo);
                Object var11_17 = null;
            }
            if (!CollectionUtils.isEmpty(newTrailUpdate)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(newTrailUpdate);
                this.addProvGoodsListService.updataProvGoods(bo);
                newTrailUpdate = null;
            }
            if (supMap != null) {
                ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
                ArrayList<Long> provId = new ArrayList<Long>();
                ProvGoodsSupRelationPO po = null;
                for (Map.Entry map : supMap.entrySet()) {
                    if (provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId()) != null) {
                        provId.add(((ProvGoodsPO)provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId())).getProvGoodsId());
                    }
                    if (CollectionUtils.isEmpty((Collection)((ProvGoodsBO)map.getValue()).getSupplierBO())) continue;
                    for (SupplierBO subo : ((ProvGoodsBO)map.getValue()).getSupplierBO()) {
                        po = new ProvGoodsSupRelationPO();
                        if (provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId()) != null) {
                            po.setProvGoodsId(((ProvGoodsPO)provMap.get(((ProvGoodsBO)map.getValue()).getProvinceCode() + ((ProvGoodsBO)map.getValue()).getMaterialId())).getProvGoodsId());
                        } else {
                            po.setProvGoodsId((Long)map.getKey());
                        }
                        po.setProvinceCode(subo.getProvinceCode());
                        po.setSupplierId(Long.parseLong(subo.getSupplierId()));
                        po.setCreateTime(new Date());
                        po.setSupplierName(subo.getSupplierName());
                        relationPO.add(po);
                    }
                }
                if (!CollectionUtils.isEmpty(provId)) {
                    this.provGoodsSupRelationDAO.deleteByProvId(provId);
                }
                if (!CollectionUtils.isEmpty(relationPO)) {
                    this.provGoodsSupRelationDAO.insertList(relationPO);
                }
            }
            if ("03".equals(((ProvGoodsBO)reqBO.getReqBO().get(0)).getGoodsStatus()) && "1".equals(reqBO.getAddType())) {
                String material = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getMaterialId();
                String provCode = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getProvinceCode();
                ArrayList<String> materialIds = new ArrayList<String>();
                materialIds.add(material);
                ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
                provinceMaterialBO.setProvinceCode(provCode);
                provinceMaterialBO.setMaterialId(materialIds);
                Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
                ArrayList<SkuBO> updateList = new ArrayList<SkuBO>();
                ArrayList<CreateSkuReqBO> createList = new ArrayList<CreateSkuReqBO>();
                Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(provCode, reqBO.getmOrgPath());
                Map<String, Sku> skuMap = this.getSku(reqBO);
                logger.debug("sku\u4fe1\u606f");
                logger.debug("\u95e8\u5e97\u5217\u8868");
                for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                    if (!CollectionUtils.isEmpty(skuMap) && skuMap.containsKey(material + shop.getKey().trim())) {
                        SkuBO update = this.toUpdate((ProvGoodsBO)reqBO.getReqBO().get(0), shop.getValue(), skuMap.get(material + shop.getKey().trim()));
                        updateList.add(update);
                        continue;
                    }
                    CreateSkuReqBO craete = this.toCreate((ProvGoodsBO)reqBO.getReqBO().get(0), shop.getValue(), priceSheet);
                    createList.add(craete);
                }
                BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                batchCreateSkuReqBO.setCreateSkuReqBOs(createList);
                if (!CollectionUtils.isEmpty(createList)) {
                    this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.xlsSkuManageService.batchUpdate(updateList);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8d27\u4fee\u6539\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u8d27\u4fee\u6539\u62a5\u9519" + e.getMessage());
        }
        result.setMaterialAndProvId(materialAndProvId);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public BaseRspBO materialCommodityCreation(AddProvGoodsListReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u8c03\u7528\u7701\u4efd\u5546\u54c1\u7684\u6279\u91cf\u521b\u5efa\uff1a" + reqBO.getReqBO().size());
        if (CollectionUtils.isEmpty((Collection)reqBO.getReqBO())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        logger.debug("\u5546\u54c1\u4e2d\u5fc3\u540c\u6b65\u6761\u6570" + reqBO.getReqBO().size());
        List<Object> provience = new ArrayList();
        try {
            provience = this.getProvCode();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u67e5\u8be2\u54c1\u724c");
        Brand brs = new Brand();
        List brands = this.brandMapper.selectAll(brs);
        HashMap<String, Long> brandMap = new HashMap<String, Long>();
        for (Object brand : brands) {
            if (brandMap.containsKey(brand.getBrandName())) continue;
            brandMap.put(brand.getBrandName(), brand.getBrandId());
        }
        HashSet<String> brandSet = new HashSet<String>();
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            if (!StringUtils.isNotEmpty((String)bo.getBrandName())) continue;
            brandSet.add(bo.getBrandName().trim());
        }
        CreateBrandReqBO brandReq = new CreateBrandReqBO();
        ArrayList<BrandBO> brandBOs = new ArrayList<BrandBO>();
        BrandBO br = null;
        for (String brand : brandSet) {
            if (brandMap.containsKey(brand)) continue;
            br = new BrandBO();
            Long brandId = Sequence.getInstance().nextId();
            brandMap.put(brand, brandId);
            br.setBrandId(brandId);
            br.setBrandName(brand.trim());
            brandBOs.add(br);
        }
        brandReq.setBrandBOs(brandBOs);
        if (!CollectionUtils.isEmpty(brandBOs)) {
            logger.debug("\u65b0\u589e\u54c1\u724c" + brandBOs.size());
            this.brandManageService.insertBrandList(brandReq);
        }
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO goodsPo = null;
        ArrayList<ProvGoodsBO> list = new ArrayList<ProvGoodsBO>();
        ProvGoodsBO provBO = null;
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            bo.setProvGoodsId(Long.valueOf(Sequence.getInstance().nextId()));
            for (String string : provience) {
                if (StringUtils.isBlank((String)string)) continue;
                provBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo, (Object)provBO);
                if (StringUtils.isNotEmpty((String)bo.getBrandName())) {
                    provBO.setBrandId((Long)brandMap.get(bo.getBrandName().trim()));
                    provBO.setBrandName(bo.getBrandName().trim());
                }
                provBO.setProvGoodsId(Long.valueOf(Sequence.getInstance().nextId()));
                provBO.setProvinceCode(string);
                list.add(provBO);
                goodsPo = new ProvGoodsPO();
                goodsPo.setMaterialId(bo.getMaterialId());
                goodsPo.setProvinceCode(string);
                record.add(goodsPo);
            }
        }
        List<Object> provGoods = new ArrayList();
        try {
            logger.debug("\u67e5\u5bfb\u540c\u6b65\u5546\u54c1\u662f\u5426\u5b58\u5728");
            provGoods = this.provGoodsDAO.selectByList(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        ArrayList<ProvGoodsBO> scmInsert = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> provInsert = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> arrayList = new ArrayList<ProvGoodsBO>();
        ArrayList<ProvGoodsBO> newTrailUpdate = new ArrayList<ProvGoodsBO>();
        ProvGoodsBO tempBO = null;
        if (CollectionUtils.isEmpty(provGoods)) {
            for (ProvGoodsBO bo : list) {
                if (bo.getGoodsSource().equals("00")) {
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)bo, (Object)tempBO);
                    tempBO.setGoodsStatus("02");
                    tempBO.setCreateTime(new Date());
                    tempBO.setCreateUsername("SCM");
                    tempBO.setIsValid("1");
                    tempBO.setIsAfterInput("1");
                    tempBO.setHasSerialNumber("0");
                    tempBO.setAllowNegativeStock("0");
                    tempBO.setIsSendScmSale("0");
                    tempBO.setHasPrice("0");
                    tempBO.setIsSendScmStock("0");
                    tempBO.setIsScmDistribute("1");
                    tempBO.setCgType("0");
                    provInsert.add(tempBO);
                    continue;
                }
                if (!bo.getGoodsSource().equals("01")) continue;
                tempBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)bo, (Object)tempBO);
                tempBO.setGoodsStatus("01");
                tempBO.setCreateTime(new Date());
                tempBO.setCreateUser("SCM");
                tempBO.setCreateUsername(bo.getCreateUser());
                tempBO.setIsValid("1");
                tempBO.setIsAfterInput("1");
                tempBO.setHasSerialNumber("0");
                tempBO.setAllowNegativeStock("0");
                tempBO.setIsSendScmSale("1");
                tempBO.setHasPrice("0");
                tempBO.setIsSendScmStock("1");
                tempBO.setIsScmDistribute("1");
                tempBO.setCgType("0");
                scmInsert.add(tempBO);
            }
        } else {
            HashMap<String, ProvGoodsPO> provMap = new HashMap<String, ProvGoodsPO>();
            for (ProvGoodsPO provGoodsPO : provGoods) {
                if (provMap.containsKey(provGoodsPO.getProvinceCode() + provGoodsPO.getMaterialId())) continue;
                provMap.put(provGoodsPO.getProvinceCode() + provGoodsPO.getMaterialId(), provGoodsPO);
            }
            for (ProvGoodsBO provGoodsBO : list) {
                if (provMap.get(provGoodsBO.getProvinceCode() + provGoodsBO.getMaterialId()) != null && ((ProvGoodsPO)provMap.get(provGoodsBO.getProvinceCode() + provGoodsBO.getMaterialId())).getGoodsSource().equals("01")) {
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)provGoodsBO, (Object)tempBO);
                    tempBO.setMaterialId(provGoodsBO.getMaterialId());
                    tempBO.setCreateTime(null);
                    tempBO.setUpdateTime(new Date());
                    tempBO.setUpdateUser("SCM");
                    arrayList.add(tempBO);
                } else if (provMap.get(provGoodsBO.getProvinceCode() + provGoodsBO.getMaterialId()) != null && ((ProvGoodsPO)provMap.get(provGoodsBO.getProvinceCode() + provGoodsBO.getMaterialId())).getGoodsSource().equals("00")) {
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)provGoodsBO, (Object)tempBO);
                    tempBO.setUpdateTime(new Date());
                    tempBO.setCreateTime(null);
                    tempBO.setUpdateUser("SCM");
                    newTrailUpdate.add(tempBO);
                }
                if (provMap.get(provGoodsBO.getProvinceCode() + provGoodsBO.getMaterialId()) != null) continue;
                if (provGoodsBO.getGoodsSource().equals("00")) {
                    tempBO = new ProvGoodsBO();
                    BeanUtils.copyProperties((Object)provGoodsBO, (Object)tempBO);
                    tempBO.setCreateTime(new Date());
                    tempBO.setIsValid("1");
                    tempBO.setCreateUsername(provGoodsBO.getCreateUser());
                    tempBO.setIsAfterInput("1");
                    tempBO.setUpdateUser("SCM");
                    tempBO.setHasSerialNumber("0");
                    tempBO.setAllowNegativeStock("0");
                    tempBO.setIsSendScmSale("0");
                    tempBO.setHasPrice("0");
                    tempBO.setIsSendScmStock("0");
                    tempBO.setIsScmDistribute("1");
                    tempBO.setCgType("0");
                    tempBO.setGoodsStatus("02");
                    provInsert.add(tempBO);
                    continue;
                }
                if (!provGoodsBO.getGoodsSource().equals("01")) continue;
                tempBO = new ProvGoodsBO();
                BeanUtils.copyProperties((Object)provGoodsBO, (Object)tempBO);
                tempBO.setCreateTime(new Date());
                tempBO.setCreateUsername(provGoodsBO.getCreateUser());
                tempBO.setIsValid("1");
                tempBO.setIsAfterInput("1");
                tempBO.setCreateUser("SCM");
                tempBO.setHasSerialNumber("0");
                tempBO.setAllowNegativeStock("0");
                tempBO.setIsSendScmSale("1");
                tempBO.setHasPrice("0");
                tempBO.setIsSendScmStock("1");
                tempBO.setIsScmDistribute("1");
                tempBO.setCgType("0");
                tempBO.setGoodsStatus("01");
                scmInsert.add(tempBO);
            }
        }
        try {
            AddProvGoodsListReqBO bo;
            if (!CollectionUtils.isEmpty(scmInsert)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(scmInsert);
                this.addProvGoodsListService.addProvGood(bo);
            }
            if (!CollectionUtils.isEmpty(provInsert)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(provInsert);
                this.addProvGoodsListService.addProvGood(bo);
            }
            if (!CollectionUtils.isEmpty(arrayList)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(arrayList);
                this.addProvGoodsListService.updataProvGoods(bo);
            }
            if (!CollectionUtils.isEmpty(newTrailUpdate)) {
                bo = new AddProvGoodsListReqBO();
                bo.setReqBO(newTrailUpdate);
                this.addProvGoodsListService.updataProvGoods(bo);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u8d27\u4fee\u6539\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u8d27\u4fee\u6539\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public String check(AddProvGoodsListReqBO reqBO) {
        String back = "";
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            if (StringUtils.isBlank((String)bo.getMaterialId())) {
                back = "\u7269\u6599\u7f16\u7801\u4e3a\u7a7a";
                return back;
            }
            if (!StringUtils.isBlank((String)bo.getMaterialId()) && "1".equals(reqBO.getAddType())) {
                ArrayList<String> ma = new ArrayList<String>();
                ma.add(bo.getMaterialId());
                List<ProvGoodsPO> list = this.provGoodsDAO.selectByMaterials(ma, ((ProvGoodsBO)reqBO.getReqBO().get(0)).getProvinceCode());
                if (!CollectionUtils.isEmpty(list)) {
                    back = "\u8be5\u7269\u6599\u5df2\u5b58\u5728," + list.get(0).getProvGoodsId();
                    return back;
                }
            }
            if (StringUtils.isBlank((String)bo.getProvinceCode())) {
                back = "\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getHasSerialNumber())) {
                back = "\u6709\u65e0\u4e32\u53f7\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getAllowNegativeStock())) {
                back = "\u5141\u8bb8\u8d1f\u5e93\u5b58\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getIsSendScmStock())) {
                back = "\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u4e3a\u7a7a";
                return back;
            }
            if (StringUtils.isBlank((String)bo.getIsSendScmSale())) {
                back = "\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u4e3a\u7a7a";
                return back;
            }
            if (!StringUtils.isBlank((String)bo.getIsScmDistribute())) continue;
            back = "\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u4e3a\u7a7a";
            return back;
        }
        return "";
    }

    public void materialAdd(AddProvGoodsListReqBO reqBO) throws Exception {
        ArrayList<DmaterialBO> dmaterialBOs = new ArrayList<DmaterialBO>();
        DmaterialBO dmaterialBO = null;
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            dmaterialBO = new DmaterialBO();
            if ("01".equals(bo.getGoodsSource())) {
                dmaterialBO.setBrandName(null);
                dmaterialBO.setColorName(null);
                dmaterialBO.setVersionName(null);
                dmaterialBO.setMaterialDesc(bo.getScmGoodsLongName());
                dmaterialBO.setIsScm("1");
                dmaterialBO.setMarqueName(null);
            } else {
                dmaterialBO.setBrandName(bo.getBrandName());
                dmaterialBO.setColorName(bo.getColorName());
                dmaterialBO.setVersionName(bo.getVersionName());
                dmaterialBO.setMaterialDesc(bo.getScmGoodsLongName());
                dmaterialBO.setIsScm("0");
                dmaterialBO.setMarqueName(bo.getGoodsModel());
            }
            dmaterialBO.setCreateTime(new Date());
            dmaterialBO.setCreateUser(bo.getCreateUser());
            dmaterialBO.setIsValid("1");
            dmaterialBO.setConfigName(bo.getConfigName());
            dmaterialBO.setMaterialId(bo.getMaterialId());
            dmaterialBO.setProvinceCode(bo.getProvinceCode());
            dmaterialBOs.add(dmaterialBO);
        }
        this.dMaterialManageService.insertMaterialRecords(dmaterialBOs);
    }

    public List<String> getProvCode() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String postUrl = this.url;
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)1);
        param.put("isCutoverFlag", (Object)1);
        String comeBack = TkHttpRequestUtils.conn(null, param.toString(), null, postUrl, null, null);
        JSONObject prov = JSONObject.parseObject((String)comeBack);
        JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
        for (int i = 0; i < orgTreeBOList.size(); ++i) {
            JSONObject item = orgTreeBOList.getJSONObject(i);
            list.add(item.getString("provinceCode"));
        }
        return list;
    }

    public BaseRspBO insureProvCreation(AddProvGoodsListReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        HashMap<Long, List> suppiler = new HashMap<Long, List>();
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO po = null;
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            if (!suppiler.containsKey(bo.getProvGoodsId())) {
                suppiler.put(bo.getProvGoodsId(), bo.getSupplierBO());
            }
            po = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setHasSerialNumber("0");
            po.setHasPrice("1");
            po.setAllowNegativeStock("05".equals(bo.getSecurityServicesType()) ? "0" : "1");
            po.setIsScmDistribute("05".equals(bo.getSecurityServicesType()) ? "1" : "0");
            po.setIsSendScmSale("05".equals(bo.getSecurityServicesType()) ? "1" : "0");
            po.setIsSendScmStock("05".equals(bo.getSecurityServicesType()) ? "1" : "0");
            po.setCgType("0");
            po.setGoodsSource("00");
            po.setPurchaseType("1");
            po.setWhetherInvoice("1");
            if (reqBO.getIsInsure().booleanValue()) {
                po.setReservedField1("1");
            } else {
                po.setReservedField1("2");
            }
            po.setIsValid("1");
            record.add(po);
        }
        try {
            this.provGoodsDAO.insertList(record);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u4fdd\u969c\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u65b0\u589e\u4f9b\u5e94\u5546");
        ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
        ProvGoodsSupRelationPO suPO = null;
        for (Map.Entry map : suppiler.entrySet()) {
            for (SupplierBO supplier : (List)map.getValue()) {
                suPO = new ProvGoodsSupRelationPO();
                suPO.setProvGoodsId((Long)map.getKey());
                suPO.setProvinceCode(supplier.getProvinceCode());
                suPO.setSupplierId(Long.parseLong(supplier.getSupplierId()));
                suPO.setCreateTime(new Date());
                suPO.setSupplierName(supplier.getSupplierName());
                relationPO.add(suPO);
            }
        }
        try {
            this.provGoodsSupRelationDAO.insertList(relationPO);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public BaseRspBO updateProv(AddProvGoodsListReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1" + JSONObject.toJSONString((Object)reqBO));
        ArrayList<ProvGoodsPO> record = new ArrayList<ProvGoodsPO>();
        ProvGoodsPO po = null;
        String materialId = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getMaterialId();
        for (ProvGoodsBO bo : reqBO.getReqBO()) {
            po = new ProvGoodsPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setCreateUser(null);
            po.setCreateUsername(null);
            po.setCreateTime(null);
            po.setUpdateTime(new Date());
            po.setWhetherInvoice("1");
            po.setUpdateUser(bo.getCreateUsername());
            record.add(po);
        }
        try {
            this.provGoodsDAO.updateList(record);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u4fee\u6539\u4f9b\u5e94\u5546");
        ArrayList<Long> pro = new ArrayList<Long>();
        String goodsType = "";
        goodsType = reqBO.getIsInsure() != false ? "1" : "2";
        List<ProvGoodsPO> provList = this.provGoodsDAO.selectInsureList(materialId, goodsType, null);
        ArrayList<ProvGoodsSupRelationPO> relationPO = new ArrayList<ProvGoodsSupRelationPO>();
        ProvGoodsSupRelationPO suPO = null;
        for (ProvGoodsPO prov : provList) {
            pro.add(prov.getProvGoodsId());
            for (SupplierBO supplier : ((ProvGoodsBO)reqBO.getReqBO().get(0)).getSupplierBO()) {
                suPO = new ProvGoodsSupRelationPO();
                suPO.setProvGoodsId(prov.getProvGoodsId());
                suPO.setProvinceCode(supplier.getProvinceCode());
                suPO.setSupplierId(Long.parseLong(supplier.getSupplierId()));
                suPO.setCreateTime(new Date());
                suPO.setSupplierName(supplier.getSupplierName());
                relationPO.add(suPO);
            }
        }
        try {
            this.provGoodsSupRelationDAO.deleteByProvId(pro);
            this.provGoodsSupRelationDAO.insertList(relationPO);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u4fdd\u969c\u670d\u52a1\u66f4\u65b0\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public Map<String, Sku> getSku(AddProvGoodsListReqBO reqBO) throws Exception {
        HashMap<String, Sku> skuMap = new HashMap<String, Sku>();
        String provinceCode = ((ProvGoodsBO)reqBO.getReqBO().get(0)).getProvinceCode();
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(provinceCode, reqBO.getmOrgPath());
        List<Object> skus = new ArrayList();
        if (!CollectionUtils.isEmpty(shopIds)) {
            ArrayList<String> materialIds = new ArrayList<String>();
            for (ProvGoodsBO bo : reqBO.getReqBO()) {
                materialIds.add(bo.getMaterialId());
            }
            skus = this.xlsSkuMapper.findAllProvinceCodeMeterialIds(provinceCode, materialIds);
        }
        if (!CollectionUtils.isEmpty(skus)) {
            for (Sku sk : skus) {
                if (!shopIds.containsKey(sk.getSupplierId().toString())) continue;
                sk.setProvinceCode(shopIds.get(sk.getSupplierId().toString()).getProvinceCode());
                sk.setCityCode(shopIds.get(sk.getSupplierId().toString()).getCityCode());
                if (skuMap.containsKey(sk.getMaterialId() + sk.getSupplierId())) continue;
                skuMap.put(sk.getMaterialId() + sk.getSupplierId(), sk);
            }
        }
        return skuMap;
    }

    public Map<String, ProvAndCityCodeBO> getProvCode(String provinceCode, String orgPath) throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        String postUrl = this.url;
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)orgPath);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        logger.debug(param.toString());
        String comeBack = TkHttpRequestUtils.conn(null, param.toString(), null, postUrl, null, null);
        JSONObject prov = JSONObject.parseObject((String)comeBack);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            ProvAndCityCodeBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            logger.debug("\u67e5\u8be2\u95e8\u5e97\u8fd4\u56de\u6761\u6570=" + orgTreeBOList.size());
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setSupplierId(item.getString("storeId"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId"), bo);
            }
        }
        return map;
    }

    public CreateSkuReqBO toCreate(ProvGoodsBO bo, ProvAndCityCodeBO shop, Map<String, DPriceSheetBO> priceSheet) {
        CreateSkuReqBO cr = new CreateSkuReqBO();
        String key = bo.getMaterialId() + shop.getProvinceCode() + shop.getCountryCode();
        DPriceSheetBO price = new DPriceSheetBO();
        if (!CollectionUtils.isEmpty(priceSheet)) {
            DPriceSheetBO dPriceSheetBO = price = priceSheet.get(key.trim()) == null ? priceSheet.get(bo.getMaterialId() + shop.getProvinceCode()) : priceSheet.get(key.trim());
        }
        if (price != null) {
            cr.setSaleSrice(price.getSalePrice());
            cr.setSheetId(price.getSheetId());
            cr.setSheetLevel(price.getSheetLevel());
            cr.setAssessmentPrice(price.getAssessmentPrice());
            cr.setSaleSrice(price.getSalePrice());
            cr.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
            cr.setAgreementPrice(price.getAgreementPrice());
            cr.setMemberPrice(price.getMemberPrice());
        }
        cr.setBrandId(bo.getBrandId());
        cr.setBrandName(bo.getBrandName());
        cr.setColor(bo.getColorName());
        cr.setBrand(bo.getBrandName());
        cr.setGoodsSource(bo.getGoodsSource());
        cr.setModel(bo.getGoodsModel());
        cr.setCgType(bo.getCgType());
        cr.setExtSkuId(bo.getExtGoodsNo());
        cr.setSkuCode(bo.getGoodsNo());
        cr.setRam(bo.getMemoryName());
        cr.setMeasureId(bo.getMeasureId());
        cr.setMeasureName(bo.getMeasureName());
        cr.setFullName(bo.getGoodsLongName());
        cr.setSupplierId(Long.valueOf(Long.parseLong(shop.getSupplierId())));
        cr.setSupplierName(shop.getShopName());
        cr.setCountyCode(shop.getCountryCode());
        cr.setProvinceCode(shop.getProvinceCode());
        cr.setCityCode(shop.getCityCode());
        cr.setName(bo.getGoodsModel());
        cr.setIsVirtualGood(bo.getAllowNegativeStock());
        cr.setMaterialId(bo.getMaterialId());
        cr.setProvGoodsId(bo.getProvGoodsId());
        cr.setProvinceCode(bo.getProvinceCode());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        cr.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        cr.setVendorName(bo.getSupNo());
        return cr;
    }

    public SkuBO toUpdate(ProvGoodsBO bo, ProvAndCityCodeBO shopId, Sku sku) {
        SkuBO skuBO = new SkuBO();
        skuBO.setBrandId(bo.getBrandId());
        skuBO.setBrandName(bo.getBrandName());
        skuBO.setColor(bo.getColorName());
        skuBO.setBrand(bo.getBrandName());
        skuBO.setGoodsSource(bo.getGoodsSource());
        String venId = "";
        for (SupplierBO su : bo.getSupplierBO()) {
            venId = venId + su.getSupplierId() + ",";
        }
        skuBO.setModel(bo.getGoodsModel());
        skuBO.setVendorId(StringUtils.isBlank((String)venId) ? null : venId.substring(0, venId.length() - 1));
        skuBO.setVendorName(bo.getSupNo());
        skuBO.setSkuId(sku.getSkuId());
        skuBO.setRam(bo.getMemoryName());
        skuBO.setProvinceCode(shopId.getProvinceCode());
        skuBO.setCgType(bo.getCgType());
        skuBO.setCityCode(shopId.getCityCode());
        skuBO.setExtSkuId(bo.getExtGoodsNo());
        skuBO.setCountyCode(shopId.getCountryCode());
        skuBO.setSkuCode(bo.getGoodsNo());
        skuBO.setSkuName(bo.getGoodsLongName());
        skuBO.setSkuLongName(bo.getGoodsLongName());
        skuBO.setErpLongName(bo.getGoodsLongName());
        skuBO.setSkuPriceTagName(bo.getGoodsLongName());
        skuBO.setMfgSku(bo.getGoodsModel());
        skuBO.setIsVirtualGood(bo.getAllowNegativeStock());
        skuBO.setProvGoodsId(bo.getProvGoodsId());
        skuBO.setSupplierId(sku.getSupplierId());
        skuBO.setIsDelete(Integer.valueOf(0));
        return skuBO;
    }
}

