/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.DPriceSheetItemManageBusiService;
import com.xls.commodity.busi.sku.QueryPriceSheetItemPageReqBO;
import com.xls.commodity.busi.sku.bo.DPriceSheetItemBO;
import com.xls.commodity.busi.sku.bo.DPriceSheetItemResBO;
import com.xls.commodity.busi.sku.bo.PriceSheetOrgBO;
import com.xls.commodity.busi.sku.bo.QueryPriceSheetItemReqBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.PriceSheetItemDAO;
import com.xls.commodity.dao.PriceSheetOrgDAO;
import com.xls.commodity.dao.po.PriceSheetItemPO;
import com.xls.commodity.dao.po.PriceSheetItemReqPO;
import com.xls.commodity.dao.po.PriceSheetOrgPO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DPriceSheetItemManageBusiServiceImpl
implements DPriceSheetItemManageBusiService {
    private static final Logger logger = LoggerFactory.getLogger(DPriceSheetItemManageBusiServiceImpl.class);
    @Autowired
    private PriceSheetItemDAO priceSheetItemDAO;
    @Autowired
    private PriceSheetOrgDAO priceSheetOrgDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;

    public RspPageBO<DPriceSheetItemBO> selectByGroupMaterial(QueryPriceSheetItemPageReqBO reqBO) {
        RspPageBO result = new RspPageBO();
        PriceSheetItemReqPO record = new PriceSheetItemReqPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setSheetLevel(reqBO.getSheetLevel());
        record.setIsValid("1");
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        ArrayList<DPriceSheetItemBO> rows = new ArrayList<DPriceSheetItemBO>();
        try {
            List<PriceSheetItemPO> itemPOList = this.priceSheetItemDAO.selectByGroupMaterial(record, (Page<PriceSheetItemPO>)page);
            if (CollectionUtils.isNotEmpty(itemPOList)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (PriceSheetItemPO po1 : itemPOList) {
                    DPriceSheetItemBO bo = new DPriceSheetItemBO();
                    bo = this.poToItemBo(po1);
                    if (!"1".equals(reqBO.getmVisiCost())) {
                        bo.setPurchasePrice("****");
                    }
                    bo.setSheetLevelStr(escaMap.get("ORG_LEVEL_STR").get(po1.getSheetLevel()));
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public RspPageBO<DPriceSheetItemBO> selectByGroupLevel(QueryPriceSheetItemPageReqBO reqBO) {
        RspPageBO result = new RspPageBO();
        PriceSheetItemReqPO record = new PriceSheetItemReqPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setIsValid("1");
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        ArrayList<DPriceSheetItemBO> rows = new ArrayList<DPriceSheetItemBO>();
        try {
            List<PriceSheetItemPO> itemPOList = this.priceSheetItemDAO.selectByGroupLevel(record, (Page<PriceSheetItemPO>)page);
            if (CollectionUtils.isNotEmpty(itemPOList)) {
                ArrayList<Long> idList = new ArrayList<Long>();
                for (PriceSheetItemPO po1 : itemPOList) {
                    idList.add(po1.getSheetId());
                }
                List<PriceSheetOrgPO> priceSheetOrgPOS = this.priceSheetOrgDAO.selectBySheetIds(idList);
                HashMap orgMap = new HashMap();
                if (CollectionUtils.isNotEmpty(priceSheetOrgPOS)) {
                    for (PriceSheetOrgPO priceSheetOrgPO : priceSheetOrgPOS) {
                        PriceSheetOrgBO orgBO;
                        if (orgMap.containsKey(priceSheetOrgPO.getSheetId())) {
                            orgBO = new PriceSheetOrgBO();
                            BeanUtils.copyProperties((Object)priceSheetOrgPO, (Object)orgBO);
                            ((List)orgMap.get(priceSheetOrgPO.getSheetId())).add(orgBO);
                            continue;
                        }
                        orgBO = new PriceSheetOrgBO();
                        BeanUtils.copyProperties((Object)priceSheetOrgPO, (Object)orgBO);
                        ArrayList<PriceSheetOrgBO> orgBOS = new ArrayList<PriceSheetOrgBO>();
                        orgBOS.add(orgBO);
                        orgMap.put(priceSheetOrgPO.getSheetId(), orgBOS);
                    }
                }
                for (PriceSheetItemPO priceSheetItemPO : itemPOList) {
                    DPriceSheetItemBO bo = this.poToItemBo(priceSheetItemPO);
                    if (!"1".equals(reqBO.getmVisiCost())) {
                        bo.setPurchasePrice("****");
                    }
                    if (orgMap.containsKey(priceSheetItemPO.getSheetId())) {
                        bo.setPriceSheetOrgBOS((List)orgMap.get(priceSheetItemPO.getSheetId()));
                    }
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    private DPriceSheetItemBO poToItemBo(PriceSheetItemPO po) {
        DPriceSheetItemBO bo = new DPriceSheetItemBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        try {
            if (po.getPurchaseFloorPrice() != null) {
                bo.setPurchaseFloorPrice(MoneyUtils.Long2BigDecimal((Long)po.getPurchaseFloorPrice()).toString());
            }
            if (po.getRetailAgreementPrice() != null) {
                bo.setRetailAgreementPrice(MoneyUtils.Long2BigDecimal((Long)po.getRetailAgreementPrice()).toString());
            }
            if (po.getCitiesLockPrice() != null) {
                bo.setCitiesLockPrice(MoneyUtils.Long2BigDecimal((Long)po.getCitiesLockPrice()).toString());
            }
            if (po.getTheCostDownPrice() != null) {
                bo.setTheCostDownPrice(MoneyUtils.Long2BigDecimal((Long)po.getTheCostDownPrice()).toString());
            }
            if (po.getAssessmentPrice() != null) {
                bo.setAssessmentPrice(MoneyUtils.Long2BigDecimal((Long)po.getAssessmentPrice()).toString());
            }
            if (po.getPurchasePrice() != null) {
                bo.setPurchasePrice(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()).toString());
            }
            if (po.getSalePrice() != null) {
                bo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)po.getSalePrice()).toString());
            }
            if (po.getAgreementPrice() != null) {
                bo.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)po.getAgreementPrice()).toString());
            }
            if (po.getProvAgreePrice() != null) {
                bo.setProvAgreePrice(MoneyUtils.Long2BigDecimal((Long)po.getProvAgreePrice()).toString());
            }
            if (po.getMemberPrice() != null) {
                bo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)po.getMemberPrice()).toString());
            }
            if (po.getTradePrice() != null) {
                bo.setTradePrice(MoneyUtils.Long2BigDecimal((Long)po.getTradePrice()).toString());
            }
            if (po.getLastPurchasePrice() != null) {
                bo.setLastPurchasePrice(MoneyUtils.Long2BigDecimal((Long)po.getLastPurchasePrice()).toString());
            }
            if (po.getCostPrice() != null) {
                bo.setCostPrice(MoneyUtils.Long2BigDecimal((Long)po.getCostPrice()).toString());
            }
            if (po.getSparePrice2() != null) {
                bo.setSparePrice2(MoneyUtils.Long2BigDecimal((Long)po.getSparePrice2()).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getSparePrice3())) {
                bo.setSparePrice3(MoneyUtils.Long2BigDecimal((Long)Long.valueOf(po.getSparePrice3())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getSparePrice4())) {
                bo.setSparePrice4(MoneyUtils.Long2BigDecimal((Long)Long.valueOf(po.getSparePrice4())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getSparePrice5())) {
                bo.setSparePrice5(MoneyUtils.Long2BigDecimal((Long)Long.valueOf(po.getSparePrice5())).toString());
            }
            if (po.getMemberLadderPrice1() != null) {
                bo.setMemberLadderPrice1(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice1()).toString());
            }
            if (po.getMemberLadderPrice2() != null) {
                bo.setMemberLadderPrice2(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice2()).toString());
            }
            if (po.getMemberLadderPrice3() != null) {
                bo.setMemberLadderPrice3(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice3()).toString());
            }
            if (po.getMemberLadderPrice4() != null) {
                bo.setMemberLadderPrice4(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice4()).toString());
            }
            if (po.getMemberLadderPrice5() != null) {
                bo.setMemberLadderPrice5(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice5()).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u91d1\u989d\u8f6c\u6362\u51fa\u9519" + e.getMessage());
        }
        return bo;
    }

    public DPriceSheetItemResBO selectByGroupMaterialNoPage(QueryPriceSheetItemReqBO reqBO) {
        DPriceSheetItemResBO result = new DPriceSheetItemResBO();
        PriceSheetItemReqPO record = new PriceSheetItemReqPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setSheetLevel(reqBO.getSheetLevel());
        record.setIsValid("1");
        ArrayList<DPriceSheetItemBO> rows = new ArrayList<DPriceSheetItemBO>();
        try {
            List<PriceSheetItemPO> itemPOList = this.priceSheetItemDAO.selectByGroupMaterial(record);
            if (CollectionUtils.isNotEmpty(itemPOList)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (PriceSheetItemPO po1 : itemPOList) {
                    DPriceSheetItemBO bo = new DPriceSheetItemBO();
                    bo = this.poToItemBo(po1);
                    if (!"1".equals(reqBO.getmVisiCost())) {
                        bo.setPurchasePrice("****");
                    }
                    bo.setSheetLevelStr(escaMap.get("ORG_LEVEL_STR").get(po1.getSheetLevel()));
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }
}

