/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.bo.RspBaseBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.atom.sku.DeleteSkuService;
import com.xls.commodity.busi.sku.DeleteProvGoodsService;
import com.xls.commodity.busi.sku.bo.DeleteProvGoodsBO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DeleteProvGoodsServiceImpl
implements DeleteProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(DeleteProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private DeleteSkuService deleteSkuService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    public RspBaseBO deleteProvGoods(DeleteProvGoodsBO provGoodsBO) {
        RspBaseBO result = new RspBaseBO();
        this.objectIsEmpty(provGoodsBO, "DeleteProvGoods\u65b9\u6cd5\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a", result);
        Long provGoodsId = provGoodsBO.getProvGoodsId();
        try {
            ProvGoodsPO provGoodsPO = this.provGoodsDAO.selectByPrimaryKey(provGoodsId);
            if (!this.isRepertoryEmpty(provGoodsPO, result)) {
                result.setMessage("\u5931\u8d25\u7701\u4efd\u5546\u54c1\u5e93\u5b58\u4e0d\u4e3a\u7a7a\u4e0d\u80fd\u8fdb\u884c\u5220\u9664");
                result.setCode("8888");
            }
            logger.debug("\u7701\u4efd\u5546\u54c1\u5e93\u5b58\u4e3a\u7a7a\u5f00\u59cb\u8fdb\u884c\u5220\u9664");
            int i = this.provGoodsDAO.deleteByPrimaryKey(provGoodsId);
            logger.debug("\u5220\u9664\u7701\u4efd\u5546\u54c1\u5f71\u54cd\u7684\u884c\u6570" + i);
            int t = this.provGoodsSupRelationDAO.deleteByProvGoodSId(provGoodsId);
            logger.debug("\u5220\u9664\u7701\u4efd\u5546\u54c1\u548c\u4f9b\u5e94\u5546\u5f71\u54cd\u7684\u884c\u6570" + t);
            this.deleteSkuService.deleteSKU(provGoodsId);
        }
        catch (BeansException e) {
            logger.error("\u5220\u9664\u7701\u4efd\u5546\u54c1\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            result.setMessage("\u5931\u8d25");
            result.setCode("8888");
        }
        result.setCode("0000");
        result.setMessage("\u6210\u529f");
        return result;
    }

    public boolean isRepertoryEmpty(ProvGoodsPO provGoodsPO, RspBaseBO result) {
        logger.debug("\u67e5\u8be2\u5230\u7701\u4efd\u5546\u54c1\u6570\u636e" + JSON.toJSONString((Object)provGoodsPO));
        this.objectIsEmpty(provGoodsPO, "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u7701\u4efd\u5546\u54c1\u6570\u636e\u5220\u9664\u5931\u8d25", result);
        JSONObject resultData = this.reqBOresultData(provGoodsPO);
        Long unsaleNum = resultData.getLong("unsaleNum");
        Long transNum = resultData.getLong("transNum");
        Long lockNum = resultData.getLong("lockNum");
        return unsaleNum <= 0L && transNum <= 0L && lockNum <= 0L;
    }

    private JSONObject reqBOresultData(ProvGoodsPO provPO) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("provId", provPO.getProvinceCode());
        param.put("materialCode", provPO.getMaterialId());
        JSONObject resultData = new JSONObject();
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcQryUnSaleCountsAbilityService", "qryUnSaleCounts", "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO");
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            invokeInfo.setRegisterType("2");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString(param), null, (InvokeInfo)invokeInfo);
            logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528" + resultData);
        }
        catch (Exception e) {
            logger.error("\u53ef\u552e,\u5728\u9014,\u9501\u5e93\uff0c\u6570\u91cf\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("9999", "\u53ef\u552e,\u5728\u9014,\u9501\u5e93\uff0c\u6570\u91cf\u67e5\u8be2\u5931\u8d25");
        }
        return resultData;
    }

    public void objectIsEmpty(Object object, String message, RspBaseBO result) {
        if (object == null || "".equals(object)) {
            logger.error(message);
            result.setMessage("\u5931\u8d25");
            result.setCode("8888");
        }
    }
}

