/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.base.common.util.MoneyUtil;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.atom.sku.DPriceSheetItemManageService;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.atom.sku.XlsSkuPriceManageService;
import com.xls.commodity.busi.sku.HeadquartersOfferService;
import com.xls.commodity.busi.sku.bo.DPriceSheetItemBO;
import com.xls.commodity.busi.sku.bo.HeadquarterOfferAddReqBO;
import com.xls.commodity.busi.sku.bo.HeadquartersOfferResBO;
import com.xls.commodity.busi.sku.bo.PriceSheetBO;
import com.xls.commodity.busi.sku.bo.PriceSheetCheckBO;
import com.xls.commodity.busi.sku.bo.PriceSheetItemBO;
import com.xls.commodity.busi.sku.bo.PriceSheetOrgBO;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.PriceSheetCheckDAO;
import com.xls.commodity.dao.PriceSheetDAO;
import com.xls.commodity.dao.PriceSheetItemDAO;
import com.xls.commodity.dao.PriceSheetOrgDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.PriceSheetCheckPO;
import com.xls.commodity.dao.po.PriceSheetItemPO;
import com.xls.commodity.dao.po.PriceSheetOrgPO;
import com.xls.commodity.dao.po.PriceSheetPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.thread.PriceSheetAddThread;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class HeadquartersOfferServiceImpl
implements HeadquartersOfferService {
    private static final Logger logger = LoggerFactory.getLogger(HeadquartersOfferServiceImpl.class);
    @Autowired
    private PriceSheetDAO priceSheetDAO;
    @Autowired
    private PriceSheetItemDAO priceSheetItemDAO;
    @Autowired
    private PriceSheetOrgDAO priceSheetOrgDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private DPriceSheetItemManageService dPriceSheetItemManageService;
    @Autowired
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    @Autowired
    private PriceSheetCheckDAO priceSheetCheckDAO;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Value(value="${getProvience}")
    private String url;

    public HeadquartersOfferResBO headquartersOfferQuery(PriceSheetBO reqBO) {
        PriceSheetItemBO bo;
        logger.debug("\u603b\u90e8\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2:");
        HeadquartersOfferResBO result = new HeadquartersOfferResBO();
        if (reqBO.getSheetId() == null) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        PriceSheetBO priceSheetBO = new PriceSheetBO();
        ArrayList<PriceSheetItemBO> priceSheetOrgBOList = new ArrayList<PriceSheetItemBO>();
        ArrayList<PriceSheetItemBO> priceSheetItemBOList = new ArrayList<PriceSheetItemBO>();
        logger.debug("\u67e5\u8be2\u7801\u8868");
        Map<String, Map<String, String>> escaMap = this.getEscape();
        try {
            logger.debug("\u67e5\u8be2\u62a5\u4ef7");
            PriceSheetPO priceSheetPO = this.priceSheetDAO.selectByPrimaryKey(reqBO.getSheetId());
            if (priceSheetPO != null) {
                BeanUtils.copyProperties((Object)priceSheetPO, (Object)priceSheetBO);
                priceSheetBO.setIsValidStr(escaMap.get("IS_VALID_STR").get(priceSheetPO.getIsValid()));
                priceSheetBO.setSheetLevelStr(escaMap.get("SHEET_LEVEL_STR").get(priceSheetPO.getSheetLevel()));
                priceSheetBO.setCheckStatusStr(escaMap.get("CHECK_STATUS_STR").get(priceSheetPO.getCheckStatus()));
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u62a5\u4ef7\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u62a5\u4ef7\u62a5\u9519" + e.getMessage());
        }
        try {
            logger.debug("\u67e5\u8be2\u62a5\u4ef7\u660e\u7ec6");
            List<PriceSheetItemPO> priceSheetItemPOList = this.priceSheetItemDAO.selectBySheetId(reqBO.getSheetId());
            logger.debug("priceSheetItemPOList:" + priceSheetItemPOList.size());
            if (!CollectionUtils.isEmpty(priceSheetItemPOList)) {
                bo = null;
                for (PriceSheetItemPO priceSheetItemPO : priceSheetItemPOList) {
                    bo = new PriceSheetItemBO();
                    BeanUtils.copyProperties((Object)priceSheetItemPO, (Object)bo);
                    bo.setIsRootControlStr(escaMap.get("IS_ROOT_CONTROL_STR").get(priceSheetItemPO.getIsRootControl()));
                    bo.setRetailAgreementPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getRetailAgreementPrice()));
                    bo.setCitiesLockPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getCitiesLockPrice()));
                    bo.setTheCostDownPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getTheCostDownPrice()));
                    bo.setPurchaseFloorPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getPurchaseFloorPrice()));
                    bo.setAgreementPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getAgreementPrice()));
                    bo.setAssessmentPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getAssessmentPrice()));
                    bo.setCostPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getCostPrice()));
                    bo.setLastPurchasePriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getLastPurchasePrice()));
                    bo.setTradePriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getTradePrice()));
                    bo.setSparePrice5Str(StringUtils.isEmpty((CharSequence)priceSheetItemPO.getSparePrice5()) ? null : MoneyUtil.Long2BigDecimal((Long)Long.parseLong(priceSheetItemPO.getSparePrice5())));
                    bo.setSparePrice4Str(StringUtils.isEmpty((CharSequence)priceSheetItemPO.getSparePrice4()) ? null : MoneyUtil.Long2BigDecimal((Long)Long.parseLong(priceSheetItemPO.getSparePrice4())));
                    bo.setSparePrice3Str(StringUtils.isEmpty((CharSequence)priceSheetItemPO.getSparePrice3()) ? null : MoneyUtil.Long2BigDecimal((Long)Long.parseLong(priceSheetItemPO.getSparePrice3())));
                    bo.setSparePrice2Str(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getSparePrice2()));
                    bo.setSalePriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getSalePrice()));
                    bo.setPurchasePriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getPurchasePrice()));
                    bo.setProvAgreePriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getProvAgreePrice()));
                    bo.setMemberPriceStr(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getMemberPrice()));
                    bo.setMemberLadderPrice5Str(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getMemberLadderPrice5()));
                    bo.setMemberLadderPrice4Str(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getMemberLadderPrice4()));
                    bo.setMemberLadderPrice3Str(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getMemberLadderPrice3()));
                    bo.setMemberLadderPrice2Str(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getMemberLadderPrice2()));
                    bo.setMemberLadderPrice1Str(MoneyUtil.Long2BigDecimal((Long)priceSheetItemPO.getMemberLadderPrice1()));
                    bo.setGoodsLevelStr(escaMap.get("GOODS_LEVEL_STR").get(priceSheetItemPO.getGoodsLevel()));
                    bo.setSheetLevelStr(escaMap.get("SHEET_LEVEL_STR").get(priceSheetItemPO.getSheetLevel()));
                    bo.setIsCoverStr(escaMap.get("PROV_GOODS_IS_OR_NO").get(priceSheetItemPO.getIsCover()));
                    priceSheetItemBOList.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u62a5\u4ef7\u660e\u7ec6\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u62a5\u4ef7\u660e\u7ec6\u62a5\u9519" + e.getMessage());
        }
        try {
            logger.debug("\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u8303\u56f4");
            List<PriceSheetOrgPO> poList = this.priceSheetOrgDAO.selectBySheetId(reqBO.getSheetId());
            if (!CollectionUtils.isEmpty(poList)) {
                bo = null;
                for (PriceSheetOrgPO priceSheetOrgPO : poList) {
                    bo = new PriceSheetOrgBO();
                    BeanUtils.copyProperties((Object)priceSheetOrgPO, (Object)bo);
                    bo.setOrgLevelStr(escaMap.get("ORG_LEVEL_STR").get(priceSheetOrgPO.getOrgLevel()));
                    priceSheetOrgBOList.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u8303\u56f4\u62a5\u9519");
            throw new BusinessException("9999", "\u62a5\u4ef7\u5355\u9002\u7528\u516c\u53f8\u8303\u56f4\u62a5\u9519" + e.getMessage());
        }
        ArrayList<PriceSheetCheckBO> shecks = new ArrayList<PriceSheetCheckBO>();
        try {
            List<PriceSheetCheckPO> check = this.priceSheetCheckDAO.selectBySheetId(reqBO.getSheetId());
            if (!CollectionUtils.isEmpty(check)) {
                PriceSheetCheckBO bo2 = null;
                for (PriceSheetCheckPO ch : check) {
                    bo2 = new PriceSheetCheckBO();
                    BeanUtils.copyProperties((Object)ch, (Object)bo2);
                    shecks.add(bo2);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6838\u62a5\u9519");
            throw new BusinessException("9999", "\u5ba1\u6838\u62a5\u9519" + e.getMessage());
        }
        result.setPriceSheetCheckBOList(shecks);
        result.setPriceSheetBO(priceSheetBO);
        result.setPriceSheetItemBOList(priceSheetItemBOList);
        result.setPriceSheetOrgBOList(priceSheetOrgBOList);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }

    public BaseRspBO headquarterAdd(HeadquarterOfferAddReqBO reqBO) {
        Object record;
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u603b\u90e8\u62a5\u4ef7\u5355\u65b0\u589e\uff1a");
        if (reqBO.getPriceSheetBO() == null || CollectionUtils.isEmpty((Collection)reqBO.getPriceSheetItemBOList()) || CollectionUtils.isEmpty((Collection)reqBO.getPriceSheetOrgBOList())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String sheetNo = sdf.format(new Date());
        StringBuffer orgRange = new StringBuffer();
        for (PriceSheetOrgBO priceSheetOrgBO : reqBO.getPriceSheetOrgBOList()) {
            orgRange.append(priceSheetOrgBO.getOrgName() + ",");
        }
        Long sheetId = 0L;
        try {
            logger.debug("\u65b0\u589e\u62a5\u4ef7\u5355");
            PriceSheetPO record2 = new PriceSheetPO();
            BeanUtils.copyProperties((Object)reqBO.getPriceSheetBO(), (Object)record2);
            record2.setSheetLevel("1");
            record2.setSheetNo(sheetNo);
            record2.setCheckStatus("01");
            record2.setOrgRange(orgRange.substring(0, orgRange.length() - 1));
            record2.setCreateTime(new Date());
            this.priceSheetDAO.insertSelective(record2);
            sheetId = record2.getSheetId();
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u62a5\u4ef7\u5355\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5355\u62a5\u9519" + e.getMessage());
        }
        ArrayList<String> matreialIds = new ArrayList<String>();
        try {
            logger.debug("\u65b0\u589e\u62a5\u4ef7\u5355\u660e\u7ec6");
            logger.debug("id:" + sheetId);
            ArrayList<DPriceSheetItemBO> reqList = new ArrayList<DPriceSheetItemBO>();
            DPriceSheetItemBO bo = null;
            for (PriceSheetItemBO iBo : reqBO.getPriceSheetItemBOList()) {
                matreialIds.add(iBo.getMaterialId());
                bo = new DPriceSheetItemBO();
                BeanUtils.copyProperties((Object)iBo, (Object)bo);
                bo.setSheetId(sheetId);
                bo.setSheetNo(sheetNo);
                bo.setSheetLevel("1");
                bo.setGoodsLevel("1");
                bo.setIsRootControl("1");
                bo.setIsCover("1");
                bo.setPurchaseFloorPrice(iBo.getPurchaseFloorPriceStr() == null ? null : iBo.getPurchaseFloorPriceStr().toString());
                bo.setRetailAgreementPrice(iBo.getRetailAgreementPriceStr() == null ? null : iBo.getTheCostDownPriceStr().toString());
                bo.setCitiesLockPrice(iBo.getCitiesLockPriceStr() == null ? null : iBo.getCitiesLockPriceStr().toString());
                bo.setTheCostDownPrice(iBo.getTheCostDownPriceStr() == null ? null : iBo.getTheCostDownPriceStr().toString());
                bo.setAgreementPrice(iBo.getAgreementPriceStr() == null ? null : iBo.getAgreementPriceStr().toString());
                bo.setAssessmentPrice(iBo.getAssessmentPriceStr() == null ? null : iBo.getAssessmentPriceStr().toString());
                bo.setCostPrice(iBo.getCostPriceStr() == null ? null : iBo.getCostPriceStr().toString());
                bo.setLastPurchasePrice(iBo.getLastPurchasePriceStr() == null ? null : iBo.getLastPurchasePriceStr().toString());
                bo.setTradePrice(iBo.getTradePriceStr() == null ? null : iBo.getTradePriceStr().toString());
                bo.setSparePrice5(iBo.getSparePrice5Str() == null ? null : iBo.getSparePrice5Str().toString());
                bo.setSparePrice4(iBo.getSparePrice4Str() == null ? null : iBo.getSparePrice4Str().toString());
                bo.setSparePrice3(iBo.getSparePrice3Str() == null ? null : iBo.getSparePrice3Str().toString());
                bo.setSparePrice2(iBo.getSparePrice2Str() == null ? null : iBo.getSparePrice2Str().toString());
                bo.setSalePrice(iBo.getSalePriceStr() == null ? null : iBo.getSalePriceStr().toString());
                bo.setPurchasePrice(iBo.getPurchasePriceStr() == null ? null : iBo.getPurchasePriceStr().toString());
                bo.setProvAgreePrice(iBo.getProvAgreePriceStr() == null ? null : iBo.getProvAgreePriceStr().toString());
                bo.setMemberPrice(iBo.getMemberPriceStr() == null ? null : iBo.getMemberPriceStr().toString());
                bo.setMemberLadderPrice5(iBo.getMemberLadderPrice5Str() == null ? null : iBo.getMemberLadderPrice5Str().toString());
                bo.setMemberLadderPrice4(iBo.getMemberLadderPrice4Str() == null ? null : iBo.getMemberLadderPrice4Str().toString());
                bo.setMemberLadderPrice3(iBo.getMemberLadderPrice3Str() == null ? null : iBo.getMemberLadderPrice3Str().toString());
                bo.setMemberLadderPrice2(iBo.getMemberLadderPrice2Str() == null ? null : iBo.getMemberLadderPrice2Str().toString());
                bo.setMemberLadderPrice1(iBo.getMemberLadderPrice1Str() == null ? null : iBo.getMemberLadderPrice1Str().toString());
                reqList.add(bo);
            }
            this.dPriceSheetItemManageService.insertSheetItemBatch(reqList);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u62a5\u4ef7\u5355\u660e\u7ec6\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5355\u660e\u7ec6\u62a5\u9519" + e.getMessage());
        }
        ArrayList<String> provCode = new ArrayList<String>();
        try {
            logger.debug("\u65b0\u589e\u516c\u53f8\u9002\u7528\u8303\u56f4");
            logger.debug("id:" + sheetId);
            record = new ArrayList<PriceSheetOrgPO>();
            PriceSheetOrgPO po = null;
            for (PriceSheetOrgBO oBo : reqBO.getPriceSheetOrgBOList()) {
                provCode.add(oBo.getProvinceCode());
                po = new PriceSheetOrgPO();
                BeanUtils.copyProperties((Object)oBo, (Object)po);
                po.setSheetId(sheetId);
                po.setOrgLevel(oBo.getOrgLevel());
                po.setCreateTime(new Date());
                po.setSheetNo(sheetNo);
                record.add(po);
            }
            this.priceSheetOrgDAO.insertList((List<PriceSheetOrgPO>)record);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u516c\u53f8\u9002\u7528\u8303\u56f4\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u516c\u53f8\u9002\u7528\u8303\u56f4\u62a5\u9519" + e.getMessage());
        }
        try {
            record = new ProvGoodsPO();
            ((ProvGoodsPO)record).setProvGoods(provCode);
            ((ProvGoodsPO)record).setMaterialIds(matreialIds);
            ((ProvGoodsPO)record).setHasPrice("1");
            this.provGoodsDAO.updateHasPrice((ProvGoodsPO)record);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u662f\u5426\u62a5\u4ef7\u5931\u8d25");
            throw new BusinessException("9999", "\u4fee\u6539\u662f\u5426\u62a5\u4ef7\u5931\u8d25" + e.getMessage());
        }
        try {
            ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
            PriceSheetAddThread priceSheetAddThread = new PriceSheetAddThread(this.xlsSkuMapper, this.xlsSkuPriceManageService, provCode, matreialIds, reqBO, sheetId);
            logger.debug("\u5f00\u542f\u5f02\u6b65\u7ebf\u7a0b");
            cachedThreadPool.execute(priceSheetAddThread);
            cachedThreadPool.shutdown();
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u4ef7\u683c\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u4ef7\u683c\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public BaseRspBO sheetAdd(HeadquarterOfferAddReqBO reqBO) {
        Object record;
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u62a5\u4ef7\u5355\u65b0\u589e\uff1a" + JSONObject.toJSONString((Object)reqBO));
        if (reqBO.getPriceSheetBO() == null || CollectionUtils.isEmpty((Collection)reqBO.getPriceSheetItemBOList()) || CollectionUtils.isEmpty((Collection)reqBO.getPriceSheetOrgBOList())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        String check = this.hasAllSheet(reqBO.getPriceSheetItemBOList(), reqBO.getmProvince());
        if (!StringUtils.isEmpty((CharSequence)check)) {
            result.setRespCode("8888");
            result.setRespDesc(check + "\u7269\u6599\u603b\u90e8\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u4fee\u6539");
            return result;
        }
        Long sheetId = 0L;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String sheetNo = sdf.format(new Date());
        StringBuffer orgRange = new StringBuffer();
        for (PriceSheetOrgBO priceSheetOrgBO : reqBO.getPriceSheetOrgBOList()) {
            orgRange.append(priceSheetOrgBO.getOrgName() + ",");
        }
        String sheetLevel = "";
        if ("2".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmProvince())) {
            sheetLevel = "2";
        } else if ("3".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmCity())) {
            sheetLevel = "3";
        } else if ("5".equals(reqBO.getmUserLevel()) && StringUtils.isNotBlank((CharSequence)reqBO.getmShopId())) {
            sheetLevel = "5";
        } else {
            logger.error("\u62a5\u4ef7\u5355\u67e5\u8be2\u7528\u6237\u6743\u9650\u4e0d\u8db3");
            return result;
        }
        try {
            logger.debug("\u65b0\u589e\u62a5\u4ef7\u5355");
            record = new PriceSheetPO();
            BeanUtils.copyProperties((Object)reqBO.getPriceSheetBO(), (Object)record);
            ((PriceSheetPO)record).setProvinceCode(reqBO.getmProvince());
            ((PriceSheetPO)record).setCityCode(reqBO.getmCity());
            ((PriceSheetPO)record).setShopCode(reqBO.getmShopId());
            ((PriceSheetPO)record).setSheetLevel(sheetLevel);
            ((PriceSheetPO)record).setCheckStatus("00");
            ((PriceSheetPO)record).setCreateTime(new Date());
            ((PriceSheetPO)record).setOrgRange(orgRange.substring(0, orgRange.length() - 1));
            ((PriceSheetPO)record).setSheetNo(sheetNo);
            this.priceSheetDAO.insertSelective((PriceSheetPO)record);
            sheetId = ((PriceSheetPO)record).getSheetId();
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u62a5\u4ef7\u5355\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5355\u62a5\u9519" + e.getMessage());
        }
        try {
            logger.debug("\u65b0\u589e\u62a5\u4ef7\u5355\u660e\u7ec6" + JSON.toJSONString((Object)reqBO.getPriceSheetItemBOList()));
            logger.debug("id:" + sheetId);
            ArrayList<DPriceSheetItemBO> reqList = new ArrayList<DPriceSheetItemBO>();
            DPriceSheetItemBO bo = null;
            for (PriceSheetItemBO iBo : reqBO.getPriceSheetItemBOList()) {
                bo = new DPriceSheetItemBO();
                BeanUtils.copyProperties((Object)iBo, (Object)bo);
                bo.setSheetId(sheetId);
                bo.setSheetNo(sheetNo);
                bo.setSheetLevel(sheetLevel);
                bo.setIsRootControl("0");
                bo.setPurchaseFloorPrice(iBo.getPurchaseFloorPriceStr() == null ? null : iBo.getPurchaseFloorPriceStr().toString());
                bo.setRetailAgreementPrice(iBo.getRetailAgreementPriceStr() == null ? null : iBo.getTheCostDownPriceStr().toString());
                bo.setCitiesLockPrice(iBo.getCitiesLockPriceStr() == null ? null : iBo.getCitiesLockPriceStr().toString());
                bo.setTheCostDownPrice(iBo.getTheCostDownPriceStr() == null ? null : iBo.getTheCostDownPriceStr().toString());
                bo.setAgreementPrice(iBo.getAgreementPriceStr() == null ? null : iBo.getAgreementPriceStr().toString());
                bo.setAssessmentPrice(iBo.getAssessmentPriceStr() == null ? null : iBo.getAssessmentPriceStr().toString());
                bo.setCostPrice(iBo.getCostPriceStr() == null ? null : iBo.getCostPriceStr().toString());
                bo.setLastPurchasePrice(iBo.getLastPurchasePriceStr() == null ? null : iBo.getLastPurchasePriceStr().toString());
                bo.setTradePrice(iBo.getTradePriceStr() == null ? null : iBo.getTradePriceStr().toString());
                bo.setSparePrice5(iBo.getSparePrice5Str() == null ? null : iBo.getSparePrice5Str().toString());
                bo.setSparePrice4(iBo.getSparePrice4Str() == null ? null : iBo.getSparePrice4Str().toString());
                bo.setSparePrice3(iBo.getSparePrice3Str() == null ? null : iBo.getSparePrice3Str().toString());
                bo.setSparePrice2(iBo.getSparePrice2Str() == null ? null : iBo.getSparePrice2Str().toString());
                bo.setSalePrice(iBo.getSalePriceStr() == null ? null : iBo.getSalePriceStr().toString());
                bo.setPurchasePrice(iBo.getPurchasePriceStr() == null ? null : iBo.getPurchasePriceStr().toString());
                bo.setProvAgreePrice(iBo.getProvAgreePriceStr() == null ? null : iBo.getProvAgreePriceStr().toString());
                bo.setMemberPrice(iBo.getMemberPriceStr() == null ? null : iBo.getMemberPriceStr().toString());
                bo.setMemberLadderPrice5(iBo.getMemberLadderPrice5Str() == null ? null : iBo.getMemberLadderPrice5Str().toString());
                bo.setMemberLadderPrice4(iBo.getMemberLadderPrice4Str() == null ? null : iBo.getMemberLadderPrice4Str().toString());
                bo.setMemberLadderPrice3(iBo.getMemberLadderPrice3Str() == null ? null : iBo.getMemberLadderPrice3Str().toString());
                bo.setMemberLadderPrice2(iBo.getMemberLadderPrice2Str() == null ? null : iBo.getMemberLadderPrice2Str().toString());
                bo.setMemberLadderPrice1(iBo.getMemberLadderPrice1Str() == null ? null : iBo.getMemberLadderPrice1Str().toString());
                reqList.add(bo);
            }
            this.dPriceSheetItemManageService.insertSheetItemBatch(reqList);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u62a5\u4ef7\u5355\u660e\u7ec6\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5355\u660e\u7ec6\u62a5\u9519" + e.getMessage());
        }
        try {
            logger.debug("\u65b0\u589e\u516c\u53f8\u9002\u7528\u8303\u56f4");
            record = new ArrayList();
            logger.debug("id:" + sheetId);
            PriceSheetOrgPO po = null;
            for (PriceSheetOrgBO oBo : reqBO.getPriceSheetOrgBOList()) {
                po = new PriceSheetOrgPO();
                BeanUtils.copyProperties((Object)oBo, (Object)po);
                po.setSheetId(sheetId);
                po.setCreateTime(new Date());
                po.setSheetNo(sheetNo);
                po.setOrgLevel(oBo.getOrgLevel());
                record.add(po);
            }
            this.priceSheetOrgDAO.insertList((List<PriceSheetOrgPO>)record);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u516c\u53f8\u9002\u7528\u8303\u56f4\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u516c\u53f8\u9002\u7528\u8303\u56f4\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public BaseRspBO deleteSheet(PriceSheetBO reqBO) {
        logger.debug("\u62a5\u4ef7\u5355\u5220\u9664");
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getSheetId() == null) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        PriceSheetPO record = new PriceSheetPO();
        record.setSheetId(reqBO.getSheetId());
        record.setIsValid("0");
        try {
            this.priceSheetDAO.updateByPrimaryKeySelective(record);
            this.priceSheetItemDAO.deleteBySheetId(reqBO.getSheetId());
            this.priceSheetOrgDAO.deleteBySheetId(reqBO.getSheetId());
        }
        catch (Exception e) {
            logger.error("\u62a5\u4ef7\u5355\u5220\u9664\u62a5\u9519");
            throw new BusinessException("9999", "\u62a5\u4ef7\u5355\u5220\u9664\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public String hasAllSheet(List<PriceSheetItemBO> priceSheetItemBOList, String provCode) {
        ArrayList<String> materiaIds = new ArrayList<String>();
        for (PriceSheetItemBO bo : priceSheetItemBOList) {
            materiaIds.add(bo.getMaterialId());
        }
        ArrayList<String> back = new ArrayList<String>();
        List<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvAndMaterial(provCode, materiaIds);
        if (!CollectionUtils.isEmpty(poList)) {
            for (ProvGoodsPO po : poList) {
                if (!"1".equals(po.getHasPrice()) || !"0".equals(po.getReservedField3())) continue;
                back.add(po.getMaterialId());
            }
            if (!CollectionUtils.isEmpty(back)) {
                return ((Object)back).toString();
            }
        }
        return null;
    }
}

