/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.toolkit.util.TkExcelUtils;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.ModelGroupService;
import com.xls.commodity.busi.sku.bo.GetTempResBO;
import com.xls.commodity.busi.sku.bo.ImportModelResBO;
import com.xls.commodity.busi.sku.bo.ImportProvGoodsReqBO;
import com.xls.commodity.busi.sku.bo.ModeFaildBO;
import com.xls.commodity.busi.sku.bo.ModelGroupBO;
import com.xls.commodity.busi.sku.bo.ModelGroupMaterialBO;
import com.xls.commodity.busi.sku.bo.ModelGroupReqBO;
import com.xls.commodity.busi.sku.bo.ModelGroupResBO;
import com.xls.commodity.busi.sku.bo.ModelSuccessBO;
import com.xls.commodity.dao.DmodelGroupDAO;
import com.xls.commodity.dao.DmodelGroupMaterialDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.po.DmodelGroupMaterialPO;
import com.xls.commodity.dao.po.DmodelGroupPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import com.xls.commodity.util.SCSOssFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ModelGroupServiceImpl
implements ModelGroupService {
    private static final Logger logger = LoggerFactory.getLogger(ModelGroupServiceImpl.class);
    @Autowired
    private DmodelGroupDAO dmodelGroupDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private DmodelGroupMaterialDAO dmodelGroupMaterialDAO;
    @Value(value="${model.import.temp}")
    private String importTemp;
    @Value(value="${model.import.path}")
    private String importPath;
    private List<ModeFaildBO> fild;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;

    public RspPageBO<ModelGroupBO> queryModelGroup(ModelGroupReqBO reqBO) {
        RspPageBO result = new RspPageBO();
        logger.debug("\u8c03\u7528\u673a\u578b\u7ec4\u5206\u9875\u67e5\u8be2" + JSONObject.toJSONString((Object)reqBO));
        DmodelGroupPO record = new DmodelGroupPO();
        record.setModelGroupName(reqBO.getModelGroupName());
        record.setSecurityServicesType(reqBO.getSecurityServicesType());
        record.setModelGroupType(StringUtils.isBlank((String)reqBO.getModelGroupType()) ? reqBO.getmUserLevel() : reqBO.getModelGroupType());
        record.setApplyProvince(reqBO.getmProvince());
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        ArrayList<ModelGroupBO> rows = new ArrayList<ModelGroupBO>();
        try {
            List<DmodelGroupPO> poList = this.dmodelGroupDAO.selectByCondition(record, (Page<DmodelGroupPO>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                Map<String, String> map = this.sysParamsAtomService.selectByParentCode("BUSINESS_TYPE");
                ModelGroupBO bo = null;
                for (DmodelGroupPO po : poList) {
                    bo = new ModelGroupBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setSecurityServicesTypeStr(map.get(po.getSecurityServicesType()));
                    String provinceName = "";
                    if (StringUtils.isNotEmpty((String)po.getApplyProvince())) {
                        provinceName = this.getProvinceName(po.getApplyProvince());
                    }
                    bo.setApplyProvinceStr(provinceName);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u673a\u578b\u7ec4\u5206\u9875\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u673a\u578b\u7ec4\u5206\u9875\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public BaseRspBO insertModelGroup(ModelGroupBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u8c03\u7528\u673a\u578b\u7ec4\u65b0\u589e" + JSONObject.toJSONString((Object)reqBO));
        String check = this.check(reqBO);
        if (null != check) {
            result.setRespCode("8888");
            result.setRespDesc(check);
            return result;
        }
        DmodelGroupPO record = new DmodelGroupPO();
        Long id = Sequence.getInstance().nextId();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setId(id);
        record.setCreateTime(new Date());
        record.setIsVaild("1");
        record.setModelGroupType(StringUtils.isBlank((String)reqBO.getModelGroupType()) ? reqBO.getmUserLevel() : reqBO.getModelGroupType());
        logger.debug("\u63d2\u5165\u673a\u578b\u7ec4");
        try {
            this.dmodelGroupDAO.insertModelGroup(record);
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u673a\u578b\u7ec4\u62a5\u9519");
            throw new BusinessException("9999", "\u63d2\u5165\u673a\u578b\u7ec4\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u63d2\u5165\u673a\u578b\u7ec4\u5546\u54c1");
        ArrayList<DmodelGroupMaterialPO> goodsList = new ArrayList<DmodelGroupMaterialPO>();
        DmodelGroupMaterialPO po = null;
        for (ModelGroupMaterialBO bo : reqBO.getModelGroupMaterial()) {
            po = new DmodelGroupMaterialPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setModelGroupId(id);
            po.setCreateTime(new Date());
            po.setIsValid("1");
            goodsList.add(po);
        }
        try {
            this.dmodelGroupMaterialDAO.insertGroupMateria(goodsList);
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u673a\u578b\u7ec4\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u63d2\u5165\u673a\u578b\u7ec4\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public BaseRspBO updateModelGroup(ModelGroupBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u8c03\u7528\u673a\u578b\u7ec4\u4fee\u6539" + JSONObject.toJSONString((Object)reqBO));
        String check = this.check(reqBO);
        if (null != check) {
            result.setRespCode("8888");
            result.setRespDesc(check);
            return result;
        }
        DmodelGroupPO record = new DmodelGroupPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)record);
        record.setUpdateTime(new Date());
        logger.debug("\u66f4\u65b0\u673a\u578b\u7ec4");
        try {
            this.dmodelGroupDAO.updateModelGroup(record);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u673a\u578b\u7ec4\u62a5\u9519");
            throw new BusinessException("9999", "\u66f4\u65b0\u673a\u578b\u7ec4\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u5220\u9664\u673a\u578b\u5546\u54c1");
        try {
            this.dmodelGroupMaterialDAO.deleteById(reqBO.getId());
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u673a\u578b\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u5220\u9664\u673a\u578b\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u65b0\u589e\u673a\u578b\u5546\u54c1");
        ArrayList<DmodelGroupMaterialPO> goodsList = new ArrayList<DmodelGroupMaterialPO>();
        DmodelGroupMaterialPO po = null;
        for (ModelGroupMaterialBO bo : reqBO.getModelGroupMaterial()) {
            po = new DmodelGroupMaterialPO();
            BeanUtils.copyProperties((Object)bo, (Object)po);
            po.setModelGroupId(reqBO.getId());
            po.setCreateTime(new Date());
            po.setIsValid("1");
            goodsList.add(po);
        }
        try {
            this.dmodelGroupMaterialDAO.insertGroupMateria(goodsList);
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u673a\u578b\u7ec4\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u63d2\u5165\u673a\u578b\u7ec4\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public ModelGroupResBO getDetailById(ModelGroupReqBO reqBO) {
        ModelGroupResBO result = new ModelGroupResBO();
        logger.debug("\u8c03\u7528\u673a\u578b\u7ec4\u8be6\u60c5\u67e5\u8be2");
        DmodelGroupPO po = new DmodelGroupPO();
        try {
            po = this.dmodelGroupDAO.selectById(reqBO.getId());
        }
        catch (Exception e) {
            logger.error("\u673a\u578b\u7ec4\u8be6\u60c5\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "\u673a\u578b\u7ec4\u8be6\u60c5\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u67e5\u8be2\u673a\u578b\u7ec4\u5546\u54c1");
        List<Object> goodsList = new ArrayList();
        try {
            DmodelGroupMaterialPO goodsPo = new DmodelGroupMaterialPO();
            goodsPo.setModelGroupId(reqBO.getId());
            goodsList = this.dmodelGroupMaterialDAO.selectGroupMateria(goodsPo);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u673a\u578b\u7ec4\u5546\u54c1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u673a\u578b\u7ec4\u5546\u54c1\u62a5\u9519" + e.getMessage());
        }
        ModelGroupBO detail = new ModelGroupBO();
        ArrayList<ModelGroupMaterialBO> modelGroupMaterial = new ArrayList<ModelGroupMaterialBO>();
        if (po != null) {
            BeanUtils.copyProperties((Object)po, (Object)detail);
            Map<String, String> map = this.sysParamsAtomService.selectByParentCode("BUSINESS_TYPE");
            detail.setSecurityServicesTypeStr(map.get(po.getSecurityServicesType()));
            String provinceName = "";
            if (StringUtils.isNotEmpty((String)po.getApplyProvince())) {
                provinceName = this.getProvinceName(po.getApplyProvince());
            }
            detail.setApplyProvinceStr(provinceName);
        }
        if (!CollectionUtils.isEmpty(goodsList)) {
            ModelGroupMaterialBO bo = null;
            for (DmodelGroupMaterialPO dmodelGroupMaterialPO : goodsList) {
                bo = new ModelGroupMaterialBO();
                BeanUtils.copyProperties((Object)dmodelGroupMaterialPO, (Object)bo);
                modelGroupMaterial.add(bo);
            }
        }
        detail.setModelGroupMaterial(modelGroupMaterial);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setModel(detail);
        return result;
    }

    public String check(ModelGroupBO reqBO) {
        if (StringUtils.isBlank((String)reqBO.getModelGroupName())) {
            return "\u673a\u578b\u7ec4\u540d\u79f0\u4e3a\u7a7a";
        }
        if (StringUtils.isBlank((String)reqBO.getSecurityServicesType())) {
            return "\u4fdd\u969c\u670d\u52a1\u7c7b\u578b\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getModelGroupMaterial())) {
            return "\u673a\u578b\u7ec4\u5546\u54c1\u4e3a\u7a7a";
        }
        for (ModelGroupMaterialBO bo : reqBO.getModelGroupMaterial()) {
            if (StringUtils.isBlank((String)bo.getMaterialId())) {
                return "\u673a\u578b\u7ec4\u5546\u54c1\u7269\u6599\u4e3a\u7a7a";
            }
            if (!StringUtils.isBlank((String)bo.getCommoditytName())) continue;
            return "\u673a\u578b\u7ec4\u5546\u54c1\u540d\u79f0\u4e3a\u7a7a";
        }
        return null;
    }

    public RspInfoListBO<ModelGroupBO> queryModelGroupNoPage(ModelGroupReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        logger.debug("\u8c03\u7528\u673a\u578b\u7ec4\u67e5\u8be2" + JSONObject.toJSONString((Object)reqBO));
        DmodelGroupPO record = new DmodelGroupPO();
        record.setModelGroupName(reqBO.getModelGroupName());
        record.setSecurityServicesType(reqBO.getSecurityServicesType());
        record.setModelGroupType(StringUtils.isBlank((String)reqBO.getModelGroupType()) ? reqBO.getmUserLevel() : reqBO.getModelGroupType());
        record.setApplyProvince(reqBO.getmProvince());
        ArrayList<ModelGroupBO> rows = new ArrayList<ModelGroupBO>();
        try {
            List<DmodelGroupPO> poList = this.dmodelGroupDAO.selectByCondition(record);
            if (!CollectionUtils.isEmpty(poList)) {
                Map<String, String> map = this.sysParamsAtomService.selectByParentCode("BUSINESS_TYPE");
                ModelGroupBO bo = null;
                for (DmodelGroupPO po : poList) {
                    bo = new ModelGroupBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    bo.setSecurityServicesTypeStr(map.get(po.getSecurityServicesType()));
                    String provinceName = "";
                    if (StringUtils.isNotEmpty((String)po.getApplyProvince())) {
                        provinceName = this.getProvinceName(po.getApplyProvince());
                    }
                    bo.setApplyProvinceStr(provinceName);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u673a\u578b\u7ec4\u67e5\u8be2\u62a5\u9519");
            throw new BusinessException("9999", "\u8c03\u7528\u673a\u578b\u7ec4\u67e5\u8be2\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public String getProvinceName(String provinceCode) {
        List<String> prov = Arrays.asList(provinceCode.split(","));
        String proName = "";
        for (String str : prov) {
            String key = "AUTHORITY_TYPE_area_code_" + str;
            logger.debug("key" + key);
            Object value = this.cacheClient.get(key);
            logger.debug("value" + value);
            if (value == null) continue;
            proName = proName + value.toString() + ",";
        }
        return StringUtils.isBlank((String)proName) ? "" : proName.substring(0, proName.length() - 1);
    }

    public RspInfoListBO<ModelGroupBO> queryModelByMaterial(ModelGroupReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<ModelGroupBO> rows = new ArrayList<ModelGroupBO>();
        List<DmodelGroupPO> poList = this.dmodelGroupDAO.selectModelByMaterial(reqBO.getMaterialId());
        if (!CollectionUtils.isEmpty(poList)) {
            ModelGroupBO bo = null;
            for (DmodelGroupPO po : poList) {
                bo = new ModelGroupBO();
                BeanUtils.copyProperties((Object)po, (Object)bo);
                rows.add(bo);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        result.setRows(rows);
        return result;
    }

    public GetTempResBO getTemp() {
        GetTempResBO result = new GetTempResBO();
        if (StringUtils.isBlank((String)this.importTemp)) {
            result.setRespCode("8888");
            result.setRespDesc("\u672a\u914d\u7f6e\u5546\u54c1\u5bfc\u5165\u6a21\u677f\u6a21\u677f\u4e0b\u8f7d\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setData(this.importTemp);
        return result;
    }

    public ImportModelResBO importComm(ImportProvGoodsReqBO reqBO) {
        File file;
        ImportModelResBO result = new ImportModelResBO();
        if (StringUtils.isEmpty((String)reqBO.getFileName())) {
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            return result;
        }
        try {
            file = SCSOssFileUtils.downloadFileFromPath(this.importPath + reqBO.getFileName(), null, true);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            return result;
        }
        if (null == file || !file.exists()) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String suffix = TkExcelUtils.getSuffix((String)file.getPath());
        if (null != suffix) {
            suffix = suffix.toLowerCase();
        }
        List<Object> rows = new ArrayList();
        try {
            rows = this.readXlsx(file.getPath(), suffix, reqBO.getProvinceCode());
        }
        catch (ResourceException e) {
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode(e.getMsgCode());
            result.setRespDesc(e.getMessage());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setSuccess(rows);
        result.setFaild(this.fild);
        return result;
    }

    public List<ModelSuccessBO> readXlsx(String path, String suffix, String provinceCode) {
        ArrayList<ModelSuccessBO> list = new ArrayList<ModelSuccessBO>();
        ArrayList rows = null;
        if ("xls".equals(suffix)) {
            List hssfRows = TkExcelUtils.readXls((String)path, (int)0, (int)2);
            rows = new ArrayList(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List xssfRows = TkExcelUtils.readXlsx((String)path, (int)0, (int)2);
            rows = new ArrayList(xssfRows);
        } else {
            logger.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
            throw new ResourceException("0007", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
        }
        if (CollectionUtils.isEmpty(rows)) {
            logger.error("\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
            throw new ResourceException("0016", "\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
        }
        this.fild = new ArrayList<ModeFaildBO>(rows.size());
        ArrayList<String> material = new ArrayList<String>();
        boolean isDecimal = false;
        for (Row row : rows) {
            if (!StringUtils.isNotEmpty((String)TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal))) continue;
            material.add(TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal).trim());
        }
        Map<String, String> goodstype = this.sysParamsAtomService.selectByParentCode("ERP_GOODS_TYPE");
        Map<String, String> screenTypeMap = this.sysParamsAtomService.selectByParentCode("SCREEN_TYPE");
        Map<String, ProvGoodsPO> provGoodsMap = this.getProvGoods(material, provinceCode);
        for (Row row : rows) {
            ModeFaildBO fbo;
            String materialId = TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal);
            if (StringUtils.isBlank((String)materialId)) {
                fbo = new ModeFaildBO();
                logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                fbo.setFaildDesc("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
                fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                this.fild.add(fbo);
                continue;
            }
            if (!provGoodsMap.containsKey(materialId)) {
                fbo = new ModeFaildBO();
                logger.debug("\u672a\u67e5\u8be2\u5230\u8be5\u7269\u6599");
                fbo.setFaildDesc("\u672a\u67e5\u8be2\u5230\u8be5\u7269\u6599");
                fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                this.fild.add(fbo);
                continue;
            }
            String goodsLongName = provGoodsMap.get(materialId).getGoodsLongName();
            String erpGoodsType = goodstype.get(provGoodsMap.get(materialId).getErpGoodsType());
            String brandName = provGoodsMap.get(materialId).getBrandName();
            String colorName = provGoodsMap.get(materialId).getColorName();
            String memoryName = provGoodsMap.get(materialId).getScreenType();
            String screenType = screenTypeMap.get(provGoodsMap.get(materialId).getGoodsLongName());
            String hasSerialNumber = provGoodsMap.get(materialId).getHasSerialNumber();
            ModelSuccessBO bo = new ModelSuccessBO();
            bo.setMaterialId(materialId);
            bo.setGoodsLongName(goodsLongName);
            bo.setErpGoodsType(erpGoodsType);
            bo.setBrandName(brandName);
            bo.setColorName(colorName);
            bo.setMemoryName(memoryName);
            bo.setScreenType(screenType);
            bo.setHasSerialNumber(hasSerialNumber);
            list.add(bo);
        }
        return list;
    }

    public Map<String, ProvGoodsPO> getProvGoods(List<String> materialIds, String provCode) {
        HashMap<String, ProvGoodsPO> map = new HashMap<String, ProvGoodsPO>();
        List<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvAndMaterial(provCode, materialIds);
        if (!CollectionUtils.isEmpty(poList)) {
            for (ProvGoodsPO po : poList) {
                if (map.containsKey(po.getMaterialId())) continue;
                map.put(po.getMaterialId(), po);
            }
        }
        return map;
    }
}

