/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.atom.sku.XlsSkuPriceManageService;
import com.xls.commodity.busi.sku.PriceSheetChectService;
import com.xls.commodity.busi.sku.bo.DPriceSheetCheckBO;
import com.xls.commodity.busi.sku.bo.DPriceSheetCheckReqBO;
import com.xls.commodity.busi.sku.bo.PriceBO;
import com.xls.commodity.dao.PriceSheetCheckDAO;
import com.xls.commodity.dao.PriceSheetDAO;
import com.xls.commodity.dao.PriceSheetItemDAO;
import com.xls.commodity.dao.PriceSheetOrgDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.PriceSheetCheckPO;
import com.xls.commodity.dao.po.PriceSheetItemPO;
import com.xls.commodity.dao.po.PriceSheetOrgPO;
import com.xls.commodity.dao.po.PriceSheetPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.util.TkHttpRequestUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PriceSheetChectServiceImpl
implements PriceSheetChectService {
    private static final Logger logger = LoggerFactory.getLogger(PriceSheetChectServiceImpl.class);
    @Autowired
    private PriceSheetCheckDAO priceSheetCheckDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private PriceSheetItemDAO priceSheetItemDAO;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuPriceMapper skuPriceMapper;
    @Autowired
    private XlsSkuPriceManageService xlsSkuPriceManageService;
    @Autowired
    private PriceSheetDAO priceSheetDAO;
    @Autowired
    private PriceSheetOrgDAO priceSheetOrgDAO;
    @Value(value="${getProvience}")
    private String url;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    private Set<String> faild;

    public BaseRspBO priceSheetChect(DPriceSheetCheckReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getdPriceSheetCheckBO())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        for (DPriceSheetCheckBO dPriceSheetCheckBO : reqBO.getdPriceSheetCheckBO()) {
            if (dPriceSheetCheckBO.getSheetId() != null && !StringUtils.isEmpty((String)dPriceSheetCheckBO.getCheckStatus())) continue;
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ArrayList<Long> sheetIds = new ArrayList<Long>();
        try {
            boolean flag = false;
            if ("02".equals(((DPriceSheetCheckBO)reqBO.getdPriceSheetCheckBO().get(0)).getCheckStatus())) {
                flag = true;
            }
            ArrayList<PriceSheetCheckPO> priceSheetCheckPO = new ArrayList<PriceSheetCheckPO>();
            PriceSheetCheckPO po = null;
            ArrayList<PriceSheetPO> priceSheetPOList = new ArrayList<PriceSheetPO>();
            PriceSheetPO priceSheetPO = null;
            for (DPriceSheetCheckBO dPriceSheetCheckBO : reqBO.getdPriceSheetCheckBO()) {
                priceSheetPO = new PriceSheetPO();
                priceSheetPO.setSheetId(dPriceSheetCheckBO.getSheetId());
                priceSheetPO.setUpdateTime(new Date());
                priceSheetPO.setCheckStatus(dPriceSheetCheckBO.getCheckStatus());
                priceSheetPOList.add(priceSheetPO);
                sheetIds.add(dPriceSheetCheckBO.getSheetId());
                po = new PriceSheetCheckPO();
                BeanUtils.copyProperties((Object)dPriceSheetCheckBO, (Object)po);
                po.setCheckTime(new Date());
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                po.setCreateTime(dateFormat.format(new Date()));
                priceSheetCheckPO.add(po);
            }
            this.add(priceSheetCheckPO);
            this.priceSheetDAO.updateList(priceSheetPOList);
            if (flag) {
                result.setRespCode("0000");
                result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
                return result;
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5ba1\u6838\u63d2\u5165\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5ba1\u6838\u63d2\u5165\u62a5\u9519" + e.getMessage());
        }
        try {
            for (DPriceSheetCheckBO dPriceSheetCheckBO : reqBO.getdPriceSheetCheckBO()) {
                ArrayList<Long> sheetId = new ArrayList<Long>();
                sheetId.add(dPriceSheetCheckBO.getSheetId());
                this.check(sheetId);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u62a5\u4ef7\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        if (CollectionUtils.isEmpty(this.faild)) {
            result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        } else {
            result.setRespDesc(this.faild.toString());
        }
        return result;
    }

    public void check(List<Long> sheetIds) {
        ArrayList<PriceSheetItemPO> item = new ArrayList();
        ArrayList<PriceSheetOrgPO> org = new ArrayList();
        try {
            logger.debug("\u67e5\u8be2\u62a5\u4ef7\u5355\u8be6\u60c5");
            item = this.priceSheetItemDAO.selectBySheetIds(sheetIds);
            org = this.priceSheetOrgDAO.selectBySheetIds(sheetIds);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u62a5\u4ef7\u5355\u8be6\u60c5\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u62a5\u4ef7\u5355\u8be6\u60c5\u62a5\u9519" + e.getMessage());
        }
        HashMap<String, PriceSheetItemPO> itemMap = new HashMap<String, PriceSheetItemPO>();
        logger.debug("\u533a\u5206\u662f\u5426\u5168\u8986\u76d6");
        ArrayList<PriceSheetItemPO> coverChangeList = new ArrayList<PriceSheetItemPO>();
        ArrayList<PriceSheetItemPO> noCoverChangeList = new ArrayList<PriceSheetItemPO>();
        ArrayList<PriceSheetItemPO> coverNoChangeList = new ArrayList<PriceSheetItemPO>();
        ArrayList<PriceSheetItemPO> noCoverNoChangeList = new ArrayList<PriceSheetItemPO>();
        Map<String, String> provGoodsMap = this.getIsChange(item, org);
        for (PriceSheetItemPO ite : item) {
            if ("1".equals(ite.getIsCover())) {
                if ("1".equals(provGoodsMap.get(ite.getMaterialId()))) {
                    coverChangeList.add(ite);
                } else if ("0".equals(provGoodsMap.get(ite.getMaterialId()))) {
                    coverNoChangeList.add(ite);
                }
            } else if ("1".equals(provGoodsMap.get(ite.getMaterialId()))) {
                noCoverChangeList.add(ite);
            } else if ("0".equals(provGoodsMap.get(ite.getMaterialId()))) {
                noCoverNoChangeList.add(ite);
            }
            if (itemMap.containsKey(ite.getMaterialId().trim())) continue;
            itemMap.put(ite.getMaterialId().trim(), ite);
        }
        this.faild = new HashSet<String>();
        try {
            if (!CollectionUtils.isEmpty(coverChangeList)) {
                this.method(coverChangeList, itemMap, 1, org);
            }
            if (!CollectionUtils.isEmpty(noCoverChangeList)) {
                this.method(noCoverChangeList, itemMap, 3, org);
            }
            if (!CollectionUtils.isEmpty(coverNoChangeList)) {
                this.method(coverNoChangeList, itemMap, 4, org);
            }
            if (!CollectionUtils.isEmpty(noCoverNoChangeList)) {
                this.method(noCoverNoChangeList, itemMap, 2, org);
            }
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u62a5\u4ef7\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
    }

    public void add(List<PriceSheetCheckPO> po) throws Exception {
        this.priceSheetCheckDAO.insertList(po);
    }

    public List<Sku> getPrice(List<Sku> param, int flag) throws Exception {
        ArrayList<Sku> sku = new ArrayList<Sku>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        for (Sku sk : param) {
            skuIds.add(sk.getSkuId());
        }
        HashMap<Long, SkuPrice> priceMap = new HashMap<Long, SkuPrice>();
        List price = this.skuPriceMapper.selectBySkuIds(skuIds);
        if (!CollectionUtils.isEmpty((Collection)price)) {
            for (SkuPrice pric : price) {
                if (priceMap.containsKey(pric.getSkuId())) continue;
                priceMap.put(pric.getSkuId(), pric);
            }
        }
        for (Sku sk : param) {
            switch (flag) {
                case 1: {
                    if (priceMap.containsKey(sk.getSkuId()) && "1".equals(((SkuPrice)priceMap.get(sk.getSkuId())).getSheetLevel())) {
                        sk.setSheetLevel("1");
                    }
                    sku.add(sk);
                    break;
                }
                case 2: {
                    this.faild.add(sk.getMaterialId() + "\uff1a\u7269\u6599\u4e0d\u53ef\u4fee\u6539\uff0c\u4e0d\u5168\u8986\u76d6");
                    break;
                }
                case 3: {
                    if (!priceMap.containsKey(sk.getSkuId()) || !"1".equals(((SkuPrice)priceMap.get(sk.getSkuId())).getHasPriceSheet())) {
                        if (priceMap.containsKey(sk.getSkuId()) && "1".equals(((SkuPrice)priceMap.get(sk.getSkuId())).getSheetLevel())) {
                            sk.setSheetLevel("1");
                        }
                        sku.add(sk);
                        break;
                    }
                    this.faild.add(sk.getMaterialId() + "\uff1a\u7269\u6599\u5df2\u5b58\u5728\u62a5\u4ef7\u5355\uff0c\u4e14\u4e0d\u5168\u8986\u76d6");
                    break;
                }
                case 4: {
                    if (!priceMap.containsKey(sk.getSkuId()) || !"1".equals(((SkuPrice)priceMap.get(sk.getSkuId())).getHasPriceSheet())) {
                        sku.add(sk);
                        break;
                    }
                    if (!priceMap.containsKey(sk.getSkuId()) || !"1".equals(((SkuPrice)priceMap.get(sk.getSkuId())).getHasPriceSheet())) break;
                    if (priceMap.containsKey(sk.getSkuId()) && !"1".equals(((SkuPrice)priceMap.get(sk.getSkuId())).getSheetLevel())) {
                        sku.add(sk);
                        break;
                    }
                    this.faild.add(sk.getMaterialId() + "\uff1a\u7269\u6599\u5df2\u5b58\u5728\u603b\u90e8\u62a5\u4ef7\u5355\uff0c\u4e14\u4e0d\u53ef\u4fee\u6539");
                }
            }
        }
        return sku;
    }

    public List<Sku> getSku(List<Long> supplierIds, List<PriceSheetItemPO> item) throws Exception {
        logger.debug("\u83b7\u53d6sku");
        ArrayList<String> materialIds = new ArrayList<String>();
        for (PriceSheetItemPO material : item) {
            materialIds.add(material.getMaterialId());
        }
        List<Sku> poList = new ArrayList<Sku>();
        if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(supplierIds)) {
            logger.debug("\u95e8\u5e97\u6570\u91cf" + supplierIds.size());
            poList = this.xlsSkuMapper.queryXlsSkuByMaterialsAndShopList(supplierIds, materialIds);
        }
        return poList;
    }

    public List<Long> getShopIdLidt(Map<String, List<String>> map) throws Exception {
        List<String> provCode = map.get("orgTreePath");
        ArrayList<Long> shopCode = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(provCode)) {
            List<Long> provShop = this.getProvCode(provCode);
            for (Long shop : provShop) {
                shopCode.add(shop);
            }
        }
        return shopCode;
    }

    public Map<String, List<String>> getItem(List<PriceSheetOrgPO> item) throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        ArrayList<String> orgTreePath = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(item)) {
            for (PriceSheetOrgPO po : item) {
                orgTreePath.add(po.getOrgTreePath());
            }
            map.put("orgTreePath", orgTreePath);
            logger.debug(((Object)map).toString());
        }
        return map;
    }

    public Map<String, String> getIsChange(List<PriceSheetItemPO> items, List<PriceSheetOrgPO> orgs) {
        ArrayList<String> materialIds = new ArrayList<String>();
        ArrayList<String> provCodes = new ArrayList<String>();
        for (PriceSheetItemPO item : items) {
            materialIds.add(item.getMaterialId());
        }
        for (PriceSheetOrgPO org : orgs) {
            provCodes.add(org.getProvinceCode());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        List<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvAndMaterial((String)provCodes.get(0), materialIds);
        for (ProvGoodsPO po : poList) {
            if ("1".equals(po.getReservedField3()) || StringUtils.isBlank((String)po.getReservedField3())) {
                map.put(po.getMaterialId(), "1");
                continue;
            }
            map.put(po.getMaterialId(), "0");
        }
        return map;
    }

    public void updatePrice(List<Sku> skus, Map<String, PriceSheetItemPO> priceMap) throws Exception {
        ArrayList<Sku> price = new ArrayList<Sku>();
        ArrayList<PriceBO> priceBOList = new ArrayList<PriceBO>();
        Sku po = null;
        PriceBO priceBO = null;
        for (Sku sku : skus) {
            po = new Sku();
            po.setSkuId(sku.getSkuId());
            if (sku.getSkuStatus() == 5) {
                po.setSkuStatus(2);
            } else if (sku.getSkuStatus() == 4) {
                po.setSkuStatus(1);
            }
            po.setSkuPrice(priceMap.get(sku.getMaterialId()).getSalePrice());
            price.add(po);
            priceBO = new PriceBO();
            priceBO.setSkuId(sku.getSkuId());
            if (!"1".equals(sku.getSheetLevel())) {
                priceBO.setAgreementPrice(priceMap.get(sku.getMaterialId()).getAgreementPrice());
            }
            priceBO.setPurchaseFloorPrice(priceMap.get(sku.getMaterialId()).getPurchaseFloorPrice());
            priceBO.setRetailAgreementPrice(priceMap.get(sku.getMaterialId()).getRetailAgreementPrice());
            priceBO.setCitiesLockPrice(priceMap.get(sku.getMaterialId()).getCitiesLockPrice());
            priceBO.setTheCostDownPrice(priceMap.get(sku.getMaterialId()).getTheCostDownPrice());
            priceBO.setAssessmentPrice(priceMap.get(sku.getMaterialId()).getAssessmentPrice());
            priceBO.setCgType(sku.getCgType());
            priceBO.setCostPrice(priceMap.get(sku.getMaterialId()).getCostPrice());
            priceBO.setLastPurchasePrice(priceMap.get(sku.getMaterialId()).getLastPurchasePrice());
            priceBO.setMarketPrice(priceMap.get(sku.getMaterialId()).getSalePrice());
            priceBO.setMemberLadderPrice1(priceMap.get(sku.getMaterialId()).getMemberLadderPrice1());
            priceBO.setMemberLadderPrice2(priceMap.get(sku.getMaterialId()).getMemberLadderPrice2());
            priceBO.setMemberLadderPrice3(priceMap.get(sku.getMaterialId()).getMemberLadderPrice3());
            priceBO.setMemberLadderPrice4(priceMap.get(sku.getMaterialId()).getMemberLadderPrice4());
            priceBO.setMemberLadderPrice5(priceMap.get(sku.getMaterialId()).getMemberLadderPrice5());
            priceBO.setMemberPrice(priceMap.get(sku.getMaterialId()).getMemberPrice());
            priceBO.setSparePrice1(priceMap.get(sku.getMaterialId()).getPurchasePrice());
            priceBO.setFixedRoyalty(priceMap.get(sku.getMaterialId()).getFixedRoyalty());
            priceBO.setGroupRoyalty(priceMap.get(sku.getMaterialId()).getGroupRoyalty());
            priceBO.setProfitRoyalty(priceMap.get(sku.getMaterialId()).getProfitRoyalty());
            priceBO.setRoyaltyRatio(priceMap.get(sku.getMaterialId()).getRoyaltyRatio());
            priceBO.setScore(priceMap.get(sku.getMaterialId()).getScore());
            priceBO.setSalePrice(priceMap.get(sku.getMaterialId()).getSalePrice());
            priceBO.setSheetLevel(priceMap.get(sku.getMaterialId()).getSheetLevel());
            priceBO.setSheetId(priceMap.get(sku.getMaterialId()).getSheetId());
            priceBO.setSparePrice2(priceMap.get(sku.getMaterialId()).getSparePrice2());
            priceBO.setSparePrice3(priceMap.get(sku.getMaterialId()).getSparePrice3());
            priceBO.setSparePrice4(priceMap.get(sku.getMaterialId()).getSparePrice4());
            priceBO.setSparePrice5(priceMap.get(sku.getMaterialId()).getSparePrice5());
            priceBO.setTradePrice(priceMap.get(sku.getMaterialId()).getTradePrice());
            priceBO.setProvAgreePrice(priceMap.get(sku.getMaterialId()).getProvAgreePrice());
            priceBO.setUpdateTime(new Date());
            priceBO.setHasPriceSheet("1");
            priceBOList.add(priceBO);
        }
        logger.debug("\u4fee\u6539\u4ef7\u683c" + JSONObject.toJSONString(price));
        logger.debug("\u4fee\u6539\u4ef7\u683c" + JSONObject.toJSONString(priceBOList));
        this.updateXlsSkuMapper(price);
        this.updateXlsSkuPriceManage(priceBOList);
    }

    private void updateXlsSkuPriceManage(List<PriceBO> priceBOList) {
        logger.debug("\u4fee\u6539sku" + priceBOList.size());
        int pointsDataLimit = 1000;
        Integer size = priceBOList.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539skuPrice" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<PriceBO> rows = priceBOList.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetChectServiceImpl.this.xlsSkuPriceManageService.batchUpdateSkuPrice(rows);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        priceBOList = null;
    }

    private void updateXlsSkuMapper(List<Sku> price) {
        logger.debug("\u4fee\u6539skuPrice" + price.size());
        int pointsDataLimit = 1000;
        Integer size = price.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u4fee\u6539sku\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6b21\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            final List<Sku> rows = price.subList(start, end);
            service.execute(new Runnable(){

                @Override
                public void run() {
                    PriceSheetChectServiceImpl.this.xlsSkuMapper.batchUpdateBySkuId(rows);
                }
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
        price = null;
    }

    public void method(List<PriceSheetItemPO> item, Map<String, PriceSheetItemPO> itemMap, int flag, List<PriceSheetOrgPO> org) {
        logger.debug("\u53ef\u4fee\u6539");
        HashMap<String, List<String>> map = new HashMap();
        try {
            map = this.getItem(org);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.debug("\u83b7\u53d6\u7701\u4efd\u7f16\u7801\u7269\u6599\u7f16\u7801\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
        ArrayList<Long> supplierIds = new ArrayList();
        try {
            if (!CollectionUtils.isEmpty(map)) {
                supplierIds = this.getShopIdLidt(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.debug("\u83b7\u53d6\u7701\u4efd\u6240\u6709\u95e8\u5e97\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
        ArrayList<Sku> record = new ArrayList();
        try {
            record = this.getSku(supplierIds, item);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.debug("\u83b7\u53d6\u95e8\u5e97\u7269\u6599\u5bf9\u5e94sku\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
        ArrayList<Sku> skus = new ArrayList();
        try {
            if (!CollectionUtils.isEmpty(record)) {
                skus = this.getPrice(record, flag);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            logger.debug("\u83b7\u53d6\u4ef7\u683c\u62a5\u9519");
            throw new BusinessException("9999", "\u83b7\u53d6\u4ef7\u683c\u62a5\u9519" + e.getMessage());
        }
        try {
            if (!CollectionUtils.isEmpty(skus)) {
                this.updatePrice(skus, itemMap);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            logger.debug("\u4fee\u6539\u4ef7\u683c\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u62a5\u4ef7\u62a5\u9519\u62a5\u9519" + e.getMessage());
        }
    }

    public List<Long> getProvCode(List<String> provCodes) throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        String postUrl = this.url;
        if (!CollectionUtils.isEmpty(provCodes)) {
            for (String orgTreePath : provCodes) {
                JSONObject param = new JSONObject();
                param.put("orgTreePath", (Object)orgTreePath);
                param.put("queryType", (Object)4);
                param.put("isCutoverFlag", (Object)1);
                param.put("isFilteStoreId", (Object)0);
                String comeBack = TkHttpRequestUtils.conn(null, param.toString(), null, postUrl, null, null);
                JSONObject prov = JSONObject.parseObject((String)comeBack);
                if (CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) continue;
                JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
                for (int i = 0; i < orgTreeBOList.size(); ++i) {
                    JSONObject item = orgTreeBOList.getJSONObject(i);
                    if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                    list.add(Long.parseLong(item.getString("storeId")));
                }
            }
        }
        return list;
    }
}

