/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.ProvGoodsEnableShutdownService;
import com.xls.commodity.busi.sku.bo.BatchCreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.ProvAndCityCodeBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsBO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.dao.po.ProvGoodsSupRelationPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import com.xls.commodity.util.TkHttpRequestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProvGoodsEnableShutdownServiceImpl
implements ProvGoodsEnableShutdownService {
    private static final Logger logger = LoggerFactory.getLogger(ProvGoodsEnableShutdownServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Value(value="${getProvience}")
    private String url;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;

    public BaseRspBO provGoodsEnableShutdown(ProvGoodsBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u7701\u4efd\u5546\u54c1\u7684\u542f\u7528\u505c\u7528\uff1a" + JSONObject.toJSONString((Object)reqBO));
        if (reqBO.getProvGoodsId() == null || StringUtils.isEmpty((String)reqBO.getGoodsStatus())) {
            logger.debug("\u5165\u53c2\u4e3a\u7a7a");
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            return result;
        }
        ProvGoodsPO provPO = new ProvGoodsPO();
        logger.debug("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001");
        try {
            provPO = this.provGoodsDAO.selectByPrimaryKey(reqBO.getProvGoodsId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u72b6\u6001\u62a5\u9519" + e.getMessage());
        }
        if ("04".equals(reqBO.getGoodsStatus())) {
            JSONObject resultData = this.reqBOresultData(provPO);
            Long unsaleNum = resultData.getLong("unsaleNum");
            Long transNum = resultData.getLong("transNum");
            if (unsaleNum > 0L || transNum > 0L) {
                result.setRespCode("9999");
                result.setRespDesc("\u53ef\u552e\u6216\u5728\u9014\u6570\u91cf\u5b58\u5728\u5e93\u5b58");
                return result;
            }
        }
        ArrayList<ProvGoodsSupRelationPO> proList = new ArrayList();
        try {
            logger.debug("\u67e5\u8be2\u4f9b\u5e94\u5546");
            proList = this.provGoodsSupRelationDAO.selectByProvGoodsId(reqBO.getProvGoodsId());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u4f9b\u5e94\u5546\u62a5\u9519" + e.getMessage());
        }
        try {
            List<SkuBO> skuBOS;
            ProvGoodsPO record;
            if ("03".equals(reqBO.getGoodsStatus())) {
                logger.debug("\u542f\u7528");
                record = new ProvGoodsPO();
                record.setProvGoodsId(provPO.getProvGoodsId());
                record.setGoodsStatus("03");
                this.provGoodsDAO.updateByPrimaryKeySelective(record);
                if ("02".equals(provPO.getGoodsStatus())) {
                    logger.debug("\u5e93\u91cc\u4e3a\u5f85\u542f\u7528");
                    List<Sku> sku = this.getSku(provPO.getProvinceCode(), provPO.getMaterialId(), reqBO.getmOrgPath());
                    if (!CollectionUtils.isEmpty(sku)) {
                        List<SkuBO> skuBOS2 = this.getSkuBOS(provPO, "03", proList, reqBO.getmOrgPath());
                        this.xlsSkuManageService.batchUpdate(skuBOS2);
                    } else {
                        this.add(provPO, proList, reqBO.getmOrgPath());
                    }
                } else if ("04".equals(provPO.getGoodsStatus())) {
                    logger.debug("\u5e93\u91cc\u4e3a\u5df2\u505c\u7528");
                    skuBOS = this.getSkuBOS(provPO, "03", proList, reqBO.getmOrgPath());
                    this.xlsSkuManageService.batchUpdate(skuBOS);
                }
            } else if ("04".equals(reqBO.getGoodsStatus())) {
                record = new ProvGoodsPO();
                record.setProvGoodsId(provPO.getProvGoodsId());
                record.setGoodsStatus("04");
                this.provGoodsDAO.updateByPrimaryKeySelective(record);
                logger.debug("\u505c\u7528");
                skuBOS = this.getSkuBOS(provPO, "04", proList, reqBO.getmOrgPath());
                this.xlsSkuManageService.batchUpdate(skuBOS);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u6216\u4fee\u6539\u62a5\u9519");
            throw new BusinessException("9999", "\u65b0\u589e\u6216\u4fee\u6539\u62a5\u9519" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    private JSONObject reqBOresultData(ProvGoodsPO provPO) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("provId", provPO.getProvinceCode());
        param.put("materialCode", provPO.getMaterialId());
        JSONObject resultData = new JSONObject();
        try {
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcQryUnSaleCountsAbilityService", "qryUnSaleCounts", "com.tydic.smc.api.ability.bo.SmcQryUnSaleCountsAbilityReqBO");
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            invokeInfo.setRegisterType("2");
            resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString(param), null, (InvokeInfo)invokeInfo);
            logger.debug("\u8fdb\u884c\u6cdb\u5316\u8c03\u7528" + resultData);
        }
        catch (Exception e) {
            logger.error("\u53ef\u552e\u548c\u5728\u9014\u6570\u91cf\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("9999", "\u53ef\u552e\u548c\u5728\u9014\u6570\u91cf\u67e5\u8be2\u5931\u8d25");
        }
        return resultData;
    }

    public List<SkuBO> getSkuBOS(ProvGoodsPO prov, String status, List<ProvGoodsSupRelationPO> relation, String orgPath) throws Exception {
        ArrayList<SkuBO> skuBOS = new ArrayList<SkuBO>();
        List<Sku> skus = this.getSku(prov.getProvinceCode(), prov.getMaterialId(), orgPath);
        String vendorId = this.getId(relation);
        String vendorName = this.getName(relation);
        logger.debug("\u4f9b\u5e94\u5546id" + vendorId);
        logger.debug("\u4f9b\u5e94\u5546\u540d\u79f0" + vendorName);
        SkuBO skuBO = null;
        for (Sku s : skus) {
            skuBO = new SkuBO();
            skuBO.setBrandId(prov.getBrandId());
            skuBO.setBrandName(prov.getBrandName());
            skuBO.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
            skuBO.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
            skuBO.setSkuId(s.getSkuId());
            skuBO.setProvinceCode(prov.getProvinceCode());
            skuBO.setCityCode(s.getCityCode());
            skuBO.setCgType(prov.getCgType());
            skuBO.setSkuCode(prov.getGoodsNo());
            skuBO.setIsVirtualGood(prov.getAllowNegativeStock());
            skuBO.setProvGoodsId(prov.getProvGoodsId());
            skuBO.setColor(prov.getColorName());
            skuBO.setRam(prov.getMemoryName());
            skuBO.setBrand(prov.getBrandName());
            skuBO.setModel(prov.getGoodsModel());
            skuBO.setSkuName(prov.getGoodsLongName());
            skuBO.setSkuLongName(prov.getGoodsLongName());
            skuBO.setErpLongName(prov.getGoodsLongName());
            skuBO.setSkuPriceTagName(prov.getGoodsLongName());
            skuBO.setMfgSku(prov.getGoodsModel());
            skuBO.setSupplierId(s.getSupplierId());
            if ("03".equals(status)) {
                skuBO.setIsDelete(Integer.valueOf(0));
            } else if ("04".equals(status)) {
                skuBO.setIsDelete(Integer.valueOf(1));
            }
            skuBOS.add(skuBO);
        }
        return skuBOS;
    }

    public List<Sku> getSku(String provCode, String materialId, String orgPath) throws Exception {
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(orgPath);
        List<Sku> skus = new ArrayList<Sku>();
        if (!CollectionUtils.isEmpty(shopIds)) {
            ArrayList<String> materialIds = new ArrayList<String>();
            materialIds.add(materialId);
            ArrayList<Long> supplierIds = new ArrayList<Long>();
            for (Map.Entry<String, ProvAndCityCodeBO> shop : shopIds.entrySet()) {
                supplierIds.add(Long.parseLong(shop.getKey()));
            }
            skus = this.xlsSkuMapper.queryXlsSkuByMaterialsAndShopListAll(supplierIds, materialIds);
        }
        for (Sku sk : skus) {
            sk.setProvinceCode(shopIds.get(sk.getSupplierId().toString()).getProvinceCode());
            sk.setCityCode(shopIds.get(sk.getSupplierId().toString()).getCityCode());
        }
        return skus;
    }

    public void add(ProvGoodsPO provPO, List<ProvGoodsSupRelationPO> relation, String orgPath) throws Exception {
        Map<String, ProvAndCityCodeBO> shopIds = this.getProvCode(orgPath);
        BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
        ArrayList<CreateSkuReqBO> reqList = new ArrayList<CreateSkuReqBO>();
        String vendorId = this.getId(relation);
        String vendorName = this.getName(relation);
        logger.debug("\u4f9b\u5e94\u5546id" + vendorId);
        logger.debug("\u4f9b\u5e94\u5546\u540d\u79f0" + vendorName);
        CreateSkuReqBO bo = null;
        if (!CollectionUtils.isEmpty(shopIds)) {
            for (Map.Entry<String, ProvAndCityCodeBO> shopId : shopIds.entrySet()) {
                bo = new CreateSkuReqBO();
                bo.setCgType(provPO.getCgType());
                bo.setGoodsSource(provPO.getGoodsSource());
                bo.setColor(provPO.getColorName());
                bo.setBrand(provPO.getBrandName());
                bo.setMeasureId(provPO.getMeasureId());
                bo.setMeasureName(provPO.getMeasureName());
                bo.setRam(provPO.getMemoryName());
                bo.setModel(provPO.getGoodsModel());
                bo.setFullName(provPO.getGoodsLongName());
                bo.setSupplierId(Long.valueOf(Long.parseLong(shopId.getKey())));
                bo.setSupplierName(shopId.getValue().getShopName());
                bo.setCityCode(shopId.getValue().getCityCode());
                bo.setProvinceCode(shopId.getValue().getProvinceCode());
                bo.setCountyCode(shopId.getValue().getCountryCode());
                bo.setName(provPO.getGoodsModel());
                bo.setIsVirtualGood(provPO.getAllowNegativeStock());
                bo.setMaterialId(provPO.getMaterialId());
                bo.setProvGoodsId(provPO.getProvGoodsId());
                bo.setSkuCode(provPO.getGoodsNo());
                bo.setProvinceCode(provPO.getProvinceCode());
                bo.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
                bo.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
                bo.setBrandId(provPO.getBrandId());
                bo.setBrandName(provPO.getBrandName());
                bo.setModel(provPO.getGoodsModel());
                reqList.add(bo);
            }
            batchCreateSkuReqBO.setCreateSkuReqBOs(reqList);
            this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
        }
    }

    public Map<String, ProvAndCityCodeBO> getProvCode(String provinceCode) throws Exception {
        HashMap<String, ProvAndCityCodeBO> map = new HashMap<String, ProvAndCityCodeBO>();
        String postUrl = this.url;
        JSONObject param = new JSONObject();
        param.put("queryType", (Object)4);
        param.fluentPut("orgTreePath", (Object)provinceCode);
        param.put("isCutoverFlag", (Object)1);
        param.put("isFilteStoreId", (Object)0);
        String comeBack = TkHttpRequestUtils.conn(null, param.toString(), null, postUrl, null, null);
        JSONObject prov = JSONObject.parseObject((String)comeBack);
        if (!CollectionUtils.isEmpty((Collection)prov.getJSONArray("orgTreeBOList"))) {
            ProvAndCityCodeBO bo = null;
            JSONArray orgTreeBOList = prov.getJSONArray("orgTreeBOList");
            for (int i = 0; i < orgTreeBOList.size(); ++i) {
                JSONObject item = orgTreeBOList.getJSONObject(i);
                if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
                bo = new ProvAndCityCodeBO();
                bo.setCityCode(item.getString("cityCode"));
                bo.setProvinceCode(item.getString("provinceCode"));
                bo.setShopName(item.getString("orgName"));
                bo.setCountryCode(item.getString("districtCode"));
                map.put(item.getString("storeId"), bo);
            }
        }
        return map;
    }

    public String getId(List<ProvGoodsSupRelationPO> relation) {
        String id = "";
        if (!CollectionUtils.isEmpty(relation)) {
            for (ProvGoodsSupRelationPO po : relation) {
                id = id + po.getSupplierId() + ",";
            }
        }
        return id;
    }

    public String getName(List<ProvGoodsSupRelationPO> relation) {
        String name = "";
        if (!CollectionUtils.isEmpty(relation)) {
            for (ProvGoodsSupRelationPO po : relation) {
                name = name + po.getSupplierName() + ",";
            }
        }
        return name;
    }
}

