/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.commodity.busi.price.BatchQuerySkuPriceBusiService;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceReqBO;
import com.ohaotian.commodity.busi.price.bo.BatchQuerySkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuPriceRspBO;
import com.ohaotian.commodity.busi.sku.bo.SkuSpecBO;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.busi.sku.QuerySkuDetailBusiXlsService;
import com.xls.commodity.busi.sku.bo.QuerySkuDetailXlsBO;
import com.xls.commodity.busi.sku.bo.QuerySkuDetailXlsReqBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class QuerySkuDetailBusiXlsServiceImpl
implements QuerySkuDetailBusiXlsService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuDetailBusiXlsServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private BatchQuerySkuPriceBusiService batchQuerySkuPriceBusiService;
    @Autowired
    private SkuSpecMapper skuSpecMapper;

    public RspInfoListBO<QuerySkuDetailXlsBO> querySkuDetail(QuerySkuDetailXlsReqBO reqBO) {
        logger.debug("\u5165\u53c2\uff1a" + JSONObject.fromObject((Object)reqBO));
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<QuerySkuDetailXlsBO> querySkuDetailXlsBOList = new ArrayList<QuerySkuDetailXlsBO>();
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1skuID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5355\u54c1\u4fe1\u606f\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u95e8\u5e97ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Long, Sku> skuMap = new HashMap<Long, Sku>();
        List<Object> skuList = new ArrayList();
        try {
            Sku sku = new Sku();
            sku.setSupplierId(reqBO.getSupplierId());
            logger.debug("\u67e5\u8be2\u5355\u54c1\u4fe1\u606f");
            skuList = this.xlsSkuMapper.selectBySkuIdAndSupplierAndstatus(reqBO.getSkuIds(), sku);
            if (CollectionUtils.isNotEmpty(skuList)) {
                for (Sku sku2 : skuList) {
                    if (skuMap.containsKey(sku2.getSkuId())) continue;
                    skuMap.put(sku2.getSkuId(), sku2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u5355\u54c1\u4fe1\u606f" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5355\u54c1\u4fe1\u606f\u670d\u52a1\u51fa\u9519");
        }
        HashMap<Long, SkuPriceRspBO> priceMap = new HashMap<Long, SkuPriceRspBO>();
        try {
            logger.debug("\u67e5\u8be2\u5355\u54c1\u4ef7\u683c");
            BatchQuerySkuPriceReqBO batchQuerySkuPriceReqBO = new BatchQuerySkuPriceReqBO();
            batchQuerySkuPriceReqBO.setSkuIds(reqBO.getSkuIds());
            batchQuerySkuPriceReqBO.setSupplierId(reqBO.getSupplierId());
            BatchQuerySkuPriceRspBO batchQuerySkuPriceRspBO = this.batchQuerySkuPriceBusiService.batchQuerySkuPrice(batchQuerySkuPriceReqBO);
            logger.debug("\u5f97\u5230\u5355\u54c1\u4ef7\u683c");
            if (batchQuerySkuPriceRspBO != null && CollectionUtils.isNotEmpty((Collection)batchQuerySkuPriceRspBO.getPrices())) {
                List prices = batchQuerySkuPriceRspBO.getPrices();
                for (SkuPriceRspBO price : prices) {
                    if (priceMap.containsKey(price.getSkuId())) continue;
                    priceMap.put(price.getSkuId(), price);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u5355\u54c1\u4ef7\u683c" + e.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5355\u54c1\u4ef7\u683c\u670d\u52a1\u51fa\u9519");
        }
        HashMap specMap = new HashMap();
        try {
            logger.debug("\u67e5\u8be2\u5546\u54c1\u89c4\u683c");
            List list = this.skuSpecMapper.selectSpecBySkuIds(reqBO.getSkuIds());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (SkuSpec skuSpec : list) {
                    if (specMap.containsKey(skuSpec.getSkuId())) {
                        ((List)specMap.get(skuSpec.getSkuId())).add(skuSpec);
                        continue;
                    }
                    ArrayList<SkuSpec> specList = new ArrayList<SkuSpec>();
                    specList.add(skuSpec);
                    specMap.put(skuSpec.getSkuId(), specList);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("\u67e5\u8be2\u5546\u54c1\u89c4\u683c" + exception.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u5546\u54c1\u89c4\u683c\u670d\u52a1\u51fa\u9519");
        }
        try {
            logger.debug("\u5f97\u5230\u5546\u54c1\u89c4\u683c");
            Object var8_14 = null;
            for (Sku sku : skuList) {
                QuerySkuDetailXlsBO querySkuDetailXlsBO = new QuerySkuDetailXlsBO();
                BeanUtils.copyProperties((Object)sku, (Object)querySkuDetailXlsBO);
                if (priceMap.get(sku.getSkuId()) != null) {
                    querySkuDetailXlsBO.setPrice((SkuPriceRspBO)priceMap.get(sku.getSkuId()));
                }
                if (specMap.get(sku.getSkuId()) != null) {
                    List skuSpecs = (List)specMap.get(sku.getSkuId());
                    ArrayList<SkuSpecBO> spec1 = new ArrayList<SkuSpecBO>();
                    ArrayList spec2 = new ArrayList();
                    for (SkuSpec sp : skuSpecs) {
                        SkuSpecBO bo = new SkuSpecBO();
                        if (sp.getCommodityPropGrpId() == 900991231L) {
                            BeanUtils.copyProperties((Object)sp, (Object)bo);
                            spec1.add(bo);
                            continue;
                        }
                        if (sp.getCommodityPropGrpId() == 900991232L) {
                            BeanUtils.copyProperties((Object)sp, (Object)bo);
                            spec1.add(bo);
                            continue;
                        }
                        if (sp.getCommodityPropGrpId() == 900991233L) {
                            BeanUtils.copyProperties((Object)sp, (Object)bo);
                            spec1.add(bo);
                            continue;
                        }
                        if (sp.getCommodityPropGrpId() == 900991234L) {
                            BeanUtils.copyProperties((Object)sp, (Object)bo);
                            spec1.add(bo);
                            continue;
                        }
                        if (sp.getPropValueListId() == null) continue;
                        BeanUtils.copyProperties((Object)sp, (Object)bo);
                        spec1.add(bo);
                    }
                    querySkuDetailXlsBO.setSpecs(spec1);
                    querySkuDetailXlsBO.setDimensions(spec2);
                }
                querySkuDetailXlsBOList.add(querySkuDetailXlsBO);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.error("\u53c2\u6570\u8f6c\u6362" + exception.getMessage());
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u53c2\u6570\u8f6c\u6362\u51fa\u9519");
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(querySkuDetailXlsBOList);
        return result;
    }
}

