/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.busi.sku.ModelGroupService;
import com.xls.commodity.busi.sku.QuerySkuInsureListService;
import com.xls.commodity.busi.sku.SysParamTransferBusiService;
import com.xls.commodity.busi.sku.bo.ModelGroupBO;
import com.xls.commodity.busi.sku.bo.ModelGroupReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuInsureListReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuInsureRspBO;
import com.xls.commodity.dao.DProvGoodsDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.DProvGoodsPO;
import com.xls.commodity.dao.po.SkuAndInsurePO;
import com.xls.commodity.dao.po.SkuInsurePO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuInsureListServiceImpl
implements QuerySkuInsureListService {
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuInsureListServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private ModelGroupService modelGroupService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private SysParamTransferBusiService sysParamTransferBusiService;
    @Autowired
    private DProvGoodsDAO dProvGoodsDAO;

    public RspInfoListBO<QuerySkuInsureRspBO> querySkuInsureList(QuerySkuInsureListReqBO querySkuInsureListReqBO) {
        RspInfoListBO result = new RspInfoListBO();
        logger.debug("\u6839\u636eskuId\u67e5\u8be2\u5355\u54c1\u7b26\u5408\u7684\u4fdd\u9669\u5217\u8868\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)querySkuInsureListReqBO));
        ArrayList<QuerySkuInsureRspBO> listQuerySkuInsureRspBO = new ArrayList<QuerySkuInsureRspBO>();
        Sku sku = new Sku();
        sku.setSkuId(querySkuInsureListReqBO.getSkuId());
        sku.setSupplierId(querySkuInsureListReqBO.getSupplierId());
        sku = this.skuMapper.selectBySkuIdAndSupplierAndstatus(sku);
        String brandName = sku.getBrandName();
        logger.debug("sku\u662f\u5426\u6709\u4e32\u7801=" + sku.getHasSerialNumber());
        Map mapsecurityServicesType = this.sysParamTransferBusiService.sysParamTransferByParentCode("BUSINESS_TYPE");
        Map mapTermOfValidity = this.sysParamTransferBusiService.sysParamTransferByParentCode("TERM_OF_VALIDITY");
        if (StringUtils.isBlank((String)brandName)) {
            result.setRows(listQuerySkuInsureRspBO);
            result.setRespCode("0000");
            result.setRespDesc("\u6210\u529f");
        }
        if (!"\u82f9\u679c".equals(brandName)) {
            logger.debug("\u54c1\u724c\u4e3a\u975e\u82f9\u679c\u7684sku");
            SkuInsurePO skuInsurePO = new SkuInsurePO();
            skuInsurePO.setSupplierId(sku.getSupplierId());
            skuInsurePO.setSkuPrice(sku.getSkuPrice());
            skuInsurePO.setHasSerialNumber(sku.getHasSerialNumber());
            List<SkuAndInsurePO> skuAndInsurePOList = this.xlsSkuMapper.selectSkuInsureListForAZ(skuInsurePO);
            if (CollectionUtils.isNotEmpty(skuAndInsurePOList)) {
                for (SkuAndInsurePO skuAndInsurePO : skuAndInsurePOList) {
                    QuerySkuInsureRspBO querySkuInsureRspBO = new QuerySkuInsureRspBO();
                    BeanUtils.copyProperties((Object)skuAndInsurePO, (Object)querySkuInsureRspBO);
                    querySkuInsureRspBO.setSecurityServicesTypeStr((String)mapsecurityServicesType.get(querySkuInsureRspBO.getSecurityServicesType()));
                    querySkuInsureRspBO.setTermOfValidityStr((String)mapTermOfValidity.get(querySkuInsureRspBO.getTermOfValidity()));
                    querySkuInsureRspBO.setSalePriceM(this.L2M(querySkuInsureRspBO.getSalePrice()));
                    querySkuInsureRspBO.setLimitPriceM(this.L2M(querySkuInsureRspBO.getLimitPrice()));
                    querySkuInsureRspBO.setPurchasePriceM(this.L2M(querySkuInsureRspBO.getPurchasePrice()));
                    querySkuInsureRspBO.setRealityPriceM(this.L2M(querySkuInsureRspBO.getRealityPrice()));
                    DProvGoodsPO dProvGoodsPO = this.dProvGoodsDAO.selectByPrimaryKey(querySkuInsureRspBO.getProvGoodsId());
                    querySkuInsureRspBO.setWhetherInvoice(dProvGoodsPO.getWhetherInvoice());
                    listQuerySkuInsureRspBO.add(querySkuInsureRspBO);
                }
            }
        } else {
            DProvGoodsPO dProvGoodsPO;
            QuerySkuInsureRspBO querySkuInsureRspBO;
            logger.debug("\u54c1\u724c\u4e3a\u82f9\u679c\u7684sku");
            SkuInsurePO skuInsurePO = new SkuInsurePO();
            skuInsurePO.setSupplierId(sku.getSupplierId());
            skuInsurePO.setSkuPrice(sku.getSkuPrice());
            skuInsurePO.setScreenType(sku.getScreenType());
            List<SkuAndInsurePO> skuAndInsurePOList = this.xlsSkuMapper.selectSkuInsureListForPG1(skuInsurePO);
            logger.debug("\u6761\u4ef61\u67e5\u8be2\u51fa\u6765\u7684\u7ed3\u679c=" + JSON.toJSONString(skuAndInsurePOList));
            SkuInsurePO skuInsurePO1 = new SkuInsurePO();
            skuInsurePO1.setSupplierId(sku.getSupplierId());
            ModelGroupReqBO modelGroupReqBO = new ModelGroupReqBO();
            modelGroupReqBO.setMaterialId(sku.getMaterialId());
            logger.debug("\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u673a\u578b\u7ec4\u670d\u52a1\u5165\u53c2=" + JSON.toJSONString((Object)modelGroupReqBO));
            RspInfoListBO listModelGroupBO = this.modelGroupService.queryModelByMaterial(modelGroupReqBO);
            logger.debug("\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u673a\u578b\u7ec4\u670d\u52a1\u51fa\u53c2=" + JSON.toJSONString((Object)listModelGroupBO));
            List<Object> skuAndInsurePOList1 = new ArrayList();
            List modelGroupBOs = listModelGroupBO.getRows();
            if (CollectionUtils.isNotEmpty((Collection)modelGroupBOs)) {
                ArrayList<Long> modelGroupIds = new ArrayList<Long>();
                for (ModelGroupBO modelGroupBO : modelGroupBOs) {
                    modelGroupIds.add(modelGroupBO.getId());
                }
                skuInsurePO1.setModelGroupIds(modelGroupIds);
                skuAndInsurePOList1 = this.xlsSkuMapper.selectSkuInsureListForPG2(skuInsurePO1);
                logger.debug("\u6761\u4ef62\u67e5\u8be2\u51fa\u6765\u7684\u7ed3\u679c=" + JSON.toJSONString(skuAndInsurePOList1));
            }
            List<SkuAndInsurePO> skuAndInsurePOList2 = this.xlsSkuMapper.selectSkuInsureListForPG3(skuInsurePO);
            logger.debug("\u6761\u4ef63\u67e5\u8be2\u51fa\u6765\u7684\u7ed3\u679c=" + JSON.toJSONString(skuAndInsurePOList2));
            skuAndInsurePOList.addAll(skuAndInsurePOList2);
            if (CollectionUtils.isNotEmpty(skuAndInsurePOList) && CollectionUtils.isNotEmpty(skuAndInsurePOList1)) {
                skuAndInsurePOList.removeAll(skuAndInsurePOList1);
                skuAndInsurePOList.addAll(skuAndInsurePOList1);
                logger.debug("\u53d6\u5e76\u96c6=" + JSON.toJSONString(skuAndInsurePOList));
                for (SkuAndInsurePO skuAndInsurePO : skuAndInsurePOList) {
                    querySkuInsureRspBO = new QuerySkuInsureRspBO();
                    BeanUtils.copyProperties((Object)skuAndInsurePO, (Object)querySkuInsureRspBO);
                    querySkuInsureRspBO.setSecurityServicesTypeStr((String)mapsecurityServicesType.get(querySkuInsureRspBO.getSecurityServicesType()));
                    querySkuInsureRspBO.setSalePriceM(this.L2M(querySkuInsureRspBO.getSalePrice()));
                    querySkuInsureRspBO.setLimitPriceM(this.L2M(querySkuInsureRspBO.getLimitPrice()));
                    querySkuInsureRspBO.setPurchasePriceM(this.L2M(querySkuInsureRspBO.getPurchasePrice()));
                    querySkuInsureRspBO.setRealityPriceM(this.L2M(querySkuInsureRspBO.getRealityPrice()));
                    dProvGoodsPO = this.dProvGoodsDAO.selectByPrimaryKey(querySkuInsureRspBO.getProvGoodsId());
                    querySkuInsureRspBO.setWhetherInvoice(dProvGoodsPO.getWhetherInvoice());
                    listQuerySkuInsureRspBO.add(querySkuInsureRspBO);
                }
            } else if (CollectionUtils.isEmpty(skuAndInsurePOList) && CollectionUtils.isNotEmpty(skuAndInsurePOList1)) {
                logger.debug("\u53d6\u5e76\u96c6=" + JSON.toJSONString(skuAndInsurePOList1));
                for (SkuAndInsurePO skuAndInsurePO : skuAndInsurePOList1) {
                    querySkuInsureRspBO = new QuerySkuInsureRspBO();
                    BeanUtils.copyProperties((Object)skuAndInsurePO, (Object)querySkuInsureRspBO);
                    querySkuInsureRspBO.setSecurityServicesTypeStr((String)mapsecurityServicesType.get(querySkuInsureRspBO.getSecurityServicesType()));
                    querySkuInsureRspBO.setSalePriceM(this.L2M(querySkuInsureRspBO.getSalePrice()));
                    querySkuInsureRspBO.setLimitPriceM(this.L2M(querySkuInsureRspBO.getLimitPrice()));
                    querySkuInsureRspBO.setPurchasePriceM(this.L2M(querySkuInsureRspBO.getPurchasePrice()));
                    querySkuInsureRspBO.setRealityPriceM(this.L2M(querySkuInsureRspBO.getRealityPrice()));
                    dProvGoodsPO = this.dProvGoodsDAO.selectByPrimaryKey(querySkuInsureRspBO.getProvGoodsId());
                    querySkuInsureRspBO.setWhetherInvoice(dProvGoodsPO.getWhetherInvoice());
                    listQuerySkuInsureRspBO.add(querySkuInsureRspBO);
                }
            }
            if (CollectionUtils.isNotEmpty(skuAndInsurePOList) && CollectionUtils.isEmpty(skuAndInsurePOList1)) {
                logger.debug("\u53d6\u5e76\u96c6=" + JSON.toJSONString(skuAndInsurePOList));
                for (SkuAndInsurePO skuAndInsurePO : skuAndInsurePOList) {
                    querySkuInsureRspBO = new QuerySkuInsureRspBO();
                    BeanUtils.copyProperties((Object)skuAndInsurePO, (Object)querySkuInsureRspBO);
                    querySkuInsureRspBO.setSecurityServicesTypeStr((String)mapsecurityServicesType.get(querySkuInsureRspBO.getSecurityServicesType()));
                    querySkuInsureRspBO.setSalePriceM(this.L2M(querySkuInsureRspBO.getSalePrice()));
                    querySkuInsureRspBO.setLimitPriceM(this.L2M(querySkuInsureRspBO.getLimitPrice()));
                    querySkuInsureRspBO.setPurchasePriceM(this.L2M(querySkuInsureRspBO.getPurchasePrice()));
                    querySkuInsureRspBO.setRealityPriceM(this.L2M(querySkuInsureRspBO.getRealityPrice()));
                    dProvGoodsPO = this.dProvGoodsDAO.selectByPrimaryKey(querySkuInsureRspBO.getProvGoodsId());
                    querySkuInsureRspBO.setWhetherInvoice(dProvGoodsPO.getWhetherInvoice());
                    listQuerySkuInsureRspBO.add(querySkuInsureRspBO);
                }
            }
        }
        result.setRows(listQuerySkuInsureRspBO);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    private BigDecimal L2M(Long price) {
        BigDecimal price1 = new BigDecimal("0");
        if (price == null) {
            return price1;
        }
        try {
            price1 = MoneyUtils.Long2BigDecimal((Long)price);
        }
        catch (Exception e) {
            logger.error("\u91d1\u989d\u8f6c\u6362\u5f02\u5e38");
        }
        return price1;
    }
}

