/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.commodity.atom.price.bo.PriceBO;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.busi.sku.QuerySkuListByManyListService;
import com.xls.commodity.busi.sku.QuerySkuPriceBySkuIdsService;
import com.xls.commodity.busi.sku.bo.QuerySkuListByManyListReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListByManyListRspBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListPageByManyListReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListPageByManyListRspBO;
import com.xls.commodity.busi.sku.bo.QuerySkuPriceBySkuIdsRspBO;
import com.xls.commodity.dao.CatalogCommodityTypeDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.CatalogCommodityTypePO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListByManyListServiceImpl
implements QuerySkuListByManyListService {
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private CatalogCommodityTypeDAO catalogCommodityTypeDAO;
    @Autowired
    private QuerySkuPriceBySkuIdsService querySkuPriceBySkuIdsService;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListByManyListServiceImpl.class);
    private static final Integer MemberLadder1 = 1;
    private static final Integer MemberLadder2 = 3;
    private static final Integer MemberLadder3 = 4;

    public RspInfoListBO<QuerySkuListByManyListRspBO> querySkuListByManyList(QuerySkuListByManyListReqBO querySkuListByManyListReqBO) {
        logger.info("\u6839\u636e\u591a\u4e2a\u5217\u8868\u67e5\u8be2sku\u5217\u8868\u670d\u52a1\u5165\u53c2=" + querySkuListByManyListReqBO.toString());
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<QuerySkuListByManyListRspBO> querySkuListByManyListRspBOs = new ArrayList<QuerySkuListByManyListRspBO>();
        Sku sku = new Sku();
        sku.setSkuIds(querySkuListByManyListReqBO.getSkuIds());
        sku.setCommodityIds(querySkuListByManyListReqBO.getCommodityIds());
        sku.setSupplierIds(querySkuListByManyListReqBO.getSupplierIds());
        sku.setCgType(querySkuListByManyListReqBO.getCgType());
        List guideCatalogIds = querySkuListByManyListReqBO.getGuideCatalogIds();
        ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)guideCatalogIds)) {
            try {
                List<CatalogCommodityTypePO> catalogCommodityTypePOs = this.catalogCommodityTypeDAO.selectByGuideCatalogIds(guideCatalogIds);
                if (CollectionUtils.isNotEmpty(catalogCommodityTypePOs)) {
                    for (CatalogCommodityTypePO catalogCommodityTypePO : catalogCommodityTypePOs) {
                        commodityTypeIds.add(catalogCommodityTypePO.getCommodityTypeId());
                    }
                }
            }
            catch (Exception e) {
                result.setRows(querySkuListByManyListRspBOs);
                result.setRespCode("8888");
                result.setRespDesc("\u6839\u636e\u591a\u4e2a\u5bfc\u8d2d\u7c7b\u76eeID\u67e5\u8be2\u7c7b\u578bID\u62a5\u9519");
                return result;
            }
        }
        sku.setCommodityTypeIds(commodityTypeIds);
        sku.setExtSkuIds(querySkuListByManyListReqBO.getExtSkuIds());
        sku.setMaterialIds(querySkuListByManyListReqBO.getMaterialIds());
        List<Object> skus = new ArrayList();
        try {
            skus = this.xlsSkuMapper.querySkuListByManyList(sku);
        }
        catch (Exception e) {
            result.setRows(querySkuListByManyListRspBOs);
            result.setRespCode("8888");
            result.setRespDesc("\u6839\u636e\u591a\u4e2alist\u67e5\u8be2\u5546\u54c1\u5217\u8868\u62a5\u9519");
            return result;
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            for (Sku sku2 : skus) {
                QuerySkuListByManyListRspBO querySkuListByManyListRspBO = new QuerySkuListByManyListRspBO();
                BeanUtils.copyProperties((Object)sku2, (Object)querySkuListByManyListRspBO);
                querySkuListByManyListRspBOs.add(querySkuListByManyListRspBO);
            }
        }
        result.setRows(querySkuListByManyListRspBOs);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public RspPageBO<QuerySkuListPageByManyListRspBO> querySkuListPageByManyList(QuerySkuListPageByManyListReqBO querySkuListPageByManyListReqBO) {
        logger.info("\u6839\u636e\u591a\u4e2a\u5217\u8868\u67e5\u8be2sku\u5217\u8868\u5206\u9875\u670d\u52a1\u5165\u53c2=" + querySkuListPageByManyListReqBO.toString());
        RspPageBO result = new RspPageBO();
        ArrayList<QuerySkuListPageByManyListRspBO> querySkuListByManyListRspBOs = new ArrayList<QuerySkuListPageByManyListRspBO>();
        Integer memLevel = querySkuListPageByManyListReqBO.getMemLevel();
        Sku sku = new Sku();
        sku.setSkuIds(querySkuListPageByManyListReqBO.getSkuIds());
        sku.setCommodityIds(querySkuListPageByManyListReqBO.getCommodityIds());
        sku.setSupplierIds(querySkuListPageByManyListReqBO.getSupplierIds());
        sku.setCgType(querySkuListPageByManyListReqBO.getCgType());
        sku.setBrandNames(querySkuListPageByManyListReqBO.getBrandNames());
        sku.setSkuStatusList(querySkuListPageByManyListReqBO.getSkuStatusList());
        List guideCatalogIds = querySkuListPageByManyListReqBO.getGuideCatalogIds();
        ArrayList<Long> commodityTypeIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)guideCatalogIds)) {
            try {
                List<CatalogCommodityTypePO> catalogCommodityTypePOs = this.catalogCommodityTypeDAO.selectByGuideCatalogIds(guideCatalogIds);
                if (CollectionUtils.isNotEmpty(catalogCommodityTypePOs)) {
                    for (CatalogCommodityTypePO catalogCommodityTypePO : catalogCommodityTypePOs) {
                        commodityTypeIds.add(catalogCommodityTypePO.getCommodityTypeId());
                    }
                }
            }
            catch (Exception e) {
                result.setRows(querySkuListByManyListRspBOs);
                result.setRespCode("8888");
                result.setRespDesc("\u6839\u636e\u591a\u4e2a\u5bfc\u8d2d\u7c7b\u76eeID\u67e5\u8be2\u7c7b\u578bID\u62a5\u9519");
            }
        }
        sku.setCommodityTypeIds(commodityTypeIds);
        Page page = new Page();
        page.setLimit(querySkuListPageByManyListReqBO.getPageSize());
        page.setOffset(querySkuListPageByManyListReqBO.getOffset());
        List<Object> skus = new ArrayList();
        try {
            skus = this.xlsSkuMapper.querySkuListPageByManyList(sku, (Page<Sku>)page);
        }
        catch (Exception e) {
            result.setRows(querySkuListByManyListRspBOs);
            result.setRespCode("8888");
            result.setRespDesc("\u6839\u636e\u591a\u4e2alist\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5206\u9875\u62a5\u9519");
            return result;
        }
        ArrayList<Long> skuIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(skus)) {
            for (Sku sku2 : skus) {
                skuIds.add(sku2.getSkuId());
            }
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            QuerySkuPriceBySkuIdsRspBO querySkuPriceBySkuIdsRspBO = new QuerySkuPriceBySkuIdsRspBO();
            try {
                querySkuPriceBySkuIdsRspBO = this.querySkuPriceBySkuIdsService.querySkuPriceBySkuIds(skuIds);
            }
            catch (Exception exception) {
                result.setRows(querySkuListByManyListRspBOs);
                result.setRespCode("8888");
                result.setRespDesc("\u6839\u636e\u591a\u4e2a\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u4f1a\u5458\u4ef7\u62a5\u9519");
                return result;
            }
            Map map = querySkuPriceBySkuIdsRspBO.getMapPriceBO();
            if (!map.isEmpty()) {
                for (Sku sku3 : skus) {
                    QuerySkuListPageByManyListRspBO querySkuListByManyListRspBO = new QuerySkuListPageByManyListRspBO();
                    BeanUtils.copyProperties((Object)sku3, (Object)querySkuListByManyListRspBO);
                    PriceBO priceBO = (PriceBO)map.get(sku3.getSkuId());
                    if (memLevel == MemberLadder1) {
                        querySkuListByManyListRspBO.setMemberPrice(priceBO.getMemberLadderPrice1());
                    } else if (memLevel == MemberLadder2) {
                        querySkuListByManyListRspBO.setMemberPrice(priceBO.getMemberLadderPrice2());
                    } else if (memLevel == MemberLadder3) {
                        querySkuListByManyListRspBO.setMemberPrice(priceBO.getMemberLadderPrice3());
                    }
                    querySkuListByManyListRspBOs.add(querySkuListByManyListRspBO);
                }
            }
        }
        result.setRows(querySkuListByManyListRspBOs);
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

