/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.commodity.dao.po.SkuPrice;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.busi.sku.QueryXlsSkuByMaterialAndProvListService;
import com.xls.commodity.busi.sku.bo.DSkuBO;
import com.xls.commodity.busi.sku.bo.OtherBO;
import com.xls.commodity.busi.sku.bo.QueryXlsSkuByMaterialAndProvReqBO;
import com.xls.commodity.busi.sku.bo.QueryXlsSkuByMaterialAndProvReqPageBO;
import com.xls.commodity.busi.sku.bo.QueryXlsSkuByProvBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityBO;
import com.xls.commodity.busi.sku.bo.XlsSearchBarEsRspInfo;
import com.xls.commodity.dao.XlsCommodityDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.dao.po.XlsCommodityPO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QueryXlsSkuByMaterialAndProvListServiceImpl
implements QueryXlsSkuByMaterialAndProvListService {
    private static final Logger logger = LoggerFactory.getLogger(QueryXlsSkuByMaterialAndProvListServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private XlsCommodityDAO xlsCommodityDAO;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public RspInfoListBO<DSkuBO> queryXlsSkuByMaterialAndProvList(QueryXlsSkuByMaterialAndProvReqBO reqBO) {
        logger.debug("\u67e5\u8be2\u5546\u54c1\u4fe1\u606f");
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<DSkuBO> rows = new ArrayList<DSkuBO>();
        ArrayList<Sku> recore = new ArrayList<Sku>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getList())) {
            Sku po = null;
            for (QueryXlsSkuByProvBO req : reqBO.getList()) {
                po = new Sku();
                po.setProvinceCode(req.getProvinceCode());
                po.setCityCode(req.getCityCode());
                po.setSupplierId(req.getSupplierId());
                po.setCountyCode(req.getCountyCode());
                po.setMaterialId(req.getMaterialId());
                recore.add(po);
            }
        } else {
            result.setRespCode("9999");
            result.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        try {
            List<Sku> poList = this.xlsSkuMapper.queryXlsSkuByMaterialAndProvList(recore);
            if (!CollectionUtils.isEmpty(poList)) {
                DSkuBO bo = null;
                for (Sku po : poList) {
                    bo = new DSkuBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            result.setRows(rows);
            return result;
        }
        result.setRespCode("0000");
        result.setRows(rows);
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspPageBO<DSkuBO> queryXlsSkuByMaterialAndProvListByPage(QueryXlsSkuByMaterialAndProvReqPageBO reqBO) {
        logger.debug("\u5206\u9875\u67e5\u8be2\u5546\u54c1\u4fe1\u606f");
        RspPageBO result = new RspPageBO();
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        ArrayList<DSkuBO> rows = new ArrayList<DSkuBO>();
        ArrayList<Sku> recore = new ArrayList<Sku>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getList())) {
            Sku po = null;
            for (QueryXlsSkuByProvBO req : reqBO.getList()) {
                po = new Sku();
                po.setProvinceCode(req.getProvinceCode());
                po.setCityCode(req.getCityCode());
                po.setSupplierId(req.getSupplierId());
                po.setCountyCode(req.getCountyCode());
                po.setMaterialId(req.getMaterialId());
                recore.add(po);
            }
        } else {
            result.setRespCode("9999");
            result.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            result.setRows(rows);
            return result;
        }
        try {
            List<Sku> poList = this.xlsSkuMapper.queryXlsSkuByMaterialAndProv(recore, (Page<Sku>)page);
            if (!CollectionUtils.isEmpty(poList)) {
                DSkuBO bo = null;
                for (Sku po : poList) {
                    bo = new DSkuBO();
                    BeanUtils.copyProperties((Object)po, (Object)bo);
                    rows.add(bo);
                }
            }
        }
        catch (Exception e) {
            result.setRespCode("9999");
            result.setRespDesc("\u7cfb\u7edf\u5f02\u5e38");
            result.setRows(rows);
            return result;
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRows(rows);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspInfoListBO<XlsSearchBarEsRspInfo> queryOther(OtherBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<XlsSearchBarEsRspInfo> rows = new ArrayList<XlsSearchBarEsRspInfo>();
        HashMap<Long, XlsCommodityBO> mapXlsCommodityBO = new HashMap<Long, XlsCommodityBO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            logger.debug("\u67e5\u8be2spu");
            List<XlsCommodityPO> xlsCommodityPOs = this.xlsCommodityDAO.selectByCommodityIds(reqBO.getCommodityIds());
            if (!CollectionUtils.isEmpty(xlsCommodityPOs)) {
                for (XlsCommodityPO xlsCommodityPO : xlsCommodityPOs) {
                    XlsCommodityBO xlsCommodityBO = new XlsCommodityBO();
                    BeanUtils.copyProperties((Object)xlsCommodityPO, (Object)xlsCommodityBO);
                    mapXlsCommodityBO.put(xlsCommodityPO.getCommodityId(), xlsCommodityBO);
                }
            }
        }
        logger.debug("sup" + JSONObject.toJSONString(mapXlsCommodityBO));
        HashMap<Long, SkuPrice> mapSkuPrice = new HashMap<Long, SkuPrice>();
        List<Object> skus = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            logger.debug("\u67e5\u8be2\u4ef7\u683c");
            List skuPrices = this.skuPriceMapper.selectBySkuIds(reqBO.getSkuIds());
            for (SkuPrice skuPrice : skuPrices) {
                mapSkuPrice.put(skuPrice.getSkuId(), skuPrice);
            }
            logger.debug("\u67e5\u8be2sku");
            skus = this.xlsSkuMapper.selectBySkuIds(reqBO.getSkuIds());
        }
        if (!CollectionUtils.isEmpty(skus)) {
            for (Sku sku : skus) {
                XlsSearchBarEsRspInfo xlsSearchBarEsRspInfo = new XlsSearchBarEsRspInfo();
                BeanUtils.copyProperties((Object)sku, (Object)xlsSearchBarEsRspInfo);
                xlsSearchBarEsRspInfo.setSkuId(sku.getSkuId().toString());
                xlsSearchBarEsRspInfo.setXlsCommodityBO((XlsCommodityBO)mapXlsCommodityBO.get(sku.getCommodityId()));
                logger.debug("supId" + sku.getCommodityId());
                SkuPrice skuPrice = (SkuPrice)mapSkuPrice.get(sku.getSkuId());
                xlsSearchBarEsRspInfo.setMaterialId(sku.getMaterialId());
                try {
                    if (reqBO.getMemLevel() == 0) {
                        if (null != skuPrice.getMemberLadderPrice2()) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMemberLadderPrice2()));
                        }
                    } else if (reqBO.getMemLevel() == 1) {
                        if (null != skuPrice.getMemberLadderPrice1()) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMemberLadderPrice1()));
                        }
                    } else if (reqBO.getMemLevel() == 3) {
                        if (null != skuPrice.getMemberLadderPrice2()) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMemberLadderPrice2()));
                        }
                    } else if (reqBO.getMemLevel() == 4 && null != skuPrice.getMemberLadderPrice3()) {
                        xlsSearchBarEsRspInfo.setMemberLadderPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMemberLadderPrice3()));
                    }
                    if (xlsSearchBarEsRspInfo.getMemberLadderPrice() != null) {
                        if (skuPrice.getPurchasePrice() != null) {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(xlsSearchBarEsRspInfo.getMemberLadderPrice().setScale(0, 4));
                        } else {
                            xlsSearchBarEsRspInfo.setMemberLadderPrice(xlsSearchBarEsRspInfo.getMemberLadderPrice().setScale(2, 4));
                        }
                    }
                    xlsSearchBarEsRspInfo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)sku.getSkuPrice()));
                    xlsSearchBarEsRspInfo.setMarketPrice(MoneyUtils.Long2BigDecimal((Long)skuPrice.getMarketPrice()));
                    xlsSearchBarEsRspInfo.setPriPicUrl(sku.getSkuMainPicUrl());
                    xlsSearchBarEsRspInfo.setSkuLocation(sku.getSkuLocation().toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u4f1a\u5458\u68af\u5ea6\u4ef7\u683c\u8f6c\u6362\u62a5\u9519" + e.getMessage());
                }
                rows.add(xlsSearchBarEsRspInfo);
            }
        }
        result.setRows(rows);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }
}

