/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.umc.ability.UmcQryMemByManagementAbilityService;
import com.tydic.umc.ability.bo.UmcQryMemByManagementAbilityReqBO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.busi.bo.UmcMemberInfoBO;
import com.xls.commodity.busi.sku.ShareAndBuyService;
import com.xls.commodity.busi.sku.bo.ShareAndBuyBO;
import com.xls.commodity.busi.sku.bo.ShareAndBuyReqBO;
import com.xls.commodity.busi.sku.bo.ShareAndBuyReqPageBO;
import com.xls.commodity.busi.sku.bo.ShopJsonBO;
import com.xls.commodity.dao.DSkuShareBuyDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.dao.po.XlsShareAndByPO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import com.xls.commodity.util.HttpUntil;
import com.xls.commodity.util.TkHttpRequestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShareAndBuyServiceImpl
implements ShareAndBuyService {
    private static final Logger logger = LoggerFactory.getLogger(ShareAndBuyServiceImpl.class);
    @Autowired
    private DSkuShareBuyDAO dSkuShareBuyDAO;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private UmcQryMemByManagementAbilityService umcQryMemByManagementAbilityService;
    @Value(value="${getShopUrl}")
    private String getShopUrl;

    public RspInfoListBO<ShareAndBuyBO> getShareAndBuy(ShareAndBuyReqBO reqBO) {
        RspInfoListBO result = new RspInfoListBO();
        XlsShareAndByPO record = this.bo2PO(reqBO);
        List<XlsShareAndByPO> poList = null;
        logger.debug("\u67e5\u8be2\u8bb0\u5f55");
        try {
            poList = this.dSkuShareBuyDAO.selectShareAndBuy(reqBO.getSupplierIdList(), record);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(poList)) {
            result.setRespCode("0000");
            result.setRespDesc("\u67e5\u65e0\u7ed3\u679c");
            return result;
        }
        List<Object> boList = new ArrayList();
        try {
            boList = this.getResult(poList);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        result.setRespCode("0000");
        result.setRows(boList);
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public RspPageBO<ShareAndBuyBO> getShareAndBuyByPage(ShareAndBuyReqPageBO reqBO) {
        RspPageBO result = new RspPageBO();
        Page page = new Page();
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getOffset());
        XlsShareAndByPO record = this.pageBO2PO(reqBO);
        List<XlsShareAndByPO> poList = null;
        try {
            poList = this.dSkuShareBuyDAO.selectShareAndBuy(reqBO.getSupplierIdList(), record, (Page<XlsShareAndByPO>)page);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(poList)) {
            result.setRespCode("0000");
            result.setRespDesc("\u67e5\u65e0\u7ed3\u679c");
            return result;
        }
        List<Object> boList = new ArrayList();
        try {
            boList = this.getResult(poList);
        }
        catch (Exception e) {
            logger.error("\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u5206\u4eab\u8bb0\u5f55\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        result.setRows(boList);
        result.setRespCode("0000");
        result.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return result;
    }

    public List<ShareAndBuyBO> getResult(List<XlsShareAndByPO> poList) throws Exception {
        ArrayList<String> sharers = new ArrayList<String>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        HashSet<Long> shopIds = new HashSet<Long>();
        for (XlsShareAndByPO po : poList) {
            if (!skuIds.contains(po.getSkuId())) {
                skuIds.add(po.getSkuId());
            }
            if (!sharers.contains(po.getSharer().toString().trim())) {
                sharers.add(po.getSharer().toString().trim());
            }
            shopIds.add(po.getSupplierId());
        }
        HashMap<Long, Sku> skuMap = new HashMap<Long, Sku>();
        logger.debug("\u67e5\u8be2sku\u4fe1\u606f");
        List<Sku> skuList = this.xlsSkuMapper.selectSkuBySkuIdList(skuIds);
        if (CollectionUtils.isNotEmpty(skuList)) {
            for (Sku sku : skuList) {
                if (skuMap.containsKey(sku.getSkuId())) continue;
                skuMap.put(sku.getSkuId(), sku);
            }
        }
        UmcQryMemByManagementAbilityReqBO umcQryMemByManagementAbilityReqBO = new UmcQryMemByManagementAbilityReqBO();
        umcQryMemByManagementAbilityReqBO.setMemIds(sharers);
        HashMap<Long, UmcMemberInfoBO> memMap = new HashMap<Long, UmcMemberInfoBO>();
        List umcMemberInfoBOList = new ArrayList();
        logger.debug("\u67e5\u8be2\u4f1a\u5458\u4fe1\u606f");
        UmcRspListBO memResult = this.umcQryMemByManagementAbilityService.qryMemList(umcQryMemByManagementAbilityReqBO);
        if (memResult != null && !CollectionUtils.isEmpty((Collection)memResult.getRows())) {
            umcMemberInfoBOList = memResult.getRows();
            for (UmcMemberInfoBO mem : umcMemberInfoBOList) {
                if (memMap.containsKey(mem.getMemId())) continue;
                memMap.put(mem.getMemId(), mem);
            }
        }
        logger.debug("\u83b7\u53d6\u5e97\u94fa\u4fe1\u606f");
        HashMap<Long, ShopJsonBO> shopMap = new HashMap<Long, ShopJsonBO>();
        List<ShopJsonBO> rows = this.getShopDetail(shopIds);
        if (CollectionUtils.isNotEmpty(rows)) {
            for (ShopJsonBO shops : rows) {
                if (shopMap.containsKey(shops.getShopId())) continue;
                shopMap.put(shops.getShopId(), shops);
            }
        }
        ShareAndBuyBO bo = null;
        ArrayList<ShareAndBuyBO> boList = new ArrayList<ShareAndBuyBO>();
        for (XlsShareAndByPO po : poList) {
            bo = new ShareAndBuyBO();
            if (po.getSharer() != null) {
                bo.setMemName(((UmcMemberInfoBO)memMap.get(po.getSharer())).getReservedField5());
            }
            if (po.getSkuId() != null) {
                bo.setSkuName(((Sku)skuMap.get(po.getSkuId())).getSkuName());
            }
            if (po.getSupplierId() != null) {
                bo.setShopName(((ShopJsonBO)shopMap.get(po.getSupplierId())).getShopName());
                bo.setProvinceCodeStr(((ShopJsonBO)shopMap.get(po.getSupplierId())).getProvinceName());
            }
            bo.setProvinceCode(po.getProvinceCode());
            bo.setShareBuyCount(po.getShareBuyCount());
            if (po.getShareBuyPriceCount() != null) {
                bo.setShareBuyPriceCount(MoneyUtils.Long2BigDecimal((Long)po.getShareBuyPriceCount()));
            }
            bo.setShareCount(po.getShareCount());
            bo.setSharer(po.getSharer());
            bo.setSkuId(po.getSkuId());
            bo.setSupplierId(po.getSupplierId());
            boList.add(bo);
        }
        return boList;
    }

    public XlsShareAndByPO bo2PO(ShareAndBuyReqBO reqBO) {
        XlsShareAndByPO po = new XlsShareAndByPO();
        po.setEndTime(reqBO.getEndTime());
        po.setSharer(reqBO.getSharer());
        po.setStartTime(reqBO.getStartTime());
        return po;
    }

    public XlsShareAndByPO pageBO2PO(ShareAndBuyReqPageBO reqBO) {
        XlsShareAndByPO po = new XlsShareAndByPO();
        po.setEndTime(reqBO.getEndTime());
        po.setSharer(reqBO.getSharer());
        po.setStartTime(reqBO.getStartTime());
        return po;
    }

    public List<ShopJsonBO> getShopDetail(Set<Long> shopIds) throws Exception {
        JSONArray array = (JSONArray)JSONArray.parse((String)shopIds.toString());
        String comeBack = "";
        if (this.getShopUrl.startsWith("https")) {
            comeBack = TkHttpRequestUtils.conn(null, array.toString(), null, this.getShopUrl, null, null);
        } else {
            HttpUntil httpUntil = new HttpUntil();
            comeBack = httpUntil.httpPost(this.getShopUrl, array.toString());
        }
        System.out.println(comeBack);
        JSONObject jsonToStringSuperBOJson = (JSONObject)JSONObject.parse((String)comeBack);
        JSONArray A = jsonToStringSuperBOJson.getJSONArray("rows");
        List result = A.toJavaList(ShopJsonBO.class);
        return result;
    }
}

