/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.cgd.commodity.dao.SkuMapper;
import com.cgd.commodity.po.Sku;
import com.ohaotian.commodity.atom.sku.UpdateSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.SkuBO;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.atom.sku.XlsCommodityManageService;
import com.xls.commodity.busi.sku.SortCommodityPriceService;
import com.xls.commodity.busi.sku.bo.XlsCommodityBO;
import com.xls.commodity.dao.XlsCommodityDAO;
import com.xls.commodity.dao.po.XlsCommodityPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.util.SortLongListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SortCommodityPriceServiceImpl
implements SortCommodityPriceService {
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    @Autowired
    private XlsCommodityManageService xlsCommodityManageService;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private XlsCommodityDAO xlsCommodityDAO;
    private static final Logger logger = LoggerFactory.getLogger(SortCommodityPriceServiceImpl.class);

    public BaseRspBO sortCommodityPrice(Long commodityId) {
        BaseRspBO baseRspBO = new BaseRspBO();
        List skus = null;
        try {
            skus = this.updateSkuAtomService.selectByCommodityId(commodityId);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u5355\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u5355\u6761\u4fee\u6539\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        if (CollectionUtils.isNotEmpty((Collection)skus)) {
            ArrayList<Long> priceList = new ArrayList<Long>();
            for (SkuBO skuBO : skus) {
                if (skuBO.getSkuStatus() != 2) continue;
                priceList.add(skuBO.getSkuPrice());
            }
            logger.info("\u4ef7\u683c\u5217\u8868=" + ((Object)priceList).toString());
            XlsCommodityBO xlsCommodityBO = new XlsCommodityBO();
            if (CollectionUtils.isNotEmpty(priceList)) {
                Long[] numbers = SortLongListUtils.sortLongList(priceList);
                xlsCommodityBO.setCommodityLowestPrice(numbers[0]);
                xlsCommodityBO.setCommodityHighestPrice(numbers[numbers.length - 1]);
            }
            xlsCommodityBO.setCommodityId(commodityId);
            xlsCommodityBO.setIsBindSku("1");
            try {
                this.xlsCommodityManageService.updateXlsCommodity(xlsCommodityBO);
            }
            catch (Exception e) {
                logger.error("\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u670d\u52a1\u62a5\u9519");
                throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u670d\u52a1\u62a5\u9519" + e.getMessage());
            }
        }
        XlsCommodityBO xlsCommodityBO = new XlsCommodityBO();
        xlsCommodityBO.setIsBindSku("0");
        xlsCommodityBO.setCommodityId(commodityId);
        try {
            this.xlsCommodityManageService.updateXlsCommodity(xlsCommodityBO);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u5546\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u4fee\u6539\u5546\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO sortCommodityPrice(List<Long> commodityIds) {
        BaseRspBO baseRspBO = new BaseRspBO();
        HashMap<Long, ArrayList<Sku>> mapListSku = new HashMap<Long, ArrayList<Sku>>();
        try {
            List skus = this.skuMapper.selectByCommodityIds(commodityIds);
            if (CollectionUtils.isNotEmpty((Collection)skus)) {
                for (Sku sku : skus) {
                    ArrayList<Sku> sku1s = (ArrayList<Sku>)mapListSku.get(sku.getCommodityId());
                    if (CollectionUtils.isNotEmpty((Collection)sku1s)) {
                        sku1s.add(sku);
                        continue;
                    }
                    sku1s = new ArrayList<Sku>();
                    sku1s.add(sku);
                    mapListSku.put(sku.getCommodityId(), sku1s);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u5546\u54c1ID\u5217\u8868\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u62a5\u9519");
        }
        ArrayList<XlsCommodityPO> xlsCommodityPOs = new ArrayList<XlsCommodityPO>();
        if (!mapListSku.isEmpty()) {
            for (Map.Entry entry : mapListSku.entrySet()) {
                List skus = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)skus)) continue;
                ArrayList<Long> priceList = new ArrayList<Long>();
                for (Sku skuBO : skus) {
                    if (skuBO.getSkuStatus() != 2 || skuBO.getSkuPrice() == null) continue;
                    priceList.add(skuBO.getSkuPrice());
                }
                if (!CollectionUtils.isNotEmpty(priceList)) continue;
                Long[] numbers = SortLongListUtils.sortLongList(priceList);
                XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
                xlsCommodityPO.setCommodityId((Long)entry.getKey());
                xlsCommodityPO.setIsBindSku("1");
                xlsCommodityPO.setCommodityLowestPrice(numbers[0]);
                xlsCommodityPO.setCommodityHighestPrice(numbers[numbers.length - 1]);
                xlsCommodityPOs.add(xlsCommodityPO);
            }
        }
        try {
            this.xlsCommodityDAO.batchUpdateByPrimaryKeySelective(xlsCommodityPOs);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6279\u91cf\u4fee\u6539\u5546\u54c1\u7684\u6700\u9ad8\u4ef7\u548c\u6700\u4f4e\u4ef7\u62a5\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

