/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.base.common.exception.ResourceException;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.SysParamTransferBusiService;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.SysParamsDAO;
import com.xls.commodity.dao.po.SysParamsPO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SysParamTransferBusiServiceImpl
implements SysParamTransferBusiService {
    private static final Logger log = LoggerFactory.getLogger(SysParamTransferBusiServiceImpl.class);
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private SysParamsDAO sysParamsDAO;

    public Map<String, String> sysParamTransferByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            log.error("\u7801\u8868\u8f6c\u4e49\u7236\u7ea7\u7f16\u7801\u548c\u7f16\u7801\u4e3a\u7a7a");
            throw new ResourceException("9999", "\u7236\u7ea7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, String> value = new HashMap<String, String>();
        List<SysParamsPO> list = null;
        try {
            list = this.sysParamsDAO.selectByParentCode(parentCode);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u51fa\u9519" + e);
            return value;
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (SysParamsPO po : list) {
                value.put(po.getCode(), po.getCodeTitle());
            }
        }
        log.info("\u7801\u8868\u8f6c\u4e49\u51fa\u53c2\uff1a" + value);
        return value;
    }

    public String sysParamTransferByParentCodeAndCode(SysParamTransBusiBO sysParamTransBusiBO) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)sysParamTransBusiBO.getParentCode()) || StringUtils.isBlank((CharSequence)sysParamTransBusiBO.getCode())) {
            log.error("\u7801\u8868\u8f6c\u4e49\u7236\u7ea7\u7f16\u7801\u548c\u7f16\u7801\u4e3a\u7a7a");
            throw new ResourceException("9999", "\u7236\u7ea7\u7f16\u7801\u548c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String parentCode = sysParamTransBusiBO.getParentCode();
        String code = sysParamTransBusiBO.getCode();
        log.info("\u7f13\u5b58\u4e2d\u4e0d\u5b58\u5728\u9700\u8981\u8f6c\u4e49\u7684\u4fe1\u606f \u524d\u53bb\u6570\u636e\u4e2d\u67e5\u8be2");
        Map<String, String> atomRsp = this.sysParamsAtomService.selectByParentCode(parentCode);
        if (MapUtils.isNotEmpty(atomRsp)) {
            result = atomRsp.get(code);
        }
        return result;
    }

    public RspInfoListBO<SysParamTransBusiBO> sysParamTransferListByParentCode(SysParamTransBusiBO sysParamTransBusiBO) {
        RspInfoListBO rsp = new RspInfoListBO();
        try {
            String parentCode = sysParamTransBusiBO.getParentCode();
            ArrayList<SysParamTransBusiBO> result = new ArrayList<SysParamTransBusiBO>();
            List<SysParamsPO> list = null;
            list = this.sysParamsDAO.selectByParentCode(parentCode);
            if (CollectionUtils.isNotEmpty(list)) {
                for (SysParamsPO po : list) {
                    result.add(po.toSysParamTransBusiBO());
                }
            }
            rsp.setRows(result);
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5931\u8d25");
        }
        return rsp;
    }
}

