/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.intfce.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.bo.SysParamTransBusiBO;
import com.xls.commodity.dao.DProvGoodsDAO;
import com.xls.commodity.intfce.sku.DProvGoodsService;
import com.xls.commodity.intfce.sku.bo.DProvGoodParametersBO;
import com.xls.commodity.intfce.sku.bo.DProvGoodsBO;
import com.xls.commodity.intfce.sku.bo.DProvGoodsBigDecimalBO;
import com.xls.commodity.intfce.sku.bo.RspPageBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DProvGoodsServiceImpl
implements DProvGoodsService {
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private DProvGoodsDAO dProvGoodsDAO;
    private static final Logger logger = LoggerFactory.getLogger(DProvGoodsServiceImpl.class);

    public RspPageBO<DProvGoodsBigDecimalBO> conditionQueryDProvGoodsBO(DProvGoodParametersBO dProvGoodParametersBO) {
        logger.debug("\u6743\u76ca\u5546\u54c1\u7ba1\u7406  \u7684\u6761\u4ef6\u67e5\u8be2=" + JSON.toJSONString((Object)dProvGoodParametersBO));
        RspPageBO result = new RspPageBO();
        Page page = new Page();
        page.setLimit(dProvGoodParametersBO.getLimit());
        page.setOffset(dProvGoodParametersBO.getOffset());
        try {
            ArrayList<DProvGoodsBigDecimalBO> dProvGoodsBigDecimalBOList = new ArrayList<DProvGoodsBigDecimalBO>();
            List<DProvGoodsBO> dProvGoodsBOList = this.dProvGoodsDAO.conditionQueryDProvGoodsBO(dProvGoodParametersBO, (Page<DProvGoodsBO>)page);
            page.setResult(dProvGoodsBOList);
            page.setTotalCount(dProvGoodsBOList.size());
            if (CollectionUtils.isNotEmpty(dProvGoodsBOList)) {
                Map<String, Map<String, String>> escaMap = this.getEscape();
                for (DProvGoodsBO dProvGoodsBO : dProvGoodsBOList) {
                    DProvGoodsBigDecimalBO dProvGoodsBigDecimalBO = new DProvGoodsBigDecimalBO();
                    if (dProvGoodsBO.getProvGoodsId() != null) {
                        dProvGoodsBigDecimalBO.setProvGoodsId(dProvGoodsBO.getProvGoodsId());
                    }
                    if (!StringUtils.isBlank((CharSequence)dProvGoodsBO.getMaterialId())) {
                        dProvGoodsBigDecimalBO.setMaterialId(dProvGoodsBO.getMaterialId());
                    }
                    if (!StringUtils.isBlank((CharSequence)dProvGoodsBO.getProductCode())) {
                        dProvGoodsBigDecimalBO.setProductCode(dProvGoodsBO.getProductCode());
                    }
                    if (!StringUtils.isBlank((CharSequence)dProvGoodsBO.getGoodsName())) {
                        dProvGoodsBigDecimalBO.setGoodsName(dProvGoodsBO.getGoodsName());
                    }
                    if (!StringUtils.isBlank((CharSequence)dProvGoodsBO.getGoodsNo())) {
                        dProvGoodsBigDecimalBO.setGoodsNo(dProvGoodsBO.getGoodsNo());
                    }
                    if (!StringUtils.isBlank((CharSequence)dProvGoodsBO.getRelatedCommodityCode())) {
                        dProvGoodsBigDecimalBO.setRelatedCommodityCode(dProvGoodsBO.getRelatedCommodityCode());
                    }
                    if (!StringUtils.isBlank((CharSequence)dProvGoodsBO.getSupNo())) {
                        dProvGoodsBigDecimalBO.setSupNo(dProvGoodsBO.getSupNo());
                    }
                    if (!StringUtils.isBlank((CharSequence)dProvGoodsBO.getInterestsStatus())) {
                        dProvGoodsBigDecimalBO.setInterestsStatusStr(dProvGoodsBO.getInterestsStatus());
                    }
                    if (dProvGoodsBO.getRealityPrice() != null) {
                        dProvGoodsBigDecimalBO.setRealityPrice(MoneyUtils.Long2BigDecimal((Long)dProvGoodsBO.getRealityPrice()));
                    }
                    if (dProvGoodsBO.getPurchasePrice() != null) {
                        dProvGoodsBigDecimalBO.setPurchasePrice(MoneyUtils.Long2BigDecimal((Long)dProvGoodsBO.getPurchasePrice()));
                    }
                    if (dProvGoodsBO.getLimitPrice() != null) {
                        dProvGoodsBigDecimalBO.setLimitPrice(MoneyUtils.Long2BigDecimal((Long)dProvGoodsBO.getLimitPrice()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)dProvGoodsBO.getInterestsStatus()) && escaMap.get("INTERESTS_STATUS") != null) {
                        dProvGoodsBigDecimalBO.setInterestsStatus(escaMap.get("INTERESTS_STATUS").get(dProvGoodsBO.getInterestsStatus()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)dProvGoodsBO.getInterestsType()) && escaMap.get("INTERESTS_TYPE") != null) {
                        dProvGoodsBigDecimalBO.setInterestsType(escaMap.get("INTERESTS_TYPE").get(dProvGoodsBO.getInterestsType()));
                    }
                    dProvGoodsBigDecimalBOList.add(dProvGoodsBigDecimalBO);
                }
            }
            result.setRows(dProvGoodsBigDecimalBOList);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6743\u76ca\u5546\u54c1\u7ba1\u7406  \u7684\u6761\u4ef6\u67e5\u8be2 \u62a5\u9519" + e.getMessage());
        }
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public void hasPriceNo(List<String> dprovgoodsHasPriceList) {
        if (CollectionUtils.isNotEmpty(dprovgoodsHasPriceList)) {
            for (String str : dprovgoodsHasPriceList) {
                this.dProvGoodsDAO.hasPriceNo(str);
            }
        }
    }

    public Map<String, Map<String, String>> getEscape() {
        List<SysParamTransBusiBO> escaList = this.sysParamsAtomService.selectAll();
        HashMap<String, Map<String, String>> escaMap = new HashMap<String, Map<String, String>>();
        if (!CollectionUtils.isEmpty(escaList)) {
            for (SysParamTransBusiBO es : escaList) {
                if (escaMap.containsKey(es.getParentCode())) {
                    ((Map)escaMap.get(es.getParentCode())).put(es.getCode(), es.getCodeTitle());
                    continue;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(es.getCode(), es.getCodeTitle());
                escaMap.put(es.getParentCode(), map);
            }
        }
        return escaMap;
    }
}

