/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.thread;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xls.commodity.busi.sku.CommodityExtSkuIdService;
import com.xls.commodity.busi.sku.XlsCommoditySkuManageService;
import com.xls.commodity.busi.sku.XlsElectronicPricePushBusiService;
import com.xls.commodity.busi.sku.bo.BindXlsCommoditySkuBO;
import com.xls.commodity.busi.sku.bo.CommodityExtSkuIdBO;
import com.xls.commodity.busi.sku.bo.CommodityExtSkuIdResBO;
import com.xls.commodity.busi.sku.bo.JsonToStringBO;
import com.xls.commodity.busi.sku.bo.JsonToStringSuperBO;
import com.xls.commodity.busi.sku.bo.RcommodityPropDefAndValueBO;
import com.xls.commodity.busi.sku.bo.RpropValueListBO;
import com.xls.commodity.busi.sku.bo.XlsQuerySkuAndPriceReqBO;
import com.xls.commodity.intfce.sku.bo.ErpToSkuReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkuBindThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SkuBindThread.class);
    private XlsCommoditySkuManageService xlsCommoditySkuManageService;
    private CommodityExtSkuIdService commodityExtSkuIdService;
    private ErpToSkuReqBO erpToSkuReqBO;
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    private Long skuId;
    private Long supplierId;

    public SkuBindThread(XlsCommoditySkuManageService xlsCommoditySkuManageService, CommodityExtSkuIdService commodityExtSkuIdService, ErpToSkuReqBO erpToSkuReqBO, XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService, Long skuId, Long supplierId) {
        this.xlsCommoditySkuManageService = xlsCommoditySkuManageService;
        this.commodityExtSkuIdService = commodityExtSkuIdService;
        this.erpToSkuReqBO = erpToSkuReqBO;
        this.xlsElectronicPricePushBusiService = xlsElectronicPricePushBusiService;
        this.skuId = skuId;
        this.supplierId = supplierId;
    }

    @Override
    public void run() {
        CommodityExtSkuIdBO commodityExtSkuIdBO = new CommodityExtSkuIdBO();
        commodityExtSkuIdBO.setExtSkuId(this.erpToSkuReqBO.getSku().getExtSkuId());
        try {
            logger.debug("\u67e5\u8be2\u52a9\u8bb0\u7801\u4e0e\u5546\u54c1\u7ed1\u5b9a\u5173\u7cfb");
            CommodityExtSkuIdResBO commodityExtSkuIdResBO = this.commodityExtSkuIdService.getRelationByExtSkuId(commodityExtSkuIdBO);
            if (!CollectionUtils.isEmpty((Collection)commodityExtSkuIdResBO.getRows())) {
                ArrayList<RcommodityPropDefAndValueBO> rcommodityPropDefAndValueBOs = new ArrayList<RcommodityPropDefAndValueBO>();
                RcommodityPropDefAndValueBO rcommodityPropDefAndValueBO = null;
                RpropValueListBO rpropValueListBO = null;
                BindXlsCommoditySkuBO bindXlsCommoditySkuBO = new BindXlsCommoditySkuBO();
                bindXlsCommoditySkuBO.setSkuId(this.skuId);
                bindXlsCommoditySkuBO.setSupplierId(this.supplierId);
                bindXlsCommoditySkuBO.setCommodityId(((CommodityExtSkuIdBO)commodityExtSkuIdResBO.getRows().get(0)).getCommodityId());
                bindXlsCommoditySkuBO.setCommodityPropGrpId(((CommodityExtSkuIdBO)commodityExtSkuIdResBO.getRows().get(0)).getCommodityPropGrpId());
                String rcommodityPropDefAndValueBOsStr = ((CommodityExtSkuIdBO)commodityExtSkuIdResBO.getRows().get(0)).getCommodityDimensionJson();
                JSONObject jsonToStringSuperBOJson = (JSONObject)JSONObject.parse((String)rcommodityPropDefAndValueBOsStr);
                JsonToStringSuperBO jsonToStringSuperBO = (JsonToStringSuperBO)JSONObject.toJavaObject((JSON)jsonToStringSuperBOJson, JsonToStringSuperBO.class);
                List jsonToStringBO = jsonToStringSuperBO.getJsonToStringBOList();
                for (JsonToStringBO json : jsonToStringBO) {
                    rcommodityPropDefAndValueBO = new RcommodityPropDefAndValueBO();
                    rpropValueListBO = new RpropValueListBO();
                    rpropValueListBO.setPropValueListId(json.getPropValueListId());
                    rpropValueListBO.setPropValue(json.getPropValue());
                    rcommodityPropDefAndValueBO.setRpropValueListBO(rpropValueListBO);
                    rcommodityPropDefAndValueBO.setPropName(json.getPropName());
                    rcommodityPropDefAndValueBO.setCommodityPropDefId(json.getCommodityPropDefId());
                    rcommodityPropDefAndValueBOs.add(rcommodityPropDefAndValueBO);
                }
                bindXlsCommoditySkuBO.setRcommodityPropDefAndValueBOs(rcommodityPropDefAndValueBOs);
                this.xlsCommoditySkuManageService.bindXlsCommoditySku(bindXlsCommoditySkuBO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u52a9\u8bb0\u7801\u4e0e\u5546\u54c1\u7ed1\u5b9a\u5173\u7cfb\u62a5\u9519");
        }
        try {
            XlsQuerySkuAndPriceReqBO pushReq = new XlsQuerySkuAndPriceReqBO();
            pushReq.setSkuId(this.skuId);
            pushReq.setSupplierId(this.supplierId);
            this.xlsElectronicPricePushBusiService.xlsPuhSku(pushReq);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u4e1a\u52a1\u670d\u52a1\uff0c\u5546\u54c1\u751f\u6210\u6210\u529f.\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519" + e);
        }
    }
}

