/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.util;

import com.alibaba.dubbo.common.utils.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class RedisConfig {
    private static final Logger logger = LoggerFactory.getLogger(RedisConfig.class);
    @Value(value="${redis.host}")
    private String host;
    @Value(value="${redis.port}")
    private String port;
    @Value(value="${redis.timeout}")
    private String timeOut;
    @Value(value="${redis.pwd}")
    private String pass;
    @Value(value="${redis.database}")
    private String dataBase;
    @Value(value="${redis.pool.maxTotal}")
    private String maxTotal;
    @Value(value="${redis.pool.maxIdle}")
    private String maxIdle;
    @Value(value="${redis.pool.maxWaitMillis}")
    private String maxWaitMillis;
    @Value(value="${redis.pool.testOnBorrow}")
    private String testOnBorrow;
    @Value(value="${redis.pool.testOnReturn}")
    private String testOnReturn;

    @Bean
    public JedisPool jedisPool() {
        JedisPool pool = null;
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(Integer.parseInt(this.maxTotal));
        config.setMaxIdle(Integer.parseInt(this.maxIdle));
        config.setMaxWaitMillis(Long.parseLong(this.maxWaitMillis));
        config.setTestOnBorrow(Boolean.getBoolean(this.testOnBorrow));
        config.setTestOnReturn(Boolean.getBoolean(this.testOnReturn));
        if (StringUtils.isNotEmpty((String)this.host) && StringUtils.isNotEmpty((String)this.port) && StringUtils.isNotEmpty((String)this.pass) && StringUtils.isNotEmpty((String)this.timeOut) && StringUtils.isNotEmpty((String)this.dataBase)) {
            logger.debug("host" + this.host);
            pool = new JedisPool((GenericObjectPoolConfig)config, this.host, Integer.parseInt(this.port), Integer.parseInt(this.timeOut), this.pass, Integer.parseInt(this.dataBase));
        }
        return pool;
    }
}

