/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.fastjson.JSONObject;
import com.cgd.common.exception.BusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.atom.sku.DPriceSheetItemManageService;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.busi.sku.bo.DPriceSheetItemBO;
import com.xls.commodity.busi.sku.bo.QueryPriceSheetItemReqBO;
import com.xls.commodity.dao.PriceSheetItemDAO;
import com.xls.commodity.dao.po.PriceSheetItemPO;
import com.xls.commodity.dao.po.PriceSheetItemReqPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DPriceSheetItemManageServiceImpl
implements DPriceSheetItemManageService {
    @Autowired
    private PriceSheetItemDAO priceSheetItemDAO;
    private static final Logger logger = LoggerFactory.getLogger(DPriceSheetItemManageServiceImpl.class);
    @Autowired
    private SysParamsAtomService sysParamsAtomService;

    public RspInfoListBO<DPriceSheetItemBO> selectSheetItemBySheetId(Long sheetId) {
        RspInfoListBO baseRspBO = new RspInfoListBO();
        if (sheetId == null) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return baseRspBO;
        }
        ArrayList<DPriceSheetItemBO> rows = new ArrayList<DPriceSheetItemBO>();
        try {
            List<PriceSheetItemPO> itemPOList = this.priceSheetItemDAO.selectBySheetId(sheetId);
            if (CollectionUtils.isNotEmpty(itemPOList)) {
                for (PriceSheetItemPO po : itemPOList) {
                    rows.add(this.poToItemBo(po));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRows(rows);
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO deleteSheetItemBySheetId(Long sheetId) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (sheetId == null) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u5220\u9664\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return baseRspBO;
        }
        try {
            this.priceSheetItemDAO.deleteBySheetId(sheetId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u5220\u9664\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO updateSheetItenBatch(List<DPriceSheetItemBO> reqList) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (CollectionUtils.isEmpty(reqList)) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return baseRspBO;
        }
        ArrayList<PriceSheetItemPO> list = new ArrayList<PriceSheetItemPO>();
        for (DPriceSheetItemBO bo : reqList) {
            list.add(this.boToItemPo(bo));
        }
        try {
            this.priceSheetItemDAO.updateByPrimaryKeySelectiveList(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO insertSheetItemBatch(List<DPriceSheetItemBO> reqList) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (CollectionUtils.isEmpty(reqList)) {
            logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
            baseRspBO.setRespCode("7777");
            baseRspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            throw new BusinessException("9999", new String[]{"\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a"});
        }
        logger.debug("\u5165\u53c2\uff1a" + JSONObject.toJSONString(reqList));
        ArrayList<PriceSheetItemPO> list = new ArrayList<PriceSheetItemPO>();
        for (DPriceSheetItemBO bo : reqList) {
            list.add(this.boToItemPo(bo));
        }
        try {
            this.priceSheetItemDAO.insertSheetItemBatch(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", new String[]{"\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u51fa\u9519"});
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    private DPriceSheetItemBO poToItemBo(PriceSheetItemPO po) {
        DPriceSheetItemBO bo = new DPriceSheetItemBO();
        BeanUtils.copyProperties((Object)po, (Object)bo);
        try {
            if (po.getPurchaseFloorPrice() != null) {
                bo.setPurchaseFloorPrice(MoneyUtils.Long2BigDecimal((Long)po.getPurchaseFloorPrice()).toString());
            }
            if (po.getRetailAgreementPrice() != null) {
                bo.setRetailAgreementPrice(MoneyUtils.Long2BigDecimal((Long)po.getRetailAgreementPrice()).toString());
            }
            if (po.getCitiesLockPrice() != null) {
                bo.setCitiesLockPrice(MoneyUtils.Long2BigDecimal((Long)po.getCitiesLockPrice()).toString());
            }
            if (po.getTheCostDownPrice() != null) {
                bo.setTheCostDownPrice(MoneyUtils.Long2BigDecimal((Long)po.getTheCostDownPrice()).toString());
            }
            if (po.getAssessmentPrice() != null) {
                bo.setAssessmentPrice(MoneyUtils.Long2BigDecimal((Long)po.getAssessmentPrice()).toString());
            }
            if (po.getPurchasePrice() != null) {
                bo.setPurchasePrice(MoneyUtils.Long2BigDecimal((Long)po.getPurchasePrice()).toString());
            }
            if (po.getSalePrice() != null) {
                bo.setSalePrice(MoneyUtils.Long2BigDecimal((Long)po.getSalePrice()).toString());
            }
            if (po.getAgreementPrice() != null) {
                bo.setAgreementPrice(MoneyUtils.Long2BigDecimal((Long)po.getAgreementPrice()).toString());
            }
            if (po.getProvAgreePrice() != null) {
                bo.setProvAgreePrice(MoneyUtils.Long2BigDecimal((Long)po.getProvAgreePrice()).toString());
            }
            if (po.getMemberPrice() != null) {
                bo.setMemberPrice(MoneyUtils.Long2BigDecimal((Long)po.getMemberPrice()).toString());
            }
            if (po.getTradePrice() != null) {
                bo.setTradePrice(MoneyUtils.Long2BigDecimal((Long)po.getTradePrice()).toString());
            }
            if (po.getLastPurchasePrice() != null) {
                bo.setLastPurchasePrice(MoneyUtils.Long2BigDecimal((Long)po.getLastPurchasePrice()).toString());
            }
            if (po.getCostPrice() != null) {
                bo.setCostPrice(MoneyUtils.Long2BigDecimal((Long)po.getCostPrice()).toString());
            }
            if (po.getSparePrice2() != null) {
                bo.setSparePrice2(MoneyUtils.Long2BigDecimal((Long)po.getSparePrice2()).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getSparePrice3())) {
                bo.setSparePrice3(MoneyUtils.Long2BigDecimal((Long)Long.valueOf(po.getSparePrice3())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getSparePrice4())) {
                bo.setSparePrice4(MoneyUtils.Long2BigDecimal((Long)Long.valueOf(po.getSparePrice4())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)po.getSparePrice5())) {
                bo.setSparePrice5(MoneyUtils.Long2BigDecimal((Long)Long.valueOf(po.getSparePrice5())).toString());
            }
            if (po.getMemberLadderPrice1() != null) {
                bo.setMemberLadderPrice1(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice1()).toString());
            }
            if (po.getMemberLadderPrice2() != null) {
                bo.setMemberLadderPrice2(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice2()).toString());
            }
            if (po.getMemberLadderPrice3() != null) {
                bo.setMemberLadderPrice3(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice3()).toString());
            }
            if (po.getMemberLadderPrice4() != null) {
                bo.setMemberLadderPrice4(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice4()).toString());
            }
            if (po.getMemberLadderPrice5() != null) {
                bo.setMemberLadderPrice5(MoneyUtils.Long2BigDecimal((Long)po.getMemberLadderPrice5()).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u91d1\u989d\u8f6c\u6362\u51fa\u9519" + e.getMessage());
        }
        return bo;
    }

    private PriceSheetItemPO boToItemPo(DPriceSheetItemBO bo) {
        PriceSheetItemPO po = new PriceSheetItemPO();
        BeanUtils.copyProperties((Object)bo, (Object)po);
        try {
            if (StringUtils.isNotBlank((CharSequence)bo.getPurchaseFloorPrice())) {
                po.setPurchaseFloorPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getPurchaseFloorPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getRetailAgreementPrice())) {
                po.setRetailAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getRetailAgreementPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getCitiesLockPrice())) {
                po.setCitiesLockPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getCitiesLockPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTheCostDownPrice())) {
                po.setTheCostDownPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getTheCostDownPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getAssessmentPrice())) {
                po.setAssessmentPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getAssessmentPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getPurchasePrice())) {
                po.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getPurchasePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSalePrice())) {
                po.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getSalePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getAgreementPrice())) {
                po.setAgreementPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getAgreementPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getProvAgreePrice())) {
                po.setProvAgreePrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getProvAgreePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberPrice())) {
                po.setMemberPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getMemberPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getTradePrice())) {
                po.setTradePrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getTradePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getLastPurchasePrice())) {
                po.setLastPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getLastPurchasePrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getCostPrice())) {
                po.setCostPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getCostPrice())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice2())) {
                po.setSparePrice2(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getSparePrice2())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice3())) {
                po.setSparePrice3(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getSparePrice3())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice4())) {
                po.setSparePrice4(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getSparePrice4())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getSparePrice5())) {
                po.setSparePrice5(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getSparePrice5())).toString());
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice1())) {
                po.setMemberLadderPrice1(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getMemberLadderPrice1())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice2())) {
                po.setMemberLadderPrice2(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getMemberLadderPrice2())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice3())) {
                po.setMemberLadderPrice3(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getMemberLadderPrice3())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice4())) {
                po.setMemberLadderPrice4(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getMemberLadderPrice4())));
            }
            if (StringUtils.isNotBlank((CharSequence)bo.getMemberLadderPrice5())) {
                po.setMemberLadderPrice5(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(bo.getMemberLadderPrice5())));
            }
            po.setCreateTime(new Date());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u65b0\u589e\u539f\u5b50\u670d\u52a1\u91d1\u989d\u8f6c\u6362\u51fa\u9519" + e.getMessage());
        }
        return po;
    }

    public RspInfoListBO<DPriceSheetItemBO> selectByGroupMaterial(QueryPriceSheetItemReqBO reqBO) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO));
        RspInfoListBO rspInfoListBO = new RspInfoListBO();
        PriceSheetItemReqPO po = new PriceSheetItemReqPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setIsValid("1");
        ArrayList<DPriceSheetItemBO> rows = new ArrayList<DPriceSheetItemBO>();
        try {
            List<PriceSheetItemPO> itemPOList = this.priceSheetItemDAO.selectByGroupMaterial(po);
            if (CollectionUtils.isNotEmpty(itemPOList)) {
                for (PriceSheetItemPO po1 : itemPOList) {
                    rows.add(this.poToItemBo(po1));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u660e\u7ec6\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        rspInfoListBO.setRows(rows);
        rspInfoListBO.setRespCode("0000");
        rspInfoListBO.setRespDesc("\u6210\u529f");
        return rspInfoListBO;
    }

    public RspInfoListBO<DPriceSheetItemBO> selectByGroupLevel(QueryPriceSheetItemReqBO reqBO) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO));
        RspInfoListBO rspInfoListBO = new RspInfoListBO();
        rspInfoListBO.setRespCode("0000");
        rspInfoListBO.setRespDesc("\u6210\u529f");
        ArrayList<DPriceSheetItemBO> rows = new ArrayList<DPriceSheetItemBO>();
        PriceSheetItemReqPO po = new PriceSheetItemReqPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setIsValid("1");
        try {
            List<PriceSheetItemPO> poList = this.priceSheetItemDAO.selectByGroupLevel(po);
            if (CollectionUtils.isNotEmpty(poList)) {
                for (PriceSheetItemPO po1 : poList) {
                    rows.add(this.poToItemBo(po1));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5546\u54c1\u4e2d\u5fc3-\u62a5\u4ef7\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e.getMessage());
        }
        rspInfoListBO.setRows(rows);
        return rspInfoListBO;
    }
}

