/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.xls.commodity.atom.sku.DShareRecordManageService;
import com.xls.commodity.atom.sku.DSkuShareBuyManageService;
import com.xls.commodity.busi.sku.AddSkuShareBuyManageService;
import com.xls.commodity.busi.sku.bo.AddSkuShareBuyReqBO;
import com.xls.commodity.busi.sku.bo.CancelDSkuShareBuyReqBO;
import com.xls.commodity.busi.sku.bo.DShareRecordBO;
import com.xls.commodity.busi.sku.bo.DSkuShareBuyBO;
import com.xls.commodity.dao.DSkuShareBuyDAO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.thread.AddSkuShareBuyThread;
import com.xls.commodity.util.CreateThreadUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AddSkuShareBuyManageServiceImpl
implements AddSkuShareBuyManageService {
    @Autowired
    private DSkuShareBuyManageService dSkuShareBuyManageService;
    @Autowired
    private DShareRecordManageService dShareRecordManageService;
    @Autowired
    private DSkuShareBuyDAO dSkuShareBuyDAO;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;
    private static final Logger logger = LoggerFactory.getLogger(AddSkuShareBuyManageServiceImpl.class);

    public BaseRspBO addDSkuShareBuy(AddSkuShareBuyReqBO addSkuShareBuyReqBO) {
        logger.info("\u65b0\u589e\u5546\u54c1\u5206\u4eab\u91c7\u8d2d\u8bb0\u5f55\u670d\u52a1\u5165\u53c2=" + addSkuShareBuyReqBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        DShareRecordBO dShareRecordBO = new DShareRecordBO();
        dShareRecordBO.setSharer(addSkuShareBuyReqBO.getSharer());
        dShareRecordBO.setSharee(addSkuShareBuyReqBO.getSharee());
        dShareRecordBO.setSkuId(addSkuShareBuyReqBO.getSkuId());
        DShareRecordBO dShareRecordBORsp = null;
        try {
            dShareRecordBORsp = this.dShareRecordManageService.selectByManyId(dShareRecordBO);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            logger.error("\u6839\u636e\u5355\u54c1ID\u3001\u5206\u4eab\u4eba\u3001\u88ab\u5206\u4eab\u4eba\u67e5\u8be2\u5206\u4eab\u8bb0\u5f55\u670d\u52a1\u62a5\u9519");
        }
        if (dShareRecordBORsp != null && dShareRecordBORsp.getRecordId() != null) {
            DSkuShareBuyBO dSkuShareBuyBO = new DSkuShareBuyBO();
            BeanUtils.copyProperties((Object)addSkuShareBuyReqBO, (Object)dSkuShareBuyBO);
            dSkuShareBuyBO.setRecordId(dShareRecordBORsp.getRecordId());
            dSkuShareBuyBO.setOrderTime(new Date());
            dSkuShareBuyBO.setBusinessStatus(Byte.valueOf((byte)0));
            BigDecimal businessPrice = addSkuShareBuyReqBO.getBusinessPrice();
            if (businessPrice != null) {
                try {
                    dSkuShareBuyBO.setBusinessPrice(MoneyUtils.BigDecimal2Long((BigDecimal)businessPrice));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error("\u91d1\u989d\u8f6c\u5316\u62a5\u9519");
                }
            }
            try {
                this.dSkuShareBuyManageService.addDSkuShareBuy(dSkuShareBuyBO);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u65b0\u589e\u5546\u54c1\u5206\u4eab\u91c7\u8d2d\u8bb0\u5f55\u670d\u52a1\u62a5\u9519");
            }
            try {
                JSONObject ruleParamsJson;
                String type = null;
                JSONObject umcIncentiveRuleAbilityReqBO = null;
                JSONObject umcGrowValueAndIntegralAbilityReqBO = null;
                if ("0".equals(dShareRecordBORsp.getIsStaffPush())) {
                    type = dShareRecordBORsp.getIsStaffPush();
                    ruleParamsJson = new JSONObject();
                    try {
                        Long sumBusinessPrice = this.dSkuShareBuyDAO.selectSumPriceByMemberId(addSkuShareBuyReqBO.getSharer());
                        BigDecimal sumBusinessPriceed = MoneyUtils.Long2BigDecimal((Long)sumBusinessPrice);
                        ruleParamsJson.put("memId", (Object)addSkuShareBuyReqBO.getSharer());
                        ruleParamsJson.put("totalPurchaseFee", (Object)sumBusinessPriceed);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error("\u6839\u636e\u5e97\u5458\u4f1a\u5458ID\u67e5\u8be2\u603b\u4ea4\u6613\u91cf\u62a5\u9519");
                    }
                    umcIncentiveRuleAbilityReqBO = new JSONObject();
                    umcIncentiveRuleAbilityReqBO.put("operCode", (Object)"IC001");
                    umcIncentiveRuleAbilityReqBO.put("memId", (Object)addSkuShareBuyReqBO.getSharer());
                    umcIncentiveRuleAbilityReqBO.put("operSystem", (Object)"commodity");
                    umcIncentiveRuleAbilityReqBO.put("operResult", (Object)"\u5458\u5de5\u63a8\u8350\u8d2d\u4e70\u5546\u54c1\u8d60\u9001\u6210\u957f\u503c\u6fc0\u52b1");
                    umcIncentiveRuleAbilityReqBO.put("operDesc", (Object)"\u5458\u5de5\u63a8\u8350\u8d2d\u4e70\u5546\u54c1\u8d60\u9001\u6210\u957f\u503c\u6fc0\u52b1");
                    umcIncentiveRuleAbilityReqBO.put("ruleParamsJson", (Object)ruleParamsJson.toString());
                } else if ("1".equals(dShareRecordBORsp.getIsStaffPush())) {
                    umcGrowValueAndIntegralAbilityReqBO = new JSONObject();
                    type = dShareRecordBORsp.getIsStaffPush();
                    umcGrowValueAndIntegralAbilityReqBO.put("operCode", (Object)"GA205");
                    umcGrowValueAndIntegralAbilityReqBO.put("memId", (Object)addSkuShareBuyReqBO.getSharer());
                    umcGrowValueAndIntegralAbilityReqBO.put("operSystem", (Object)"commodity");
                    umcGrowValueAndIntegralAbilityReqBO.put("operResult", (Object)"\u4f1a\u5458\u63a8\u8350\u4f1a\u5458\u8d2d\u4e70\u5546\u54c1");
                    umcGrowValueAndIntegralAbilityReqBO.put("operDesc", (Object)"\u4f1a\u5458\u63a8\u8350\u4f1a\u5458\u8d2d\u4e70\u5546\u54c1");
                    ruleParamsJson = new JSONObject();
                    ruleParamsJson.put("memId", (Object)addSkuShareBuyReqBO.getSharer());
                    ruleParamsJson.put("payAmount", (Object)addSkuShareBuyReqBO.getBusinessPrice());
                    umcGrowValueAndIntegralAbilityReqBO.put("ruleParamsJson", (Object)ruleParamsJson.toString());
                }
                AddSkuShareBuyThread addSkuShareBuyThread = new AddSkuShareBuyThread(type, umcIncentiveRuleAbilityReqBO, umcGrowValueAndIntegralAbilityReqBO, this.hsfVersion, this.hsfGroup, this.hsfClientTimeout);
                ExecutorService singleThreadPool = CreateThreadUtils.createSimpleThreadPool(addSkuShareBuyThread, "addSkuShareBuyThread", 1, 1);
                singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
                singleThreadPool.shutdown();
            }
            catch (Exception e) {
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u5f02\u6b65\u7684\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u51fa\u9519--\u589e\u52a0\u4ea4\u6613\u8bb0\u5f55\u6210\u529f");
                return baseRspBO;
            }
        }
        logger.info("\u5206\u4eab\u8bb0\u5f55\u8868\u91cc\u9762\u6ca1\u6709\u5206\u4eab\u8bb0\u5f55");
        baseRspBO.setRespCode("7777");
        baseRspBO.setRespDesc("\u5206\u4eab\u8bb0\u5f55\u8868\u91cc\u9762\u6ca1\u6709\u5206\u4eab\u8bb0\u5f55");
        return baseRspBO;
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public BaseRspBO cancelDSkuShareBuy(CancelDSkuShareBuyReqBO cancelDSkuShareBuyReqBO) {
        logger.info("\u53d6\u6d88\u5546\u54c1\u5206\u4eab\u91c7\u8d2d\u8bb0\u5f55\u670d\u52a1(\u9000\u5355\u4e86)\u5165\u53c2=" + cancelDSkuShareBuyReqBO.toString());
        BaseRspBO baseRspBO = new BaseRspBO();
        DSkuShareBuyBO dSkuShareBuyBO = new DSkuShareBuyBO();
        dSkuShareBuyBO.setOrderId(cancelDSkuShareBuyReqBO.getOrderId());
        dSkuShareBuyBO.setCancelTime(new Date());
        dSkuShareBuyBO.setBusinessStatus(Byte.valueOf((byte)1));
        try {
            this.dSkuShareBuyManageService.updateDSkuShareBuy(dSkuShareBuyBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u53d6\u6d88\u5546\u54c1\u91c7\u8d2d\u8bb0\u5f55\u7684\u670d\u52a1\u62a5\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }
}

