/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.xls.commodity.busi.sku.BarCodeManageService;
import com.xls.commodity.busi.sku.bo.BarCodeReqBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsBO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BarCodeManageServiceImpl
implements BarCodeManageService {
    private static final Logger log = LoggerFactory.getLogger(BarCodeManageServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;

    public BaseRspBO saveBarcode(BarCodeReqBO reqBO) {
        String provCode;
        if (null == reqBO || StringUtils.isBlank((CharSequence)reqBO.getBarCode()) || StringUtils.isBlank((CharSequence)reqBO.getMatCode())) {
            log.error("\u6761\u5f62\u7801\u548c\u7269\u6599\u7f16\u7801\u5fc5\u586b");
            return new BaseRspBO("0001", "\u6761\u5f62\u7801\u548c\u7269\u6599\u7f16\u7801\u5fc5\u586b");
        }
        String string = provCode = StringUtils.isNotBlank((CharSequence)reqBO.getmProvince()) ? reqBO.getmProvince() : reqBO.getProvinceCode();
        if (StringUtils.isBlank((CharSequence)provCode)) {
            log.error("\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
            return new BaseRspBO("0001", "\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
        }
        List<ProvGoodsPO> provGoodsPOS = this.provGoodsDAO.selectProvGoodsByProvinceCodeAndMaterialId(provCode, reqBO.getMatCode());
        if (CollectionUtils.isEmpty(provGoodsPOS)) {
            log.error("\u672a\u67e5\u8be2\u5230\u7269\u6599\u7f16\u7801\u4e3a\u3010" + reqBO.getMatCode() + "\u3011\u7684\u7701\u4efd\u5546\u54c1");
            return new BaseRspBO("0002", "\u672a\u67e5\u8be2\u5230\u7269\u6599\u7f16\u7801\u4e3a\u3010" + reqBO.getMatCode() + "\u3011\u7684\u7701\u4efd\u5546\u54c1");
        }
        ProvGoodsPO updRecord = new ProvGoodsPO();
        updRecord.setBarCode(reqBO.getBarCode());
        updRecord.setMaterialId(reqBO.getMatCode());
        updRecord.setProvinceCode(provCode);
        try {
            this.provGoodsDAO.updateByMaterialSelective(updRecord);
        }
        catch (Exception e) {
            log.error("\u5f55\u5165\u6761\u5f62\u7801\u5931\u8d25\uff1a" + e.getMessage());
            return new BaseRspBO("9999", "\u5f55\u5165\u6761\u5f62\u7801\u5931\u8d25");
        }
        return new BaseRspBO("0000", "\u64cd\u4f5c\u6210\u529f");
    }

    public RspInfoListBO<ProvGoodsBO> listSkuIdByBarCode(BarCodeReqBO reqBO) {
        List<ProvGoodsPO> pos;
        if (null == reqBO || null == reqBO.getShopId() || CollectionUtils.isEmpty((Collection)reqBO.getBarCodes())) {
            log.error("\u95e8\u5e97ID\u6216\u6761\u5f62\u7801\u4e3a\u7a7a");
            return new RspInfoListBO("0001", "\u95e8\u5e97ID\u6216\u6761\u5f62\u7801\u4e3a\u7a7a");
        }
        ProvGoodsPO record = new ProvGoodsPO();
        record.setSupplierId(reqBO.getShopId());
        record.setBarCodes(reqBO.getBarCodes());
        record.setProvinceCode(reqBO.getmProvince());
        try {
            pos = this.provGoodsDAO.selectByBarCode(record);
        }
        catch (Exception e) {
            log.error("\u6839\u636e\u6761\u5f62\u7801\u67e5\u8be2skuId\u5931\u8d25\uff1a" + e.getMessage());
            return new RspInfoListBO("0003", "\u6839\u636e\u6761\u5f62\u7801\u67e5\u8be2skuId\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(pos)) {
            return new RspInfoListBO("0000", "\u64cd\u4f5c\u6210\u529f");
        }
        ArrayList<ProvGoodsBO> bos = new ArrayList<ProvGoodsBO>();
        for (ProvGoodsPO po : pos) {
            ProvGoodsBO bo = new ProvGoodsBO();
            bo.setSkuId(po.getSkuId());
            bo.setShopId(po.getSupplierId());
            bo.setBarCode(po.getBarCode());
            bo.setHasSerialNumber(po.getHasSerialNumber());
            bo.setColorName(po.getColorName());
            bo.setMemoryName(po.getMemoryName());
            bo.setGoodsModel(po.getGoodsModel());
            bo.setVersionName(po.getVersionName());
            bos.add(bo);
        }
        return new RspInfoListBO("0000", "\u64cd\u4f5c\u6210\u529f", bos);
    }
}

