/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.po.Brand;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.busi.sku.AddGoodsByProvCodeService;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.BrandManageService;
import com.xls.commodity.busi.sku.CTMSManageProvGoodsService;
import com.xls.commodity.busi.sku.ProvGoodsEnableShutdownService;
import com.xls.commodity.busi.sku.ProvUpdateService;
import com.xls.commodity.busi.sku.bo.AddProvGoodsListReqBO;
import com.xls.commodity.busi.sku.bo.BatchEnableShutdownProvGoodsBO;
import com.xls.commodity.busi.sku.bo.BatchProvGoodsCreateAndUpdateBO;
import com.xls.commodity.busi.sku.bo.BrandBO;
import com.xls.commodity.busi.sku.bo.CreateBrandReqBO;
import com.xls.commodity.busi.sku.bo.OrderBackBO;
import com.xls.commodity.busi.sku.bo.Product;
import com.xls.commodity.busi.sku.bo.ProvGoodsBO;
import com.xls.commodity.busi.sku.bo.RspBatchBaseBO;
import com.xls.commodity.busi.sku.bo.SupplierBO;
import com.xls.commodity.dao.MaterialDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.MaterialPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.intfce.sku.DPriceSheetService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.thread.ImportProvGoodsThrean;
import com.xls.commodity.util.RedisUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;

@Service
public class CTMSManageProvGoodsServiceImpl
implements CTMSManageProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(CTMSManageProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private BrandManageService brandManageService;
    @Autowired
    private AddGoodsByProvCodeService addGoodsByProvCodeService;
    @Autowired
    private ProvGoodsEnableShutdownService provGoodsEnableShutdownService;
    @Autowired
    private ProvUpdateService provUpdateService;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    @Autowired
    private MaterialDAO materialDAO;
    @Autowired
    private DPriceSheetService dPriceSheetService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;
    @Value(value="${uat.SupplierId1}")
    private String SupplierId1;
    @Value(value="${uat.SupplierId2}")
    private String SupplierId2;

    public RspBatchBaseBO batchProvGoodsCreateAndUpdate(BatchProvGoodsCreateAndUpdateBO reqBO) {
        ArrayList<Product> updateProvGoodsList;
        HashMap<String, ProvGoodsPO> stringProvGoodsPOHashMap;
        ArrayList<OrderBackBO> result;
        RspBatchBaseBO results;
        block15: {
            results = new RspBatchBaseBO();
            result = new ArrayList<OrderBackBO>();
            logger.debug("batchProvGoodsCreateAndUpdate\u65b9\u6cd5\u5165\u53c2:" + JSON.toJSONString((Object)reqBO.getProduct()));
            try {
                this.requestCheckout(reqBO.getProduct());
            }
            catch (Exception e) {
                OrderBackBO backBO = this.resultManage("0", e.getMessage(), null);
                result.add(backBO);
                results.setOrderBack(result);
                return results;
            }
            ArrayList<String> materialIdList = new ArrayList<String>();
            reqBO.getProduct().stream().forEach(str -> materialIdList.add(str.getMaterialId().trim()));
            Map<String, MaterialPO> scmMap = this.getScm(materialIdList);
            logger.debug("\u67e5\u8be2\u5230\u7684SCM\u5546\u54c1\uff1a" + JSON.toJSONString(scmMap));
            reqBO.getProduct().stream().forEach(str -> {
                if (scmMap.containsKey(str.getMaterialId().trim())) {
                    if (!StringUtils.isEmpty((String)((MaterialPO)scmMap.get(str.getMaterialId().trim())).getMarqueName())) {
                        str.setGoodsModel(((MaterialPO)scmMap.get(str.getMaterialId().trim())).getMarqueName());
                    }
                    if (!StringUtils.isEmpty((String)((MaterialPO)scmMap.get(str.getMaterialId().trim())).getBrandName())) {
                        str.setBrandName(((MaterialPO)scmMap.get(str.getMaterialId().trim())).getBrandName());
                    }
                    if (!StringUtils.isEmpty((String)((MaterialPO)scmMap.get(str.getMaterialId().trim())).getColorName())) {
                        str.setColorName(((MaterialPO)scmMap.get(str.getMaterialId().trim())).getColorName());
                    }
                    if (!StringUtils.isEmpty((String)((MaterialPO)scmMap.get(str.getMaterialId().trim())).getMaterialDesc())) {
                        str.setScmGoodsLongName(((MaterialPO)scmMap.get(str.getMaterialId().trim())).getMaterialDesc());
                    }
                    str.setGoodsSource("01");
                }
            });
            try {
                this.setGoodsStatus(reqBO.getProduct());
            }
            catch (Exception e) {
                logger.error("GoodsStatus\u5c5e\u6027\u8bbe\u7f6e\u51fa\u9519\uff1a" + e.getMessage());
                OrderBackBO backBO = this.resultManage("0", e.getMessage(), null);
                result.add(backBO);
                results.setOrderBack(result);
                return results;
            }
            try {
                this.setBrandID(reqBO);
            }
            catch (Exception e) {
                logger.error("brandId\u8bbe\u7f6e\u51fa\u9519");
                OrderBackBO backBO = this.resultManage("0", "\u54c1\u724cID\u521b\u5efa\u9519\u8bef", null);
                result.add(backBO);
                results.setOrderBack(result);
                return results;
            }
            ArrayList<ProvGoodsPO> provGoodsPOS = new ArrayList<ProvGoodsPO>();
            reqBO.getProduct().stream().forEach(str -> {
                ProvGoodsPO provGoodsPO = new ProvGoodsPO();
                provGoodsPO.setMaterialId(str.getMaterialId());
                provGoodsPO.setProvinceCode(str.getProvinceCode());
                provGoodsPOS.add(provGoodsPO);
            });
            logger.debug("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u5165\u53c2\uff1a" + JSON.toJSONString(provGoodsPOS));
            List<ProvGoodsPO> ProvGoodsList = null;
            try {
                ProvGoodsList = this.provGoodsDAO.selectByList(provGoodsPOS);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u51fa\u9519\uff1a" + e.getMessage());
                OrderBackBO backBO = this.resultManage("0", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u51fa\u9519", null);
                result.add(backBO);
                results.setOrderBack(result);
                return results;
            }
            logger.debug("\u67e5\u8be2\u5230\u7684\u7701\u4efd\u5546\u54c1\uff1a" + JSON.toJSONString(ProvGoodsList));
            stringProvGoodsPOHashMap = new HashMap<String, ProvGoodsPO>();
            if (!CollectionUtils.isEmpty(ProvGoodsList)) {
                ProvGoodsList.stream().forEach(str -> {
                    if (!stringProvGoodsPOHashMap.containsKey(str.getMaterialId().trim() + str.getProvinceCode().trim())) {
                        stringProvGoodsPOHashMap.put(str.getMaterialId().trim() + str.getProvinceCode().trim(), (ProvGoodsPO)str);
                    }
                });
            }
            ArrayList<Product> createProvGoodsList = new ArrayList<Product>();
            updateProvGoodsList = new ArrayList<Product>();
            reqBO.getProduct().stream().forEach(str -> {
                if (stringProvGoodsPOHashMap.containsKey(str.getMaterialId().trim() + str.getProvinceCode().trim())) {
                    str.setProvGoodsId(((ProvGoodsPO)stringProvGoodsPOHashMap.get(str.getMaterialId().trim() + str.getProvinceCode().trim())).getProvGoodsId());
                    updateProvGoodsList.add((Product)str);
                } else {
                    createProvGoodsList.add((Product)str);
                }
            });
            logger.debug("\u7528\u4e8e\u521b\u5efa\u7684\u7701\u4efd\u5546\u54c1" + JSON.toJSONString(createProvGoodsList));
            if (!CollectionUtils.isEmpty(createProvGoodsList)) {
                List<String> deleteMaterialIds = null;
                String key = "IMPORT_PROVINCE_GOODS" + ((Product)createProvGoodsList.get(0)).getProvinceCode();
                try {
                    deleteMaterialIds = this.redisCheckout(createProvGoodsList, key);
                    this.createProGoods(createProvGoodsList);
                    createProvGoodsList.stream().forEach(str -> {
                        OrderBackBO backBO = this.resultManage("1", null, str.getMaterialId());
                        result.add(backBO);
                    });
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u51fa\u9519\uff1a" + e.getMessage());
                    OrderBackBO backBO = this.resultManage("0", e.getMessage(), null);
                    result.add(backBO);
                    if (CollectionUtils.isEmpty(deleteMaterialIds)) break block15;
                    logger.debug("\u7a0b\u5e8f\u62a5\u9519\u5220\u9664redis\u4e2d\u7684\u7269\u6599\uff1a" + JSON.toJSONString(deleteMaterialIds));
                    Jedis jedis = RedisUtil.getJedis();
                    jedis.srem(key, new String[]{String.valueOf(deleteMaterialIds)});
                    if (null == jedis) break block15;
                    jedis.close();
                }
            }
        }
        logger.debug("\u7528\u4e8e\u4fee\u6539\u7684\u7701\u4efd\u5546\u54c1" + JSON.toJSONString(updateProvGoodsList));
        if (!CollectionUtils.isEmpty(updateProvGoodsList)) {
            try {
                this.updateProvGoods(updateProvGoodsList, stringProvGoodsPOHashMap);
                updateProvGoodsList.stream().forEach(str -> {
                    OrderBackBO backBO = this.resultManage("1", null, str.getMaterialId());
                    result.add(backBO);
                });
            }
            catch (Exception e) {
                logger.error("\u4fee\u6539\u7701\u4efd\u5546\u54c1\u51fa\u9519\uff1a" + e.getMessage());
                OrderBackBO backBO = this.resultManage("0", e.getMessage(), null);
                result.add(backBO);
            }
        }
        results.setOrderBack(result);
        return results;
    }

    public List<String> redisCheckout(List<Product> createProvGoodsList, String key) {
        ArrayList<String> materialIds = new ArrayList<String>();
        createProvGoodsList.stream().forEach(str -> materialIds.add(str.getMaterialId().trim()));
        Jedis jedis = RedisUtil.getJedis();
        Boolean exists = jedis.exists(key);
        logger.debug("Redis\u5224\u65ad\u662f\u5426\u6709\u8fd9\u4e2aKey\uff1a" + JSON.toJSONString((Object)exists));
        try {
            if (exists.booleanValue()) {
                Set reidsMaterialIdList = jedis.smembers(key);
                logger.debug("\u6839\u636ekey\u5728redis\u4e2d\u67e5\u8be2\u5230\u7684\u6570\u636e\uff1a" + JSON.toJSONString((Object)reidsMaterialIdList));
                reidsMaterialIdList.stream().forEach(str1 -> {
                    HashSet hashSet = this.stringConversion((String)str1);
                    logger.debug("HashSet\u5b58\u653e\u7684\u503c" + JSON.toJSONString((Object)hashSet));
                    materialIds.stream().forEach(str2 -> {
                        boolean contains = hashSet.contains(str2);
                        if (contains) {
                            logger.error("\u6279\u91cf\u5904\u7406\u672a\u540c\u6b65\u5b8c\u6210\u8bf7\u7a0d\u540e\u5728\u8bd5");
                            throw new BusinessException("9999", "\u6279\u91cf\u5904\u7406\u672a\u540c\u6b65\u5b8c\u6210\u8bf7\u7a0d\u540e\u5728\u8bd5");
                        }
                    });
                });
                jedis.sadd(key, new String[]{String.valueOf(materialIds)});
                logger.debug("\u6dfb\u52a0\u5230Redis\u4e2d\u7684\u6570\u636e\uff1a" + JSON.toJSONString(materialIds));
            } else {
                logger.debug("Key\u4e0d\u5b58\u5728\u5411Redis\u4e2d\u6dfb\u52a0\u7684\u7269\u6599" + JSON.toJSONString(materialIds));
                jedis.sadd(key, new String[]{String.valueOf(materialIds)});
            }
        }
        catch (Exception e) {
            throw new BusinessException("9999", e.getMessage());
        }
        finally {
            if (null != jedis) {
                jedis.close();
                logger.debug("\u5173\u95edRedis\u8fde\u63a5\u6c60");
            }
        }
        return materialIds;
    }

    public HashSet stringConversion(String str) {
        String s1 = str.replace("[", ",");
        String s2 = s1.replace("]", ",");
        String[] strArray = s2.split(",");
        List<String> list = Arrays.asList(strArray);
        HashSet hashSet = new HashSet();
        list.stream().forEach(li -> {
            if (!li.equals("")) {
                hashSet.add(li.trim());
            }
        });
        return hashSet;
    }

    public void updateProvGoods(ArrayList<Product> updateProvGoodsList, HashMap<String, ProvGoodsPO> ProvGoodsPOHashMap) {
        logger.debug("\u6279\u91cf\u4fee\u6539\u7701\u4efd\u5546\u54c1\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(updateProvGoodsList));
        ArrayList<Product> enableProvGoods = new ArrayList<Product>();
        ArrayList<Product> shutdownProvGoods = new ArrayList<Product>();
        updateProvGoodsList.stream().forEach(str -> {
            if (StringUtils.isBlank((String)str.getStatus())) {
                logger.error("\u5546\u54c1\u7684\u72b6\u6001\u4e3a\u7a7a\u5904\u7406\u5931\u8d25");
                throw new BusinessException("9999", "\u5546\u54c1\u7684\u72b6\u6001\u4e3a\u7a7a\u5904\u7406\u5931\u8d25");
            }
            if ("03".equals(str.getStatus())) {
                enableProvGoods.add((Product)str);
            }
            if ("04".equals(str.getStatus())) {
                shutdownProvGoods.add((Product)str);
            }
        });
        if (!CollectionUtils.isEmpty(shutdownProvGoods)) {
            AddProvGoodsListReqBO addProvGoodsListReqBO;
            logger.debug("\u4fee\u6539\u505c\u7528\u5546\u54c1\u5165\u53c2" + JSON.toJSONString(shutdownProvGoods));
            ArrayList shutdownProvGoodsId = new ArrayList();
            shutdownProvGoods.stream().forEach(str -> shutdownProvGoodsId.add(str.getProvGoodsId()));
            BatchEnableShutdownProvGoodsBO batchEnableShutdownProvGoodsBO = new BatchEnableShutdownProvGoodsBO();
            batchEnableShutdownProvGoodsBO.setProvGoodsIdList(shutdownProvGoodsId);
            batchEnableShutdownProvGoodsBO.setEnableOrDisableType("0");
            BaseRspBO baseRspBO = this.provGoodsEnableShutdownService.batchProvGoodsEnableShutdown(batchEnableShutdownProvGoodsBO);
            if ("9999".equals(baseRspBO.getRespCode())) {
                logger.error("\u7701\u4efd\u5546\u54c1\u7684\u505c\u7528\u51fa\u9519" + baseRspBO.getRespDesc());
                throw new BusinessException("9999", "\u7701\u4efd\u5546\u54c1\u7684\u505c\u7528\u51fa\u9519" + baseRspBO.getRespDesc());
            }
            try {
                addProvGoodsListReqBO = this.provGoodsEncapsulation(shutdownProvGoods);
            }
            catch (Exception e) {
                logger.error("\u7701\u4efd\u5546\u54c1\u5c5e\u6027\u5b57\u6bb5\u7684\u5c01\u88c5\u51fa\u9519" + e.getMessage());
                throw new BusinessException("9999", e.getMessage());
            }
            addProvGoodsListReqBO.getReqBO().stream().forEach(str -> {
                BaseRspBO rspBO = this.provUpdateService.newProvUpdate(str);
                if ("8888".equals(rspBO.getRespCode())) {
                    logger.error("\u4fee\u6539\u505c\u7528\u7701\u4efd\u5546\u54c1\u7684\u51fa\u9519" + rspBO.getRespDesc());
                    throw new BusinessException("9999", "\u4fee\u6539\u505c\u7528\u7701\u4efd\u5546\u54c1\u7684\u51fa\u9519" + rspBO.getRespDesc());
                }
            });
        }
        if (!CollectionUtils.isEmpty(enableProvGoods)) {
            AddProvGoodsListReqBO addProvGoodsListReqBO;
            logger.debug("\u4fee\u6539\u542f\u7528\u5546\u54c1\u5165\u53c2" + JSON.toJSONString(enableProvGoods));
            try {
                addProvGoodsListReqBO = this.provGoodsEncapsulation(enableProvGoods);
            }
            catch (Exception e) {
                logger.error("\u7701\u4efd\u5546\u54c1\u5c5e\u6027\u5b57\u6bb5\u7684\u5c01\u88c5\u51fa\u9519" + e.getMessage());
                throw new BusinessException("9999", e.getMessage());
            }
            addProvGoodsListReqBO.getReqBO().stream().forEach(str -> {
                str.setCreateUser(null);
                str.setCreateUsername(null);
                str.setUpdateUser("CTMS");
                BaseRspBO rspBO = this.provUpdateService.newProvUpdate(str);
                if ("8888".equals(rspBO.getRespCode())) {
                    logger.error("\u4fee\u6539\u542f\u7528\u7701\u4efd\u5546\u54c1\u51fa\u9519" + rspBO.getRespDesc());
                    throw new BusinessException("9999", "\u4fee\u6539\u542f\u7528\u7701\u4efd\u5546\u54c1\u51fa\u9519" + rspBO.getRespDesc());
                }
            });
        }
    }

    public void createProGoods(List<Product> createProvGoodsList) {
        logger.debug("\u6279\u91cf\u521b\u5efa\u7701\u4efd\u5546\u54c1\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(createProvGoodsList));
        ArrayList<Product> provGoodsEnableList = new ArrayList<Product>();
        createProvGoodsList.stream().forEach(str -> {
            if ("03".equals(str.getStatus())) {
                provGoodsEnableList.add((Product)str);
            }
        });
        if (CollectionUtils.isEmpty(provGoodsEnableList)) {
            logger.error("\u521b\u5efa\u7701\u4efd\u5546\u54c1\u51fa\u9519");
            throw new BusinessException("9999", "\u72b6\u6001\u4e3a\u505c\u7528\u5546\u54c1\u4e0d\u8fdb\u884c\u521b\u5efa");
        }
        logger.debug("provGoodsEnableList\u6570\u636e" + JSON.toJSONString(provGoodsEnableList));
        AddProvGoodsListReqBO addProvGoodsListReqBO = null;
        try {
            addProvGoodsListReqBO = this.provGoodsEncapsulation(provGoodsEnableList);
        }
        catch (Exception e) {
            logger.error("\u7701\u4efd\u5546\u54c1\u5c5e\u6027\u5b57\u6bb5\u7684\u5c01\u88c5\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", e.getMessage());
        }
        try {
            this.BatchcreateProvGoods(addProvGoodsListReqBO);
        }
        catch (Exception e) {
            logger.error("createProGoods\u65b9\u6cd5\u51fa\u9519");
            throw new BusinessException("9999", e.getMessage());
        }
    }

    public void BatchcreateProvGoods(AddProvGoodsListReqBO reqBO) {
        ImportProvGoodsThrean importProvGoodsThrean = new ImportProvGoodsThrean(reqBO, this.addGoodsByProvCodeService, this.xlsSkuMapper, this.xlsSkuManageService, this.batchCreateSkuService, this.dPriceSheetService, reqBO.getmOrgPath(), this.hsfVersion, this.hsfGroup, this.hsfClientTimeout);
        try {
            importProvGoodsThrean.CTMSCreateProvGoods();
        }
        catch (Exception e) {
            logger.error("BatchcreateProvGoods\u65b9\u6cd5\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", e.getMessage());
        }
    }

    public AddProvGoodsListReqBO provGoodsEncapsulation(List<Product> provGoodsEnableList) {
        AddProvGoodsListReqBO addProvGoodsListReqBO = new AddProvGoodsListReqBO();
        ArrayList provGoodsBOS = new ArrayList();
        provGoodsEnableList.stream().forEach(str -> {
            String i;
            ArrayList<SupplierBO> supplierBOS = new ArrayList<SupplierBO>();
            SupplierBO supplierBO = new SupplierBO();
            ProvGoodsBO bo = new ProvGoodsBO();
            bo.setGoodsNo(str.getGoodsNo());
            bo.setDescribe(null);
            bo.setProvGoodsId(str.getProvGoodsId());
            bo.setMaterialId(str.getMaterialId());
            bo.setBrandName(str.getBrandName());
            bo.setBrandId(str.getBrandId());
            bo.setScreenType(str.getScreenType());
            bo.setGoodsStalls(str.getGoodsStalls());
            bo.setColorName(str.getColorName());
            bo.setMemoryName(str.getMemoryName());
            bo.setVersionName(str.getVersionName());
            bo.setGoodsLongName(str.getGoodsLongName());
            bo.setBossCode(null);
            bo.setBossColor(null);
            bo.setGoodsAttr(str.getGoodsAttr());
            bo.setSerialNumberLength(str.getSerialNumberLength());
            bo.setPurchaseType(str.getPurchaseType());
            bo.setIsAfterInput(str.getIsAfterInput());
            bo.setIsAfterInputSte(null);
            bo.setHasPrice(null);
            bo.setNetwork(str.getNetwork());
            bo.setOperateSystem(str.getOperateSystem());
            bo.setRemark(str.getRemark());
            bo.setReservedField1("0");
            bo.setIsValid(null);
            bo.setMaxStock(str.getMaxStock());
            bo.setMinStock(str.getMinStock());
            bo.setAllowStockAge(str.getAllowStockAge());
            bo.setShelveDate(str.getShelveDate());
            bo.setStandardSystem(str.getStandardSystem());
            bo.setScmGoodsLongName(str.getScmGoodsLongName());
            bo.setTaxTypeCode(str.getTaxTypeCode());
            bo.setIsSendScmStock(str.getIsSendScmStock());
            bo.setIsSendScmSale(str.getIsSendScmSale());
            bo.setIsScmDistribute(str.getIsScmDistribute());
            bo.setCgType("0");
            bo.setMeasureName(str.getMeasureName());
            bo.setProvinceCode(str.getProvinceCode());
            bo.setGoodsModel(str.getGoodsModel());
            bo.setModelTypeName(null);
            bo.setConfigName(str.getConfigName());
            bo.setMeasureId(null);
            bo.setCreateUser("CTMS");
            bo.setCreateUsername("CTMS");
            bo.setGoodsStatus(str.getStatus());
            bo.setModelCommonName(str.getModelCommoneName());
            if (StringUtils.isEmpty((String)str.getGoodsSource())) {
                bo.setGoodsSource("00");
            } else {
                bo.setGoodsSource(str.getGoodsSource());
            }
            if (!"1".equals(str.getHasSerialNumber()) && !"0".equals(str.getHasSerialNumber())) {
                logger.error("\u6709\u65e0\u4e32\u53f7\u5b57\u6bb5\u503c\u6709\u8bef");
                throw new BusinessException("9999", "\u6709\u65e0\u4e32\u53f7\u5b57\u6bb5\u503c\u6709\u8bef");
            }
            bo.setHasSerialNumber(str.getHasSerialNumber());
            if ("1".equals(str.getAllowNegativeStock()) || "0".equals(str.getAllowNegativeStock())) {
                if ("1".equals(str.getHasSerialNumber()) && "1".equals(str.getAllowNegativeStock())) {
                    logger.error("\u6709\u4e32\u53f7\u4e0d\u5141\u8bb8\u8d1f\u5e93\u5b58");
                    throw new BusinessException("9999", "\u6709\u4e32\u53f7\u4e0d\u5141\u8bb8\u8d1f\u5e93\u5b58");
                }
            } else {
                logger.error("\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u5b57\u6bb5\u503c\u6709\u8bef");
                throw new BusinessException("9999", "\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u5b57\u6bb5\u503c\u6709\u8bef");
            }
            bo.setAllowNegativeStock(str.getAllowNegativeStock());
            if (StringUtils.isBlank((String)str.getModelTypeName())) {
                logger.error("ModelTypeName\u5b57\u6bb5\u503c\u4e3a\u7a7a");
                throw new BusinessException("9999", "ModelTypeName\u5b57\u6bb5\u503c\u4e3a\u7a7a");
            }
            switch (i = str.getModelTypeName()) {
                case "\u4fc3\u9500\u54c1": {
                    bo.setErpGoodsType("01");
                    break;
                }
                case "\u591a\u5f62\u6001\u7ec8\u7aef": {
                    bo.setErpGoodsType("02");
                    break;
                }
                case "\u56fa\u5b9a\u8d44\u4ea7": {
                    bo.setErpGoodsType("03");
                    break;
                }
                case "\u914d\u4ef6": {
                    bo.setErpGoodsType("04");
                    break;
                }
                case "\u624b\u673a": {
                    bo.setErpGoodsType("05");
                    break;
                }
                case "\u865a\u62df\u5546\u54c1": {
                    bo.setErpGoodsType("06");
                    break;
                }
                case "\u6f14\u793a\u673a": {
                    bo.setErpGoodsType("07");
                    break;
                }
                case "\u5382\u5546\u8d60\u54c1": {
                    bo.setErpGoodsType("08");
                    break;
                }
                case "\u98df\u54c1": {
                    bo.setErpGoodsType("09");
                    break;
                }
                case "\u751f\u6d3b\u65e5\u7528": {
                    bo.setErpGoodsType("10");
                    break;
                }
                case "\u79fb\u52a8\u4e1a\u52a1": {
                    bo.setErpGoodsType("11");
                    break;
                }
                case "\u65b0\u4e1a\u52a1": {
                    bo.setErpGoodsType("12");
                    break;
                }
                default: {
                    logger.error("\u5546\u54c1\u5206\u7c7b\u5b57\u6bb5\u503c\u65e0\u6cd5\u5339\u914d");
                    throw new BusinessException("9999", "\u5546\u54c1\u5206\u7c7b\u5b57\u6bb5\u503c\u65e0\u6cd5\u5339\u914d");
                }
            }
            if (bo.getErpGoodsType().equals("02") || bo.getErpGoodsType().equals("04") || bo.getErpGoodsType().equals("05")) {
                bo.setWhetherInvoice("1");
            } else {
                bo.setWhetherInvoice("0");
            }
            if (StringUtils.isBlank((String)str.getPurchaseType())) {
                logger.error("PurchaseType\u5b57\u6bb5\u503c\u4e3a\u7a7a");
                throw new BusinessException("9999", "PurchaseType\u5b57\u6bb5\u503c\u4e0d\u6b63\u786e");
            }
            if ("1".equals(str.getPurchaseType())) {
                bo.setSupNo("\u4e2d\u56fd\u79fb\u52a8\u901a\u4fe1\u96c6\u56e2\u7ec8\u7aef\u6709\u9650\u516c\u53f8\u5e7f\u4e1c\u5206\u516c\u53f8");
                supplierBO.setSupplierId(this.SupplierId1);
                supplierBO.setSupplierName("\u4e2d\u56fd\u79fb\u52a8\u901a\u4fe1\u96c6\u56e2\u7ec8\u7aef\u6709\u9650\u516c\u53f8\u5e7f\u4e1c\u5206\u516c\u53f8");
                supplierBO.setScmSupplierId("4400");
                supplierBO.setSupplierType("2");
                supplierBO.setEnabledFlag("1");
                supplierBO.setSupplierCredit("0");
                supplierBO.setProvinceCode("280000");
                supplierBO.setRelLevel("2");
            } else if ("2".equals(str.getPurchaseType())) {
                bo.setSupNo("\u4e2d\u56fd\u79fb\u52a8\u901a\u4fe1\u96c6\u56e2\u7ec8\u7aef\u6709\u9650\u516c\u53f8\u603b\u90e8");
                supplierBO.setSupplierId(this.SupplierId2);
                supplierBO.setSupplierName("\u4e2d\u56fd\u79fb\u52a8\u901a\u4fe1\u96c6\u56e2\u7ec8\u7aef\u6709\u9650\u516c\u53f8\u603b\u90e8");
                supplierBO.setScmSupplierId("1000");
                supplierBO.setSupplierType("3");
                supplierBO.setEnabledFlag("1");
                supplierBO.setSupplierCredit("0");
                supplierBO.setProvinceCode("280000");
                supplierBO.setRelLevel("2");
            } else {
                logger.error("\u91c7\u8d2d\u7c7b\u578b\u5b57\u6bb5\u503c\u4e0d\u6b63\u786e\u4e3a\uff1a" + JSON.toJSONString((Object)str.getPurchaseType()));
                throw new BusinessException("9999", "\u91c7\u8d2d\u7c7b\u578b\u5b57\u6bb5\u503c\u4e0d\u6b63\u786e");
            }
            supplierBOS.add(supplierBO);
            bo.setSupplierBO(supplierBOS);
            provGoodsBOS.add(bo);
        });
        addProvGoodsListReqBO.setReqBO(provGoodsBOS);
        this.setorgTreePath(addProvGoodsListReqBO);
        return addProvGoodsListReqBO;
    }

    public void setBrandID(BatchProvGoodsCreateAndUpdateBO reqBO) {
        logger.debug("BrandID\u8bbe\u7f6e\u5165\u53c2\u5165\u53e3" + JSON.toJSONString((Object)reqBO));
        ArrayList<BrandBO> brandBOs = new ArrayList<BrandBO>();
        Map<String, Long> brandMap = null;
        try {
            brandMap = this.getBrandMap();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("9999", "\u67e5\u8be2\u54c1\u724c\u51fa\u9519");
        }
        for (Product str : reqBO.getProduct()) {
            if (StringUtils.isBlank((String)str.getBrandName().trim())) {
                logger.error("\u8f93\u5165\u7684BrandName\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u8f93\u5165\u7684BrandName\u4e3a\u7a7a");
            }
            if (brandMap.containsKey(str.getBrandName().trim())) {
                str.setBrandId(brandMap.get(str.getBrandName().trim()));
                continue;
            }
            Long brandId = Sequence.getInstance().nextId();
            str.setBrandId(brandId);
            BrandBO br = new BrandBO();
            br.setBrandId(brandId);
            br.setBrandName(str.getBrandName().trim());
            brandBOs.add(br);
        }
        if (!CollectionUtils.isEmpty(brandBOs)) {
            try {
                this.createBrand(brandBOs);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new BusinessException("9999", "\u54c1\u724c\u521b\u5efa\u51fa\u9519");
            }
        }
        logger.debug("BrandID\u8bbe\u7f6e\u5165\u53c2\u51fa\u53e3" + JSON.toJSONString((Object)reqBO));
    }

    public void createBrand(List<BrandBO> brandBOS) {
        CreateBrandReqBO brandReq = new CreateBrandReqBO();
        brandReq.setBrandBOs(brandBOS);
        try {
            if (!CollectionUtils.isEmpty(brandBOS)) {
                this.brandManageService.insertBrandList(brandReq);
            }
        }
        catch (Exception e) {
            logger.error("\u54c1\u724c\u521b\u5efa\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", "\u54c1\u724c\u521b\u5efa\u51fa\u9519");
        }
    }

    public Map<String, Long> getBrandMap() {
        Brand record = new Brand();
        List brands = null;
        try {
            brands = this.brandMapper.selectAll(record);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u54c1\u724c\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", "\u67e5\u8be2\u54c1\u724c\u51fa\u9519");
        }
        TreeMap<String, Long> brandMap = new TreeMap<String, Long>(String.CASE_INSENSITIVE_ORDER);
        brands.stream().forEach(str -> {
            if (!brandMap.containsKey(str.getBrandName().trim())) {
                brandMap.put(str.getBrandName().trim(), str.getBrandId());
            }
        });
        return brandMap;
    }

    public void setorgTreePath(AddProvGoodsListReqBO addProvGoods) {
        Map<String, String> orgTreePathmap = null;
        try {
            orgTreePathmap = this.sysParamsAtomService.selectByParentCode("province_code_ORG_TREE_PATH");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7801\u8868\u51fa\u9519" + e.getMessage());
            throw new BusinessException("9999", "\u67e5\u8be2\u7801\u8868\u51fa\u9519");
        }
        logger.debug("\u67e5\u8be2\u7801\u8868\u6570\u636e\uff1a" + JSON.toJSONString(orgTreePathmap));
        if (null == orgTreePathmap.get(((ProvGoodsBO)addProvGoods.getReqBO().get(0)).getProvinceCode())) {
            logger.error("\u6839\u636e\u7701\u4efd\u7f16\u7801\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u673a\u6784\u6811");
            throw new BusinessException("9999", "\u6839\u636e\u7701\u4efd\u7f16\u7801\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u673a\u6784\u6811");
        }
        addProvGoods.setmOrgPath(orgTreePathmap.get(((ProvGoodsBO)addProvGoods.getReqBO().get(0)).getProvinceCode()));
    }

    public OrderBackBO resultManage(String status, String desc, String materialId) {
        OrderBackBO orderBackBO = new OrderBackBO();
        orderBackBO.setStatus(status);
        orderBackBO.setDesc(desc);
        orderBackBO.setMaterialId(materialId);
        return orderBackBO;
    }

    public void setGoodsStatus(List<Product> products) {
        products.stream().forEach(str -> {
            if (StringUtils.isBlank((String)str.getStatus())) {
                logger.error("Status\u5c5e\u6027\u5165\u53c2\u4e3a\u7a7a");
                throw new BusinessException("9999", "Status\u5c5e\u6027\u5165\u53c2\u4e3a\u7a7a");
            }
            if (str.getStatus().equals("0")) {
                str.setStatus("03");
            } else if (str.getStatus().equals("1")) {
                str.setStatus("04");
            } else {
                logger.error("Status\u5c5e\u6027\u5165\u53c2\u5f02\u5e38");
                throw new BusinessException("9999", "Status\u5c5e\u6027\u5165\u53c2\u5f02\u5e38");
            }
        });
    }

    public Map<String, MaterialPO> getScm(List<String> materialIds) {
        List<MaterialPO> poList;
        HashMap<String, MaterialPO> map = new HashMap<String, MaterialPO>();
        if (!CollectionUtils.isEmpty(materialIds) && !CollectionUtils.isEmpty(poList = this.materialDAO.selectScmMaterials(materialIds))) {
            poList.stream().forEach(po -> {
                if (!map.containsKey(po.getMaterialId().trim())) {
                    map.put(po.getMaterialId().trim(), (MaterialPO)po);
                }
            });
        }
        return map;
    }

    public void requestCheckout(List<Product> request) {
        if (CollectionUtils.isEmpty(request)) {
            logger.error("\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("9999", "\u5165\u53c2\u4e3a\u7a7a");
        }
        String proCode = request.get(0).getProvinceCode();
        HashSet<String> materialIdHashSet = new HashSet<String>();
        int count = 0;
        if (StringUtils.isEmpty((String)proCode)) {
            logger.error("\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
            throw new BusinessException("9999", "\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
        }
        for (Product str : request) {
            ++count;
            if (!proCode.equals(str.getProvinceCode())) {
                logger.error("\u7701\u4efd\u7f16\u7801\u4e0d\u4e00\u81f4");
                throw new BusinessException("9999", "\u5165\u53c2\u4e3a\u7a7a");
            }
            boolean falg = materialIdHashSet.add(str.getMaterialId());
            if (!falg) {
                logger.error("\u7269\u6599\u7f16\u7801\u91cd\u590d");
                throw new BusinessException("9999", "\u7269\u6599\u7f16\u7801\u91cd\u590d");
            }
            if (StringUtils.isEmpty((String)str.getModelTypeName())) {
                logger.error("\u5206\u7c7b\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u5206\u7c7b\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (("\u624b\u673a".equals(str.getModelTypeName()) || "\u591a\u5f62\u6001\u7ec8\u7aef".equals(str.getModelTypeName()) || "\u914d\u4ef6".equals(str.getModelTypeName())) && StringUtils.isEmpty((String)str.getTaxTypeCode())) {
                logger.error("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)str.getBrandName())) {
                logger.error("\u54c1\u724c\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u54c1\u724c\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)str.getGoodsModel())) {
                logger.error("\u5546\u54c1\u578b\u53f7\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u5546\u54c1\u578b\u53f7\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)str.getGoodsLongName())) {
                logger.error("\u5546\u54c1\u5168\u79f0\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u5546\u54c1\u5168\u79f0\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)str.getPurchaseType())) {
                logger.error("\u91c7\u8d2d\u7c7b\u578b\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u91c7\u8d2d\u7c7b\u578b\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)str.getHasSerialNumber())) {
                logger.error("\u6709\u65e0\u4e32\u53f7\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u6709\u65e0\u4e32\u53f7\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)str.getAllowNegativeStock())) {
                logger.error("\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)str.getIsSendScmSale())) {
                logger.error("\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (!"1".equals(str.getIsSendScmSale()) && !"0".equals(str.getIsSendScmSale())) {
                logger.error("\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u5b57\u6bb5\u6709\u8bef");
                throw new BusinessException("9999", "\u662f\u5426\u53d1\u9001SCM\u9500\u5355\u5b57\u6bb5\u6709\u8bef");
            }
            if (StringUtils.isEmpty((String)str.getIsSendScmStock())) {
                logger.error("\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (!"1".equals(str.getIsSendScmStock()) && !"0".equals(str.getIsSendScmStock())) {
                logger.error("\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u5b57\u6bb5\u6709\u8bef");
                throw new BusinessException("9999", "\u662f\u5426\u540c\u6b65SCM\u5e93\u5b58\u5b57\u6bb5\u6709\u8bef");
            }
            if (StringUtils.isEmpty((String)str.getIsScmDistribute())) {
                logger.error("\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u5b57\u6bb5\u4e3a\u7a7a");
                throw new BusinessException("9999", "\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u5b57\u6bb5\u4e3a\u7a7a");
            }
            if (str.getIsScmDistribute().equals("1") || str.getIsScmDistribute().equals("0")) continue;
            logger.error("\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u5b57\u6bb5\u6709\u8bef");
            throw new BusinessException("9999", "\u662f\u5426SCM\u81ea\u52a8\u94fa\u8d27\u5b57\u6bb5\u6709\u8bef");
        }
        if (count > 100) {
            logger.error("\u6279\u91cf\u5904\u7406\u6570\u636e\u91cf\u4e0d\u80fd\u5927\u4e8e100");
            throw new BusinessException("9999", "\u6279\u91cf\u5904\u7406\u6570\u636e\u91cf\u4e0d\u80fd\u5927\u4e8e100");
        }
    }
}

