/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.cgd.commodity.dao.BrandMapper;
import com.cgd.commodity.po.Brand;
import com.ohaotian.base.common.bo.RspInfoBO;
import com.ohaotian.plugin.db.Sequence;
import com.xls.commodity.atom.sku.DMaterialDefineManageService;
import com.xls.commodity.atom.sku.DMaterialManageService;
import com.xls.commodity.busi.sku.AddGoodsByProvCodeService;
import com.xls.commodity.busi.sku.BrandManageService;
import com.xls.commodity.busi.sku.CreateDMaterialService;
import com.xls.commodity.busi.sku.bo.BrandBO;
import com.xls.commodity.busi.sku.bo.CreateBrandReqBO;
import com.xls.commodity.busi.sku.bo.CreateDmaterialReqBO;
import com.xls.commodity.busi.sku.bo.CreateDmaterialdddReqBO;
import com.xls.commodity.busi.sku.bo.DMaterialDefineBO;
import com.xls.commodity.busi.sku.bo.DmaterialBO;
import com.xls.commodity.busi.sku.bo.DmaterialReqBO;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CreateDMaterialServiceImpl
implements CreateDMaterialService {
    @Autowired
    private DMaterialManageService dMaterialManageService;
    @Autowired
    private DMaterialDefineManageService dMaterialDefineManageService;
    @Autowired
    private AddGoodsByProvCodeService addGoodsByProvCodeService;
    @Autowired
    private BrandMapper brandMapper;
    @Autowired
    private BrandManageService brandManageService;
    private final int SIZE = 7;
    private final Integer type_0 = 0;
    private final Integer type_1 = 1;
    private final Integer type_2 = 2;
    private final String SEPARATED = "_";
    private static final Logger logger = LoggerFactory.getLogger(CreateDMaterialServiceImpl.class);

    public RspInfoBO createDMaterials(CreateDmaterialReqBO reqBO) {
        logger.debug("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u5546\u54c1\u63d2\u5165\u5217\u8868\u670d\u52a1\u5165\u53c2=" + reqBO.getDmaterialBOS().size());
        RspInfoBO rspInfoBO = new RspInfoBO();
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u6210\u529f");
        List reqBOList = reqBO.getDmaterialBOS();
        if (CollectionUtils.isEmpty((Collection)reqBOList)) {
            rspInfoBO.setRespCode("7777");
            rspInfoBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
            return rspInfoBO;
        }
        ArrayList<DmaterialBO> dmaterialBO1 = new ArrayList<DmaterialBO>();
        ArrayList<DmaterialBO> dmaterialBO2 = new ArrayList<DmaterialBO>();
        ArrayList<DmaterialBO> dmaterialBO3 = new ArrayList<DmaterialBO>();
        ArrayList<DmaterialBO> dmaterialBO4 = new ArrayList<DmaterialBO>();
        ArrayList<DmaterialBO> dmaterialBO5 = new ArrayList<DmaterialBO>();
        Date now = new Date();
        block8: for (DmaterialReqBO dReqBO : reqBOList) {
            if (StringUtils.isBlank((CharSequence)dReqBO.getScmMaterialId())) continue;
            int typeMaterial = this.isTypeMaterial(dReqBO.getScmMaterialId());
            if (this.type_0 == typeMaterial) continue;
            DmaterialBO dmaterialBO = new DmaterialBO();
            BeanUtils.copyProperties((Object)dReqBO, (Object)dmaterialBO);
            dmaterialBO.setMaterialId(dReqBO.getScmMaterialId());
            dmaterialBO.setCreateTime(now);
            dmaterialBO.setIsScm("1");
            dmaterialBO.setCreateUser("SCM");
            dmaterialBO.setUpdateUser("SCM");
            dmaterialBO.setIsValid("1");
            char type = '\u0000';
            if (this.type_1 == typeMaterial) {
                type = dmaterialBO.getMaterialId().charAt(2);
            } else if (this.type_2 == typeMaterial) {
                type = dmaterialBO.getMaterialId().charAt(0);
            }
            switch (type) {
                case '1': {
                    dmaterialBO1.add(dmaterialBO);
                    continue block8;
                }
                case '2': {
                    dmaterialBO2.add(dmaterialBO);
                    continue block8;
                }
                case '3': {
                    dmaterialBO3.add(dmaterialBO);
                    continue block8;
                }
                case '4': {
                    dmaterialBO4.add(dmaterialBO);
                    continue block8;
                }
            }
            dmaterialBO5.add(dmaterialBO);
        }
        if (CollectionUtils.isNotEmpty(dmaterialBO1)) {
            this.formatMaterialBO(dmaterialBO1, '1');
        }
        if (CollectionUtils.isNotEmpty(dmaterialBO2)) {
            this.formatMaterialBO(dmaterialBO2, '2');
        }
        if (CollectionUtils.isNotEmpty(dmaterialBO3)) {
            this.formatMaterialBO(dmaterialBO3, '3');
        }
        if (CollectionUtils.isNotEmpty(dmaterialBO4)) {
            this.formatMaterialBO(dmaterialBO4, '4');
        }
        ArrayList<DmaterialBO> dmaterialBOs = new ArrayList<DmaterialBO>();
        dmaterialBOs.addAll(dmaterialBO1);
        dmaterialBOs.addAll(dmaterialBO2);
        dmaterialBOs.addAll(dmaterialBO3);
        dmaterialBOs.addAll(dmaterialBO4);
        dmaterialBOs.addAll(dmaterialBO5);
        if (CollectionUtils.isEmpty(dmaterialBOs)) {
            return rspInfoBO;
        }
        try {
            logger.debug("\u65b0\u589e\u7269\u6599\u5546\u54c1\u6761\u6570" + dmaterialBOs.size());
            this.dMaterialManageService.insertMaterialRecords(dmaterialBOs);
            List brands = this.brandMapper.selectAll(new Brand());
            TreeMap<String, Long> brandMap = new TreeMap<String, Long>(String.CASE_INSENSITIVE_ORDER);
            for (Brand brand : brands) {
                if (brandMap.containsKey(brand.getBrandName())) continue;
                brandMap.put(brand.getBrandName(), brand.getBrandId());
            }
            HashSet<String> brandSet = new HashSet<String>();
            for (DmaterialBO bo : dmaterialBOs) {
                if (!StringUtils.isNotEmpty((CharSequence)bo.getBrandName())) continue;
                brandSet.add(bo.getBrandName().trim());
            }
            ArrayList<BrandBO> brandBOs = new ArrayList<BrandBO>();
            BrandBO br = null;
            CreateBrandReqBO brandReq = new CreateBrandReqBO();
            for (String brand : brandSet) {
                if (brandMap.containsKey(brand)) continue;
                br = new BrandBO();
                Long brandId = Sequence.getInstance().nextId();
                br.setBrandId(brandId);
                br.setBrandName(brand.trim());
                brandBOs.add(br);
            }
            brandReq.setBrandBOs(brandBOs);
            if (CollectionUtils.isNotEmpty(brandBOs)) {
                logger.debug("\u65b0\u589e\u5546\u54c1\u54c1\u724c" + brandBOs.size());
                this.brandManageService.insertBrandList(brandReq);
            }
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u7269\u6599\u5546\u54c1\u670d\u52a1\u62a5\u9519" + e);
            rspInfoBO.setRespCode("8888");
            rspInfoBO.setRespDesc("\u5931\u8d25");
            return rspInfoBO;
        }
        return rspInfoBO;
    }

    private String[] stringToArray(String materialId) {
        String[] stirs = new String[7];
        int typeMaterial = this.isTypeMaterial(materialId);
        if (this.type_1 == typeMaterial) {
            stirs[0] = materialId.substring(2, 3);
            stirs[1] = materialId.substring(3, 6);
            stirs[2] = materialId.substring(2, 10);
            stirs[3] = materialId.substring(10, 13);
            stirs[4] = materialId.substring(13, 16);
            stirs[5] = materialId.substring(16, 17);
            stirs[6] = materialId.substring(17, 18);
        } else if (this.type_2 == typeMaterial) {
            stirs[0] = materialId.substring(0, 1);
            stirs[1] = materialId.substring(1, 4);
            stirs[2] = materialId.substring(0, 8);
            stirs[3] = materialId.substring(8, 11);
            stirs[4] = materialId.substring(11, 14);
            stirs[5] = materialId.substring(14, 15);
            stirs[6] = materialId.substring(15, 16);
        }
        return stirs;
    }

    private void formatMaterialBO(List<DmaterialBO> danialBOs, char code1) {
        String code = String.valueOf(code1);
        DMaterialDefineBO dMaterialDefineBO = new DMaterialDefineBO();
        dMaterialDefineBO.setProductTypeCode(code);
        RspInfoListBO dMaterialDefineBORspInfoListBO = this.dMaterialDefineManageService.selectMaterialDefineByBatch(dMaterialDefineBO);
        List dmdList = dMaterialDefineBORspInfoListBO.getRows();
        HashMap<String, String> defineMap = new HashMap<String, String>();
        for (DMaterialDefineBO dm : dmdList) {
            if (!StringUtils.isNotBlank((CharSequence)dm.getDataName())) continue;
            if ("1".equals(dm.getDataType())) {
                defineMap.put(dm.getProductTypeCode() + "_" + "1", dm.getDataName());
                continue;
            }
            defineMap.put(dm.getProductTypeCode() + "_" + dm.getDataType() + "_" + dm.getDataCode(), dm.getDataName());
        }
        dMaterialDefineBO = new DMaterialDefineBO();
        dMaterialDefineBO.setDataType("4");
        RspInfoListBO dMaterialDefineBORspInfoListBO1 = this.dMaterialDefineManageService.selectMaterialDefineByBatch(dMaterialDefineBO);
        dmdList = dMaterialDefineBORspInfoListBO1.getRows();
        HashMap<String, String> colorMap = new HashMap<String, String>();
        for (DMaterialDefineBO dm : dmdList) {
            if (!StringUtils.isNotBlank((CharSequence)dm.getDataName())) continue;
            colorMap.put("4_" + dm.getDataCode(), dm.getDataName());
        }
        dMaterialDefineBO.setDataType("1");
        dMaterialDefineBORspInfoListBO = this.dMaterialDefineManageService.selectMaterialDefineByBatch(dMaterialDefineBO);
        dmdList = dMaterialDefineBORspInfoListBO.getRows();
        for (DMaterialDefineBO dm : dmdList) {
            if (!StringUtils.isNotBlank((CharSequence)dm.getDataName())) continue;
            defineMap.put(code + "_" + "1" + "_" + dm.getDataCode(), dm.getDataName());
        }
        for (int i = 0; i < danialBOs.size(); ++i) {
            DmaterialBO bo1 = danialBOs.get(i);
            String[] strings = this.stringToArray(bo1.getMaterialId());
            switch (code1) {
                case '2': {
                    if (defineMap.containsKey(code + "_" + "5" + "_" + strings[4])) {
                        bo1.setConfigName((String)defineMap.get(code + "_" + "5" + "_" + strings[4]));
                    }
                }
                case '1': {
                    if (defineMap.containsKey(code + "_" + "6" + "_" + strings[5])) {
                        bo1.setVersionName((String)defineMap.get(code + "_" + "6" + "_" + strings[5]));
                    }
                    if (defineMap.containsKey(code + "_" + "7" + "_" + strings[6])) {
                        bo1.setModelTypeName((String)defineMap.get(code + "_" + "7" + "_" + strings[6]));
                    }
                }
                case '3': 
                case '4': {
                    if (defineMap.containsKey(code + "_" + "1" + "_" + strings[0])) {
                        bo1.setGoodsTypeName((String)defineMap.get(code + "_" + "1" + "_" + strings[0]));
                    }
                    if (defineMap.containsKey(code + "_" + "2" + "_" + strings[1])) {
                        bo1.setBrandName((String)defineMap.get(code + "_" + "2" + "_" + strings[1]));
                    }
                    if (defineMap.containsKey(code + "_" + "3" + "_" + strings[2])) {
                        bo1.setMarqueName((String)defineMap.get(code + "_" + "3" + "_" + strings[2]));
                    }
                    if (!colorMap.containsKey("4_" + strings[3])) break;
                    bo1.setColorName((String)colorMap.get("4_" + strings[3]));
                    break;
                }
            }
            danialBOs.set(i, bo1);
        }
    }

    public RspInfoBO createDMaterialDefines(CreateDmaterialdddReqBO reqBO) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u63d2\u5165\u5217\u8868\u670d\u52a1\u5165\u53c2=" + reqBO);
        RspInfoBO rspInfoBO = new RspInfoBO();
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u6210\u529f");
        List dMaterialDefineBOS = reqBO.getDefineBOS();
        if (CollectionUtils.isEmpty((Collection)dMaterialDefineBOS)) {
            logger.debug("\u5546\u54c1\u4e2d\u5fc3\u7269\u6599\u7f16\u7801\u5b9a\u4e49\u63d2\u5165\u5217\u8868\u670d\u52a1\u5165\u53c2list\u4e3a\u7a7a\uff01");
            return rspInfoBO;
        }
        try {
            this.dMaterialDefineManageService.insertMaterialDefineRecords(dMaterialDefineBOS);
        }
        catch (Exception e) {
            logger.error("\u65b0\u589e\u7269\u6599\u5b9a\u4e49\u670d\u52a1\u62a5\u9519" + e);
            rspInfoBO.setRespCode("8888");
            rspInfoBO.setRespDesc("\u5931\u8d25");
            return rspInfoBO;
        }
        return rspInfoBO;
    }

    public RspInfoBO delMaterialDefineByDataType(DMaterialDefineBO reqBO) {
        logger.info("\u5546\u54c1\u4e2d\u5fc3\u5220\u9664\u7269\u6599\u5b9a\u4e49\u670d\u52a1\u5165\u53c2=" + reqBO);
        RspInfoBO rspInfoBO = new RspInfoBO();
        rspInfoBO.setRespCode("0000");
        rspInfoBO.setRespDesc("\u6210\u529f");
        try {
            this.dMaterialDefineManageService.deleteMaterialDefineByDataType(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u7269\u6599\u5b9a\u4e49\u670d\u52a1\u62a5\u9519" + e);
            rspInfoBO.setRespCode("8888");
            rspInfoBO.setRespDesc("\u5931\u8d25");
            return rspInfoBO;
        }
        return rspInfoBO;
    }

    private Integer isTypeMaterial(String material) {
        String regex = ".*[a-zA-Z]+.*";
        if (!(material.length() == 18 || material.length() == 16 && Pattern.compile(regex).matcher(material).matches())) {
            return this.type_0;
        }
        if (material.length() == 18) {
            return this.type_1;
        }
        if (material.length() == 16 && Pattern.compile(regex).matcher(material).matches()) {
            return this.type_2;
        }
        return this.type_0;
    }
}

