/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.xls.commodity.atom.sku.RCommodityLabelManageService;
import com.xls.commodity.busi.sku.QuerySkuListByLabelService;
import com.xls.commodity.busi.sku.bo.QuerySkuListByLabelReqBO;
import com.xls.commodity.busi.sku.bo.QuerySkuListByLabelRspBO;
import com.xls.commodity.busi.sku.bo.RCommodityLabelBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.bo.RspInfoListBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuerySkuListByLabelServiceImpl
implements QuerySkuListByLabelService {
    @Autowired
    private RCommodityLabelManageService rCommodityLabelManageService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    private static final Logger logger = LoggerFactory.getLogger(QuerySkuListByLabelServiceImpl.class);

    public RspInfoListBO<QuerySkuListByLabelRspBO> querySkuListByLabel(QuerySkuListByLabelReqBO querySkuListByLabelReqBO) {
        logger.debug("\u6839\u636e\u5546\u54c1\u6807\u7b7eID\u67e5\u8be2\u5355\u54c1\u5217\u8868\u670d\u52a1\u5165\u53c2=" + querySkuListByLabelReqBO.toString());
        RspInfoListBO result = new RspInfoListBO();
        ArrayList<QuerySkuListByLabelRspBO> querySkuListByLabelRspBOs = new ArrayList<QuerySkuListByLabelRspBO>();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        List rCommodityLabelBOs = null;
        try {
            rCommodityLabelBOs = this.rCommodityLabelManageService.selectByLabelId(querySkuListByLabelReqBO.getLabelId());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u6807\u7b7eID\u67e5\u8be2\u6807\u7b7e\u548c\u5546\u54c1\u5173\u7cfb\u539f\u5b50\u670d\u52a1\u62a5\u9519");
        }
        if (CollectionUtils.isNotEmpty((Collection)rCommodityLabelBOs)) {
            for (RCommodityLabelBO rCommodityLabelBO : rCommodityLabelBOs) {
                commodityIds.add(rCommodityLabelBO.getCommodityId());
            }
        }
        List<Object> skus = new ArrayList();
        if (CollectionUtils.isNotEmpty(commodityIds)) {
            Sku sku = new Sku();
            sku.setCommodityIds(commodityIds);
            skus = this.xlsSkuMapper.selectByCommodityIds(sku);
        }
        if (CollectionUtils.isNotEmpty(skus)) {
            for (Sku sku : skus) {
                QuerySkuListByLabelRspBO querySkuListByLabelRspBO = new QuerySkuListByLabelRspBO();
                BeanUtils.copyProperties((Object)sku, (Object)querySkuListByLabelRspBO);
                querySkuListByLabelRspBOs.add(querySkuListByLabelRspBO);
            }
        }
        result.setRows(querySkuListByLabelRspBOs);
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

