/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ResourceException;
import com.tydic.newretail.toolkit.util.TkExcelUtils;
import com.xls.commodity.busi.sku.SheetImportService;
import com.xls.commodity.busi.sku.bo.GetTempReqBO;
import com.xls.commodity.busi.sku.bo.GetTempResBO;
import com.xls.commodity.busi.sku.bo.ImportFaildBO;
import com.xls.commodity.busi.sku.bo.ImportProvGoodsReqBO;
import com.xls.commodity.busi.sku.bo.ImportSheetResBO;
import com.xls.commodity.busi.sku.bo.ImportSheetSuccessBO;
import com.xls.commodity.constants.SysParamConstant;
import com.xls.commodity.dao.MaterialDAO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.po.MaterialPO;
import com.xls.commodity.dao.po.ProvGoodsPO;
import com.xls.commodity.util.SCSOssFileUtils;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SheetImportServiceImpl
implements SheetImportService {
    private static final Logger logger = LoggerFactory.getLogger(SheetImportServiceImpl.class);
    @Value(value="${prov.sheet.path}")
    private String provSheetPath;
    @Value(value="${prov.sheet.temp}")
    private String provSheetTemp;
    @Value(value="${hq.sheet.path}")
    private String hqSheetPath;
    @Value(value="${hq.sheet.temp}")
    private String hqSheetTemp;
    private List<ImportFaildBO> fild;
    @Autowired
    private MaterialDAO materialDAO;
    @Autowired
    private ProvGoodsDAO provGoodsDAO;

    public GetTempResBO getSheetTemp(GetTempReqBO reqBO) {
        logger.debug("\u83b7\u53d6\u62a5\u4ef7\u5355\u5bfc\u5165\u6a21\u677f");
        GetTempResBO result = new GetTempResBO();
        if ("hq".equals(reqBO.getTempName())) {
            if (StringUtils.isBlank((String)this.hqSheetTemp)) {
                result.setRespCode("8888");
                result.setRespDesc("\u672a\u914d\u7f6e\u603b\u90e8\u62a5\u4ef7\u5355\u6a21\u677f\u4e0b\u8f7d\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return result;
            }
            result.setData(this.hqSheetTemp);
        } else if ("prov".equals(reqBO.getTempName())) {
            if (StringUtils.isBlank((String)this.provSheetTemp)) {
                result.setRespCode("8888");
                result.setRespDesc("\u672a\u914d\u7f6e\u7701\u4efd\u62a5\u4ef7\u5355\u6a21\u677f\u4e0b\u8f7d\u5730\u5740\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                return result;
            }
            result.setData(this.provSheetTemp);
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public ImportSheetResBO importHqComm(ImportProvGoodsReqBO reqBO) {
        File file;
        ImportSheetResBO result = new ImportSheetResBO();
        if (StringUtils.isEmpty((String)reqBO.getFileName())) {
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            return result;
        }
        try {
            file = SCSOssFileUtils.downloadFileFromPath(this.hqSheetPath + reqBO.getFileName(), null, true);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            return result;
        }
        if (null == file || !file.exists()) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String suffix = TkExcelUtils.getSuffix((String)file.getPath());
        if (null != suffix) {
            suffix = suffix.toLowerCase();
        }
        List<Object> rows = new ArrayList();
        try {
            rows = this.readXlsx(file.getPath(), suffix, reqBO.getProvinceCode(), true);
        }
        catch (ResourceException e) {
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode(e.getMsgCode());
            result.setRespDesc(e.getMessage());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setSuccess(rows);
        result.setImportFaild(this.fild);
        return result;
    }

    public ImportSheetResBO importProvComm(ImportProvGoodsReqBO reqBO) {
        File file;
        ImportSheetResBO result = new ImportSheetResBO();
        if (StringUtils.isEmpty((String)reqBO.getFileName())) {
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a");
            return result;
        }
        try {
            file = SCSOssFileUtils.downloadFileFromPath(this.provSheetPath + reqBO.getFileName(), null, true);
        }
        catch (Exception e) {
            logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25");
            return result;
        }
        if (null == file || !file.exists()) {
            logger.error("\u6587\u4ef6\u4e0d\u5b58\u5728");
            result.setRespCode("8888");
            result.setRespDesc("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return result;
        }
        String suffix = TkExcelUtils.getSuffix((String)file.getPath());
        if (null != suffix) {
            suffix = suffix.toLowerCase();
        }
        List<Object> rows = new ArrayList();
        try {
            rows = this.readXlsx(file.getPath(), suffix, reqBO.getProvinceCode(), false);
        }
        catch (ResourceException e) {
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode(e.getMsgCode());
            result.setRespDesc(e.getMessage());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
            result.setRespCode("8888");
            result.setRespDesc("\u89e3\u6790\u6587\u4ef6\u5f02\u5e38");
            return result;
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setSuccess(rows);
        result.setImportFaild(this.fild);
        return result;
    }

    public List<ImportSheetSuccessBO> readXlsx(String path, String suffix, String provinceCode, Boolean isHq) throws Exception {
        ArrayList rows = null;
        if ("xls".equals(suffix)) {
            List hssfRows = TkExcelUtils.readXls((String)path, (int)0, (int)2);
            rows = new ArrayList(hssfRows);
        } else if ("xlsx".equals(suffix)) {
            List xssfRows = TkExcelUtils.readXlsx((String)path, (int)0, (int)2);
            rows = new ArrayList(xssfRows);
        } else {
            logger.error("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
            throw new ResourceException("0007", "\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1a\u4ec5\u652f\u6301xls\u53caxlsx\u683c\u5f0f");
        }
        if (CollectionUtils.isEmpty(rows)) {
            logger.error("\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
            throw new ResourceException("0016", "\u672a\u83b7\u53d6\u6587\u4ef6\u5185\u5bb9");
        }
        boolean isDecimal = false;
        this.fild = new ArrayList<ImportFaildBO>(rows.size());
        ArrayList<String> paramMaterials = new ArrayList<String>();
        ArrayList<String> materials = new ArrayList<String>();
        for (Row row : rows) {
            if (!StringUtils.isNotEmpty((String)TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal))) continue;
            paramMaterials.add(TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal).trim());
        }
        Map<String, ImportSheetSuccessBO> materialMap = this.getMaterial(paramMaterials, isHq, provinceCode);
        ArrayList<ImportSheetSuccessBO> list = new ArrayList<ImportSheetSuccessBO>();
        ImportSheetSuccessBO bo = null;
        for (Row row : rows) {
            Object fbo;
            String purchaseFloorPriceStr;
            String materialId = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(0), (Boolean)isDecimal).trim();
            String materialDesc = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal).trim();
            String goodsLongName = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(1), (Boolean)isDecimal).trim();
            String assessmentPriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(2), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(2), (Boolean)true).trim();
            String purchasePriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(3), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(3), (Boolean)true).trim();
            String salePriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(4), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(4), (Boolean)true).trim();
            String agreementPriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(5), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(5), (Boolean)true).trim();
            String provAgreePriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(6), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(6), (Boolean)true).trim();
            String memberPriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(7), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(7), (Boolean)true).trim();
            String score = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(8), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(8), (Boolean)isDecimal).trim();
            String fixedRoyalty = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(9), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(9), (Boolean)isDecimal).trim();
            String royaltyRatio = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(10), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(10), (Boolean)isDecimal).trim();
            String groupRoyalty = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(11), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(11), (Boolean)isDecimal).trim();
            String profitRoyalty = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(12), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(12), (Boolean)isDecimal).trim();
            String isCover = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(13), (Boolean)isDecimal)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(13), (Boolean)isDecimal).trim();
            String theCostDownPriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(14), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(14), (Boolean)true).trim();
            String retailAgreementPriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(15), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(15), (Boolean)true).trim();
            String citiesLockPriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(16), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(16), (Boolean)true).trim();
            String string = purchaseFloorPriceStr = StringUtils.isBlank((String)TkExcelUtils.changeCellToString((Cell)row.getCell(17), (Boolean)true)) ? null : TkExcelUtils.changeCellToString((Cell)row.getCell(17), (Boolean)true).trim();
            String back = this.check(row.getRowNum(), materialId, salePriceStr, isCover, isHq);
            if (null != back) continue;
            if (!materialMap.containsKey(materialId)) {
                fbo = new ImportFaildBO();
                logger.debug("\u7269\u6599\u7f16\u7801" + materialId + "\u4e0d\u5b58\u5728");
                fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                fbo.setDesc("\u7269\u6599\u7f16\u7801" + materialId + "\u4e0d\u5b58\u5728");
                this.fild.add((ImportFaildBO)fbo);
                continue;
            }
            if (!isHq.booleanValue() && !"03".equals(materialMap.get(materialId).getGoodsStatus())) {
                fbo = new ImportFaildBO();
                logger.debug("\u7269\u6599\u7f16\u7801" + materialId + "\u672a\u542f\u7528");
                fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                fbo.setDesc("\u7269\u6599\u7f16\u7801" + materialId + "\u672a\u542f\u7528");
                this.fild.add((ImportFaildBO)fbo);
                continue;
            }
            if (materials.contains(materialId)) {
                fbo = new ImportFaildBO();
                logger.debug("\u7269\u6599\u7f16\u7801\u91cd\u590d");
                fbo.setRowNum(Integer.valueOf(row.getRowNum() + 1));
                fbo.setDesc("\u7269\u6599\u7f16" + materialId + "\u7801\u91cd\u590d");
                this.fild.add((ImportFaildBO)fbo);
                continue;
            }
            materials.add(materialId);
            bo = new ImportSheetSuccessBO();
            bo.setFixedRoyalty(fixedRoyalty);
            bo.setGoodsLongName(materialMap.get(materialId).getGoodsLongName());
            bo.setGroupRoyalty(groupRoyalty);
            if (!isHq.booleanValue()) {
                switch (isCover) {
                    case "\u662f": {
                        bo.setIsCover("1");
                        break;
                    }
                    case "Y": {
                        bo.setIsCover("1");
                        break;
                    }
                    default: {
                        bo.setIsCover("0");
                    }
                }
            }
            bo.setMaterialDesc(materialMap.get(materialId).getGoodsLongName());
            bo.setMaterialId(materialId);
            bo.setProvGoodsId(materialMap.get(materialId).getProvGoodsId());
            bo.setProfitRoyalty(profitRoyalty);
            bo.setScore(score);
            bo.setRoyaltyRatio(royaltyRatio);
            if (StringUtils.isNotEmpty((String)purchaseFloorPriceStr)) {
                bo.setPurchaseFloorPriceStr(new BigDecimal(purchaseFloorPriceStr));
            }
            if (StringUtils.isNotEmpty((String)theCostDownPriceStr)) {
                bo.setTheCostDownPriceStr(new BigDecimal(theCostDownPriceStr));
            }
            if (StringUtils.isNotEmpty((String)retailAgreementPriceStr)) {
                bo.setRetailAgreementPriceStr(new BigDecimal(retailAgreementPriceStr));
            }
            if (StringUtils.isNotEmpty((String)purchasePriceStr)) {
                bo.setPurchasePriceStr(new BigDecimal(purchasePriceStr));
            }
            if (StringUtils.isNotEmpty((String)provAgreePriceStr)) {
                bo.setProvAgreePriceStr(new BigDecimal(provAgreePriceStr));
            }
            if ("280000".equals(provinceCode)) {
                BigDecimal agree = new BigDecimal(SysParamConstant.AGREEMENTPRICE);
                BigDecimal city = new BigDecimal(SysParamConstant.CITIESLOCKPRICESTR);
                if (StringUtils.isNotEmpty((String)salePriceStr)) {
                    Double citiesLockPrice = new BigDecimal(salePriceStr).multiply(city).doubleValue();
                    Double agreementPrice = new BigDecimal(salePriceStr).multiply(agree).doubleValue();
                    bo.setCitiesLockPriceStr(new BigDecimal(citiesLockPrice));
                    bo.setAgreementPriceStr(new BigDecimal(agreementPrice));
                }
            }
            if (StringUtils.isNotEmpty((String)agreementPriceStr)) {
                bo.setAgreementPriceStr(new BigDecimal(agreementPriceStr));
            }
            if (StringUtils.isNotEmpty((String)citiesLockPriceStr)) {
                bo.setCitiesLockPriceStr(new BigDecimal(citiesLockPriceStr));
            }
            if (StringUtils.isNotEmpty((String)assessmentPriceStr)) {
                bo.setAssessmentPriceStr(new BigDecimal(assessmentPriceStr));
            }
            if (StringUtils.isNotEmpty((String)memberPriceStr)) {
                bo.setMemberPriceStr(new BigDecimal(memberPriceStr));
            }
            if (StringUtils.isNotEmpty((String)salePriceStr)) {
                bo.setSalePriceStr(new BigDecimal(salePriceStr));
            }
            list.add(bo);
        }
        return list;
    }

    public String check(int rowNum, String materialId, String salePriceStr, String isCover, Boolean isHq) {
        if (StringUtils.isBlank((String)materialId)) {
            ImportFaildBO fbo = new ImportFaildBO();
            logger.debug("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            fbo.setDesc("\u7269\u6599\u7f16\u7801\u4e3a\u7a7a");
            fbo.setRowNum(Integer.valueOf(rowNum + 1));
            this.fild.add(fbo);
            return "\u7269\u6599\u7f16\u7801\u4e3a\u7a7a";
        }
        if (!isHq.booleanValue()) {
            if (StringUtils.isBlank((String)salePriceStr)) {
                ImportFaildBO fbo = new ImportFaildBO();
                logger.debug("\u96f6\u552e\u4ef7\u4e3a\u7a7a");
                fbo.setDesc("\u96f6\u552e\u4ef7\u4e3a\u7a7a");
                fbo.setRowNum(Integer.valueOf(rowNum + 1));
                this.fild.add(fbo);
                return "\u96f6\u552e\u4ef7\u4e3a\u7a7a";
            }
            if (StringUtils.isBlank((String)isCover)) {
                ImportFaildBO fbo = new ImportFaildBO();
                logger.debug("\u662f\u5426\u5168\u8986\u76d6\u4e3a\u7a7a");
                fbo.setDesc("\u662f\u5426\u5168\u8986\u76d6\u4e3a\u7a7a");
                fbo.setRowNum(Integer.valueOf(rowNum + 1));
                this.fild.add(fbo);
                return "\u662f\u5426\u5168\u8986\u76d6\u4e3a\u7a7a";
            }
        }
        return null;
    }

    public Map<String, ImportSheetSuccessBO> getMaterial(List<String> materials, Boolean idHq, String prov) {
        HashMap<String, ImportSheetSuccessBO> map;
        block3: {
            block4: {
                map = new HashMap<String, ImportSheetSuccessBO>();
                if (CollectionUtils.isEmpty(materials)) break block3;
                if (!idHq.booleanValue()) break block4;
                List<MaterialPO> poList = this.materialDAO.selectByMaterialIds(materials);
                if (CollectionUtils.isEmpty(poList)) break block3;
                ImportSheetSuccessBO bo = null;
                for (MaterialPO po : poList) {
                    if (map.containsKey(po.getMaterialId())) continue;
                    bo = new ImportSheetSuccessBO();
                    bo.setGoodsLongName(po.getMaterialDesc());
                    bo.setMaterialDesc(po.getMaterialDesc());
                    bo.setMaterialId(po.getMaterialId());
                    bo.setProvGoodsId(null);
                    map.put(po.getMaterialId(), bo);
                }
                break block3;
            }
            List<ProvGoodsPO> poList = this.provGoodsDAO.selectByProvAndMaterial(prov, materials);
            if (!CollectionUtils.isEmpty(poList)) {
                ImportSheetSuccessBO bo = null;
                for (ProvGoodsPO po : poList) {
                    if (map.containsKey(po.getMaterialId())) continue;
                    bo = new ImportSheetSuccessBO();
                    bo.setMaterialDesc(po.getGoodsLongName());
                    bo.setGoodsLongName(po.getGoodsLongName());
                    bo.setMaterialId(po.getMaterialId());
                    bo.setGoodsStatus(po.getGoodsStatus());
                    bo.setProvGoodsId(po.getProvGoodsId());
                    map.put(po.getMaterialId(), bo);
                }
            }
        }
        return map;
    }
}

