/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.atom.sku.XlsSkuManageService;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.SkuCreateByProvGoodsService;
import com.xls.commodity.busi.sku.bo.BatchCreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.DPriceSheetBO;
import com.xls.commodity.busi.sku.bo.ShopIdAndShopNameBO;
import com.xls.commodity.busi.sku.bo.SkuCreateByProvGoodsReqBO;
import com.xls.commodity.dao.ProvGoodsDAO;
import com.xls.commodity.dao.ProvGoodsInsureServiceDAO;
import com.xls.commodity.dao.ProvGoodsSupRelationDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.ProvGoodsAndSupplierPO;
import com.xls.commodity.dao.po.ProvGoodsInsureServicePO;
import com.xls.commodity.dao.po.ProvGoodsSupRelationPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.DPriceSheetService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.ProvinceMaterialBO;
import com.xls.commodity.intfce.sku.bo.SkuBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SkuCreateByProvGoodsServiceImpl
implements SkuCreateByProvGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(SkuCreateByProvGoodsServiceImpl.class);
    @Autowired
    private ProvGoodsDAO provGoodsDAO;
    @Autowired
    private BatchCreateSkuService batchCreateSkuService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private XlsSkuManageService xlsSkuManageService;
    @Value(value="${hsf.version}")
    private String hsfVersion;
    @Value(value="${hsf.group}")
    private String hsfGroup;
    @Value(value="${hsf.clientTimeout}")
    private String hsfClientTimeout;
    @Autowired
    private ProvGoodsInsureServiceDAO provGoodsInsureServiceDAO;
    @Autowired
    private ProvGoodsSupRelationDAO provGoodsSupRelationDAO;
    @Autowired
    private DPriceSheetService dPriceSheetService;

    public BaseRspBO createSku(final SkuCreateByProvGoodsReqBO reqBO) {
        logger.debug("\u5165\u53c2" + JSONObject.toJSONString((Object)reqBO));
        logger.debug("\u95e8\u5e97\u5546\u54c1\u521b\u5efa");
        BaseRspBO result = new BaseRspBO();
        ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
        record.setProvinceCode(reqBO.getProvinceCode());
        List<Object> goods = new ArrayList();
        try {
            goods = this.provGoodsDAO.queryProvGoodsGroup(record);
            logger.debug("\u7701\u4efd\u5546\u54c1\u6570\u91cf" + goods.size());
        }
        catch (Exception e) {
            logger.error("\u7701\u4efd\u5546\u54c1\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("9999", "\u7701\u4efd\u5546\u54c1\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        ArrayList<Long> shopIds = new ArrayList<Long>();
        ArrayList<String> cityCode = new ArrayList<String>();
        for (ShopIdAndShopNameBO shop : reqBO.getShops()) {
            shopIds.add(shop.getShopId());
            cityCode.add(shop.getCityCode());
        }
        logger.debug("\u67e5\u8be2\u5546\u54c1\u662f\u5426\u5b58\u5728");
        HashMap<String, Long> exitst = new HashMap<String, Long>();
        List<Object> skuList = Collections.synchronizedList(new ArrayList());
        if (!CollectionUtils.isEmpty(shopIds)) {
            skuList = this.xlsSkuMapper.queryXlsSkuByShopList(shopIds);
            logger.debug("\u5df2\u5b58\u5728\u5546\u54c1" + skuList.size());
            if (!CollectionUtils.isEmpty(skuList)) {
                for (Object good : skuList) {
                    if (exitst.containsKey(((Sku)good).getSupplierId() + ((Sku)good).getMaterialId())) continue;
                    exitst.put(((Sku)good).getSupplierId() + ((Sku)good).getMaterialId(), ((Sku)good).getSkuId());
                }
            }
        }
        ArrayList<String> materialIds = new ArrayList<String>();
        if (!CollectionUtils.isEmpty(goods)) {
            for (ProvGoodsAndSupplierPO provGoodsAndSupplierPO : goods) {
                materialIds.add(provGoodsAndSupplierPO.getMaterialId());
            }
        }
        final AtomicReference atomSkuList = new AtomicReference(skuList);
        ProvinceMaterialBO provinceMaterialBO = new ProvinceMaterialBO();
        provinceMaterialBO.setProvinceCode(reqBO.getProvinceCode());
        provinceMaterialBO.setMaterialId(materialIds);
        provinceMaterialBO.setCityCodes(cityCode);
        Map priceSheet = this.dPriceSheetService.findDPriceSheet(provinceMaterialBO);
        logger.debug("\u62a5\u4ef7\u5355" + priceSheet.size());
        ArrayList<CreateSkuReqBO> addSkuList = new ArrayList<CreateSkuReqBO>();
        ArrayList<SkuBO> skuBOS = new ArrayList<SkuBO>();
        if (!CollectionUtils.isEmpty(goods)) {
            for (ProvGoodsAndSupplierPO provGoodsAndSupplierPO : goods) {
                if (!StringUtils.isBlank((String)provGoodsAndSupplierPO.getMaterialId())) {
                    for (ShopIdAndShopNameBO shop : reqBO.getShops()) {
                        CreateSkuReqBO sku;
                        if (exitst.containsKey(shop.getShopId() + provGoodsAndSupplierPO.getMaterialId())) {
                            sku = this.toUpdateBO(provGoodsAndSupplierPO, shop.getShopId(), shop.getCityCode(), (Long)exitst.get(shop.getShopId() + provGoodsAndSupplierPO.getMaterialId()), shop.getCountyCode());
                            if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "03")) {
                                sku.setIsDelete(Integer.valueOf(0));
                            } else if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "04")) {
                                sku.setIsDelete(Integer.valueOf(1));
                            }
                            skuBOS.add((SkuBO)sku);
                            continue;
                        }
                        sku = this.toAddBO(provGoodsAndSupplierPO, shop.getShopId(), shop.getCityCode(), shop.getShopName(), shop.getCountyCode(), priceSheet);
                        if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "03")) {
                            sku.setIsDelete(String.valueOf(0));
                        } else if (Objects.equals(provGoodsAndSupplierPO.getGoodsStatus(), "04")) {
                            sku.setIsDelete(String.valueOf(1));
                        }
                        addSkuList.add(sku);
                    }
                    continue;
                }
                logger.debug("\u7269\u6599\u4e3a\u7a7a");
            }
        }
        logger.debug("\u65b0\u589e\u5546\u54c1\u6761\u6570" + addSkuList.size());
        try {
            if (!CollectionUtils.isEmpty(addSkuList)) {
                this.addSku(addSkuList);
            }
            if (!CollectionUtils.isEmpty(skuBOS)) {
                this.updateSku(skuBOS);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1\u5931\u8d25");
            throw new BusinessException("9999", "\u521b\u5efa\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SkuCreateByProvGoodsServiceImpl.this.createInsureGoods(reqBO.getShops(), (List)atomSkuList.get(), reqBO.getProvinceCode());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.debug("\u4fdd\u969c\u670d\u52a1\u521b\u5efa\u5b8c\u6210");
            }
        }).start();
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public void createInsureGoods(List<ShopIdAndShopNameBO> shops, List<Sku> skuList, String proviceCode) throws Exception {
        ProvGoodsInsureServicePO record = new ProvGoodsInsureServicePO();
        record.setProvinceCode(proviceCode);
        record.setSecurityServicesStatus("01");
        List<ProvGoodsInsureServicePO> poList = this.provGoodsInsureServiceDAO.selectSelectiveAll(record);
        ArrayList<Long> provGoodsId = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(poList)) {
            return;
        }
        for (ProvGoodsInsureServicePO in : poList) {
            provGoodsId.add(in.getProvGoodsId());
        }
        List<ProvGoodsSupRelationPO> supplier = this.provGoodsSupRelationDAO.selectByProvGoodsIds(provGoodsId);
        HashMap<Long, ProvGoodsSupRelationPO> supplierMap = new HashMap<Long, ProvGoodsSupRelationPO>();
        for (ProvGoodsSupRelationPO provGoodsSupRelationPO : supplier) {
            supplierMap.put(provGoodsSupRelationPO.getProvGoodsId(), provGoodsSupRelationPO);
        }
        ArrayList<Long> shopIds = new ArrayList<Long>();
        for (ShopIdAndShopNameBO shopIdAndShopNameBO : shops) {
            shopIds.add(shopIdAndShopNameBO.getShopId());
        }
        logger.debug("\u67e5\u8be2\u5546\u54c1\u662f\u5426\u5b58\u5728");
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (!CollectionUtils.isEmpty(shopIds)) {
            skuList = this.xlsSkuMapper.queryXlsSkuByShopList(shopIds);
            logger.debug("\u5df2\u5b58\u5728\u5546\u54c1" + skuList.size());
            if (!CollectionUtils.isEmpty(skuList)) {
                for (Sku good : skuList) {
                    if (hashMap.containsKey(good.getSupplierId() + good.getMaterialId())) continue;
                    hashMap.put(good.getSupplierId() + good.getMaterialId(), good.getSkuId());
                }
            }
        }
        ArrayList<CreateSkuReqBO> arrayList = new ArrayList<CreateSkuReqBO>();
        for (ProvGoodsInsureServicePO po : poList) {
            for (ShopIdAndShopNameBO shop : shops) {
                if (hashMap.containsKey(shop.getShopId() + po.getMaterialId())) continue;
                CreateSkuReqBO sku = new CreateSkuReqBO();
                Long skuId = Sequence.getInstance().nextId();
                if ("01".equals(po.getSecurityServicesStatus())) {
                    sku.setIsDelete("0");
                } else {
                    sku.setIsDelete("1");
                }
                sku.setSkuId(skuId);
                sku.setModel(po.getGoodsLongName());
                sku.setGoodsSource("00");
                sku.setCgType("0");
                sku.setSaleSrice(po.getRealityPrice());
                sku.setAssessmentPrice(po.getLimitPrice());
                sku.setSparePrice1(po.getPurchasePrice());
                sku.setAgreementPrice(po.getSalePrice());
                sku.setCountyCode(shop.getCountyCode());
                sku.setFullName(po.getGoodsLongName());
                sku.setSupplierId(shop.getShopId());
                sku.setSupplierName(shop.getShopName());
                sku.setProvinceCode(proviceCode);
                sku.setCityCode(shop.getCityCode());
                sku.setName(po.getGoodsLongName());
                sku.setIsVirtualGood("05".equals(po.getSecurityServicesType()) ? "0" : "1");
                sku.setMaterialId(po.getMaterialId());
                sku.setProvGoodsId(po.getProvGoodsId());
                sku.setVendorId(((ProvGoodsSupRelationPO)supplierMap.get(po.getProvGoodsId())).getSupplierId().toString());
                sku.setVendorName(((ProvGoodsSupRelationPO)supplierMap.get(po.getProvGoodsId())).getSupplierName());
                arrayList.add(sku);
            }
        }
        if (!CollectionUtils.isEmpty(arrayList)) {
            this.addSku(arrayList);
            logger.debug("\u521b\u5efasku\u5b8c\u6210");
        }
    }

    public void updateSku(List<SkuBO> skuBOS) throws Exception {
        logger.debug("\u5546\u54c1\u66f4\u65b0\u6570\u91cf" + skuBOS.size());
        int pointsDataLimit = 1000;
        Integer size = skuBOS.size();
        if (pointsDataLimit < size) {
            int part = size / pointsDataLimit;
            logger.debug("\u65b0\u589e\u5546\u54c1\u5171\u66f4\u65b0" + size + "\u6761\u6570\u636e\u3002\u5206" + part + "\u6761\u6267\u884c");
            for (int i = 0; i < part; ++i) {
                logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
                List<SkuBO> rows = skuBOS.subList(0, pointsDataLimit);
                this.xlsSkuManageService.batchUpdate(rows);
                skuBOS.subList(0, pointsDataLimit).clear();
            }
            if (!CollectionUtils.isEmpty(skuBOS)) {
                logger.debug("\u66f4\u65b0\u5269\u4e0b\u6570\u636e\uff0c\u5171" + skuBOS.size());
                this.xlsSkuManageService.batchUpdate(skuBOS);
            }
        } else {
            this.xlsSkuManageService.batchUpdate(skuBOS);
        }
    }

    public void addSku(List<CreateSkuReqBO> add) throws Exception {
        int pointsDataLimit = 2000;
        Integer size = add.size();
        int part = size / pointsDataLimit;
        int len = size % pointsDataLimit == 0 ? part : part + 1;
        logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + len + "\u6761\u6267\u884c");
        ExecutorService service = Executors.newFixedThreadPool(9);
        for (int i = 0; i < len; ++i) {
            logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
            int start = i * pointsDataLimit;
            int end = start + pointsDataLimit;
            if (end > size) {
                end = size;
            }
            logger.debug("\u5f00\u59cb\u7ed3\u675f=" + start + "+" + end);
            List<CreateSkuReqBO> rows = add.subList(start, end);
            service.execute(() -> {
                BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
                batchCreateSkuReqBO.setCreateSkuReqBOs(rows);
                this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
            });
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        service.shutdown();
    }

    public CreateSkuReqBO toAddBO(ProvGoodsAndSupplierPO po, Long shopId, String cityCode, String shopName, String countyCode, Map<String, DPriceSheetBO> priceSheet) {
        String key = po.getMaterialId() + po.getProvinceCode() + cityCode;
        DPriceSheetBO price = new DPriceSheetBO();
        if (!CollectionUtils.isEmpty(priceSheet)) {
            price = priceSheet.get(key.trim()) == null ? priceSheet.get(po.getMaterialId() + po.getProvinceCode()) : priceSheet.get(key.trim());
        }
        CreateSkuReqBO sku = new CreateSkuReqBO();
        sku.setBrandId(po.getBrandId());
        sku.setBrandName(po.getBrandName());
        sku.setColor(po.getColorName());
        sku.setModel(po.getGoodsModel());
        sku.setBrand(po.getBrandName());
        sku.setGoodsSource(po.getGoodsSource());
        sku.setCgType(po.getCgType());
        if (price != null) {
            sku.setSaleSrice(price.getSalePrice());
            sku.setSheetId(price.getSheetId());
            sku.setSheetLevel(price.getSheetLevel());
            sku.setAssessmentPrice(price.getAssessmentPrice());
            sku.setSparePrice1("1".equals(price.getSheetLevel()) ? null : price.getPurchasePrice());
            sku.setPurchasePrice("1".equals(price.getSheetLevel()) ? price.getPurchasePrice() : null);
            sku.setAgreementPrice(price.getAgreementPrice());
            sku.setMemberPrice(price.getMemberPrice());
        }
        sku.setCountyCode(countyCode);
        sku.setExtSkuId(po.getExtGoodsNo());
        sku.setSkuCode(po.getGoodsNo());
        sku.setRam(po.getMemoryName());
        sku.setMeasureId(po.getMeasureId());
        sku.setMeasureName(po.getMeasureName());
        sku.setFullName(po.getGoodsLongName());
        sku.setSupplierId(shopId);
        sku.setSupplierName(shopName);
        sku.setProvinceCode(po.getProvinceCode());
        sku.setCityCode(cityCode);
        sku.setName(po.getGoodsModel());
        sku.setIsVirtualGood(po.getAllowNegativeStock());
        sku.setMaterialId(po.getMaterialId());
        sku.setProvGoodsId(po.getProvGoodsId());
        sku.setVendorId(po.getSupplierIds());
        sku.setVendorName(po.getSupplierName());
        return sku;
    }

    public SkuBO toUpdateBO(ProvGoodsAndSupplierPO po, Long shopId, String cityCode, Long skuId, String countyCode) {
        SkuBO skuBO = new SkuBO();
        skuBO.setBrandId(po.getBrandId());
        skuBO.setBrandName(po.getBrandName());
        skuBO.setColor(po.getColorName());
        skuBO.setBrand(po.getBrandName());
        skuBO.setGoodsSource(po.getGoodsSource());
        skuBO.setModel(po.getGoodsModel());
        skuBO.setVendorId(po.getSupplierIds());
        skuBO.setVendorName(po.getSupplierName());
        skuBO.setSkuId(skuId);
        skuBO.setRam(po.getMemoryName());
        skuBO.setProvinceCode(po.getProvinceCode());
        skuBO.setCgType(po.getCgType());
        skuBO.setCityCode(cityCode);
        skuBO.setCountyCode(countyCode);
        skuBO.setExtSkuId(po.getExtGoodsNo());
        skuBO.setSkuCode(po.getGoodsNo());
        skuBO.setSkuName(po.getGoodsLongName());
        skuBO.setSkuLongName(po.getGoodsLongName());
        skuBO.setErpLongName(po.getGoodsLongName());
        skuBO.setSkuPriceTagName(po.getGoodsLongName());
        skuBO.setMfgSku(po.getGoodsModel());
        skuBO.setIsVirtualGood(po.getAllowNegativeStock());
        skuBO.setProvGoodsId(po.getProvGoodsId());
        skuBO.setSupplierId(shopId);
        skuBO.setIsDelete(Integer.valueOf(0));
        return skuBO;
    }

    public BaseRspBO createSkuStock(SkuCreateByProvGoodsReqBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        logger.debug("\u521b\u5efa\u4fdd\u9669\u5546\u54c1\u5e93\u5b58\u63a5\u53e3");
        if (StringUtils.isBlank((String)reqBO.getProvinceCode()) && StringUtils.isBlank((String)reqBO.getMaterialId()) && CollectionUtils.isEmpty((Collection)reqBO.getMaterialIds())) {
            result.setRespCode("8888");
            result.setRespDesc("\u7269\u6599\u548c\u7701\u4efd\u4e0d\u53ef\u540c\u65f6\u4e3a\u7a7a");
            return result;
        }
        ArrayList<Long> provGoodsIds = new ArrayList();
        try {
            provGoodsIds = this.getInsureProvGoodsId(reqBO);
        }
        catch (Exception e) {
            throw new BusinessException("9999", "\u67e5\u8be2\u7701\u4efd\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        logger.debug("\u83b7\u53d6sku\u4fe1\u606f\u548c\u8981\u540c\u6b65\u7684\u95e8\u5e97");
        Map<Object, Object> skuMap = new HashMap();
        try {
            if (!CollectionUtils.isEmpty(provGoodsIds)) {
                skuMap = this.getSku(provGoodsIds);
            }
        }
        catch (Exception e) {
            throw new BusinessException("9999", "\u83b7\u53d6sku\u5546\u54c1\u5931\u8d25" + e.getMessage());
        }
        if (!CollectionUtils.isEmpty(skuMap)) {
            for (Map.Entry<Object, Object> map : skuMap.entrySet()) {
                try {
                    if (CollectionUtils.isEmpty((Collection)((Collection)map.getValue()))) continue;
                    this.createStock((List)map.getValue());
                }
                catch (Exception e) {
                    logger.debug(e.getMessage());
                    logger.debug((String)map.getKey() + "\u5e93\u5b58\u540c\u6b65\u5931\u8d25");
                }
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public void createStock(List<Sku> skus) throws Exception {
        logger.debug("\u521b\u5efa\u5e93\u5b58");
        JSONObject smcCreateSkuStockAbilityReqBO = new JSONObject();
        smcCreateSkuStockAbilityReqBO.put("mName", (Object)"\u7edf\u4e00\u63a5\u53e3");
        JSONObject smcProvGoodsInfoBO = new JSONObject();
        smcProvGoodsInfoBO.put("materialCode", (Object)skus.get(0).getMaterialId());
        smcProvGoodsInfoBO.put("provId", (Object)skus.get(0).getProvinceCode());
        smcProvGoodsInfoBO.put("imsiFlag", (Object)"0");
        smcProvGoodsInfoBO.put("negativeFlag", (Object)"1");
        smcProvGoodsInfoBO.put("state", (Object)"1");
        smcProvGoodsInfoBO.put("goodsName", (Object)skus.get(0).getSkuLongName());
        smcProvGoodsInfoBO.put("reserve1", (Object)skus.get(0).getVendorId());
        smcProvGoodsInfoBO.put("reserve2", (Object)skus.get(0).getVendorName());
        JSONArray skuShopList = new JSONArray();
        JSONObject stock = null;
        for (Sku sku : skus) {
            stock = new JSONObject();
            stock.put("skuId", (Object)sku.getSkuId().toString());
            stock.put("shopId", (Object)sku.getSupplierId().toString());
            skuShopList.add((Object)stock);
        }
        smcCreateSkuStockAbilityReqBO.put("smcProvGoodsInfoBO", (Object)smcProvGoodsInfoBO);
        smcCreateSkuStockAbilityReqBO.put("skuShopList", (Object)skuShopList);
        logger.debug(smcCreateSkuStockAbilityReqBO.toJSONString());
        logger.debug("\u521b\u5efa\u5e93\u5b58\u6570\u91cf" + skuShopList.size());
        InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcCreateSkuStockAbilityService", "createSkuStock", "com.tydic.smc.api.ability.bo.SmcCreateSkuStockAbilityReqBO");
        invokeInfo.setRegisterType("2");
        invokeInfo.setVersion(this.hsfVersion);
        invokeInfo.setGroup(this.hsfGroup);
        invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
        JSONObject resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)smcCreateSkuStockAbilityReqBO), null, (InvokeInfo)invokeInfo);
        logger.debug("\u521b\u5efa\u5e93\u5b58\u7ed3\u679c\u8fd4\u56de" + JSONObject.toJSONString((Object)resultData));
    }

    public Map<String, List<Sku>> getSku(List<Long> provGoodsIds) throws Exception {
        HashMap<String, List<Sku>> skuMap = new HashMap<String, List<Sku>>();
        List<Sku> skus = this.xlsSkuMapper.selectSkuByProvGoods(provGoodsIds);
        if (!CollectionUtils.isEmpty(skus)) {
            for (Sku sku : skus) {
                if (skuMap.containsKey(sku.getProvinceCode() + sku.getMaterialId())) {
                    ((List)skuMap.get(sku.getProvinceCode() + sku.getMaterialId())).add(sku);
                    continue;
                }
                ArrayList<Sku> list = new ArrayList<Sku>();
                list.add(sku);
                skuMap.put(sku.getProvinceCode() + sku.getMaterialId(), list);
            }
        }
        return skuMap;
    }

    public List<Long> getInsureProvGoodsId(SkuCreateByProvGoodsReqBO reqBO) throws Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        ProvGoodsAndSupplierPO record = new ProvGoodsAndSupplierPO();
        record.setProvinceCode(reqBO.getProvinceCode());
        record.setMaterialId(reqBO.getMaterialId());
        record.setMaterialIds(reqBO.getMaterialIds());
        List<ProvGoodsAndSupplierPO> insure = this.provGoodsDAO.queryInsureToCreateStock(record);
        if (!CollectionUtils.isEmpty(insure)) {
            for (ProvGoodsAndSupplierPO prov : insure) {
                list.add(prov.getProvGoodsId());
            }
        }
        return list;
    }
}

