/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.ohaotian.commodity.atom.sku.UpdateSkuAtomService;
import com.ohaotian.commodity.atom.sku.bo.SkuBO;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.atom.spec.bo.SpecBO;
import com.ohaotian.commodity.dao.SkuSpecMapper;
import com.ohaotian.commodity.dao.po.SkuSpec;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.atom.sku.DDimensionNameManageService;
import com.xls.commodity.atom.sku.RDimensionRecordManageService;
import com.xls.commodity.atom.sku.XlsCommodityManageService;
import com.xls.commodity.busi.sku.CommodityExtSkuIdService;
import com.xls.commodity.busi.sku.SortCommodityPriceService;
import com.xls.commodity.busi.sku.XlsCommodityExtSkuManageService;
import com.xls.commodity.busi.sku.XlsElectronicPricePushBusiService;
import com.xls.commodity.busi.sku.bo.BindXlsCommodityExtSkuBO;
import com.xls.commodity.busi.sku.bo.CommodityExtSkuIdBO;
import com.xls.commodity.busi.sku.bo.CommodityExtSkuIdResBO;
import com.xls.commodity.busi.sku.bo.DDimensionNameBO;
import com.xls.commodity.busi.sku.bo.JsonToStringBO;
import com.xls.commodity.busi.sku.bo.JsonToStringSuperBO;
import com.xls.commodity.busi.sku.bo.RDimensionRecordBO;
import com.xls.commodity.busi.sku.bo.RcommodityPropDefAndValueBO;
import com.xls.commodity.busi.sku.bo.UntyingXlsCommodityExtSkuBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityBO;
import com.xls.commodity.dao.CommodityExtSkuIdDAO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.CommodityExtSkuIdPO;
import com.xls.commodity.dao.po.Sku;
import com.xls.commodity.intfce.sku.InitSkuFodderRelationService;
import com.xls.commodity.intfce.sku.InitSkuFodderSpecService;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.intfce.sku.bo.InitSkuFodderRelationReqBO;
import com.xls.commodity.intfce.sku.bo.RelieveSkuFodderRelationReqBO;
import com.xls.commodity.intfce.sku.bo.SelectBycommodityPropDefIdAndpropValueListIdBO;
import com.xls.commodity.intfce.sku.bo.SkuFodderSpecBO;
import com.xls.commodity.thread.PushElectronicPriceTagThread;
import com.xls.commodity.util.CreateThreadUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class XlsCommodityExtSkuManageServiceImpl
implements XlsCommodityExtSkuManageService {
    private static final Logger logger = LoggerFactory.getLogger(XlsCommodityExtSkuManageServiceImpl.class);
    @Autowired
    private CommodityExtSkuIdService commodityExtSkuIdService;
    @Autowired
    private RDimensionRecordManageService rDimensionRecordManageService;
    @Autowired
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private InitSkuFodderSpecService initSkuFodderSpecService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private SkuSpecMapper skuSpecMapper;
    @Autowired
    private InitSkuFodderRelationService initSkuFodderRelationService;
    @Autowired
    private DDimensionNameManageService dDimensionNameManageService;
    @Autowired
    private XlsCommodityManageService xlsCommodityManageService;
    @Autowired
    private UpdateSkuAtomService updateSkuAtomService;
    @Autowired
    private SortCommodityPriceService sortCommodityPriceService;
    @Autowired
    private CommodityExtSkuIdDAO commodityExtSkuIdDAO;

    public BaseRspBO bindXlsCommodityExtSku(BindXlsCommodityExtSkuBO reqBO) {
        String materialId = reqBO.getMaterialId();
        logger.debug("\u7ed1\u5b9a\u5546\u54c1\u4e0e\u5355\u54c1\u670d\u52a1\u5165\u53c2=" + reqBO.toString());
        List rcommodityPropDefAndValueBOs = reqBO.getRcommodityPropDefAndValueBOs();
        ArrayList<Long> listOrder = new ArrayList<Long>();
        ArrayList<Long> propValueListIds = new ArrayList<Long>();
        String propValueStr = "";
        BaseRspBO baseRspBO = new BaseRspBO();
        if (reqBO.getMaterialId() == "" || "".equals(reqBO.getMaterialId())) {
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return baseRspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSupplierIds())) {
            baseRspBO.setRespCode("8888");
            baseRspBO.setRespDesc("\u9002\u7528\u95e8\u5e97\u4e0d\u80fd\u4e3a\u7a7a");
            return baseRspBO;
        }
        final ArrayList<SpecBO> specBOList = new ArrayList<SpecBO>();
        ArrayList<SelectBycommodityPropDefIdAndpropValueListIdBO> selectBycommodityPropDefIdAndpropValueListIdBOs = new ArrayList<SelectBycommodityPropDefIdAndpropValueListIdBO>();
        List<Sku> skuList = null;
        HashMap<Long, String> shopNameMap = new HashMap<Long, String>();
        try {
            logger.debug("\u9002\u7528\u95e8\u5e97" + reqBO.getSupplierIds());
            skuList = this.xlsSkuMapper.queryXlsSkuByMaterialAndShopList(reqBO.getSupplierIds(), reqBO.getMaterialId());
            if (CollectionUtils.isEmpty(skuList)) {
                baseRspBO.setRespCode("8888");
                baseRspBO.setRespDesc("\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e3a\u7a7a");
                return baseRspBO;
            }
            for (Sku sku : skuList) {
                if (!StringUtils.isEmpty(shopNameMap.get(sku.getSupplierId()))) continue;
                shopNameMap.put(sku.getSupplierId(), sku.getSupplierName());
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u7269\u6599+\u95e8\u5e97\u67e5\u8be2sku\u5217\u8868\u5931\u8d25");
            throw new BusinessException("9999", "\u6839\u636e\u7269\u6599+\u95e8\u5e97\u67e5\u8be2sku\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
        JsonToStringSuperBO jsonToStringSuperBO = new JsonToStringSuperBO();
        ArrayList<JsonToStringBO> JsonToStringBOList = new ArrayList<JsonToStringBO>();
        JsonToStringBO jsonToStringBO = null;
        if (CollectionUtils.isNotEmpty((Collection)rcommodityPropDefAndValueBOs)) {
            for (RcommodityPropDefAndValueBO rcommodityPropDefAndValueBO : rcommodityPropDefAndValueBOs) {
                jsonToStringBO = new JsonToStringBO();
                jsonToStringBO.setCommodityPropDefId(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                jsonToStringBO.setPropName(rcommodityPropDefAndValueBO.getPropName());
                jsonToStringBO.setPropValueListId(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
                jsonToStringBO.setPropValue(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValue());
                JsonToStringBOList.add(jsonToStringBO);
                listOrder.add(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                propValueStr = propValueStr + rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValue();
                SelectBycommodityPropDefIdAndpropValueListIdBO selectBycommodityPropDefIdAndpropValueListIdBO = new SelectBycommodityPropDefIdAndpropValueListIdBO();
                selectBycommodityPropDefIdAndpropValueListIdBO.setCommodityPropDefId(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                selectBycommodityPropDefIdAndpropValueListIdBO.setPropValueListId(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
                selectBycommodityPropDefIdAndpropValueListIdBOs.add(selectBycommodityPropDefIdAndpropValueListIdBO);
                propValueListIds.add(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
            }
            jsonToStringSuperBO.setJsonToStringBOList(JsonToStringBOList);
        }
        ArrayList<Sku> willBind = new ArrayList<Sku>();
        int num = rcommodityPropDefAndValueBOs.size();
        ArrayList bindSkuList = new ArrayList();
        logger.debug("\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb");
        Sku willBindSku = null;
        try {
            for (Sku spec : skuList) {
                boolean existResult = this.eterminingDimensions(spec, listOrder, propValueStr, reqBO);
                if (!existResult) {
                    willBindSku = new Sku();
                    willBindSku.setSkuId(spec.getSkuId());
                    willBindSku.setSupplierId(spec.getSupplierId());
                    willBind.add(willBindSku);
                    continue;
                }
                if (bindSkuList.contains(shopNameMap.get(spec.getSupplierId()))) continue;
                bindSkuList.add(shopNameMap.get(spec.getSupplierId()));
            }
            logger.debug("\u5c06\u8981\u7ed1\u5b9a\u7684sku\u5217\u8868" + ((Object)willBind).toString());
        }
        catch (BusinessException e) {
            logger.error("\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u51fa\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7ed1\u5b9a\u5173\u7cfb\u51fa\u9519" + e.getMessage());
        }
        if (CollectionUtils.isEmpty(willBind)) {
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc(((Object)bindSkuList).toString() + "\u95e8\u5e97\u4e0b\u5df2\u5b58\u5728\u8be5\u7ef4\u5ea6");
            return baseRspBO;
        }
        logger.debug("\u67e5\u8be2\u7d20\u6750");
        Long fodderId = null;
        try {
            fodderId = this.inquiryMaterial(selectBycommodityPropDefIdAndpropValueListIdBOs, num);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7d20\u6750\u51fa\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u7d20\u6750\u51fa\u9519" + e.getMessage());
        }
        logger.debug("\u6839\u636e\u5c5e\u6027ID\u548c\u5c5e\u6027\u503cID\u67e5\u8be2\u7d20\u6750\u89c4\u683c");
        Long dimensionId = null;
        try {
            dimensionId = this.queryDimensionGroup(propValueListIds, num);
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u901a\u8fc7\u7ef4\u5ea6\u503cID\u5217\u8868\u67e5\u8be2\u7ef4\u5ea6\u548c\u540d\u79f0\u5bf9\u5e94\u5173\u7cfb\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u901a\u8fc7\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0ID\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0");
        Sku skuDimension = null;
        try {
            if (dimensionId != null) {
                skuDimension = this.queryDimensionName(dimensionId);
            }
            if (!StringUtils.isEmpty((Object)skuDimension.getMaterialIdList())) {
                List<String> materials = Arrays.asList(skuDimension.getMaterialIdList().split(","));
                logger.debug("\u9002\u7528\u7269\u6599" + materials.toString());
                logger.debug("\u7ed1\u5b9a\u7684\u7269\u6599" + reqBO.getMaterialId());
                if (!materials.contains(reqBO.getMaterialId())) {
                    baseRspBO.setRespCode("8888");
                    baseRspBO.setRespDesc("\u8be5\u7269\u6599\u4e0d\u5728\u8be5\u7ef4\u5ea6\u8303\u56f4\u5185");
                    return baseRspBO;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0ID\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0\u62a5\u9519");
            throw new BusinessException("9999", "\u901a\u8fc7\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0ID\u67e5\u8be2\u7ef4\u5ea6\u7ec4\u5408\u540d\u79f0\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u67e5\u8be2\u72b6\u6001");
        List<Sku> skuStatue = null;
        try {
            skuStatue = this.xlsSkuMapper.selectBySkuIdListAndSupplierListAndstatus(willBind);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u670d\u52a1");
        XlsCommodityBO xlsCommodityBO = null;
        try {
            xlsCommodityBO = this.xlsCommodityManageService.selectXlsCommodityDetail(reqBO.getCommodityId());
            if (xlsCommodityBO == null) {
                baseRspBO.setRespCode("0000");
                baseRspBO.setRespDesc("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u7ed3\u679c\u4e3a\u7a7a");
                return baseRspBO;
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u5546\u54c1id" + xlsCommodityBO.getCommodityId());
        final List<SkuBO> upSkuParam = this.encapsulationIntoReferences(xlsCommodityBO, skuStatue, skuDimension);
        logger.debug("\u66f4\u65b0\u5355\u54c1\u4fe1\u606f");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.updateSkuAtomService.updateSku(upSkuParam);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5355\u6761\u4fee\u6539\u5355\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u5355\u6761\u4fee\u6539\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        final ArrayList<Long> delSkuList = new ArrayList<Long>();
        SpecBO specBO = null;
        for (Sku sku : willBind) {
            delSkuList.add(sku.getSkuId());
            for (RcommodityPropDefAndValueBO rcommodityPropDefAndValueBO : rcommodityPropDefAndValueBOs) {
                specBO = new SpecBO();
                specBO.setSupplierId(sku.getSupplierId());
                specBO.setSkuId(sku.getSkuId());
                specBO.setCommodityId(reqBO.getCommodityId());
                specBO.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
                specBO.setCommoditySpecId(rcommodityPropDefAndValueBO.getCommodityPropDefId());
                specBO.setPropName(rcommodityPropDefAndValueBO.getPropName());
                specBO.setPropShowName(rcommodityPropDefAndValueBO.getPropName());
                specBO.setPropValueListId(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValueListId());
                specBO.setPropValue(rcommodityPropDefAndValueBO.getRpropValueListBO().getPropValue());
                specBOList.add(specBO);
            }
        }
        logger.debug("\u5220\u9664\u5df2\u7ed1\u5b9a\u7684\u7ef4\u5ea6");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.initSkuSpecAtomService.delSkuSpec(delSkuList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5df2\u7ed1\u5b9a\u7684\u7ef4\u5ea6\u62a5\u9519");
            throw new BusinessException("9999", "\u5220\u9664\u5df2\u7ed1\u5b9a\u7684\u7ef4\u5ea6\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u521b\u5efa\u7ef4\u5ea6\u4e2a\u6570" + specBOList.size());
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.initSkuSpecAtomService.initSkuSpec(specBOList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5355\u54c1\u7ef4\u5ea6\u62a5\u9519");
            throw new BusinessException("9999", "\u521b\u5efa\u5355\u54c1\u7ef4\u5ea6\u62a5\u9519" + e.getMessage());
        }
        try {
            this.sortCommodityPriceService.sortCommodityPrice(reqBO.getCommodityId());
        }
        catch (Exception e) {
            logger.error("\u6392\u5e8f\u5546\u54c1\u4ef7\u683c\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u6392\u5e8f\u5546\u54c1\u4ef7\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        if (fodderId != null) {
            logger.debug("\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u7d20\u6750id" + fodderId);
            final ArrayList<InitSkuFodderRelationReqBO> initSkuFodderRelationReqBOList = new ArrayList<InitSkuFodderRelationReqBO>();
            InitSkuFodderRelationReqBO initSkuFodderRelationReqBO = null;
            final ArrayList<RelieveSkuFodderRelationReqBO> relieveList = new ArrayList<RelieveSkuFodderRelationReqBO>();
            RelieveSkuFodderRelationReqBO relieveSkuFodderRelationReqBO = null;
            for (Sku sku : willBind) {
                relieveSkuFodderRelationReqBO = new RelieveSkuFodderRelationReqBO();
                relieveSkuFodderRelationReqBO.setSkuId(sku.getSkuId());
                initSkuFodderRelationReqBO = new InitSkuFodderRelationReqBO();
                initSkuFodderRelationReqBO.setCreateTime(new Date());
                initSkuFodderRelationReqBO.setFodderId(fodderId);
                initSkuFodderRelationReqBO.setRelationStatus(Integer.valueOf(0));
                initSkuFodderRelationReqBO.setSkuId(sku.getSkuId());
                initSkuFodderRelationReqBO.setSupplierId(sku.getSupplierId());
                initSkuFodderRelationReqBO.setUpdateTime(new Date());
                initSkuFodderRelationReqBOList.add(initSkuFodderRelationReqBO);
                relieveList.add(relieveSkuFodderRelationReqBO);
            }
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        XlsCommodityExtSkuManageServiceImpl.this.initSkuFodderRelationService.relieveSkuFodderRelation(relieveList);
                    }
                }).start();
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u62a5\u9519");
                throw new BusinessException("9999", "\u5220\u9664\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u5173\u7cfb\u62a5\u9519" + e.getMessage());
            }
            try {
                logger.debug("\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u7d20\u6750\u5165\u53c2" + ((Object)initSkuFodderRelationReqBOList).toString());
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        XlsCommodityExtSkuManageServiceImpl.this.initSkuFodderRelationService.initSkuFodderRelation(initSkuFodderRelationReqBOList);
                    }
                }).start();
            }
            catch (Exception e) {
                logger.error("\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u62a5\u9519");
                throw new BusinessException("9999", "\u7ed1\u5b9a\u7d20\u6750\u548c\u5355\u54c1\u5173\u7cfb\u62a5\u9519" + e.getMessage());
            }
        }
        String commodityDimensionJson = JSONObject.fromObject((Object)jsonToStringSuperBO).toString();
        CommodityExtSkuIdBO commodityExtSkuIdBO = new CommodityExtSkuIdBO();
        logger.debug("\u7269\u6599" + materialId);
        commodityExtSkuIdBO.setMaterialId(materialId);
        commodityExtSkuIdBO.setProvinceCode(reqBO.getProvinceCode());
        CommodityExtSkuIdResBO commodityExtSkuIdResBO = this.commodityExtSkuIdService.getRelationByExtSkuId(commodityExtSkuIdBO);
        if (CollectionUtils.isEmpty((Collection)commodityExtSkuIdResBO.getRows())) {
            CommodityExtSkuIdBO addCommodityExtSkuIdBO = new CommodityExtSkuIdBO();
            addCommodityExtSkuIdBO.setProvinceCode(reqBO.getProvinceCode());
            addCommodityExtSkuIdBO.setMaterialId(reqBO.getMaterialId());
            Object suppilerIds = "";
            for (Long supplier : reqBO.getSupplierIds()) {
                suppilerIds = (String)suppilerIds + supplier + ",";
            }
            addCommodityExtSkuIdBO.setOpreateUserId(reqBO.getmUserId().toString());
            addCommodityExtSkuIdBO.setSuppilerIdList(((String)suppilerIds).substring(0, ((String)suppilerIds).length() - 1));
            addCommodityExtSkuIdBO.setIsValid('1');
            addCommodityExtSkuIdBO.setCommodityPropGrpId(reqBO.getCommodityPropGrpId());
            addCommodityExtSkuIdBO.setCommodityId(reqBO.getCommodityId());
            addCommodityExtSkuIdBO.setCommodityDimensionJson(commodityDimensionJson);
            addCommodityExtSkuIdBO.setCreateTime(new Date());
            addCommodityExtSkuIdBO.setExtSkuId(reqBO.getExtSkuId());
            addCommodityExtSkuIdBO.setUpdateTime(new Date());
            logger.debug("\u589e\u52a0\u5173\u8054\u5173\u7cfb" + addCommodityExtSkuIdBO);
            try {
                this.commodityExtSkuIdService.addRelation(addCommodityExtSkuIdBO);
            }
            catch (Exception exception) {
                logger.error("\u589e\u52a0\u5173\u8054\u5173\u7cfb\u5931\u8d25");
                throw new BusinessException("9999", "\u589e\u52a0\u5173\u8054\u5173\u7cfb\u5931\u8d25" + exception.getMessage());
            }
        }
        ArrayList<Long> skuIDs = new ArrayList<Long>();
        for (Sku sku : willBind) {
            skuIDs.add(sku.getSkuId());
        }
        PushElectronicPriceTagThread pushElectronicPriceTagThread = new PushElectronicPriceTagThread(this.xlsElectronicPricePushBusiService, null, null, skuIDs);
        ExecutorService executorService = CreateThreadUtils.createSimpleThreadPool(pushElectronicPriceTagThread, "pushElectronicPriceTagThread", 1, 1);
        executorService.execute(() -> logger.debug(Thread.currentThread().getName()));
        executorService.shutdown();
        baseRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(bindSkuList)) {
            baseRspBO.setRespDesc("\u6210\u529f");
        } else {
            baseRspBO.setRespDesc(((Object)bindSkuList).toString() + "\u95e8\u5e97\u4e0b\u5df2\u5b58\u5728\u8be5\u5546\u54c1\u7ef4\u5ea6");
        }
        return baseRspBO;
    }

    public BaseRspBO untyingXlsCommoditySku(UntyingXlsCommodityExtSkuBO reqBO) {
        BaseRspBO result = new BaseRspBO();
        if (reqBO.getMaterialId() == "" || "".equals(reqBO.getMaterialId())) {
            result.setRespCode("8888");
            result.setRespDesc("\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            return result;
        }
        final ArrayList<SkuBO> skuBOList = new ArrayList<SkuBO>();
        List<Sku> skuList = null;
        ArrayList<String> materialIds = new ArrayList<String>();
        materialIds.add(reqBO.getMaterialId());
        List<CommodityExtSkuIdPO> bind = this.commodityExtSkuIdDAO.selectByMaterials(materialIds, reqBO.getProvinceCode());
        String supplierStr = bind.get(0).getSuppilerIdList();
        List<String> supplier = Arrays.asList(supplierStr.split(","));
        ArrayList<Long> suppliers = new ArrayList<Long>();
        for (String su : supplier) {
            suppliers.add(Long.parseLong(su));
        }
        try {
            skuList = this.xlsSkuMapper.queryXlsSkuByMaterialAndShopList(suppliers, reqBO.getMaterialId());
            if (CollectionUtils.isEmpty(skuList)) {
                result.setRespCode("8888");
                result.setRespDesc("\u67e5\u8be2\u5355\u54c1\u5217\u8868\u4e3a\u7a7a");
                return result;
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u95e8\u5e97ID\u548c\u7269\u6599ID\u67e5\u8be2sku\u5217\u8868\u5931\u8d25");
            throw new BusinessException("9999", "\u6839\u636e\u95e8\u5e97ID\u548c\u7269\u6599ID\u67e5\u8be2sku\u5217\u8868\u5931\u8d25" + e.getMessage());
        }
        List<Sku> skuStatue = null;
        try {
            skuStatue = this.xlsSkuMapper.selectBySkuIdListAndSupplierListAndstatus(skuList);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5355\u54c1\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u67e5\u8be2\u5355\u54c1\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        SkuBO skuBO = null;
        for (Sku staSku : skuStatue) {
            skuBO = new SkuBO();
            skuBO.setSkuId(staSku.getSkuId());
            skuBO.setSupplierId(staSku.getSupplierId());
            if (staSku.getSkuStatus() == 2) {
                skuBO.setSkuStatus(Integer.valueOf(1));
            } else if (staSku.getSkuStatus() == 5) {
                skuBO.setSkuStatus(Integer.valueOf(4));
            }
            skuBO.setSkuName(staSku.getErpLongName());
            skuBO.setSkuLongName(staSku.getErpLongName());
            skuBO.setSkuPriceTagName(staSku.getErpLongName());
            skuBOList.add(skuBO);
        }
        logger.debug("\u5982\u53c2" + ((Object)skuBOList).toString());
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.updateSkuAtomService.updateSkuNullCommodityId(skuBOList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5355\u6761\u4fee\u6539\u5355\u54c1\u7684commodityId\u4e3a\u7a7a\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u5355\u6761\u4fee\u6539\u5355\u54c1\u7684commodityId\u4e3a\u7a7a\u670d\u52a1" + e.getMessage());
        }
        logger.debug("\u6392\u5e8f\u5546\u54c1\u4ef7\u683c\u670d\u52a1");
        try {
            this.sortCommodityPriceService.sortCommodityPrice(reqBO.getCommodityId());
        }
        catch (Exception e) {
            logger.error("\u6392\u5e8f\u5546\u54c1\u4ef7\u683c\u670d\u52a1\u62a5\u9519");
            throw new BusinessException("9999", "\u6392\u5e8f\u5546\u54c1\u4ef7\u683c\u670d\u52a1\u62a5\u9519" + e.getMessage());
        }
        final ArrayList<SkuSpec> skuSpecList = new ArrayList<SkuSpec>();
        final ArrayList<RelieveSkuFodderRelationReqBO> relieveSkuFodderRelationReqBOList = new ArrayList<RelieveSkuFodderRelationReqBO>();
        ArrayList<Long> skuIDs = new ArrayList<Long>();
        RelieveSkuFodderRelationReqBO relieveSkuFodderRelationReqBO = null;
        SkuSpec record = null;
        for (Sku staSku : skuList) {
            relieveSkuFodderRelationReqBO = new RelieveSkuFodderRelationReqBO();
            record = new SkuSpec();
            relieveSkuFodderRelationReqBO.setSkuId(staSku.getSkuId());
            relieveSkuFodderRelationReqBO.setSupplierId(staSku.getSupplierId());
            record.setSupplierId(staSku.getSupplierId());
            record.setSkuId(staSku.getSkuId());
            skuIDs.add(staSku.getSkuId());
            skuSpecList.add(record);
            relieveSkuFodderRelationReqBOList.add(relieveSkuFodderRelationReqBO);
        }
        logger.debug("\u5220\u9664\u5546\u54c1\u7684\u7d20\u6750\u89c4\u683c");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.skuSpecMapper.deleteByManyList(skuSpecList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u5546\u54c1\u7684\u7d20\u6750\u89c4\u683c\u62a5\u9519");
            throw new BusinessException("9999", "\u5220\u9664\u5546\u54c1\u7684\u7d20\u6750\u89c4\u683c\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u89e3\u9664\u5546\u54c1\u4e0e\u7d20\u6750\u7684\u5173\u7cfb");
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    XlsCommodityExtSkuManageServiceImpl.this.initSkuFodderRelationService.relieveSkuFodderRelation(relieveSkuFodderRelationReqBOList);
                }
            }).start();
        }
        catch (Exception e) {
            logger.error("\u89e3\u9664\u5355\u54c1\u4e0e\u7d20\u6750\u7684\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u89e3\u9664\u5355\u54c1\u4e0e\u7d20\u6750\u7684\u5173\u7cfb\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u89e3\u9664\u5546\u54c1\u4e0e\u52a9\u8bb0\u7801\u5173\u8054\u5173\u7cfb");
        CommodityExtSkuIdBO commodityExtSkuIdBO = new CommodityExtSkuIdBO();
        commodityExtSkuIdBO.setExtSkuId(reqBO.getExtSkuId());
        commodityExtSkuIdBO.setIsValid('0');
        commodityExtSkuIdBO.setOpreateUserId(reqBO.getmUserId().toString());
        commodityExtSkuIdBO.setProvinceCode(reqBO.getProvinceCode());
        commodityExtSkuIdBO.setMaterialId(reqBO.getMaterialId());
        commodityExtSkuIdBO.setUpdateTime(new Date());
        try {
            this.commodityExtSkuIdService.updateStatus(commodityExtSkuIdBO);
        }
        catch (Exception e) {
            logger.error("\u89e3\u9664\u5546\u54c1\u4e0e\u52a9\u8bb0\u7801\u5173\u8054\u5173\u7cfb\u62a5\u9519");
            throw new BusinessException("9999", "\u89e3\u9664\u5546\u54c1\u4e0e\u52a9\u8bb0\u7801\u5173\u8054\u5173\u7cfb\u62a5\u9519" + e.getMessage());
        }
        logger.debug("\u540c\u6b65\u7535\u5b50\u4ef7\u7b7e");
        PushElectronicPriceTagThread pushElectronicPriceTagThread = new PushElectronicPriceTagThread(this.xlsElectronicPricePushBusiService, null, null, skuIDs);
        ExecutorService singleThreadPool = CreateThreadUtils.createSimpleThreadPool(pushElectronicPriceTagThread, "pushElectronicPriceTagThread", 1, 1);
        singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
        singleThreadPool.shutdown();
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }

    public List<SkuBO> encapsulationIntoReferences(XlsCommodityBO xlsCommodityBO, List<Sku> skuStatue, Sku skuDimension) {
        ArrayList<SkuBO> skuList = new ArrayList<SkuBO>();
        SkuBO skuParam = null;
        for (Sku skuSta : skuStatue) {
            skuParam = new SkuBO();
            if (skuDimension != null) {
                skuParam.setSkuName(skuDimension.getSkuName());
                skuParam.setSkuPriceTagName(skuDimension.getSkuPriceTagName());
                skuParam.setSkuLongName(skuDimension.getSkuLongName());
            }
            skuParam.setSkuId(skuSta.getSkuId());
            skuParam.setSupplierId(skuSta.getSupplierId());
            skuParam.setCommodityId(xlsCommodityBO.getCommodityId());
            skuParam.setSkuMainPicUrl(xlsCommodityBO.getCommodityMainPic());
            skuParam.setCommodityTypeId(xlsCommodityBO.getCommodityTypeId());
            skuParam.setUpdateTime(new Date());
            skuParam.setPackParam("{\"sellList\":[{\"label\": \"\u5305\u88c5\u6e05\u5355\",\"value\": \"\u4fdd\u4fee\u5361\u3001\u8bf4\u660e\u4e66\u3002\"},{\"label\": \"\u6743\u5229\u58f0\u660e\",\"value\": \"\u548c\u52a8\u529b\u4f18\u54c1\u9986\u7684\u6240\u6709\u5546\u54c1\u4fe1\u606f\u3001\u5ba2\u6237\u8bc4\u4ef7\u3001\u5546\u54c1\u54a8\u8be2\u3001\u7f51\u53cb\u8ba8\u8bba\u7b49\u5185\u5bb9\uff0c\u662f\u548c\u52a8\u529b\u4f18\u54c1\u9986\u91cd\u8981\u7684\u7ecf\u8425\u8d44\u6e90\uff0c\u672a\u7ecf\u8bb8\u53ef\uff0c\u7981\u6b62\u975e\u6cd5\u8f6c\u8f7d\u4f7f\u7528\u3002\"}]}");
            if (skuSta.getSkuStatus() == 1) {
                skuParam.setSkuStatus(Integer.valueOf(2));
                skuParam.setOnShelveTime(new Date());
            } else if (skuSta.getSkuStatus() == 4) {
                skuParam.setSkuStatus(Integer.valueOf(5));
            }
            skuList.add(skuParam);
        }
        return skuList;
    }

    public Sku queryDimensionName(Long dimensionId) throws BusinessException {
        Sku sku = new Sku();
        DDimensionNameBO dDimensionNameBO = this.dDimensionNameManageService.selectByDimensionId(dimensionId);
        sku.setSkuName(dDimensionNameBO.getDimensionName());
        sku.setSkuPriceTagName(dDimensionNameBO.getDimensionName());
        sku.setSkuLongName(dDimensionNameBO.getDimensionLongName());
        sku.setMaterialIdList(dDimensionNameBO.getMaterialIdList());
        return sku;
    }

    public Long queryDimensionGroup(List<Long> propValueListIds, int num) throws BusinessException {
        logger.info("\u9009\u62e9\u7684\u7ef4\u5ea6\u503c\u7684ID\u5217\u8868\u4e3a=" + propValueListIds.toString());
        List rDimensionRecordBOs = null;
        Long dimensionId = null;
        rDimensionRecordBOs = this.rDimensionRecordManageService.selectByPropValueListIds(propValueListIds);
        logger.debug("\u7ef4\u5ea6\u7ec4\u5408\u67e5\u8be2\u7ed3\u679c" + rDimensionRecordBOs.toString());
        HashMap<Long, Integer> mapDimensionId = new HashMap<Long, Integer>();
        if (CollectionUtils.isNotEmpty((Collection)rDimensionRecordBOs)) {
            for (RDimensionRecordBO rDimensionRecordBO : rDimensionRecordBOs) {
                if (mapDimensionId.containsKey(rDimensionRecordBO.getDimensionId())) {
                    mapDimensionId.put(rDimensionRecordBO.getDimensionId(), (Integer)mapDimensionId.get(rDimensionRecordBO.getDimensionId()) + 1);
                    continue;
                }
                mapDimensionId.put(rDimensionRecordBO.getDimensionId(), 1);
            }
        }
        logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u7ef4\u5ea6\u7ec4\u5408\u7684\u540d\u79f0\u53ca\u7ef4\u5ea6\u503cID=" + ((Object)mapDimensionId).toString());
        if (mapDimensionId.isEmpty()) {
            return null;
        }
        for (Map.Entry entry : mapDimensionId.entrySet()) {
            if ((Integer)entry.getValue() < num) continue;
            dimensionId = (Long)entry.getKey();
        }
        return dimensionId;
    }

    public Long inquiryMaterial(List<SelectBycommodityPropDefIdAndpropValueListIdBO> selectBycommodityPropDefIdAndpropValueListIdBOs, int num) throws BusinessException {
        List skuFodderSpecBOs = null;
        skuFodderSpecBOs = this.initSkuFodderSpecService.selectBycommodityPropDefIdAndpropValueListId(selectBycommodityPropDefIdAndpropValueListIdBOs);
        Long fodderId = null;
        if (CollectionUtils.isNotEmpty((Collection)skuFodderSpecBOs)) {
            HashMap<Long, Integer> mapFodderId = new HashMap<Long, Integer>();
            for (SkuFodderSpecBO skuFodderSpecBO : skuFodderSpecBOs) {
                if (mapFodderId.containsKey(skuFodderSpecBO.getFodderId())) {
                    mapFodderId.put(skuFodderSpecBO.getFodderId(), (Integer)mapFodderId.get(skuFodderSpecBO.getFodderId()) + 1);
                    continue;
                }
                mapFodderId.put(skuFodderSpecBO.getFodderId(), 1);
            }
            logger.info("\u67e5\u8be2\u51fa\u6765\u7684\u7d20\u6750ID\u53ca\u6570\u91cf=" + mapFodderId);
            for (Map.Entry entry : mapFodderId.entrySet()) {
                if ((Integer)entry.getValue() < num) continue;
                fodderId = (Long)entry.getKey();
            }
        }
        return fodderId;
    }

    public boolean eterminingDimensions(Sku reqBO, List<Long> listOrder, String propValueStr, BindXlsCommodityExtSkuBO bind) throws BusinessException {
        List skuSpecs = null;
        SkuSpec skuSpec = new SkuSpec();
        skuSpec.setCommodityId(bind.getCommodityId());
        skuSpec.setSupplierId(reqBO.getSupplierId());
        skuSpecs = this.skuSpecMapper.selectByCommodityIdAndSupplierId(skuSpec);
        boolean flag = false;
        if (CollectionUtils.isNotEmpty((Collection)skuSpecs)) {
            HashMap<Long, HashMap<Long, SkuSpec>> mapListSkuSpec = new HashMap<Long, HashMap<Long, SkuSpec>>();
            for (SkuSpec skuSpe : skuSpecs) {
                HashMap<Long, SkuSpec> mapSkuSpec = (HashMap<Long, SkuSpec>)mapListSkuSpec.get(skuSpe.getSkuId());
                if (mapSkuSpec == null) {
                    mapSkuSpec = new HashMap<Long, SkuSpec>();
                    mapSkuSpec.put(skuSpe.getCommoditySpecId(), skuSpe);
                    mapListSkuSpec.put(skuSpe.getSkuId(), mapSkuSpec);
                    continue;
                }
                mapSkuSpec.put(skuSpe.getCommoditySpecId(), skuSpe);
            }
            ArrayList<String> a = new ArrayList<String>();
            for (Map.Entry entry : mapListSkuSpec.entrySet()) {
                String aaa = "";
                for (Long commoditySpecId : listOrder) {
                    if (((Map)entry.getValue()).get(commoditySpecId) == null) continue;
                    aaa = aaa + ((SkuSpec)((Map)entry.getValue()).get(commoditySpecId)).getPropValue();
                }
                a.add(aaa);
            }
            logger.debug("\u5c06\u8981\u7ed1\u5b9a\u7684\u7ef4\u5ea6=" + propValueStr.toString());
            logger.debug("\u5df2\u5b58\u5728\u7ed1\u5b9a\u7684\u7ef4\u5ea6=" + ((Object)a).toString());
            for (String str1 : a) {
                if (!propValueStr.equals(str1)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

