/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.busi.sku.impl;

import com.cgd.commodity.constant.Constant;
import com.cgd.common.exception.BusinessException;
import com.ohaotian.commodity.busi.sku.bo.SkuAndPriceBO;
import com.ohaotian.commodity.dao.SkuMapper;
import com.ohaotian.commodity.dao.po.Sku;
import com.xls.commodity.busi.sku.XlsElectronicPricePushBusiService;
import com.xls.commodity.busi.sku.bo.DSkuBO;
import com.xls.commodity.busi.sku.bo.XlsQuerySkuAndPriceReqBO;
import com.xls.commodity.busi.sku.bo.XlsQuerySkuAndPriceRspBO;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import com.xls.commodity.thread.PushElectronicPriceTagThread;
import com.xls.commodity.util.CreateThreadUtils;
import com.xls.commodity.util.HttpUntil;
import com.xls.commodity.util.TkHttpRequestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class XlsElectronicPricePushBusiServiceImpl
implements XlsElectronicPricePushBusiService {
    private static final Logger logger = LoggerFactory.getLogger(XlsElectronicPricePushBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Value(value="${qrcode.prefix}")
    private String qrcodePrefix;
    @Value(value="${electronic.price.integration}")
    private String electronicPriceIntegration;
    @Autowired
    private SkuMapper skuMapper;
    @Autowired
    private XlsElectronicPricePushBusiService xlsElectronicPricePushBusiService;
    @Autowired
    private XlsSkuMapper xlsSkuMapper;

    public XlsQuerySkuAndPriceRspBO xlsElectronicPricePush(List<SkuAndPriceBO> skuList) {
        XlsQuerySkuAndPriceRspBO result = new XlsQuerySkuAndPriceRspBO();
        if (this.isDebugEnabled) {
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5bf9\u63a5\u6761\u6570\uff1a" + skuList.size());
        }
        if (!CollectionUtils.isNotEmpty(skuList)) {
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5165\u53c2\u4e3a\u7a7a");
            throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u5165\u53c2\u4e3a\u7a7a");
        }
        try {
            logger.debug("***********\u4e8c\u7ef4\u7801\u524d\u7f00" + this.qrcodePrefix + "********************");
            HashMap supplierMap = new HashMap();
            for (SkuAndPriceBO skuAndPriceBO : skuList) {
                skuAndPriceBO.setQrCode(this.qrcodePrefix + "supplierId=" + skuAndPriceBO.getSupplierId() + "&skuId=" + skuAndPriceBO.getSkuId() + "&deviceSource=" + Constant.ELEC_DEVICE_SOURCE);
                skuAndPriceBO.setPackParam("");
                skuAndPriceBO.setSkuDetail("");
                skuAndPriceBO.setUpdateTime(null);
                skuAndPriceBO.setCreateTime(null);
                skuAndPriceBO.setOnShelveTime(null);
                if (supplierMap.containsKey(skuAndPriceBO.getSupplierId())) {
                    ((List)supplierMap.get(skuAndPriceBO.getSupplierId())).add(skuAndPriceBO);
                    continue;
                }
                ArrayList<SkuAndPriceBO> list = new ArrayList<SkuAndPriceBO>();
                list.add(skuAndPriceBO);
                supplierMap.put(skuAndPriceBO.getSupplierId(), list);
            }
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5bf9\u63a5\u95e8\u5e97\uff1a" + supplierMap.size());
            for (Map.Entry entry : supplierMap.entrySet()) {
                List items = (List)entry.getValue();
                if (!CollectionUtils.isNotEmpty((Collection)items)) continue;
                int pointsDataLimit = 100;
                Integer size = items.size();
                if (pointsDataLimit < size) {
                    String rsp;
                    int part = size / pointsDataLimit;
                    logger.debug(entry.getKey() + "\u95e8\u5e97\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + part + "\u6279\u540c\u6b65");
                    for (int i = 0; i < part; ++i) {
                        List<SkuAndPriceBO> listPage = items.subList(0, pointsDataLimit);
                        String rsp2 = this.integration((Long)entry.getKey(), listPage);
                        if (null == rsp2 || !rsp2.contains("0000")) {
                            logger.error("\u95e8\u5e97" + entry.getKey() + "\u7b2c" + i + "\u6279\u540c\u6b65\u5931\u8d25");
                            logger.debug(com.alibaba.fastjson.JSONObject.toJSONString(listPage));
                        }
                        items.subList(0, pointsDataLimit).clear();
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)items) || null != (rsp = this.integration((Long)entry.getKey(), items)) && rsp.contains("0000")) continue;
                    logger.error("\u95e8\u5e97" + entry.getKey() + "\u6279\u540c\u6b65\u5931\u8d25");
                    logger.debug(com.alibaba.fastjson.JSONObject.toJSONString((Object)items));
                    continue;
                }
                String rsp = this.integration((Long)entry.getKey(), items);
                if (null != rsp && rsp.contains("0000")) continue;
                logger.error("\u95e8\u5e97" + entry.getKey() + "\u540c\u6b65\u5931\u8d25");
                logger.debug(com.alibaba.fastjson.JSONObject.toJSONString((Object)items));
            }
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519" + e);
            e.printStackTrace();
            throw new BusinessException("\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u51fa\u9519", (Throwable)e);
        }
        result.setCode("0000");
        result.setMessage("\u6210\u529f");
        return result;
    }

    public XlsQuerySkuAndPriceRspBO xlsPuhSku(XlsQuerySkuAndPriceReqBO reqBO) {
        XlsQuerySkuAndPriceRspBO result = new XlsQuerySkuAndPriceRspBO();
        logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u5165\u53c2\uff1a" + reqBO.toString());
        try {
            Sku reqSku = new Sku();
            reqSku.setSkuName(reqBO.getSkuName());
            reqSku.setSupplierId(reqBO.getSupplierId());
            List<Long> skuIds = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getSkuIds())) {
                skuIds = reqBO.getSkuIds();
            } else if (null != reqBO.getSkuId()) {
                skuIds.add(reqBO.getSkuId());
            }
            List<SkuAndPriceBO> skuAndPriceBOList = new ArrayList();
            try {
                skuAndPriceBOList = this.skuMapper.qrySkuAndPriceByRecord(reqSku, skuIds);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
                throw new BusinessException("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519", (Throwable)e);
            }
            if (null != skuAndPriceBOList && skuAndPriceBOList.size() > 0) {
                this.xlsElectronicPricePush(skuAndPriceBOList);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a" + e.getMessage());
            throw new BusinessException("\u6839\u636e\u6761\u4ef6\u540c\u6b65sku\u5230\u7535\u5b50\u4ef7\u7b7e\u51fa\u9519\uff1a", (Throwable)e);
        }
        result.setCode("0000");
        result.setMessage("\u6210\u529f");
        return result;
    }

    public String integration(Long supplierId, List<SkuAndPriceBO> goodList) {
        String comeBack = "";
        try {
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u5f00\u59cb");
            JSONObject param = new JSONObject();
            JSONArray array = JSONArray.fromObject(goodList);
            param.put((Object)"item", (Object)array);
            String postUrl = this.electronicPriceIntegration;
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3url:" + postUrl);
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3param:" + goodList.size());
            if (postUrl.startsWith("https")) {
                comeBack = TkHttpRequestUtils.conn(null, param.toString(), null, postUrl, null, null);
            } else {
                HttpUntil httpUntil = new HttpUntil();
                comeBack = httpUntil.httpPost(postUrl, param.toString());
            }
            logger.error("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u8fd4\u56de:" + comeBack);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u9519\u8bef", (Throwable)e);
        }
        return comeBack;
    }

    public BaseRspBO changeElectronicName(DSkuBO reqBO) {
        BaseRspBO result = null;
        if (reqBO.getSkuId() == null) {
            result = new BaseRspBO();
            result.setRespCode("8888");
            result.setRespDesc("\u8bf7\u8f93\u5165skuId");
            return result;
        }
        if (reqBO.getSupplierId() == null) {
            result = new BaseRspBO();
            result.setRespCode("8888");
            result.setRespDesc("\u8bf7\u8f93\u5165\u5e97\u94faID");
            return result;
        }
        if (StringUtils.isEmpty((Object)reqBO.getSkuPriceTagName())) {
            result = new BaseRspBO();
            result.setRespCode("8888");
            result.setRespDesc("\u8bf7\u8f93\u5165\u7535\u5b50\u4ef7\u7b7e");
            return result;
        }
        com.xls.commodity.dao.po.Sku sku = new com.xls.commodity.dao.po.Sku();
        sku.setSkuId(reqBO.getSkuId());
        sku.setSupplierId(reqBO.getSupplierId());
        sku.setSkuPriceTagName(reqBO.getSkuPriceTagName());
        try {
            this.xlsSkuMapper.changeElectronicName(sku);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u8c03\u7528\u7535\u5b50\u4ef7\u7b7e\u6570\u636e\u5bf9\u63a5\u63a5\u53e3\u9519\u8bef", (Throwable)e);
        }
        PushElectronicPriceTagThread pushElectronicPriceTagThread = new PushElectronicPriceTagThread(this.xlsElectronicPricePushBusiService, reqBO.getSkuId(), reqBO.getSupplierId(), null);
        ExecutorService singleThreadPool = CreateThreadUtils.createSimpleThreadPool(pushElectronicPriceTagThread, "pushElectronicPriceTagThread", 1, 1);
        singleThreadPool.execute(() -> logger.debug(Thread.currentThread().getName()));
        singleThreadPool.shutdown();
        result = new BaseRspBO();
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        return result;
    }
}

