/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.thread;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.newretail.toolkit.bo.InvokeInfo;
import com.tydic.newretail.toolkit.util.TKGenericServiceUtils;
import com.xls.commodity.busi.sku.BatchCreateSkuService;
import com.xls.commodity.busi.sku.bo.BatchCreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.CreateSkuReqBO;
import com.xls.commodity.busi.sku.bo.ProvGoodsInterestsBO;
import com.xls.commodity.busi.sku.bo.SupplierBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class InterestsSkuCreateThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(InterestsSkuCreateThread.class);
    private JSONArray orgTreeBOList;
    private ProvGoodsInterestsBO provGoodsInterestsBO;
    private BatchCreateSkuService batchCreateSkuService;
    private String hsfVersion;
    private String hsfGroup;
    private String hsfClientTimeout;

    public InterestsSkuCreateThread(JSONArray orgTreeBOList, ProvGoodsInterestsBO provGoodsInterestsBO, BatchCreateSkuService batchCreateSkuService, String hsfVersion, String hsfGroup, String hsfClientTimeout) {
        this.orgTreeBOList = orgTreeBOList;
        this.provGoodsInterestsBO = provGoodsInterestsBO;
        this.batchCreateSkuService = batchCreateSkuService;
        this.hsfVersion = hsfVersion;
        this.hsfGroup = hsfGroup;
        this.hsfClientTimeout = hsfClientTimeout;
    }

    @Override
    public void run() {
        String vendorName = "";
        String vendorId = "";
        for (SupplierBO su : this.provGoodsInterestsBO.getSupplierBO()) {
            vendorId = vendorId + su.getSupplierId() + ",";
            vendorName = vendorName + su.getSupplierName() + ",";
        }
        vendorId = vendorId.substring(0, vendorId.length() - 1);
        vendorName = vendorName.substring(0, vendorName.length() - 1);
        int pointsDataLimit = 1000;
        Integer size = this.orgTreeBOList.size();
        try {
            if (pointsDataLimit < size) {
                int part = size / pointsDataLimit;
                logger.debug("\u65b0\u589e\u5546\u54c1\u5171" + size + "\u6761\u6570\u636e\u3002\u5206" + part + "\u6761\u6267\u884c");
                for (int i = 0; i < part; ++i) {
                    logger.debug("\u7b2c" + i + "\u6279\u6570\u636e");
                    JSONArray rows = (JSONArray)this.orgTreeBOList.subList(0, pointsDataLimit);
                    this.createSku(this.provGoodsInterestsBO, rows, vendorName, vendorId);
                    this.orgTreeBOList.subList(0, pointsDataLimit).clear();
                }
                if (!CollectionUtils.isEmpty((Collection)this.orgTreeBOList)) {
                    logger.debug("\u5269\u4e0b\u6761\u6570" + this.orgTreeBOList.size());
                    this.createSku(this.provGoodsInterestsBO, this.orgTreeBOList, vendorName, vendorId);
                }
            } else {
                logger.debug("\u672a\u5206\u6279----------\u603b\u6761\u6570" + this.orgTreeBOList.size());
                this.createSku(this.provGoodsInterestsBO, this.orgTreeBOList, vendorName, vendorId);
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u5546\u54c1" + e);
        }
    }

    public void createSku(ProvGoodsInterestsBO provGoodsInterestsBO, JSONArray orgTreeBOList, String vendorName, String vendorId) throws Exception {
        ArrayList<CreateSkuReqBO> skuList = new ArrayList<CreateSkuReqBO>();
        JSONArray skuShopList = new JSONArray();
        for (int i = 0; i < orgTreeBOList.size(); ++i) {
            CreateSkuReqBO bo = new CreateSkuReqBO();
            JSONObject stock = new JSONObject();
            JSONObject item = orgTreeBOList.getJSONObject(i);
            if (!StringUtils.isNotEmpty((String)item.getString("storeId"))) continue;
            Long skuId = Sequence.getInstance().nextId();
            bo.setSkuId(skuId);
            stock.put("skuId", (Object)skuId);
            stock.put("shopId", (Object)item.getString("storeId"));
            skuShopList.add((Object)stock);
            bo.setAssessmentPrice(MoneyUtils.BigDecimal2Long((BigDecimal)provGoodsInterestsBO.getLimitPriceStr()));
            bo.setPurchasePrice(MoneyUtils.BigDecimal2Long((BigDecimal)provGoodsInterestsBO.getPurchasePriceStr()));
            bo.setSaleSrice(MoneyUtils.BigDecimal2Long((BigDecimal)provGoodsInterestsBO.getRealityPriceStr()));
            bo.setFullName(provGoodsInterestsBO.getGoodsName());
            bo.setProvinceCode(item.getString("provinceCode"));
            bo.setProvGoodsId(provGoodsInterestsBO.getProvGoodsId());
            bo.setCityCode(item.getString("cityCode"));
            bo.setCountyCode(item.getString("districtCode"));
            bo.setSupplierId(Long.valueOf(Long.parseLong(item.getString("storeId"))));
            bo.setSupplierName(item.getString("orgName"));
            bo.setMaterialId(provGoodsInterestsBO.getMaterialId());
            bo.setVendorName(StringUtils.isBlank((String)vendorName) ? null : vendorName.substring(0, vendorName.length() - 1));
            bo.setVendorId(StringUtils.isBlank((String)vendorId) ? null : vendorId.substring(0, vendorId.length() - 1));
            bo.setName(provGoodsInterestsBO.getGoodsName());
            skuList.add(bo);
        }
        if (!CollectionUtils.isEmpty(skuList)) {
            BatchCreateSkuReqBO batchCreateSkuReqBO = new BatchCreateSkuReqBO();
            batchCreateSkuReqBO.setCreateSkuReqBOs(skuList);
            logger.debug("\u521b\u5efasku" + JSONObject.toJSONString((Object)batchCreateSkuReqBO));
            this.batchCreateSkuService.batchCreateSku(batchCreateSkuReqBO);
        }
        logger.debug("\u521b\u5efa\u5e93\u5b58");
        JSONObject smcCreateSkuStockAbilityReqBO = new JSONObject();
        smcCreateSkuStockAbilityReqBO.put("mName", (Object)"\u7edf\u4e00\u521b\u5efa\u63a5\u53e3");
        JSONObject smcProvGoodsInfoBO = new JSONObject();
        smcProvGoodsInfoBO.put("materialCode", (Object)provGoodsInterestsBO.getMaterialId());
        smcProvGoodsInfoBO.put("provId", (Object)provGoodsInterestsBO.getmProvince());
        smcProvGoodsInfoBO.put("imsiFlag", (Object)"0");
        smcProvGoodsInfoBO.put("negativeFlag", (Object)"1");
        smcProvGoodsInfoBO.put("state", (Object)"1");
        smcProvGoodsInfoBO.put("goodsName", (Object)provGoodsInterestsBO.getGoodsName());
        smcProvGoodsInfoBO.put("reserve1", (Object)vendorId);
        smcProvGoodsInfoBO.put("reserve2", (Object)vendorName);
        if (!CollectionUtils.isEmpty((Collection)skuShopList)) {
            smcCreateSkuStockAbilityReqBO.put("smcProvGoodsInfoBO", (Object)smcProvGoodsInfoBO);
            smcCreateSkuStockAbilityReqBO.put("skuShopList", (Object)skuShopList);
            logger.debug("\u521b\u5efa\u5e93\u5b58\u6570\u91cf" + skuShopList.size());
            InvokeInfo invokeInfo = new InvokeInfo("com.tydic.smc.api.ability.SmcCreateSkuStockAbilityService", "createSkuStock", "com.tydic.smc.api.ability.bo.SmcCreateSkuStockAbilityReqBO");
            invokeInfo.setRegisterType("2");
            invokeInfo.setVersion(this.hsfVersion);
            invokeInfo.setGroup(this.hsfGroup);
            invokeInfo.setClientTimeout(Integer.valueOf(this.hsfClientTimeout));
            JSONObject resultData = TKGenericServiceUtils.genericServiceInvoke((String)JSONObject.toJSONString((Object)smcCreateSkuStockAbilityReqBO), null, (InvokeInfo)invokeInfo);
            logger.debug("\u521b\u5efa\u5e93\u5b58\u7ed3\u679c\u8fd4\u56de" + JSONObject.toJSONString((Object)resultData));
        }
    }
}

