/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.commodity.atom.spec.InitSkuSpecAtomService;
import com.ohaotian.commodity.dao.SkuPriceMapper;
import com.ohaotian.plugin.base.exception.BusinessException;
import com.xls.commodity.atom.sku.DeleteSkuService;
import com.xls.commodity.dao.XlsSkuMapper;
import com.xls.commodity.dao.po.Sku;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteSkuServiceImpl
implements DeleteSkuService {
    private static final Logger logger = LoggerFactory.getLogger(DeleteSkuServiceImpl.class);
    @Autowired
    private XlsSkuMapper xlsSkuMapper;
    @Autowired
    private InitSkuSpecAtomService initSkuSpecAtomService;
    @Autowired
    private SkuPriceMapper skuPriceMapper;

    public void deleteSKU(List<Long> provGoodsIdS) {
        logger.debug("DeleteSku\u5165\u53c2" + JSON.toJSONString(provGoodsIdS));
        try {
            List<Sku> skus = this.xlsSkuMapper.selectSkuByProvGoods(provGoodsIdS);
            if (!CollectionUtils.isEmpty(skus)) {
                ArrayList skuIds = new ArrayList();
                skus.stream().forEach(str -> skuIds.add(str.getSkuId()));
                logger.debug("\u67e5\u8be2\u5230\u7684skuID" + JSON.toJSONString(skuIds));
                this.skuPriceMapper.deleteBySkuId(skuIds);
                this.xlsSkuMapper.batchdeleteSkuByProvGoods(provGoodsIdS);
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664sku\u5931\u8d25" + e.getMessage());
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5220\u9664sku\u5931\u8d25");
        }
    }
}

