/*
 * Decompiled with CFR 0.152.
 */
package com.xls.commodity.atom.sku.impl;

import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.ohaotian.plugin.db.Page;
import com.xls.commodity.atom.sku.SysParamsAtomService;
import com.xls.commodity.atom.sku.XlsCommodityManageService;
import com.xls.commodity.busi.sku.bo.RspPageBaseBO;
import com.xls.commodity.busi.sku.bo.SelectXlsCommodiyForStatisticsReqBO;
import com.xls.commodity.busi.sku.bo.StatisticsXlsCommodityBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityPageBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityReqBO;
import com.xls.commodity.busi.sku.bo.XlsCommodityResBO;
import com.xls.commodity.dao.XlsCommodityDAO;
import com.xls.commodity.dao.po.StatisticsXlsCommodityPO;
import com.xls.commodity.dao.po.XlsCommodityPO;
import com.xls.commodity.intfce.sku.bo.BaseRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XlsCommodityManageServiceImpl
implements XlsCommodityManageService {
    @Autowired
    private XlsCommodityDAO xlsCommodityDAO;
    @Autowired
    private SysParamsAtomService sysParamsAtomService;
    private static final Logger logger = LoggerFactory.getLogger(XlsCommodityManageServiceImpl.class);

    public BaseRspBO insertXlsCommodity(XlsCommodityBO xlsCommodityBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        if (xlsCommodityBO == null) {
            baseRspBO.setRespCode("0000");
            baseRspBO.setRespDesc("\u6210\u529f");
            return baseRspBO;
        }
        XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
        BeanUtils.copyProperties((Object)xlsCommodityBO, (Object)xlsCommodityPO);
        try {
            this.xlsCommodityDAO.insertSelective(xlsCommodityPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u5355\u6761\u6dfb\u52a0xls\u5546\u54c1\u7ec4\u51fa\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public XlsCommodityResBO selectXlsCommodityNoPage(XlsCommodityReqBO xlsCommodityPageBO) {
        XlsCommodityResBO result = new XlsCommodityResBO();
        ArrayList<XlsCommodityBO> xlsCommodityBOs = new ArrayList<XlsCommodityBO>();
        XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
        BeanUtils.copyProperties((Object)xlsCommodityPageBO, (Object)xlsCommodityPO);
        List<XlsCommodityPO> xlsCommodityPOs = null;
        try {
            xlsCommodityPOs = this.xlsCommodityDAO.selectByMany(xlsCommodityPO);
        }
        catch (Exception e) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u51fa\u9519" + e);
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u51fa\u9519" + e.getMessage());
            return result;
        }
        Map<String, String> mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_STATUS");
        Map<String, String> mapSysCommodityIsbindfodder = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_ISBINDFODDER");
        if (CollectionUtils.isNotEmpty(xlsCommodityPOs)) {
            for (XlsCommodityPO xlsCommodityPO1 : xlsCommodityPOs) {
                XlsCommodityBO xlsCommodityBO1 = new XlsCommodityBO();
                BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)xlsCommodityBO1);
                xlsCommodityBO1.setCommodityStatusName(mapSysCommodityStatus.get(xlsCommodityBO1.getCommodityStatus()));
                xlsCommodityBO1.setIsBindFodderName(mapSysCommodityIsbindfodder.get(xlsCommodityBO1.getIsBindFodder()));
                xlsCommodityBOs.add(xlsCommodityBO1);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(xlsCommodityBOs);
        return result;
    }

    public RspPageBaseBO<XlsCommodityBO> selectXlsCommodity(XlsCommodityPageBO xlsCommodityPageBO) {
        RspPageBaseBO result = new RspPageBaseBO();
        ArrayList<XlsCommodityBO> xlsCommodityBOs = new ArrayList<XlsCommodityBO>();
        XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
        BeanUtils.copyProperties((Object)xlsCommodityPageBO, (Object)xlsCommodityPO);
        Page page = new Page();
        page.setLimit(xlsCommodityPageBO.getPageSize());
        page.setOffset(xlsCommodityPageBO.getOffset());
        List<XlsCommodityPO> xlsCommodityPOs = null;
        try {
            xlsCommodityPOs = this.xlsCommodityDAO.selectByMany(xlsCommodityPO, (Page<XlsCommodityPO>)page);
        }
        catch (Exception e) {
            result.setRespCode("8888");
            result.setRespDesc("\u5931\u8d25");
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5546\u54c1\u5217\u8868\u51fa\u9519" + e.getMessage());
            return result;
        }
        Map<String, String> mapSysCommodityStatus = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_STATUS");
        Map<String, String> mapSysCommodityIsbindfodder = this.sysParamsAtomService.selectByParentCode("SYS_COMMODITY_ISBINDFODDER");
        if (CollectionUtils.isNotEmpty(xlsCommodityPOs)) {
            for (XlsCommodityPO xlsCommodityPO1 : xlsCommodityPOs) {
                XlsCommodityBO xlsCommodityBO1 = new XlsCommodityBO();
                BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)xlsCommodityBO1);
                xlsCommodityBO1.setCommodityStatusName(mapSysCommodityStatus.get(xlsCommodityBO1.getCommodityStatus()));
                xlsCommodityBO1.setIsBindFodderName(mapSysCommodityIsbindfodder.get(xlsCommodityBO1.getIsBindFodder()));
                xlsCommodityBOs.add(xlsCommodityBO1);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(xlsCommodityBOs);
        result.setTotal(page.getTotalPages());
        result.setRecordsTotal(page.getTotalCount());
        return result;
    }

    public XlsCommodityBO selectXlsCommodityDetail(Long commodityId) {
        XlsCommodityBO xlsCommodityBO = new XlsCommodityBO();
        try {
            XlsCommodityPO xlsCommodityPO = this.xlsCommodityDAO.selectByPrimaryKey(commodityId);
            if (xlsCommodityPO == null) {
                logger.debug("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
                return xlsCommodityBO;
            }
            BeanUtils.copyProperties((Object)xlsCommodityPO, (Object)xlsCommodityBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
        }
        return xlsCommodityBO;
    }

    public BaseRspBO updateXlsCommodity(XlsCommodityBO xlsCommodityBO) {
        BaseRspBO baseRspBO = new BaseRspBO();
        XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
        BeanUtils.copyProperties((Object)xlsCommodityBO, (Object)xlsCommodityPO);
        try {
            xlsCommodityPO.setUpdateTime(new Date());
            this.xlsCommodityDAO.updateByPrimaryKeySelective(xlsCommodityPO);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u5355\u6761\u4fee\u6539xls\u5546\u54c1\u51fa\u9519");
        }
        baseRspBO.setRespCode("0000");
        baseRspBO.setRespDesc("\u6210\u529f");
        return baseRspBO;
    }

    public RspPageBaseBO<StatisticsXlsCommodityBO> selectXlsCommodiyForStatistics(SelectXlsCommodiyForStatisticsReqBO selectXlsCommodiyForStatisticsReqBO) {
        RspPageBaseBO result = new RspPageBaseBO();
        ArrayList<StatisticsXlsCommodityBO> statisticsXlsCommodityBOs = new ArrayList<StatisticsXlsCommodityBO>();
        Page page = new Page();
        page.setLimit(selectXlsCommodiyForStatisticsReqBO.getPageSize());
        page.setOffset(selectXlsCommodiyForStatisticsReqBO.getOffset());
        XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
        xlsCommodityPO.setCommodityName(selectXlsCommodiyForStatisticsReqBO.getCommodityName());
        xlsCommodityPO.setCommodityBrand(selectXlsCommodiyForStatisticsReqBO.getCommodityBrand());
        List<StatisticsXlsCommodityPO> statisticsXlsCommodityPOs = this.xlsCommodityDAO.selectXlsCommodiyForStatistics(xlsCommodityPO, (Page<StatisticsXlsCommodityPO>)page);
        if (CollectionUtils.isNotEmpty(statisticsXlsCommodityPOs)) {
            for (StatisticsXlsCommodityPO statisticsXlsCommodityPO : statisticsXlsCommodityPOs) {
                StatisticsXlsCommodityBO statisticsXlsCommodityBO = new StatisticsXlsCommodityBO();
                BeanUtils.copyProperties((Object)statisticsXlsCommodityPO, (Object)statisticsXlsCommodityBO);
                statisticsXlsCommodityBOs.add(statisticsXlsCommodityBO);
            }
        }
        result.setRespCode("0000");
        result.setRespDesc("\u6210\u529f");
        result.setRows(statisticsXlsCommodityBOs);
        result.setRecordsTotal(page.getTotalCount());
        result.setTotal(page.getTotalPages());
        return result;
    }

    public List<XlsCommodityReqBO> selectCommodity(XlsCommodityBO xlsCommodityBO) {
        logger.debug("\u8c03\u7528\u5c0f\u7a0b\u5e8f\u67e5\u8be2spu\u5546\u54c1\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5f00\u59cb---");
        XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
        ArrayList<XlsCommodityReqBO> xlsCommodityBOS = new ArrayList<XlsCommodityReqBO>();
        List<Object> xlsCommodityPOS = new ArrayList();
        if (xlsCommodityBO == null) {
            return xlsCommodityBOS;
        }
        try {
            BeanUtils.copyProperties((Object)xlsCommodityBO, (Object)xlsCommodityPO);
            xlsCommodityPOS = this.xlsCommodityDAO.selectCommodity(xlsCommodityPO);
            if (xlsCommodityPOS == null) {
                logger.debug("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
                return xlsCommodityBOS;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
        }
        xlsCommodityPOS.stream().forEach(xlsCommodityPO1 -> {
            XlsCommodityReqBO xlsCommodityBO1 = new XlsCommodityReqBO();
            BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)xlsCommodityBO1);
            xlsCommodityBOS.add(xlsCommodityBO1);
        });
        return xlsCommodityBOS;
    }

    public List<XlsCommodityReqBO> selectCommodityBySupplierId(XlsCommodityBO xlsCommodityBO) {
        logger.debug("\u8c03\u7528\u5c0f\u7a0b\u5e8f\u6709\u95e8\u5e97\u5165\u53c2\u67e5\u8be2spu\u5546\u54c1\u4fe1\u606f\u539f\u5b50\u670d\u52a1\u5f00\u59cb---");
        XlsCommodityPO xlsCommodityPO = new XlsCommodityPO();
        ArrayList<XlsCommodityReqBO> xlsCommodityBOS = new ArrayList<XlsCommodityReqBO>();
        List<Object> xlsCommodityPOS = new ArrayList();
        if (xlsCommodityBO == null) {
            return xlsCommodityBOS;
        }
        try {
            BeanUtils.copyProperties((Object)xlsCommodityBO, (Object)xlsCommodityPO);
            xlsCommodityPOS = this.xlsCommodityDAO.selectCommodityBySupplierId(xlsCommodityPO);
            if (xlsCommodityPOS == null) {
                logger.debug("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u7ed3\u679c\u4e3a\u7a7a");
                return xlsCommodityBOS;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6570\u636e\u5e93\u67e5\u8be2\u5546\u54c1\u8be6\u60c5\u51fa\u9519" + e.getMessage());
        }
        xlsCommodityPOS.stream().forEach(xlsCommodityPO1 -> {
            XlsCommodityReqBO xlsCommodityBO1 = new XlsCommodityReqBO();
            BeanUtils.copyProperties((Object)xlsCommodityPO1, (Object)xlsCommodityBO1);
            xlsCommodityBOS.add(xlsCommodityBO1);
        });
        return xlsCommodityBOS;
    }
}

